/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import oracle.sysman.vxx.ResData;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class VxxResourceUtil {
    public static URL getLocalizedResource(Class cls, String baseNameFormat) {
        return VxxResourceUtil.getLocalizedResource(cls, baseNameFormat, null);
    }

    public static URL getLocalizedResource(Class cls, String baseNameFormat, Locale locale) {
        ResData data = VxxResourceUtil.getLocalizedResourceData(cls, baseNameFormat, locale);
        if (data != null) {
            return data.getURL();
        }
        return null;
    }

    private static ResData getLocalizedResourceData(Class cls, String baseNameFormat, Locale locale) {
        ResData data = null;
        if (locale != null) {
            data = VxxResourceUtil.getResourceForLocale(cls, baseNameFormat, locale);
        }
        if (data == null) {
            data = VxxResourceUtil.getResourceForLocale(cls, baseNameFormat, Locale.getDefault());
        }
        if (data == null) {
            data = VxxResourceUtil.getResourceForItem(cls, baseNameFormat, "");
        }
        return data;
    }

    private static ResData getResourceForLocale(Class cls, String baseNameFormat, Locale locale) {
        String localeStr = "_" + locale.toString();
        while (localeStr.length() > 0) {
            ResData data = VxxResourceUtil.getResourceForItem(cls, baseNameFormat, localeStr);
            if (data != null) {
                return data;
            }
            localeStr = VxxResourceUtil.trimTrailing_(localeStr);
        }
        return null;
    }

    private static String trimTrailing_(String toTrim) {
        if (toTrim.charAt(0) != '_') {
            throw new IllegalArgumentException();
        }
        int index = toTrim.lastIndexOf("_");
        return toTrim.substring(0, index);
    }

    private static ResData getResourceForItem(Class cls, String baseNameFormat, String replacement) {
        String resource = MessageFormat.format(baseNameFormat, replacement);
        URL url = cls.getResource(resource);
        if (url != null) {
            return new ResData(url, resource);
        }
        return null;
    }

    public static String getLocalizedDirectory(Class cls, String baseNameFormat) {
        return VxxResourceUtil.getLocalizedDirectory(cls, baseNameFormat, null);
    }

    public static String getLocalizedDirectory(Class cls, String baseNameFormat, Locale locale) {
        ResData data = VxxResourceUtil.getLocalizedResourceData(cls, baseNameFormat, locale);
        if (data != null) {
            return data.getURLString();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.exit(0);
        }
        VxxtTRACE.enableDebugTracing();
        VxxtTRACE.configure(false, true, false, false, "", false);
        Locale.setDefault(new Locale("en", "US", "ORACLE"));
        VxxtTRACE.out("Set default locale to : " + Locale.getDefault());
        try {
            Class<?> c = Class.forName("java.lang.Object");
            Locale locale = null;
            if (args.length == 3) {
                locale = new Locale(args[1], args[2]);
            }
            if (args.length == 4) {
                locale = new Locale(args[1], args[2], args[3]);
            }
            VxxtTRACE.out("returned URL resource is: " + VxxResourceUtil.getLocalizedResource(c, args[0], locale));
            System.exit(0);
        }
        catch (Exception e) {
            VxxtTRACE.out(e);
            System.exit(0);
        }
    }
}

