/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import java.math.BigDecimal;
import java.sql.Time;
import java.text.CollationKey;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.DateComparator;
import oracle.sysman.vxx.VxxBigDecimalComparator;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class VxxSortVector
extends Vector
implements Comparator {
    private Vector _columnTypes = new Vector();
    private boolean _diffsExist;
    private boolean _firstSort = false;
    private boolean _ascending;
    private boolean _sortDir = true;
    private int _colIndex;
    private int _lastSort = -1;
    private int _dataType = 12;
    private static RuleBasedCollator _collator = null;
    private DateFormat m_dateFormat;
    private static DateFormat m_defaultDateFormat = null;
    private Object m_lock = new Object();
    private static final Random _random = new Random();

    private Collator getCollator() {
        if (_collator == null) {
            Object object = this.m_lock;
            synchronized (object) {
                if (_collator == null) {
                    String addRules = "& '_' < ' ' & ' ' < '_'";
                    try {
                        _collator = new RuleBasedCollator(String.valueOf(((RuleBasedCollator)Collator.getInstance()).getRules()) + addRules);
                    }
                    catch (ParseException e) {
                        System.out.println("Exception: " + e);
                    }
                }
            }
        }
        return _collator;
    }

    private DateFormat getDateFormat() {
        if (this.m_dateFormat == null) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_dateFormat == null) {
                    if (m_defaultDateFormat == null) {
                        m_defaultDateFormat = DateFormat.getDateTimeInstance(1, 2);
                        m_defaultDateFormat.setTimeZone(TimeZone.getDefault());
                    }
                    this.m_dateFormat = m_defaultDateFormat;
                }
            }
        }
        return this.m_dateFormat;
    }

    public int compare(Object o1, Object o2) {
        String s1 = "";
        String s2 = "";
        int result = 0;
        if (o1 instanceof Vector) {
            s1 = (String)((Vector)o1).elementAt(this._colIndex);
        } else if (o1 instanceof String) {
            s1 = (String)o1;
        }
        if (o2 instanceof Vector) {
            s2 = (String)((Vector)o2).elementAt(this._colIndex);
        } else if (o2 instanceof String) {
            s2 = (String)o2;
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if ((result = this.compareData(s1, s2, this._dataType)) != 0) {
            this._diffsExist = true;
        }
        return result;
    }

    protected int compareData(String s1, String s2, int dataType) {
        switch (dataType) {
            case 1: 
            case 12: {
                return this.getCollator().compare(s1, s2);
            }
            case 2: {
                BigDecimal n1 = null;
                BigDecimal n2 = null;
                try {
                    n1 = new BigDecimal(s1);
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n2 = new BigDecimal(s2);
                }
                catch (NumberFormatException numberFormatException) {}
                if (n1 == n2) {
                    return 0;
                }
                if (n1 == null || n2 == null) {
                    return n1 == null ? -1 : 1;
                }
                return n1.compareTo(n2);
            }
            case 91: {
                java.sql.Date t1 = java.sql.Date.valueOf(s1);
                java.sql.Date t2 = java.sql.Date.valueOf(s1);
                if (t1.before(t2)) {
                    return -1;
                }
                if (t1.after(t2)) {
                    return 1;
                }
                return 0;
            }
            case 92: {
                Time t1 = Time.valueOf(s1);
                Time t2 = Time.valueOf(s1);
                if (t1.before(t2)) {
                    return -1;
                }
                if (t1.after(t2)) {
                    return 1;
                }
                return 0;
            }
            case 93: {
                DateFormat df = this.getDateFormat();
                try {
                    Date d1 = df.parse(s1);
                    Date d2 = df.parse(s2);
                    if (d1.before(d2)) {
                        return -1;
                    }
                    if (d1.after(d2)) {
                        return 1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    VxxtTRACE.out(e);
                    return 0;
                }
            }
        }
        return 0;
    }

    public void setColumnType(int colIndex, int dataType) {
        if (this._columnTypes.size() <= colIndex) {
            this._columnTypes.insertElementAt(new Integer(dataType), colIndex);
        } else {
            this._columnTypes.setElementAt(new Integer(dataType), colIndex);
        }
    }

    public void setDateFormat(DateFormat edf) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_dateFormat = edf;
        }
    }

    public int getColumnType(int colIndex) {
        try {
            return (Integer)this._columnTypes.elementAt(colIndex);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 12;
        }
    }

    public void sort() {
        this.sort(0, true);
    }

    public void sort(boolean ascending) {
        this.sort(0, ascending);
    }

    public void sort(int sortIndex) {
        this.sort(sortIndex, true);
    }

    public void sortData(int sortIndex) {
        this.sort(sortIndex, true);
    }

    public void sortData(int sortIndex, boolean ascending) {
        this.sort(sortIndex, ascending);
    }

    public void sort(int sortIndex, boolean ascending, boolean force) {
        if (force) {
            this._lastSort = -1;
        }
        this.sort(sortIndex, ascending);
    }

    public void sort(int sortIndex, boolean ascending) {
        this._ascending = ascending;
        this._colIndex = sortIndex < 0 ? 0 : sortIndex;
        int n = this._dataType = this._columnTypes.size() == 0 ? 12 : this.getColumnType(this._colIndex);
        if (this._colIndex != this._lastSort) {
            this._diffsExist = false;
            switch (this._dataType) {
                case 12: {
                    this.quickSortStrings(this.elementData, this.elementCount, this._colIndex);
                    break;
                }
                case 93: {
                    this.quickSortTimestamps(this.elementData, this.elementCount, this._colIndex);
                    break;
                }
                case 2: {
                    this.quickSortNumbers(this.elementData, this.elementCount, this._colIndex);
                    break;
                }
                default: {
                    VxxSortVector.quickSort(this.elementData, this.elementCount, this);
                }
            }
            this._lastSort = this._colIndex;
            this._sortDir = this._ascending;
            if (!this._ascending) {
                VxxSortVector.flipData(this.elementData, this.elementCount);
            }
        } else if (this._diffsExist && this._sortDir != this._ascending) {
            VxxSortVector.flipData(this.elementData, this.elementCount);
            this._sortDir = ascending;
        }
    }

    protected void quickSortStrings(Object[] items, int nitems, int colIndex) {
        CollationKey[] keys = new CollationKey[nitems];
        CollationKey nullKey = this.getCollator().getCollationKey("");
        int i = 0;
        while (i < nitems) {
            keys[i] = this.getCollator().getCollationKey((String)((Vector)items[i]).elementAt(colIndex));
            if (keys[i] == null) {
                keys[i] = nullKey;
            }
            ++i;
        }
        this._diffsExist = VxxSortVector._quickSortItemsByCollKey(keys, items, 0, nitems - 1);
    }

    protected void quickSortTimestamps(Object[] items, int nitems, int colIndex) {
        Object[] dates = new Date[nitems];
        DateFormat df = this.getDateFormat();
        int i = 0;
        while (i < nitems) {
            try {
                dates[i] = df.parse((String)((Vector)items[i]).elementAt(colIndex));
            }
            catch (Exception exception) {
                dates[i] = null;
            }
            ++i;
        }
        Comparator dc = DateComparator.getComparator();
        this._diffsExist = VxxSortVector._quickSortItemsByObject(dates, items, 0, nitems - 1, dc);
    }

    protected void quickSortNumbers(Object[] items, int nitems, int colIndex) {
        Object[] nums = new BigDecimal[nitems];
        int i = 0;
        while (i < nitems) {
            try {
                nums[i] = new BigDecimal((String)((Vector)items[i]).elementAt(colIndex));
            }
            catch (Exception exception) {
                nums[i] = null;
            }
            ++i;
        }
        Comparator bdc = VxxBigDecimalComparator.getComparator();
        this._diffsExist = VxxSortVector._quickSortItemsByObject(nums, items, 0, nitems - 1, bdc);
    }

    public static boolean quickSortItemsByCollKey(CollationKey[] keys, Object[] items) {
        return VxxSortVector._quickSortItemsByCollKey(keys, items, 0, items.length - 1);
    }

    protected static boolean _quickSortItemsByCollKey(CollationKey[] keys, Object[] items, int left0, int right0) {
        int left = left0;
        int right = right0;
        boolean foundDiffs = false;
        int r = _random.nextInt();
        int div = right0 - left0 + 1;
        if (div != 0) {
            r %= div;
        }
        if (r < 0) {
            r = -r;
        }
        if (right0 > left0) {
            CollationKey midKey = keys[left0 + r];
            while (left < right) {
                CollationKey leftKey = keys[left];
                CollationKey rightKey = keys[right];
                while (left < right0 && leftKey.compareTo(midKey) < 0) {
                    leftKey = keys[++left];
                    foundDiffs = true;
                }
                while (right > left0 && rightKey.compareTo(midKey) > 0) {
                    rightKey = keys[--right];
                    foundDiffs = true;
                }
                if (left > right) continue;
                if (rightKey.compareTo(leftKey) != 0) {
                    VxxSortVector.swap(keys, left, right);
                    VxxSortVector.swap(items, left, right);
                    foundDiffs = true;
                }
                ++left;
                --right;
            }
            if (left0 < right) {
                foundDiffs |= VxxSortVector._quickSortItemsByCollKey(keys, items, left0, right);
            }
            if (left < right0) {
                foundDiffs |= VxxSortVector._quickSortItemsByCollKey(keys, items, left, right0);
            }
        }
        return foundDiffs;
    }

    protected static boolean _quickSortItemsByObject(Object[] objs, Object[] items, int left0, int right0, Comparator dc) {
        int left = left0;
        int right = right0;
        boolean foundDiffs = false;
        int r = _random.nextInt();
        int div = right0 - left0 + 1;
        if (div != 0) {
            r %= div;
        }
        if (r < 0) {
            r = -r;
        }
        if (right0 > left0) {
            Object midObj = objs[left0 + r];
            while (left < right) {
                Object leftObj = objs[left];
                Object rightObj = objs[right];
                while (left < right0 && dc.compare(leftObj, midObj) < 0) {
                    leftObj = objs[++left];
                    foundDiffs = true;
                }
                while (right > left0 && dc.compare(rightObj, midObj) > 0) {
                    rightObj = objs[--right];
                    foundDiffs = true;
                }
                if (left > right) continue;
                if (dc.compare(rightObj, leftObj) != 0) {
                    VxxSortVector.swap(objs, left, right);
                    VxxSortVector.swap(items, left, right);
                    foundDiffs = true;
                }
                ++left;
                --right;
            }
            if (left0 < right) {
                foundDiffs |= VxxSortVector._quickSortItemsByObject(objs, items, left0, right, dc);
            }
            if (left < right0) {
                foundDiffs |= VxxSortVector._quickSortItemsByObject(objs, items, left, right0, dc);
            }
        }
        return foundDiffs;
    }

    public static void quickSort(Object[] items, int nitems, Comparator comp) {
        VxxSortVector._quickSort(items, 0, nitems - 1, comp);
    }

    private static void _quickSort(Object[] items, int left0, int right0, Comparator comp) {
        int left = left0;
        int right = right0;
        int r = _random.nextInt();
        int div = right0 - left0 + 1;
        if (div != 0) {
            r %= div;
        }
        if (r < 0) {
            r = -r;
        }
        if (right0 > left0) {
            Object midObj = items[left0 + r];
            while (left < right) {
                Object leftObj = items[left];
                Object rightObj = items[right];
                while (left < right0 && comp.compare(leftObj, midObj) < 0) {
                    leftObj = items[++left];
                }
                while (right > left0 && comp.compare(rightObj, midObj) > 0) {
                    rightObj = items[--right];
                }
                if (left > right) continue;
                if (comp.compare(rightObj, leftObj) != 0) {
                    VxxSortVector.swap(items, left, right);
                }
                ++left;
                --right;
            }
            if (left0 < right) {
                VxxSortVector._quickSort(items, left0, right, comp);
            }
            if (left < right0) {
                VxxSortVector._quickSort(items, left, right0, comp);
            }
        }
    }

    private static void flipData(Object[] items, int nitems) {
        int _limit = nitems;
        int i = 0;
        while (i < _limit / 2) {
            VxxSortVector.swap(items, i, _limit - (i + 1));
            ++i;
        }
    }

    private static void swap(Object[] items, int loc1, int loc2) {
        Object tmp = items[loc1];
        items[loc1] = items[loc2];
        items[loc2] = tmp;
    }
}

