/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import java.awt.Image;
import oracle.sysman.emSDK.common.nls.ImageBundle;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class VxxTypeConstants {
    private static ImageBundle m_iconBundle = null;
    private static MessageBundle m_msgBundle = new MessageBundle("Types");
    private static String[] oraTypeMap = null;
    public static final int VXX_TYPE_CLUSTER = 0;
    public static final int VXX_TYPE_DATABASE_LINK = 1;
    public static final int VXX_TYPE_DATAFILE = 2;
    public static final int VXX_TYPE_FUNCTION = 3;
    public static final int VXX_TYPE_INDEX = 4;
    public static final int VXX_TYPE_PACKAGE = 5;
    public static final int VXX_TYPE_PACKAGE_BODY = 6;
    public static final int VXX_TYPE_PROCEDURE = 7;
    public static final int VXX_TYPE_PROFILE = 8;
    public static final int VXX_TYPE_ROLE = 9;
    public static final int VXX_TYPE_ROLLBACK_SEGMENT = 10;
    public static final int VXX_TYPE_SEQUENCE = 11;
    public static final int VXX_TYPE_SYNONYM = 12;
    public static final int VXX_TYPE_TABLE = 13;
    public static final int VXX_TYPE_TABLESPACE = 14;
    public static final int VXX_TYPE_TRIGGER = 15;
    public static final int VXX_TYPE_USER = 16;
    public static final int VXX_TYPE_VIEW = 17;
    public static final int VXX_TYPE_PARTITION = 18;
    public static final int VXX_TYPE_SCHEMA = 19;
    public static final int VXX_TYPE_NONE = 20;
    public static final int VXX_TYPE_SESSION = 21;
    public static final int VXX_TYPE_TRANSACTION = 22;
    public static final int VXX_TYPE_INITPARMETERS = 23;
    public static final int VXX_TYPE_STOCONFIG = 24;
    public static final int VXX_TYPE_DATABASE = 25;
    public static final int VXX_TYPE_QUEUE_TABLE = 26;
    public static final int VXX_TYPE_QUEUE = 27;
    public static final int VXX_TYPE_ARRAY_TYPE = 28;
    public static final int VXX_TYPE_TABLE_TYPE = 29;
    public static final int VXX_TYPE_OBJECT_TYPE = 30;
    public static final int VXX_TYPE_REFRESH_GROUP = 31;
    public static final int VXX_TYPE_SNAPSHOT = 32;
    public static final int VXX_TYPE_SNAPSHOT_LOG = 33;
    public static final int VXX_TYPE_DATABASE_STATE = 34;
    public static final int VXX_TYPE_NON_EXISTENT = 35;
    public static final int VXX_TYPE_INDEX_PARTITION = 36;
    public static final int VXX_TYPE_TABLE_PARTITION = 37;
    public static final int VXX_TYPE_OBJECT_PRIVILEGE = 38;
    public static final int VXX_TYPE_SYSTEM_PRIVILEGE = 39;
    public static final int VXX_TYPE_REDOLOGMEMBER = 40;
    public static final int VXX_TYPE_REDOLOGGROUP = 41;
    public static final int VXX_TYPE_JAVA_SOURCE = 56;
    public static final int VXX_TYPE_TABLE_COLUMNS = 58;
    public static final int VXX_TYPE_CONTROLFILE = 70;
    public static final int VXX_TYPE_ARCHIVELOG = 71;
    public static final int VXX_TYPE_RESOURCE_CONSUMER_GROUP = 75;
    public static final int VXX_TYPE_RESOURCE_PLAN = 76;
    public static final int VXX_TYPE_DIMENSION = 78;
    public static final int VXX_TYPE_RESOURCE_GROUP_GRANTEES = 79;
    public static final String TYPE_ID_TO_NAME_DECODE_STRING = "0, 'Cluster', 1, 'Database Link', 2, 'Datafile', 3, 'Function',4, 'Index', 5, 'Package', 6, 'Package Body', 7, 'Procedure', 8, 'Profile', 9, 'Role', 10, 'Rollback Segment', 11, 'Sequence', 12, 'Synonym', 13, 'Table', 14, 'Tablespace', 15, 'Trigger', 16, 'User', 17, 'View', 18, 'Partition', 19, 'Schema', 28, 'Array Type', 29, 'Table Type', 30, 'Object Type', 31, 'Refresh Group', 32, 'Snapshot', 33, 'Snapshot Log', 'Unknown Type' ";
    public static final String TYPE_ID_TO_PLURAL_NAME_DECODE_STRING = "0, 'Clusters', 1, 'Database Links', 2, 'Datafiles', 3, 'Functions',4, 'Indexes', 5, 'Packages', 6, 'Package Bodies', 7, 'Procedures', 8, 'Profiles', 9, 'Roles', 10, 'Rollback Segments', 11, 'Sequences', 12, 'Synonyms', 13, 'Tables', 14, 'Tablespaces', 15, 'Triggers', 16, 'Users', 17, 'Views', 18, 'Partitions', 19, 'Schemas', 28, 'Array Types', 29, 'Table Types', 30, 'Object Types', 31, 'Refresh Groups', 32, 'Snapshots', 33, 'Snapshot Logs', 'Unknown Types' ";
    public static final int VXX_TYPE_DIRECTIVE = 42;
    public static final int VXX_TYPE_EXEMPLAR = 43;
    public static final int VXX_TYPE_JOB = 44;
    public static final int VXX_TYPE_DESTINATION = 45;
    public static final int VXX_TYPE_PLAN = 46;
    public static final int VXX_TYPE_SCRIPT = 47;
    public static final int VXX_TYPE_GRANTS = 48;
    public static final int VXX_TYPE_DEPENDENCIES = 49;
    public static final int VXX_TYPE_CRONE = 50;
    public static final int VXX_TYPE_CR = 51;
    public static final int VXX_TYPE_CRCHILD = 52;
    public static final int VXX_TYPE_DESTMCW = 53;
    public static final int VXX_TYPE_PLANMCW = 54;
    public static final int VXX_TYPE_PLANONEMCW = 55;
    public static final int VXX_TYPE_ATTRIBUTES = 57;
    public static final int VXX_TYPE_CMUSERSMCW = 58;
    public static final int VXX_TYPE_CMUSERALLOBJECTSFLDR = 59;
    public static final int VXX_TYPE_CMPLANSMCW = 60;
    public static final int VXX_TYPE_CMPLANCRFLDR = 61;
    public static final int VXX_TYPE_CMBASELINESMCW = 62;
    public static final int VXX_TYPE_CMBLCRFLDR = 63;
    public static final int VXX_TYPE_CMPLANSFLDR = 64;
    public static final int VXX_TYPE_CMBASELINESFLDR = 65;
    public static final int VXX_TYPE_BEXEMPLAR = 66;
    public static final int VXX_TYPE_CMUSERALLOBJECTSBASELINES = 67;
    public static final int VXX_TYPE_CMUSERALLOBJECTSPLANS = 68;
    public static final int VXX_TYPE_CMBASELINE = 69;
    public static final int VXX_TYPE_ONEDESTINATION = 72;
    public static final int VXX_TYPE_CMCOMPARISONSFLDR = 73;
    public static final int VXX_TYPE_CMCOMPARISONSMCW = 74;
    public static final int VXX_TYPE_CMUSERALLOBJECTSCOMPARISONS = 77;
    public static final int VXX_TYPE_CMCOMPARISONFLDR = 82;
    public static final int VXX_TYPE_CMUSERALLOBJECTSFLDR_NOACCESS = 85;
    public static final int VXX_TYPE_CMPLANSFLDR_NOACCESS = 86;
    public static final int VXX_TYPE_CMBASELINESFLDR_NOACCESS = 87;
    public static final int VXX_TYPE_CMCOMPARISONSFLDR_NOACCESS = 88;
    public static final int VXX_TYPE_CMUSERALLOBJECTSBASELINES_NOACCESS = 89;
    public static final int VXX_TYPE_CMUSERALLOBJECTSPLANS_NOACCESS = 90;
    public static final int VXX_TYPE_CMUSERALLOBJECTSCOMPARISONS_NOACCESS = 91;
    public static final int VXX_TYPE_CMPLANSMCW_NOACCESS = 92;
    public static final int VXX_TYPE_CMBASELINESMCW_NOACCESS = 93;
    public static final int VXX_TYPE_CMCOMPARISONSMCW_NOACCESS = 94;
    public static final int VXX_TYPE_CMPLANCRFLDR_NOACCESS = 95;
    public static final int VXX_TYPE_CMBLCRFLDR_NOACCESS = 96;
    public static final int VXX_TYPE_CMCOMPARISONFLDR_NOACCESS = 97;
    public static final int VXX_TYPE_CACHE_SEGMENT = 79;
    public static final int VXX_TYPE_LOBINDEX = 80;
    public static final int VXX_TYPE_LOBSEGMENT = 81;
    public static final int VXX_TYPE_DEF_ROLLBACK = 83;
    public static final int VXX_TYPE_TEMPORARY = 84;
    public static final int VXX_TYPE_NESTED_TABLE = 98;
    public static final int VXX_TYPE_INDEX_SUBPARTITION = 99;
    public static final int VXX_TYPE_TABLE_SUBPARTITION = 100;
    public static final int VXX_TYPE_LOB_PARTITION = 101;
    public static final int VXX_TYPE_LOB_SUBPARTITION = 102;
    public static final int VXX_TYPE_UNKNOWN = -1;
    public static final int VXX_TYPE_NUMTYPES_ASM = 20;
    public static final int VXX_TYPE_NUMTYPES_ASM_SEARCH = 28;
    private static final int MAX_TYPE_INDEX = 103;
    public static final int VXX_TYPE_NUMTYPES = 104;

    public static boolean isOCMType(int type) {
        if (VxxTypeConstants.isStorageType(type) || VxxTypeConstants.isSchemaType(type) || VxxTypeConstants.isSecurityType(type)) {
            return true;
        }
        switch (type) {
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOCMiType(int type) {
        if (VxxTypeConstants.isStorageType(type) || VxxTypeConstants.isSchemaType(type) || VxxTypeConstants.isSecurityType(type)) {
            return true;
        }
        switch (type) {
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 74: 
            case 77: 
            case 82: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOCMTypeToRemove(int type) {
        switch (type) {
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 72: 
            case 74: 
            case 77: 
            case 82: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSchemaType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 56: 
            case 78: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStorageType(int type) {
        switch (type) {
            case 2: 
            case 10: 
            case 14: 
            case 40: 
            case 41: 
            case 70: 
            case 71: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSecurityType(int type) {
        switch (type) {
            case 8: 
            case 9: 
            case 16: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInstanceType(int type) {
        switch (type) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 34: 
            case 75: 
            case 76: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOCMSupportedDBType(int intType) {
        switch (intType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 31: 
            case 32: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertySheetCreatable(int type) {
        return type != 78;
    }

    public static boolean isWizardCreatable(int type) {
        return type == 13 || type == 17 || type == 78;
    }

    public static String generateDecodeString(String expr) {
        if (oraTypeMap == null) {
            oraTypeMap = new String[104];
            int i = 0;
            while (i < 104) {
                VxxTypeConstants.oraTypeMap[i] = "";
                ++i;
            }
            VxxTypeConstants.oraTypeMap[0] = "CLUSTER";
            VxxTypeConstants.oraTypeMap[1] = "DATABASE LINK";
            VxxTypeConstants.oraTypeMap[3] = "FUNCTION";
            VxxTypeConstants.oraTypeMap[4] = "INDEX";
            VxxTypeConstants.oraTypeMap[5] = "PACKAGE";
            VxxTypeConstants.oraTypeMap[6] = "PACKAGE BODY";
            VxxTypeConstants.oraTypeMap[7] = "PROCEDURE";
            VxxTypeConstants.oraTypeMap[11] = "SEQUENCE";
            VxxTypeConstants.oraTypeMap[12] = "SYNONYM";
            VxxTypeConstants.oraTypeMap[13] = "TABLE";
            VxxTypeConstants.oraTypeMap[15] = "TRIGGER";
            VxxTypeConstants.oraTypeMap[17] = "VIEW";
            VxxTypeConstants.oraTypeMap[18] = "PARTITION";
            VxxTypeConstants.oraTypeMap[21] = "SESSION";
            VxxTypeConstants.oraTypeMap[22] = "TRANSACTION";
            VxxTypeConstants.oraTypeMap[23] = "INIT PARAMETERS";
            VxxTypeConstants.oraTypeMap[24] = "STORED CONFIGURATION";
            VxxTypeConstants.oraTypeMap[25] = "DATABASE";
            VxxTypeConstants.oraTypeMap[26] = "QUEUE TABLE";
            VxxTypeConstants.oraTypeMap[27] = "QUEUE";
            VxxTypeConstants.oraTypeMap[28] = "ARRAY TYPE";
            VxxTypeConstants.oraTypeMap[29] = "TABLE TYPE";
            VxxTypeConstants.oraTypeMap[30] = "OBJECT TYPE";
            VxxTypeConstants.oraTypeMap[32] = "SNAPSHOT";
            VxxTypeConstants.oraTypeMap[31] = "REFRESH GROUP";
            VxxTypeConstants.oraTypeMap[33] = "SNAPSHOT LOG";
            VxxTypeConstants.oraTypeMap[34] = "DATABASE STATE";
            VxxTypeConstants.oraTypeMap[56] = "JAVA SOURCE";
            VxxTypeConstants.oraTypeMap[58] = "TABLE COLUMNS";
            VxxTypeConstants.oraTypeMap[70] = "CONTROL FILE";
            VxxTypeConstants.oraTypeMap[71] = "ARCHIVE LOG";
            VxxTypeConstants.oraTypeMap[35] = "NON-EXISTENT";
            VxxTypeConstants.oraTypeMap[75] = "RESOURCE CONSUMER GROUP";
            VxxTypeConstants.oraTypeMap[76] = "RESOURCE PLAN";
            VxxTypeConstants.oraTypeMap[78] = "DIMENSION";
        }
        String decodeString = "decode(" + expr;
        int i = 0;
        while (i < 104) {
            if (oraTypeMap[i].length() != 0) {
                decodeString = String.valueOf(decodeString) + ",'" + oraTypeMap[i] + "'," + i;
            }
            ++i;
        }
        decodeString = String.valueOf(decodeString) + ") TYPE";
        return decodeString;
    }

    public static String typeIndextoVxxName(int typeId) {
        switch (typeId) {
            case 0: {
                return "oracle_sysman_cluster";
            }
            case 1: {
                return "oracle_sysman_dblink";
            }
            case 3: {
                return "oracle_sysman_function";
            }
            case 4: {
                return "oracle_sysman_index";
            }
            case 6: {
                return "oracle_sysman_packageBody";
            }
            case 5: {
                return "oracle_sysman_package";
            }
            case 7: {
                return "oracle_sysman_procedure";
            }
            case 26: {
                return "oracle_sysman_queueTable";
            }
            case 11: {
                return "oracle_sysman_sequence";
            }
            case 12: {
                return "oracle_sysman_synonym";
            }
            case 13: {
                return "oracle_sysman_table";
            }
            case 15: {
                return "oracle_sysman_trigger";
            }
            case 17: {
                return "oracle_sysman_view";
            }
            case 28: {
                return "oracle_sysman_arrayType";
            }
            case 29: {
                return "oracle_sysman_tableType";
            }
            case 30: {
                return "oracle_sysman_objectType";
            }
            case 31: {
                return "oracle_sysman_refreshGroup";
            }
            case 32: {
                return "oracle_sysman_snapshot";
            }
            case 33: {
                return "oracle_sysman_snapshotLog";
            }
            case 56: {
                return "oracle_sysman_java_source";
            }
            case 78: {
                return "oracle_sysman_dimension";
            }
        }
        return null;
    }

    public static String typeIndextoName(int type) {
        String name = "Unknown";
        if (type == 13) {
            name = "TABLE";
        } else if (type == 16) {
            name = "USER";
        } else if (type == 14) {
            name = "TABLESPACE";
        } else if (type == 9) {
            name = "ROLE";
        } else if (type == 8) {
            name = "PROFILE";
        } else if (type == 17) {
            name = "VIEW";
        } else if (type == 15) {
            name = "TRIGGER";
        } else if (type == 4) {
            name = "INDEX";
        } else if (type == 11) {
            name = "SEQUENCE";
        } else if (type == 0) {
            name = "CLUSTER";
        } else if (type == 7) {
            name = "PROCEDURE";
        } else if (type == 3) {
            name = "FUNCTION";
        } else if (type == 2) {
            name = "DATAFILE";
        } else if (type == 5) {
            name = "PACKAGE";
        } else if (type == 6) {
            name = "PACKAGE BODY";
        } else if (type == 12) {
            name = "SYNONYM";
        } else if (type == 10) {
            name = "ROLLBACK SEGMENT";
        } else if (type == 1) {
            name = "DATABASE LINK";
        } else if (type == 20) {
            name = "NONE";
        } else if (type == 18) {
            name = "PARTITION";
        } else if (type == 21) {
            name = "SESSION";
        } else if (type == 22) {
            name = "TRANSACTION";
        } else if (type == 23) {
            name = "INIT PARMETERS";
        } else if (type == 24) {
            name = "STORED CONFIGURATION";
        } else if (type == 25) {
            name = "DATABASE";
        } else if (type == 26) {
            name = "QUEUE TABLE";
        } else if (type == 27) {
            name = "QUEUE";
        } else if (type == 28) {
            name = "ARRAY TYPE";
        } else if (type == 29) {
            name = "TABLE TYPE";
        } else if (type == 30) {
            name = "OBJECT TYPE";
        } else if (type == 31) {
            name = "REFRESH GROUP";
        } else if (type == 32) {
            name = "SNAPSHOT";
        } else if (type == 33) {
            name = "SNAPSHOT LOG";
        } else if (type == 78) {
            name = "DIMENSION";
        } else if (type == 34) {
            name = "DATABASE STATE";
        } else if (type == 35) {
            name = "NON-EXISTENT";
        } else if (type == 36) {
            name = "INDEX PARTITION";
        } else if (type == 37) {
            name = "TABLE PARTITION";
        } else if (type == 38) {
            name = "OBJECT PRIVILEGE";
        } else if (type == 39) {
            name = "SYSTEM PRIVILEGE";
        } else if (type == 40) {
            name = "REDO LOG MEMBER";
        } else if (type == 41) {
            name = "REDO LOG GROUP";
        } else if (type == 56) {
            name = "JAVA SOURCE";
        } else if (type == 58) {
            name = "TABLE COLUMNS";
        } else if (type == 70) {
            name = "CONTROL FILE";
        } else if (type == 71) {
            name = "ARCHIVE LOG";
        } else if (type == 75) {
            name = "RESOURCE CONSUMER GROUP";
        } else if (type == 76) {
            name = "RESOURCE PLAN";
        } else if (type == 42) {
            name = "DIRECTIVE";
        } else if (type == 43) {
            name = "EXEMPLAR";
        } else if (type == 44) {
            name = "JOB";
        } else if (type == 45) {
            name = "DESTINATION";
        } else if (type == 72) {
            name = "ONEDESTINATION";
        } else if (type == 46) {
            name = "PLAN";
        } else if (type == 47) {
            name = "SCRIPT";
        } else if (type == 57) {
            name = "ATTRIBUTES";
        } else if (type == 48) {
            name = "GRANTS";
        } else if (type == 49) {
            name = "DEPENDENCIES";
        } else if (type == 50) {
            name = "CHANGE REQUESTS SUBGRP";
        } else if (type == 51) {
            name = "CHANGE REQUESTS GROUP";
        } else if (type == 52) {
            name = "CHANGE REQUEST CHILDREN";
        } else if (type == 53) {
            name = "DESTINATION GROUP";
        } else if (type == 54) {
            name = "PLAN GROUP";
        } else if (type == 55) {
            name = "PLAN MCW GROUP";
        } else if (type == 58) {
            name = "CMUSERSMCW";
        } else if (type == 59) {
            name = "CMUSERALLOBJECTSMCW";
        } else if (type == 85) {
            name = "CMUSERALLOBJECTSMCWNOACCESS";
        } else if (type == 60) {
            name = "CMPLANSMCW";
        } else if (type == 92) {
            name = "CMPLANSMCWNOACCESS";
        } else if (type == 61) {
            name = "CMPLANCRFLDR";
        } else if (type == 95) {
            name = "CMPLANCRFLDRNOACCESS";
        } else if (type == 62) {
            name = "CMBASELINESMCW";
        } else if (type == 93) {
            name = "CMBASELINESMCWNOACCESS";
        } else if (type == 74) {
            name = "CMCOMPARISONSMCW";
        } else if (type == 94) {
            name = "CMCOMPARISONSMCWNOACCESS";
        } else if (type == 63) {
            name = "CMBLCRFLDR";
        } else if (type == 96) {
            name = "CMBLCRFLDRNOACCESS";
        } else if (type == 82) {
            name = "CMCOMPARISONFLDR";
        } else if (type == 97) {
            name = "CMCOMPARISONFLDRNOACCESS";
        } else if (type == 64) {
            name = "CMPLANSFLDR";
        } else if (type == 86) {
            name = "CMPLANSFLDRNOACCESS";
        } else if (type == 65) {
            name = "CMBASELINESFLDR";
        } else if (type == 87) {
            name = "CMBASELINESFLDRNOACCESS";
        } else if (type == 66) {
            name = "BEXEMPLAR";
        } else if (type == 67) {
            name = "CMUSERALLOBJECTSBASELINES";
        } else if (type == 89) {
            name = "CMUSERALLOBJECTSBASELINESNOACCESS";
        } else if (type == 68) {
            name = "CMUSERALLOBJECTSPLANS";
        } else if (type == 90) {
            name = "CMUSERALLOBJECTSPLANSNOACCESS";
        } else if (type == 77) {
            name = "CMUSERALLOBJECTSCOMPARISONS";
        } else if (type == 91) {
            name = "CMUSERALLOBJECTSCOMPARISONSNOACCESS";
        } else if (type == 73) {
            name = "CMCOMPARISONSFLDR";
        } else if (type == 88) {
            name = "CMCOMPARISONSFLDRNOACCESS";
        } else if (type == 79) {
            name = "CACHE";
        } else if (type == 80) {
            name = "LOBINDEX";
        } else if (type == 81) {
            name = "LOBSEGMENT";
        } else if (type == 83) {
            name = "DEFERRED ROLLBACK";
        } else if (type == 84) {
            name = "TEMPORARY";
        } else if (type == 98) {
            name = "NESTED TABLE";
        } else if (type == 99) {
            name = "INDEX SUBPARTITION";
        } else if (type == 100) {
            name = "TABLE SUBPARTITION";
        } else if (type == 101) {
            name = "LOB PARTITION";
        } else if (type == 102) {
            name = "LOB SUBPARTITION";
        }
        return name;
    }

    public static String typeIndextoVtoClassName(int typeID) {
        switch (typeID) {
            case 0: {
                return "oracle.sysman.vto.vtos.VtosCluster";
            }
            case 1: {
                return "oracle.sysman.vto.vtos.VtosDBLink";
            }
            case 3: {
                return "oracle.sysman.vto.vtos.VtosFunction";
            }
            case 5: {
                return "oracle.sysman.vto.vtos.VtosPackage";
            }
            case 6: {
                return "oracle.sysman.vto.vtos.VtosPackageBody";
            }
            case 7: {
                return "oracle.sysman.vto.vtos.VtosProcedure";
            }
            case 4: {
                return "oracle.sysman.vto.vtos.VtosIndex";
            }
            case 11: {
                return "oracle.sysman.vto.vtos.VtosSequence";
            }
            case 12: {
                return "oracle.sysman.vto.vtos.VtosSynonym";
            }
            case 13: {
                return "oracle.sysman.vto.vtos.VtosTable";
            }
            case 15: {
                return "oracle.sysman.vto.vtos.VtosTrigger";
            }
            case 17: {
                return "oracle.sysman.vto.vtos.VtosView";
            }
            case 26: {
                return "oracle.sysman.vto.vtos.VtosQueueTable";
            }
            case 27: {
                return "oracle.sysman.vto.vtos.VtosQueue";
            }
            case 28: {
                return "oracle.sysman.vto.vtos.VtosArrayType";
            }
            case 29: {
                return "oracle.sysman.vto.vtos.VtosTableType";
            }
            case 30: {
                return "oracle.sysman.vto.vtos.VtosObjectType";
            }
            case 31: {
                return "oracle.sysman.vto.vtol.VtolRefreshGroup";
            }
            case 32: {
                return "oracle.sysman.vto.vtol.VtolOneSnapshotItem";
            }
            case 33: {
                return "oracle.sysman.vto.vtol.VtolSnapshotLog";
            }
            case 36: {
                return "oracle.sysman.vto.vtos.VtosOneIndexPartition";
            }
            case 37: {
                return "oracle.sysman.vto.vtos.VtosOneTablePartition";
            }
            case 56: {
                return "oracle.sysman.vto.vtos.VtosJavaSource";
            }
            case 78: {
                return "oracle.sysman.vto.vtos.VtosDimension";
            }
            case 2: {
                return "oracle.sysman.vto.vtog.VtogDatafile";
            }
            case 14: {
                return "oracle.sysman.vto.vtog.VtogTablespace";
            }
            case 10: {
                return "oracle.sysman.vto.vtog.VtogRollbackSegment";
            }
            case 40: {
                return "oracle.sysman.vto.VtoObject";
            }
            case 41: {
                return "oracle.sysman.vto.vtog.VtogRedoLogGroup";
            }
            case 70: {
                return "oracle.sysman.vto.vtog.VtogControlfile";
            }
            case 71: {
                return "oracle.sysman.vto.vtog.VtogArchiveLog";
            }
            case 16: {
                return "oracle.sysman.vto.vtoy.VtoyUser";
            }
            case 9: {
                return "oracle.sysman.vto.vtoy.VtoyRole";
            }
            case 8: {
                return "oracle.sysman.vto.vtoy.VtoyProfile";
            }
            case 25: 
            case 34: {
                return "oracle.sysman.vto.vtoi.VtoiInitParamCurConfig";
            }
            case 23: {
                return "oracle.sysman.vto.vtoi.VtoiInitParamCurConfig";
            }
            case 24: {
                return "oracle.sysman.vto.vtoi.VtoiInitParamStoConfig";
            }
            case 21: {
                return "oracle.sysman.vto.vtoi.VtoiSession";
            }
            case 22: {
                return "oracle.sysman.vto.vtoi.VtoiTransaction";
            }
            case 75: {
                return "oracle.sysman.vto.vtoi.VtoiResourceGroup";
            }
            case 76: {
                return "oracle.sysman.vto.vtoi.VtoiResourcePlan";
            }
            case 43: 
            case 66: {
                return "oracle.sysman.vto.vtoz.VtozExemplar";
            }
            case 42: {
                return "oracle.sysman.vto.vtoz.VtozDirective";
            }
            case 45: 
            case 72: {
                return "oracle.sysman.vto.vtoz.VtozDestination";
            }
            case 55: 
            case 60: 
            case 61: 
            case 68: 
            case 90: 
            case 92: {
                return "oracle.sysman.vto.vtoz.VtozPlan";
            }
            case 62: 
            case 63: 
            case 67: 
            case 89: 
            case 93: {
                return "oracle.sysman.vto.vtoz.VtozBaseline";
            }
            case 74: 
            case 77: 
            case 82: 
            case 91: 
            case 94: {
                return "oracle.sysman.vto.vtoz.VtozComparison";
            }
        }
        return "oracle.sysman.vto.VtoObject";
    }

    public static String typeIndextoDisplayName(int type) {
        switch (type) {
            case 13: {
                return m_msgBundle.getMessage("3013", false);
            }
            case 16: {
                return m_msgBundle.getMessage("3016", false);
            }
            case 14: {
                return m_msgBundle.getMessage("3014", false);
            }
            case 9: {
                return m_msgBundle.getMessage("3009", false);
            }
            case 8: {
                return m_msgBundle.getMessage("3008", false);
            }
            case 17: {
                return m_msgBundle.getMessage("3017", false);
            }
            case 15: {
                return m_msgBundle.getMessage("3015", false);
            }
            case 4: {
                return m_msgBundle.getMessage("3004", false);
            }
            case 11: {
                return m_msgBundle.getMessage("3011", false);
            }
            case 0: {
                return m_msgBundle.getMessage("3000", false);
            }
            case 7: {
                return m_msgBundle.getMessage("3007", false);
            }
            case 3: {
                return m_msgBundle.getMessage("3003", false);
            }
            case 2: {
                return m_msgBundle.getMessage("3002", false);
            }
            case 5: {
                return m_msgBundle.getMessage("3005", false);
            }
            case 6: {
                return m_msgBundle.getMessage("3006", false);
            }
            case 12: {
                return m_msgBundle.getMessage("3012", false);
            }
            case 10: {
                return m_msgBundle.getMessage("3010", false);
            }
            case 1: {
                return m_msgBundle.getMessage("3001", false);
            }
            case 20: {
                return m_msgBundle.getMessage("3051", false);
            }
            case 18: {
                return m_msgBundle.getMessage("3018", false);
            }
            case 21: {
                return m_msgBundle.getMessage("3020", false);
            }
            case 22: {
                return m_msgBundle.getMessage("3021", false);
            }
            case 23: {
                return m_msgBundle.getMessage("3054", false);
            }
            case 24: {
                return m_msgBundle.getMessage("3023", false);
            }
            case 25: {
                return m_msgBundle.getMessage("3024", false);
            }
            case 26: {
                return m_msgBundle.getMessage("3025", false);
            }
            case 27: {
                return m_msgBundle.getMessage("3026", false);
            }
            case 28: {
                return m_msgBundle.getMessage("3049", false);
            }
            case 29: {
                return m_msgBundle.getMessage("3027", false);
            }
            case 30: {
                return m_msgBundle.getMessage("3028", false);
            }
            case 31: {
                return m_msgBundle.getMessage("3029", false);
            }
            case 32: {
                return m_msgBundle.getMessage("3030", false);
            }
            case 33: {
                return m_msgBundle.getMessage("3031", false);
            }
            case 34: {
                return m_msgBundle.getMessage("3050", false);
            }
            case 35: {
                return m_msgBundle.getMessage("3052", false);
            }
            case 36: {
                return m_msgBundle.getMessage("3032", false);
            }
            case 37: {
                return m_msgBundle.getMessage("3033", false);
            }
            case 38: {
                return m_msgBundle.getMessage("3034", false);
            }
            case 39: {
                return m_msgBundle.getMessage("3035", false);
            }
            case 40: {
                return m_msgBundle.getMessage("3036", false);
            }
            case 41: {
                return m_msgBundle.getMessage("3037", false);
            }
            case 56: {
                return m_msgBundle.getMessage("3048", false);
            }
            case 78: {
                return m_msgBundle.getMessage("3057", false);
            }
            case 75: {
                return m_msgBundle.getMessage("3055", false);
            }
            case 76: {
                return m_msgBundle.getMessage("3056", false);
            }
            case 79: {
                return m_msgBundle.getMessage("3058", false);
            }
            case 80: {
                return m_msgBundle.getMessage("3059", false);
            }
            case 81: {
                return m_msgBundle.getMessage("3060", false);
            }
            case 83: {
                return m_msgBundle.getMessage("3062", false);
            }
            case 84: {
                return m_msgBundle.getMessage("3061", false);
            }
            case 98: {
                return m_msgBundle.getMessage("3063", false);
            }
            case 99: {
                return m_msgBundle.getMessage("3064", false);
            }
            case 100: {
                return m_msgBundle.getMessage("3065", false);
            }
            case 101: {
                return m_msgBundle.getMessage("3066", false);
            }
            case 102: {
                return m_msgBundle.getMessage("3067", false);
            }
            case 71: {
                return m_msgBundle.getMessage("3068", false);
            }
        }
        return m_msgBundle.getMessage("3053", false);
    }

    public static int typeNameToIndex(String name) {
        int index = -1;
        if (name.equals("TABLE")) {
            index = 13;
        } else if (name.equals("USER")) {
            index = 16;
        } else if (name.equals("TABLESPACE")) {
            index = 14;
        } else if (name.equals("ROLE")) {
            index = 9;
        } else if (name.equals("PROFILE")) {
            index = 8;
        } else if (name.equals("VIEW")) {
            index = 17;
        } else if (name.equals("TRIGGER")) {
            index = 15;
        } else if (name.equals("INDEX")) {
            index = 4;
        } else if (name.equals("SEQUENCE")) {
            index = 11;
        } else if (name.equals("CLUSTER")) {
            index = 0;
        } else if (name.equals("PROCEDURE")) {
            index = 7;
        } else if (name.equals("FUNCTION")) {
            index = 3;
        } else if (name.equals("DATAFILE")) {
            index = 2;
        } else if (name.equals("PACKAGE")) {
            index = 5;
        } else if (name.equals("PACKAGE BODY")) {
            index = 6;
        } else if (name.equals("SYNONYM")) {
            index = 12;
        } else if (name.equals("ROLLBACK SEGMENT")) {
            index = 10;
        } else if (name.equals("DATABASE LINK")) {
            index = 1;
        } else if (name.equals("NONE")) {
            index = 20;
        } else if (name.equals("PARTITION")) {
            index = 18;
        } else if (name.equals("SESSION")) {
            index = 21;
        } else if (name.equals("TRANSACTION")) {
            index = 22;
        } else if (name.equals("INIT PARMETERS")) {
            index = 23;
        } else if (name.equals("STORED CONFIGURATION")) {
            index = 24;
        } else if (name.equals("DATABASE")) {
            index = 25;
        } else if (name.equals("QUEUE TABLE")) {
            index = 26;
        } else if (name.equals("QUEUE")) {
            index = 27;
        } else if (name.equals("ARRAY TYPE")) {
            index = 28;
        } else if (name.equals("TABLE TYPE")) {
            index = 29;
        } else if (name.equals("OBJECT TYPE")) {
            index = 30;
        } else if (name.equals("REFRESH GROUP")) {
            index = 31;
        } else if (name.equals("SNAPSHOT")) {
            index = 32;
        } else if (name.equals("SNAPSHOT LOG")) {
            index = 33;
        } else if (name.equals("DIMENSION")) {
            index = 78;
        } else if (name.equals("DATABASE STATE")) {
            index = 34;
        } else if (name.equals("NON-EXISTENT")) {
            index = 35;
        } else if (name.equals("INDEX PARTITION")) {
            index = 36;
        } else if (name.equals("TABLE PARTITION")) {
            index = 37;
        } else if (name.equals("OBJECT PRIVILEGE")) {
            index = 38;
        } else if (name.equals("SYSTEM PRIVILEGE")) {
            index = 39;
        } else if (name.equals("REDO LOG MEMBER")) {
            index = 40;
        } else if (name.equals("REDO LOG GROUP")) {
            index = 41;
        } else if (name.equals("JAVA SOURCE")) {
            index = 56;
        } else if (name.equals("TABLE COLUMNS")) {
            index = 58;
        } else if (name.equals("CONTROL FILE")) {
            index = 70;
        } else if (name.equals("ARCHIVE LOG")) {
            index = 71;
        } else if (name.equals("RESOURCE CONSUMER GROUP")) {
            index = 75;
        } else if (name.equals("RESOURCE PLAN")) {
            index = 76;
        } else if (name.equals("DIRECTIVE")) {
            index = 42;
        } else if (name.equals("EXEMPLAR")) {
            index = 43;
        } else if (name.equals("JOB")) {
            index = 44;
        } else if (name.equals("DESTINATION")) {
            index = 45;
        } else if (name.equals("ONEDESTINATION")) {
            index = 72;
        } else if (name.equals("PLAN")) {
            index = 46;
        } else if (name.equals("SCRIPT")) {
            index = 47;
        } else if (name.equals("ATTRIBUTES")) {
            index = 57;
        } else if (name.equals("GRANTS")) {
            index = 48;
        } else if (name.equals("DEPENDENCIES")) {
            index = 49;
        } else if (name.equals("CHANGE REQUESTS SUBGRP")) {
            index = 50;
        } else if (name.equals("CHANGE REQUESTS GROUP")) {
            index = 51;
        } else if (name.equals("CHANGE REQUEST CHILDREN")) {
            index = 52;
        } else if (name.equals("DESTINATION GROUP")) {
            index = 53;
        } else if (name.equals("PLAN GROUP")) {
            index = 54;
        } else if (name.equals("PLAN MCW GROUP")) {
            index = 55;
        } else if (name.equals("CMUSERSMCW")) {
            index = 58;
        } else if (name.equals("CMUSERALLOBJECTSMCW")) {
            index = 59;
        } else if (name.equals("CMUSERALLOBJECTSMCWNOACCESS")) {
            index = 85;
        } else if (name.equals("CMPLANSMCW")) {
            index = 60;
        } else if (name.equals("CMPLANSMCWNOACCESS")) {
            index = 92;
        } else if (name.equals("CMPLANCRFLDR")) {
            index = 61;
        } else if (name.equals("CMPLANCRFLDRNOACCESS")) {
            index = 95;
        } else if (name.equals("CMBASELINESMCW")) {
            index = 62;
        } else if (name.equals("CMBASELINESMCWNOACCESS")) {
            index = 93;
        } else if (name.equals("CMCOMPARISONSMCW")) {
            index = 74;
        } else if (name.equals("CMCOMPARISONSMCWNOACCESS")) {
            index = 94;
        } else if (name.equals("CMBLCRFLDR")) {
            index = 63;
        } else if (name.equals("CMBLCRFLDRNOACCESS")) {
            index = 96;
        } else if (name.equals("CMCOMPARISONFLDR")) {
            index = 82;
        } else if (name.equals("CMCOMPARISONFLDRNOACCESS")) {
            index = 97;
        } else if (name.equals("CMPLANSFLDR")) {
            index = 64;
        } else if (name.equals("CMPLANSFLDRNOACCESS")) {
            index = 86;
        } else if (name.equals("CMBASELINESFLDR")) {
            index = 65;
        } else if (name.equals("CMBASELINESFLDRNOACCESS")) {
            index = 87;
        } else if (name.equals("BEXEMPLAR")) {
            index = 66;
        } else if (name.equals("CMUSERALLOBJECTSBASELINES")) {
            index = 67;
        } else if (name.equals("CMUSERALLOBJECTSBASELINESNOACCESS")) {
            index = 89;
        } else if (name.equals("CMUSERALLOBJECTSPLANS")) {
            index = 68;
        } else if (name.equals("CMUSERALLOBJECTSPLANSNOACCESS")) {
            index = 90;
        } else if (name.equals("CMUSERALLOBJECTSCOMPARISONS")) {
            index = 77;
        } else if (name.equals("CMUSERALLOBJECTSCOMPARISONSNOACCESS")) {
            index = 91;
        } else if (name.equals("CMCOMPARISONSFLDR")) {
            index = 73;
        } else if (name.equals("CMCOMPARISONSFLDRNOACCESS")) {
            index = 88;
        } else if (name.equals("ROLLBACK")) {
            index = 10;
        } else if (name.equals("CACHE")) {
            index = 79;
        } else if (name.equals("LOBINDEX")) {
            index = 80;
        } else if (name.equals("LOBSEGMENT")) {
            index = 81;
        } else if (name.equals("DEFERRED ROLLBACK")) {
            index = 83;
        } else if (name.equals("TEMPORARY")) {
            index = 84;
        } else if (name.equals("NESTED TABLE")) {
            index = 98;
        } else if (name.equals("INDEX SUBPARTITION")) {
            index = 99;
        } else if (name.equals("TABLE SUBPARTITION")) {
            index = 100;
        } else if (name.equals("LOB PARTITION")) {
            index = 101;
        } else if (name.equals("LOB SUBPARTITION")) {
            index = 102;
        }
        return index;
    }

    private static ImageBundle _getIconBundle() {
        if (m_iconBundle == null) {
            m_iconBundle = new ImageBundle("Vta");
        }
        return m_iconBundle;
    }

    public static Image getSmallIcon(int objType) {
        ImageBundle iconBundle = VxxTypeConstants._getIconBundle();
        if (objType == 0) {
            return iconBundle.getImage("2105");
        }
        if (objType == 1) {
            return iconBundle.getImage("2106");
        }
        if (objType == 78) {
            return iconBundle.getImage("2129");
        }
        if (objType == 3) {
            return iconBundle.getImage("2108");
        }
        if (objType == 4) {
            return iconBundle.getImage("2112");
        }
        if (objType == 6) {
            return iconBundle.getImage("2110");
        }
        if (objType == 5) {
            return iconBundle.getImage("2109");
        }
        if (objType == 7) {
            return iconBundle.getImage("2111");
        }
        if (objType == 11) {
            return iconBundle.getImage("2104");
        }
        if (objType == 12) {
            return iconBundle.getImage("2103");
        }
        if (objType == 13) {
            return iconBundle.getImage("2101");
        }
        if (objType == 15) {
            return iconBundle.getImage("2113");
        }
        if (objType == 17) {
            return iconBundle.getImage("2102");
        }
        if (objType == 8) {
            return iconBundle.getImage("2157");
        }
        if (objType == 9) {
            return iconBundle.getImage("2151");
        }
        if (objType == 16) {
            return iconBundle.getImage("2150");
        }
        if (objType == 26) {
            return iconBundle.getImage("2116");
        }
        if (objType == 27) {
            return iconBundle.getImage("2117");
        }
        if (objType == 28) {
            return iconBundle.getImage("2118");
        }
        if (objType == 29) {
            return iconBundle.getImage("2119");
        }
        if (objType == 30) {
            return iconBundle.getImage("2120");
        }
        if (objType == 2) {
            return iconBundle.getImage("2200");
        }
        if (objType == 14) {
            return iconBundle.getImage("2202");
        }
        if (objType == 10) {
            return iconBundle.getImage("2201");
        }
        if (objType == 31) {
            return iconBundle.getImage("2121");
        }
        if (objType == 32) {
            return iconBundle.getImage("2122");
        }
        if (objType == 33) {
            return iconBundle.getImage("2123");
        }
        if (objType == 41) {
            return iconBundle.getImage("2203");
        }
        if (objType == 56) {
            return iconBundle.getImage("2124");
        }
        if (objType == 75) {
            return iconBundle.getImage("2158");
        }
        if (objType == 76) {
            return iconBundle.getImage("2159");
        }
        return null;
    }

    public static boolean isExtractableType(int type) {
        if (VxxTypeConstants.isStorageType(type) || VxxTypeConstants.isSchemaType(type) || VxxTypeConstants.isSecurityType(type)) {
            return true;
        }
        switch (type) {
            case 21: 
            case 24: 
            case 75: 
            case 76: {
                return true;
            }
        }
        return false;
    }

    public static boolean supportsCreateLike(int type) {
        return VxxTypeConstants.isSchemaType(type) || VxxTypeConstants.isSecurityType(type) || VxxTypeConstants.isStorageType(type) && type != 70 && type != 41 && type != 71;
    }

    public static boolean supportsRemove(int type) {
        return VxxTypeConstants.isSchemaType(type) || VxxTypeConstants.isSecurityType(type) || VxxTypeConstants.isStorageType(type) && type != 70 && type != 2 && type != 71;
    }

    public static boolean supportsShowDependencies(int type) {
        return VxxTypeConstants.isSchemaType(type) || VxxTypeConstants.isSecurityType(type) || VxxTypeConstants.isStorageType(type) && type != 70 && type != 41 && type != 71;
    }

    public static boolean supportsCreateWizard(int type) {
        return type == 13 || type == 17;
    }
}

