/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vxx.VxxTypeConstants;

public class VxxTypes {
    private static MessageBundle m_msgBundle = new MessageBundle("Types");
    private static final String CONTAINER = "_container";
    public static final String VXX_TYPE_NULL = "null";
    public static final String VXX_TYPE_NETWORK = "oracle_sysman_network";
    public static final String VXX_TYPE_DATABASE = "oracle_sysman_database";
    public static final String VXX_TYPE_OPS_DATABASE = "oracle_sysman_ops";
    public static final String VXX_TYPE_OPS_INSTANCE = "oracle_sysman_opsinst";
    public static final String VXX_TYPE_LISTENER = "oracle_sysman_listener";
    public static final String VXX_TYPE_NODE = "oracle_sysman_node";
    public static final String VXX_TYPE_GROUP = "oracle_sysman_group";
    public static final String VXX_TYPE_WEBSERVER = "oracle_sysman_webserver";
    public static final String VXX_TYPE_CARTRIDGE = "oracle_sysman_cartridge";
    public static final String VXX_TYPE_NAMESERVER = "oracle_sysman_nameserver";
    public static final String VXX_TYPE_PAGING = "oracle_sysman_paging";
    public static final String VXX_TYPE_CMANAGER = "oracle_sysman_cmanager";
    public static final String VXX_TYPE_SQL_SERVER = "oracle_sysman_sqlserver";
    public static final String VXX_TYPE_SAP_R3 = "oracle_sysman_sap";
    public static final String[] VXX_TYPE_EQUIVALENT_DATABASES = new String[]{"oracle_sysman_database", "oracle_sysman_ops"};
    public static final String VXX_TYPE_OMS_JOB = "oracle_sysman_oms_job";
    public static final String VXX_TYPE_OMS_JOBLIBRARY = "oracle_sysman_oms_jobLibrary";
    public static final String VXX_TYPE_OMS_EVENT = "oracle_sysman_oms_event";
    public static final String VXX_TYPE_OMS_EVENTLIBRARY = "oracle_sysman_oms_eventLibrary";
    public static final String VXX_TYPE_OMS_USER = "oracle_sysman_oms_user";
    public static final String VXX_TYPE_EVENT = "oracle_sysman_event";
    public static final String VXX_TYPE_JOB = "oracle_sysman_job";
    public static final String VXX_TYPE_CLUSTER = "oracle_sysman_cluster";
    public static final String VXX_TYPE_DATABASE_LINK = "oracle_sysman_dblink";
    public static final String VXX_TYPE_DATAFILE = "oracle_sysman_datafile";
    public static final String VXX_TYPE_FUNCTION = "oracle_sysman_function";
    public static final String VXX_TYPE_INDEX = "oracle_sysman_index";
    public static final String VXX_TYPE_PACKAGE = "oracle_sysman_package";
    public static final String VXX_TYPE_PACKAGE_BODY = "oracle_sysman_packageBody";
    public static final String VXX_TYPE_PROCEDURE = "oracle_sysman_procedure";
    public static final String VXX_TYPE_PROFILE = "oracle_sysman_profile";
    public static final String VXX_TYPE_ROLE = "oracle_sysman_role";
    public static final String VXX_TYPE_ROLLBACK_SEGMENT = "oracle_sysman_rollbackSegment";
    public static final String VXX_TYPE_SEQUENCE = "oracle_sysman_sequence";
    public static final String VXX_TYPE_SYNONYM = "oracle_sysman_synonym";
    public static final String VXX_TYPE_TABLE = "oracle_sysman_table";
    public static final String VXX_TYPE_TABLESPACE = "oracle_sysman_tablespace";
    public static final String VXX_TYPE_TRIGGER = "oracle_sysman_trigger";
    public static final String VXX_TYPE_USER = "oracle_sysman_user";
    public static final String VXX_TYPE_VIEW = "oracle_sysman_view";
    public static final String VXX_TYPE_PARTITION = "oracle_sysman_partition";
    public static final String VXX_TYPE_SCHEMA = "oracle_sysman_schema";
    public static final String VXX_TYPE_TRANSACTION = "oracle_sysman_transaction";
    public static final String VXX_TYPE_INITPARAMETERS = "oracle_sysman_init_parameters";
    public static final String VXX_TYPE_SESSION = "oracle_sysman_session";
    public static final String VXX_TYPE_STOCONFIG = "oracle_sysman_storeConfig";
    public static final String VXX_TYPE_QUEUE_TABLE = "oracle_sysman_queueTable";
    public static final String VXX_TYPE_QUEUE = "oracle_sysman_queue";
    public static final String VXX_TYPE_ARRAY_TYPE = "oracle_sysman_arrayType";
    public static final String VXX_TYPE_TABLE_TYPE = "oracle_sysman_tableType";
    public static final String VXX_TYPE_OBJECT_TYPE = "oracle_sysman_objectType";
    public static final String VXX_TYPE_REFRESH_GROUP = "oracle_sysman_refreshGroup";
    public static final String VXX_TYPE_SNAPSHOT = "oracle_sysman_snapshot";
    public static final String VXX_TYPE_SNAPSHOT_LOG = "oracle_sysman_snapshotLog";
    public static final String VXX_TYPE_INDEX_PARTITION = "oracle_sysman_indexPartition";
    public static final String VXX_TYPE_TABLE_PARTITION = "oracle_sysman_tablePartition";
    public static final String VXX_TYPE_OBJECT_PRIVILEGE = "oracle_sysman_objpriv";
    public static final String VXX_TYPE_SYSTEM_PRIVILEGE = "oracle_sysman_syspriv";
    public static final String VXX_TYPE_REDOLOGMEMBER = "oracle_sysman_redologmember";
    public static final String VXX_TYPE_REDOLOGGROUP = "oracle_sysman_redologgroup";
    public static final String VXX_TYPE_JAVA_SOURCE = "oracle_sysman_java_source";
    public static final String VXX_TYPE_TABLE_COLUMNS = "oracle_sysman_table_columns";
    public static final String VXX_TYPE_CONTROLFILE = "oracle_sysman_controlfile";
    public static final String VXX_TYPE_RESOURCE_CONSUMER_GROUPS = "oracle_sysman_rsrc_group";
    public static final String VXX_TYPE_RESOURCE_PLANS = "oracle_sysman_rsrc_plan";
    public static final String VXX_TYPE_DIMENSION = "oracle_sysman_dimension";
    public static final String VXX_TYPE_RESOURCE_GROUP_GRANTEES = "oracle_sysman_rsrcgrp_grantees";

    public static String getContainerType(String type) {
        return String.valueOf(type) + CONTAINER;
    }

    public static String getInstanceType(String type) {
        int pos = type.indexOf(CONTAINER);
        if (pos >= 0) {
            return type.substring(0, pos);
        }
        return type;
    }

    public static boolean isContainerType(String type) {
        int pos = type.indexOf(CONTAINER);
        return pos != -1;
    }

    public static String typeToVtoClassName(String name) {
        String ret = null;
        if (name == null) {
            return null;
        }
        if (name.equals(VXX_TYPE_DATABASE)) {
            ret = VxxTypeConstants.typeIndextoVtoClassName(25);
        }
        return ret;
    }

    public static String getUserVisibleTypeName(String type) {
        String typeID = null;
        if (type.equalsIgnoreCase(VXX_TYPE_CLUSTER)) {
            typeID = "3000";
        } else if (type.equalsIgnoreCase(VXX_TYPE_DATABASE_LINK)) {
            typeID = "3001";
        } else if (type.equalsIgnoreCase(VXX_TYPE_DATAFILE)) {
            typeID = "3002";
        } else if (type.equalsIgnoreCase(VXX_TYPE_FUNCTION)) {
            typeID = "3003";
        } else if (type.equalsIgnoreCase(VXX_TYPE_INDEX)) {
            typeID = "3004";
        } else if (type.equalsIgnoreCase(VXX_TYPE_PACKAGE)) {
            typeID = "3005";
        } else if (type.equalsIgnoreCase(VXX_TYPE_PACKAGE_BODY)) {
            typeID = "3006";
        } else if (type.equalsIgnoreCase(VXX_TYPE_PROCEDURE)) {
            typeID = "3007";
        } else if (type.equalsIgnoreCase(VXX_TYPE_PROFILE)) {
            typeID = "3008";
        } else if (type.equalsIgnoreCase(VXX_TYPE_ROLE)) {
            typeID = "3009";
        } else if (type.equalsIgnoreCase(VXX_TYPE_ROLLBACK_SEGMENT)) {
            typeID = "3010";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SEQUENCE)) {
            typeID = "3011";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SYNONYM)) {
            typeID = "3012";
        } else if (type.equalsIgnoreCase(VXX_TYPE_TABLE)) {
            typeID = "3013";
        } else if (type.equalsIgnoreCase(VXX_TYPE_TABLESPACE)) {
            typeID = "3014";
        } else if (type.equalsIgnoreCase(VXX_TYPE_TRIGGER)) {
            typeID = "3015";
        } else if (type.equalsIgnoreCase(VXX_TYPE_USER)) {
            typeID = "3016";
        } else if (type.equalsIgnoreCase(VXX_TYPE_PARTITION)) {
            typeID = "3018";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SCHEMA)) {
            typeID = "3019";
        } else if (type.equalsIgnoreCase(VXX_TYPE_TRANSACTION)) {
            typeID = "3021";
        } else if (type.equalsIgnoreCase(VXX_TYPE_INITPARAMETERS)) {
            typeID = "3022";
        } else if (type.equalsIgnoreCase(VXX_TYPE_STOCONFIG)) {
            typeID = "3023";
        } else if (type.equalsIgnoreCase(VXX_TYPE_DATABASE)) {
            typeID = "3024";
        } else if (type.equalsIgnoreCase(VXX_TYPE_QUEUE_TABLE)) {
            typeID = "3025";
        } else if (type.equalsIgnoreCase(VXX_TYPE_QUEUE)) {
            typeID = "3026";
        } else if (type.equalsIgnoreCase(VXX_TYPE_TABLE_TYPE)) {
            typeID = "3027";
        } else if (type.equalsIgnoreCase(VXX_TYPE_OBJECT_TYPE)) {
            typeID = "3028";
        } else if (type.equalsIgnoreCase(VXX_TYPE_REFRESH_GROUP)) {
            typeID = "3029";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SNAPSHOT)) {
            typeID = "3030";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SNAPSHOT_LOG)) {
            typeID = "3031";
        } else if (type.equalsIgnoreCase(VXX_TYPE_INDEX_PARTITION)) {
            typeID = "3032";
        } else if (type.equalsIgnoreCase(VXX_TYPE_TABLE_PARTITION)) {
            typeID = "3033";
        } else if (type.equalsIgnoreCase(VXX_TYPE_OBJECT_PRIVILEGE)) {
            typeID = "3034";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SYSTEM_PRIVILEGE)) {
            typeID = "3035";
        } else if (type.equalsIgnoreCase(VXX_TYPE_REDOLOGMEMBER)) {
            typeID = "3036";
        } else if (type.equalsIgnoreCase(VXX_TYPE_REDOLOGGROUP)) {
            typeID = "3037";
        } else if (type.equalsIgnoreCase(VXX_TYPE_NETWORK)) {
            typeID = "3038";
        } else if (type.equalsIgnoreCase(VXX_TYPE_LISTENER)) {
            typeID = "3039";
        } else if (type.equalsIgnoreCase(VXX_TYPE_NODE)) {
            typeID = "3040";
        } else if (type.equalsIgnoreCase(VXX_TYPE_GROUP)) {
            typeID = "3041";
        } else if (type.equalsIgnoreCase(VXX_TYPE_WEBSERVER)) {
            typeID = "3042";
        } else if (type.equalsIgnoreCase(VXX_TYPE_CARTRIDGE)) {
            typeID = "3043";
        } else if (type.equalsIgnoreCase(VXX_TYPE_NAMESERVER)) {
            typeID = "3044";
        } else if (type.equalsIgnoreCase(VXX_TYPE_JOB)) {
            typeID = "3046";
        } else if (type.equalsIgnoreCase(VXX_TYPE_EVENT)) {
            typeID = "3047";
        } else if (type.equalsIgnoreCase(VXX_TYPE_JAVA_SOURCE)) {
            typeID = "3048";
        } else if (type.equalsIgnoreCase(VXX_TYPE_RESOURCE_CONSUMER_GROUPS)) {
            typeID = "3055";
        } else if (type.equalsIgnoreCase(VXX_TYPE_RESOURCE_PLANS)) {
            typeID = "3056";
        } else if (type.equalsIgnoreCase(VXX_TYPE_DIMENSION)) {
            typeID = "3057";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SQL_SERVER)) {
            typeID = "3069";
        } else if (type.equalsIgnoreCase(VXX_TYPE_CMANAGER)) {
            typeID = "3070";
        } else if (type.equalsIgnoreCase(VXX_TYPE_SAP_R3)) {
            typeID = "3071";
        } else if (type.equalsIgnoreCase(VXX_TYPE_OPS_INSTANCE)) {
            typeID = "3072";
        }
        if (typeID != null) {
            return m_msgBundle.getMessage(typeID, false);
        }
        return null;
    }

    public static String[] getEquivalentTypes(String type) {
        if (type.equalsIgnoreCase(VXX_TYPE_DATABASE)) {
            return VXX_TYPE_EQUIVALENT_DATABASES;
        }
        return new String[]{type};
    }

    public static boolean isEquivalentType(String baseType, String type) {
        if (baseType.equalsIgnoreCase(VXX_TYPE_DATABASE)) {
            return VxxTypes.compareStringToArrayElements(type, VXX_TYPE_EQUIVALENT_DATABASES);
        }
        return baseType.equalsIgnoreCase(type);
    }

    public static String getRootType(String type) {
        if (type.equalsIgnoreCase(VXX_TYPE_OPS_DATABASE)) {
            return VXX_TYPE_DATABASE;
        }
        return type;
    }

    public static boolean isDistributed(String type) {
        return type.equalsIgnoreCase(VXX_TYPE_OPS_DATABASE);
    }

    private static boolean compareStringToArrayElements(String s, String[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("string is null");
        }
        int i = 0;
        while (i < array.length) {
            if (s.equalsIgnoreCase(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

