/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx.vxxd;

import oracle.sysman.vxx.vxxd.CryptException;
import oracle.sysman.vxx.vxxd.VxxdDES;

public class VxxdCrypt {
    private VxxdDES desEngine = new VxxdDES();

    public String encrypt(String data, String password) {
        if (data.length() <= 0) {
            return data;
        }
        return new String(this.encryptAsByteArray(data, password));
    }

    public byte[] encryptAsByteArray(String data, String password) {
        if (data.length() <= 0) {
            return data.getBytes();
        }
        data = this.padString(data);
        password = this.padString(password);
        return this.encryptAsByteArray(data.getBytes(), password.getBytes());
    }

    public synchronized byte[] encryptAsByteArray(byte[] databytes, byte[] passwordbytes) {
        if (databytes.length <= 0) {
            return databytes;
        }
        databytes = this.padBytes(databytes);
        passwordbytes = this.padBytes(passwordbytes);
        int datalength = databytes.length;
        byte[] passwordSize = new byte[8];
        int i = 0;
        while (i < 8) {
            passwordSize[i] = passwordbytes[i];
            ++i;
        }
        this.desEngine.setKeys(passwordSize);
        DataHolder dataHolder = new DataHolder(databytes);
        int i2 = 0;
        while (i2 < datalength) {
            byte[] encryptedData = dataHolder.getSet();
            try {
                this.desEngine.desEncryption(encryptedData, 1);
            }
            catch (CryptException cryptException) {
                System.out.println("Caught cryptException");
            }
            dataHolder.putSet(encryptedData);
            i2 += 8;
        }
        this.desEngine.nullKeys();
        return dataHolder.getResult();
    }

    public synchronized String decrypt(String data, String password) {
        if (data.length() <= 0) {
            return data;
        }
        String decryptedString = new String(this.decryptAsByteArray(data.getBytes(), password.getBytes()));
        return decryptedString.trim();
    }

    public synchronized byte[] decryptAsByteArray(byte[] databytes, byte[] passwordbytes) {
        if (databytes.length <= 0) {
            return databytes;
        }
        passwordbytes = this.padBytes(passwordbytes);
        int datalength = databytes.length;
        byte[] passwordSize = new byte[8];
        int i = 0;
        while (i < 8) {
            passwordSize[i] = passwordbytes[i];
            ++i;
        }
        this.desEngine.setKeys(passwordSize);
        DataHolder dataHolder = new DataHolder(databytes);
        int i2 = 0;
        while (i2 < datalength) {
            byte[] decryptedData = dataHolder.getSet();
            try {
                this.desEngine.desDecryption(decryptedData, 1);
            }
            catch (CryptException cryptException) {
                System.out.println("Caught cryptException");
            }
            dataHolder.putSet(decryptedData);
            i2 += 8;
        }
        this.desEngine.nullKeys();
        return this.stripSpaceBytes(dataHolder.getResult());
    }

    public void close() {
        this.desEngine.nullKeys();
        this.desEngine = null;
    }

    private byte[] stripSpaceBytes(byte[] inputBytes) {
        int endOfArray = 0;
        int i = inputBytes.length - 1;
        while (i >= 0) {
            if (inputBytes[i] != 32) {
                endOfArray = i + 1;
                i = -1;
            }
            --i;
        }
        if (endOfArray == 0) {
            return new byte[endOfArray];
        }
        byte[] rArray = new byte[endOfArray];
        System.arraycopy(inputBytes, 0, rArray, 0, endOfArray);
        return rArray;
    }

    private byte[] padBytes(byte[] inputBytes) {
        byte[] outputBytes = null;
        int padlength = 0;
        int modulo = 0;
        int datalength = inputBytes.length;
        if (datalength < 8) {
            padlength = 8 - datalength;
        } else {
            modulo = datalength % 8;
            if (modulo > 0) {
                padlength = 8 - modulo;
            }
        }
        if (padlength == 0) {
            return inputBytes;
        }
        int spaceByte = 32;
        outputBytes = new byte[datalength + padlength];
        int i = 0;
        while (i < datalength) {
            outputBytes[i] = inputBytes[i];
            ++i;
        }
        int totallength = datalength + padlength;
        int i2 = datalength;
        while (i2 < totallength) {
            outputBytes[i2] = spaceByte;
            ++i2;
        }
        return outputBytes;
    }

    private String padString(String inputString) {
        int padlength = 0;
        int modulo = 0;
        int datalength = inputString.length();
        if (datalength < 8) {
            padlength = 8 - datalength;
        } else {
            modulo = datalength % 8;
            if (modulo > 0) {
                padlength = 8 - modulo;
            }
        }
        if (padlength != 0) {
            char[] pad = new char[padlength];
            int i = 0;
            while (i < padlength) {
                pad[i] = 32;
                ++i;
            }
            String padString = new String(pad);
            inputString = inputString.concat(padString);
        }
        return inputString;
    }

    class DataHolder {
        private int nextGet;
        private int nextPut;
        private byte[] initialData;
        private byte[] resultantData;
        private byte[] dataBlock;
        private int datalength;

        public DataHolder(byte[] initialData) {
            VxxdCrypt.this = VxxdCrypt.this;
            this.datalength = initialData.length;
            this.initialData = initialData;
            this.resultantData = new byte[this.datalength];
        }

        public byte[] getSet() {
            if (this.nextGet > this.datalength) {
                return null;
            }
            this.dataBlock = new byte[8];
            int i = 0;
            while (i < 8) {
                this.dataBlock[i] = this.initialData[this.nextGet];
                ++i;
                ++this.nextGet;
            }
            return this.dataBlock;
        }

        public void putSet(byte[] inputSet) {
            int i = 0;
            while (i < inputSet.length) {
                this.resultantData[this.nextPut] = inputSet[i];
                ++i;
                ++this.nextPut;
            }
        }

        public byte[] getResult() {
            return this.resultantData;
        }
    }
}

