/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx.vxxt;

import java.io.DataOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import oracle.sysman.vxx.vxxt.LoggerStream;

public class VxxtTRACE {
    private static boolean m_bTraceEnabled;
    private static boolean m_bTraceThreads;
    private static boolean m_bFullTrace;
    private static int m_CurrentTraceLevel;
    public static final int USER_LEVEL = 5;
    public static final int ADMIN_LEVEL = 3;
    public static final int DEVELOPER_LEVEL = 2;
    public static final int DEBUG_LEVEL = 2;
    public static final int INFORMATION_LEVEL = 3;
    public static final int WARNING_LEVEL = 4;
    public static final int ERROR_LEVEL = 15;
    public static final int CRITICAL_LEVEL = 16;
    private static boolean m_bTraceToStdOut;
    private static String m_strTraceFileName;
    private static boolean m_bTraceToFile;
    private static PrintStream m_psOut;
    private static DataOutputStream m_dsOut;
    private static boolean m_bPrintDate;
    private static boolean m_bPrintLineInfo;
    private static String m_strJavaNewLine;
    private static String m_strFinalizer;
    private static Throwable m_thTrace;
    private static StringWriter m_swTrace;
    private static PrintWriter m_pwTrace;
    private static StringTokenizer m_stStringTokenizer;
    protected static PrintStream m_stdout;
    protected static PrintStream m_stderr;
    private static int m_maxLogOutputSize;
    private static int m_maxLogOutputFiles;
    private static boolean m_bSavePreviousLog;
    public static final int MINIMUM_LOGGING_FILE_CNT = 2;

    public static void traceEnabled(boolean bState) {
        m_bTraceEnabled = bState;
    }

    public static void setTraceLevel(int nTraceLevel) {
        m_CurrentTraceLevel = nTraceLevel;
    }

    public static void configure(boolean traceToWindow, boolean traceToStdOut, boolean printDate, boolean traceToFile, String traceFileName, boolean printLineInfo) {
        if (!m_bFullTrace) {
            return;
        }
        if (m_bTraceEnabled) {
            return;
        }
        m_bTraceEnabled = true;
        m_bTraceToStdOut = traceToStdOut;
        m_bPrintDate = printDate;
        m_bPrintLineInfo = printLineInfo;
        if (traceToFile) {
            VxxtTRACE.enableLogging(traceFileName);
        }
    }

    public static void setMaxLogOutputSize(int sizeInMeg) {
        m_maxLogOutputSize = sizeInMeg;
    }

    public static void setMaxLogOutputFiles(int nFiles) {
        m_maxLogOutputFiles = nFiles;
    }

    public static void setSavePreviousLog(boolean bSave) {
        m_bSavePreviousLog = bSave;
    }

    public static void setTraceThreadsOption(boolean tt) {
        m_bTraceThreads = tt;
    }

    public static void enableDebugTracing() {
        m_CurrentTraceLevel = 2;
        m_bFullTrace = true;
    }

    public static void out(Object obj) {
        if (obj != null) {
            VxxtTRACE.out(obj.toString());
        } else {
            VxxtTRACE.out("null");
        }
    }

    public static void out(String strText, int level) {
        if (VxxtTRACE.isLevelEnabled(level)) {
            VxxtTRACE.internalOut(strText, level);
        }
    }

    public static boolean isLevelEnabled(int level) {
        return m_bTraceEnabled && level >= m_CurrentTraceLevel || level == 16;
    }

    public static void out(String strText) {
        if (VxxtTRACE.isLevelEnabled(2)) {
            VxxtTRACE.internalOut(strText, 2);
        }
    }

    private static void internalOut(String strText, int level) {
        if (m_bTraceEnabled) {
            Calendar cal = Calendar.getInstance();
            String timeStamp = String.valueOf(cal.get(1)) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + ":" + cal.get(14);
            if (m_bTraceThreads) {
                strText = " [" + Thread.currentThread().getName() + "][" + timeStamp + "] " + strText;
            }
            if (m_bPrintLineInfo) {
                m_thTrace = new Throwable();
                m_swTrace = new StringWriter();
                m_pwTrace = new PrintWriter((Writer)m_swTrace, true);
                m_thTrace.printStackTrace(m_pwTrace);
                String temp = m_swTrace.toString();
                StringTokenizer stStringTokenizer = new StringTokenizer(temp, m_strJavaNewLine);
                stStringTokenizer.nextToken();
                stStringTokenizer.nextToken();
                stStringTokenizer.nextToken();
                String trace_info_line = stStringTokenizer.nextToken();
                stStringTokenizer = new StringTokenizer(trace_info_line);
                stStringTokenizer.nextToken();
                trace_info_line = stStringTokenizer.nextToken();
                strText = String.valueOf(strText) + "  -> " + trace_info_line;
                if (m_bPrintDate) {
                    strText = String.valueOf(strText) + "; " + new Date();
                }
            }
            if (m_bTraceToStdOut || level == 16 || !m_bTraceToFile) {
                VxxtTRACE.traceToStdOut(strText);
                VxxtTRACE.traceToStdOut(m_strJavaNewLine);
            }
            if (m_bTraceToFile) {
                System.out.println(strText);
            }
        }
    }

    public static void out(Exception e) {
        if (m_bTraceEnabled && !m_bFullTrace) {
            VxxtTRACE.out(e.toString());
            e.printStackTrace();
        } else if (m_bTraceEnabled) {
            m_swTrace = new StringWriter();
            m_pwTrace = new PrintWriter((Writer)m_swTrace, true);
            e.printStackTrace(m_pwTrace);
            String temp = m_swTrace.toString();
            VxxtTRACE.out(String.valueOf(e.toString()) + m_strJavaNewLine + temp);
        }
    }

    public static void finalizerOut(String strText, int level) {
        block8: {
            block7: {
                if (!m_bTraceEnabled && level < 16) break block7;
                if (m_bTraceThreads) {
                    System.out.print(m_strFinalizer);
                }
                System.out.println(strText);
                break block8;
            }
            if (!m_bTraceEnabled) break block8;
            if (m_bTraceToStdOut) {
                if (m_bTraceThreads) {
                    VxxtTRACE.traceToStdOut(m_strFinalizer);
                }
                VxxtTRACE.traceToStdOut(strText);
                VxxtTRACE.traceToStdOut(m_strJavaNewLine);
            }
            if (m_bTraceToFile) {
                try {
                    if (m_bTraceThreads) {
                        System.out.print(m_strFinalizer);
                    }
                    System.out.println(strText);
                }
                catch (Exception e) {
                    System.out.print("Trace: error writing to file ");
                    System.out.print(m_strTraceFileName);
                    System.out.print(".  All further file output is terminated");
                    System.out.println(e);
                    m_bTraceToFile = false;
                }
            }
        }
    }

    public static void backup() {
        if (m_psOut != null) {
            m_psOut.close();
        }
        LoggerStream.updateOldFiles(m_strTraceFileName, true);
    }

    private static void openTraceFile() {
        try {
            if (m_maxLogOutputSize <= 0) {
                m_psOut = new LoggerStream(m_strTraceFileName, m_bSavePreviousLog);
            } else {
                m_maxLogOutputFiles = Math.max(m_maxLogOutputFiles, 2);
                long eachFileSize = LoggerStream.convertMegToBytes(m_maxLogOutputSize) / (long)m_maxLogOutputFiles;
                m_psOut = new LoggerStream(m_strTraceFileName, m_maxLogOutputFiles, eachFileSize, m_bSavePreviousLog);
            }
        }
        catch (Exception e) {
            System.out.println("Trace: error opening file " + m_strTraceFileName + " All further file output is terminated");
            e.printStackTrace();
            System.out.println(e);
            m_bTraceToFile = false;
        }
    }

    public static void stackTrace(Throwable th) {
        block4: {
            if (!m_bFullTrace) {
                return;
            }
            m_thTrace = th == null ? new Throwable() : th;
            m_swTrace = new StringWriter();
            m_pwTrace = new PrintWriter((Writer)m_swTrace, true);
            m_thTrace.printStackTrace(m_pwTrace);
            String temp = m_swTrace.toString();
            if (m_bTraceToStdOut) {
                VxxtTRACE.traceToStdOut(temp);
                VxxtTRACE.traceToStdOut(m_strJavaNewLine);
            }
            if (!m_bTraceToFile) break block4;
            try {
                System.out.println(temp);
            }
            catch (Exception e) {
                System.out.println("Trace: error writing to file " + m_strTraceFileName + " All further file output is terminated");
                System.out.println(e);
                m_bTraceToFile = false;
            }
        }
    }

    public static void stackTrace() {
        VxxtTRACE.stackTrace(null);
    }

    public static void enableLogging(String traceFileName) {
        m_bTraceToFile = true;
        m_strTraceFileName = traceFileName;
        m_stdout = System.out;
        m_stderr = System.err;
        if (m_bTraceToFile && m_psOut == null) {
            VxxtTRACE.openTraceFile();
            System.setErr(m_psOut);
            System.setOut(m_psOut);
        }
    }

    public static void traceToStdOut(String str) {
        if (m_bTraceToFile) {
            m_stdout.print(str);
        } else {
            System.out.print(str);
        }
    }

    static {
        m_bTraceThreads = true;
        m_psOut = null;
        m_dsOut = null;
        m_strJavaNewLine = System.getProperty("line.separator");
        m_strFinalizer = "[* Finalizer *] ";
    }
}

