/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;
import oracle.repapi.client.AllA;
import oracle.repapi.client.ClientConsts;
import oracle.repapi.client.RSTracker;
import oracle.repapi.client.RepAPI;
import oracle.repapi.client.RepAPITest;
import oracle.repapi.client.SnapAccess;
import oracle.repapi.joint.ErrorResult;
import oracle.repapi.joint.GroupResultSet;
import oracle.repapi.joint.RepAPIConditionals;
import oracle.repapi.joint.RepAPIException;
import oracle.repapi.joint.ResultSet;
import oracle.repapi.joint.ResultSetFactory;

public final class RefGrp
implements ClientConsts,
RepAPIConditionals {
    protected int m_rgid;
    private int m_last_refresh;
    private boolean m_dropped = false;
    private RepAPI m_repobj;
    private boolean m_read_only;
    private byte m_refresh_option = 0;
    protected String m_refresh_group_name;
    private int m_refresh_sequence_number;
    private SnapAccess[] m_snaplist;
    private AllA m_FDS;
    private boolean m_locked = false;

    protected RefGrp(RepAPI repapi, String rgn, int gid) {
        this.m_repobj = repapi;
        this.m_refresh_group_name = rgn;
        this.m_rgid = gid;
    }

    protected RefGrp(RepAPI repapi, String rgn, int gid, SnapAccess[] snap) {
        this.m_repobj = repapi;
        this.m_refresh_group_name = rgn;
        this.m_snaplist = snap;
        this.m_rgid = gid;
    }

    protected void dropSnapshot(String name) throws RepAPIException {
        new RepAPITest(this.m_repobj).executeEvent(24);
        if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
            this.unlock();
            this.m_FDS.notifyAndClear(null);
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        try {
            new RepAPITest(this.m_repobj).executeEvent(25);
            this.m_FDS.m_local.m_fdsa.drop(name);
        }
        catch (Throwable ioe) {
            if (this.m_repobj.m_debug_switch) {
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(205, new String[]{name}, new String[]{ioe.getMessage()})}, 0, 0, 0, 0, 2);
            this.m_FDS.m_remote.error(err);
            this.unlock();
            this.m_FDS.notifyAndClear(err);
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
    }

    protected boolean fdsAccessAvailable() {
        if (this.getFDSAccess() == null) {
            this.m_FDS = this.m_repobj.getAccess();
            if (this.m_FDS == null) {
                return false;
            }
        }
        return true;
    }

    protected void fillSnaplist() throws RepAPIException {
        if (this.m_repobj.m_debug_switch) {
            System.out.println("fillSnaplist");
        }
        if (this.m_snaplist != null) {
            return;
        }
        boolean offset = false;
        try {
            short[] pos1 = new short[]{5, 6};
            int[] intarray = new int[]{this.m_rgid};
            ResultSet SnapRS = ResultSetFactory.createSingleRow(pos1, new Object[]{intarray, this.m_repobj.m_master_name}, this.m_repobj.m_diffchset);
            RSTracker rst = new RSTracker();
            ResultSet snapsRS = null;
            Stack<SnapAccess> tmpstack = new Stack<SnapAccess>();
            do {
                if ((snapsRS = this.m_FDS.m_local.m_snap_tab.fetch(ClientConsts.SNAP_SNF, SnapRS, null, rst)) == null) {
                    throw new IOException("");
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(snapsRS.buf);
                DataInputStream dis = new DataInputStream(bis);
                offset = false;
                int[] colLengths = ResultSetFactory.decodeLengths(snapsRS, snapsRS.numrows * snapsRS.cold.pos.length);
                int i = 0;
                while (i < snapsRS.numrows) {
                    int sid = dis.readInt();
                    String name = ResultSetFactory.getStringColumn(dis, colLengths[i * 4 + 1], this.m_repobj.m_diffchset);
                    String schema = ResultSetFactory.getStringColumn(dis, colLengths[i * 4 + 2], this.m_repobj.m_diffchset);
                    short flag = dis.readShort();
                    SnapAccess tmpobject = tmpstack.push(new SnapAccess(this.m_rgid, sid, name, schema, flag));
                    ++i;
                }
            } while (rst.m_RSmore);
            new RepAPITest(this.m_repobj).executeEvent(26);
            this.m_snaplist = new SnapAccess[tmpstack.size()];
            int i = 0;
            while (i < this.m_snaplist.length) {
                this.m_snaplist[i] = (SnapAccess)tmpstack.elementAt(i);
                ++i;
            }
        }
        catch (Throwable ioe) {
            if (this.m_repobj.m_debug_switch) {
                ioe.printStackTrace();
            }
            throw new RepAPIException(501, new String[]{String.valueOf(this.m_rgid)}, new String[]{ioe.getMessage()});
        }
    }

    protected AllA getFDSAccess() {
        return this.m_FDS;
    }

    protected String getNextSnaplistName() {
        if (this.m_snaplist == null || this.m_snaplist.length < 1) {
            return null;
        }
        return this.m_snaplist[this.m_snaplist.length - 1].m_snapname;
    }

    protected int getRSN() {
        return this.m_refresh_sequence_number;
    }

    public byte getRefreshOption() {
        return this.m_refresh_option;
    }

    protected SnapAccess getSnaplistElement(int snapid) {
        if (this.m_snaplist == null || this.m_snaplist.length < 1) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < this.m_snaplist.length) {
            if (this.m_snaplist[i].m_snap_id == snapid) {
                return this.m_snaplist[i];
            }
            ++i;
        }
        return null;
    }

    protected SnapAccess getSnaplistElement(String sname) {
        if (this.m_snaplist == null || this.m_snaplist.length < 1) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < this.m_snaplist.length) {
            if (this.m_snaplist[i].m_snapname.equals(sname)) break;
            ++i;
        }
        if (i == this.m_snaplist.length) {
            return null;
        }
        return this.m_snaplist[i];
    }

    protected SnapAccess getSnaplistElementAt(int i) {
        if (this.m_snaplist == null || this.m_snaplist.length < 1) {
            return null;
        }
        return this.m_snaplist[i];
    }

    protected int getSnaplistSize() {
        if (this.m_snaplist == null || this.m_snaplist.length < 1) {
            return 0;
        }
        return this.m_snaplist.length;
    }

    protected boolean isLocked() {
        return this.m_locked;
    }

    protected synchronized boolean lock() {
        if (this.isLocked()) {
            return false;
        }
        this.m_locked = true;
        return true;
    }

    private void refresh() throws RepAPIException {
        ErrorResult err;
        boolean push_needed = false;
        if (this.m_repobj.m_debug_switch) {
            System.out.println("Refresh");
        }
        new RepAPITest(this.m_repobj).executeEvent(27);
        if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
            this.unlock();
            this.m_FDS.notifyAndClear(null);
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        this.fillSnaplist();
        RSTracker rst = new RSTracker();
        ResultSet RefRS = null;
        int[] intarray = new int[]{this.m_rgid};
        short[] pos1 = new short[]{1, 3};
        try {
            RefRS = ResultSetFactory.createSingleRow(pos1, new Object[]{intarray, this.m_repobj.m_master_name}, this.m_repobj.m_diffchset);
            new RepAPITest(this.m_repobj).executeEvent(28);
            if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
                this.unlock();
                this.m_FDS.notifyAndClear(null);
                this.m_repobj.abortOrRemote(this.m_FDS);
            }
            RefRS = this.m_FDS.m_local.m_refgrp_tab.fetch(new short[]{1, 2, 3, 4, 5}, RefRS, null, rst);
            ByteArrayInputStream bis = new ByteArrayInputStream(RefRS.buf);
            DataInputStream dis = new DataInputStream(bis);
            dis.skipBytes(RefRS.buf.length - 8);
            this.m_last_refresh = dis.readInt();
            this.m_refresh_sequence_number = dis.readInt();
        }
        catch (Throwable ioe6) {
            if (this.m_repobj.m_debug_switch) {
                ioe6.printStackTrace();
            }
            ErrorResult err2 = new ErrorResult(new String[]{"C", RepAPIException.msg(309, null, new String[]{ioe6.getMessage()})}, 0, 0, 0, 0, 4);
            this.unlock();
            this.m_FDS.notifyAndClear(err2);
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        ResultSet lpRS = null;
        ResultSet RepRS = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            RepRS = ResultSetFactory.createSingleRow(new short[]{1}, new Object[]{this.m_repobj.m_master_name}, this.m_repobj.m_diffchset, RefRS, RefRS.cold);
            rst = new RSTracker();
            new RepAPITest(this.m_repobj).executeEvent(29);
            if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
                this.unlock();
                this.m_FDS.notifyAndClear(null);
                this.m_repobj.abortOrRemote(this.m_FDS);
            }
            lpRS = this.m_FDS.m_local.m_repapi_tab.fetch(new short[]{4}, RepRS, null, rst);
        }
        catch (Throwable ioe2) {
            if (this.m_repobj.m_debug_switch) {
                ioe2.printStackTrace();
            }
            ErrorResult err3 = new ErrorResult(new String[]{"C", RepAPIException.msg(307, null, new String[]{ioe2.getMessage()})}, 0, 0, 0, 0, 4);
            this.unlock();
            this.m_FDS.notifyAndClear(err3);
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        pos1 = new short[]{1, 1, 3};
        short[] fetch1 = new short[]{3, 4, 5, 6, 8};
        GroupResultSet grs = new GroupResultSet(this.m_rgid, 1, 0, 0, new ResultSet[1]);
        rst = new RSTracker();
        int i = 0;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(bs);
            this.m_FDS.m_notpushed = lpRS == null ? 0 : ResultSetFactory.getIntegerColumn(lpRS.buf, 0) + 1;
            int[] nArray = new int[3];
            nArray[0] = this.m_last_refresh + 1;
            nArray[1] = this.m_FDS.m_notpushed == 0 ? 0 : this.m_FDS.m_notpushed - 1;
            intarray = nArray;
            ResultSet RepQRS = ResultSetFactory.createSingleRow(pos1, new Object[]{intarray}, this.m_repobj.m_diffchset, RefRS, RefRS.cold);
            i = 0;
            while (i < this.m_snaplist.length) {
                new RepAPITest(this.m_repobj).executeEvent(30);
                if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
                    this.unlock();
                    this.m_FDS.notifyAndClear(null);
                    if (push_needed) {
                        this.m_repobj.clearPushLock();
                    }
                    this.m_repobj.abortOrRemote(this.m_FDS);
                }
                try {
                    new RepAPITest(this.m_repobj).executeEvent(31);
                    this.m_snaplist[i].ResetFDSObject(this.m_FDS.m_local.m_fdsa.locate(this.m_snaplist[i].m_snapname, this.m_snaplist[i].m_schemaname, null));
                }
                catch (IOException ioe3) {
                    if (this.m_repobj.m_debug_switch) {
                        ioe3.printStackTrace();
                    }
                    err = new ErrorResult(new String[]{"C", RepAPIException.msg(502, new String[]{this.m_snaplist[i].m_snapname}, new String[]{ioe3.getMessage()})}, 0, 0, 0, 0, 4);
                    if (push_needed) {
                        this.m_FDS.m_remote.error(err);
                    }
                    this.unlock();
                    this.m_FDS.notifyAndClear(err);
                    if (push_needed) {
                        this.m_repobj.clearPushLock();
                    }
                    this.m_repobj.abortOrRemote(this.m_FDS);
                }
                this.m_snaplist[i].m_table.lock();
                if (this.m_refresh_option != 67 && (this.m_snaplist[i].m_snaptype & 1) == 0) {
                    boolean firsttime = true;
                    ResultSetFactory.setIntegerColumn(RepQRS.buf, 8, this.m_snaplist[i].m_snap_id);
                    do {
                        ResultSet repQRS = this.m_FDS.m_local.m_repQ_tab.fetch(fetch1, RepQRS, null, rst);
                        new RepAPITest(this.m_repobj).executeEvent(32);
                        if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
                            this.unlock();
                            this.m_FDS.notifyAndClear(null);
                            if (push_needed) {
                                this.m_repobj.clearPushLock();
                            }
                            this.m_repobj.abortOrRemote(this.m_FDS);
                        }
                        if (firsttime) {
                            if (repQRS == null) break;
                            if (!push_needed) {
                                this.m_repobj.testSetPushLock();
                                this.m_FDS.m_remote.refresh_initiate(this.m_rgid, this.m_refresh_option, (short)1, this.m_refresh_sequence_number);
                                push_needed = true;
                            } else {
                                this.m_FDS.m_remote.push_req(grs, ++this.m_FDS.m_sentRequestNumber);
                            }
                        } else {
                            this.m_FDS.m_remote.push_req(grs, ++this.m_FDS.m_sentRequestNumber);
                        }
                        grs.rsltsets[0] = repQRS;
                        grs.rsltsets[0].flags |= 0x1000;
                        grs.rsltsets[0].snapid = 0;
                        grs.rsltsets[0].tranid = 0;
                        firsttime = false;
                    } while (rst.m_RSmore);
                }
                ++i;
            }
        }
        catch (Throwable ioe4) {
            if (this.m_repobj.m_debug_switch) {
                ioe4.printStackTrace();
            }
            ErrorResult err4 = new ErrorResult(new String[]{"C", RepAPIException.msg(308, new String[]{this.m_snaplist[i].m_snapname}, new String[]{ioe4.getMessage()})}, 0, 0, 0, 0, 8);
            if (push_needed) {
                this.m_FDS.m_remote.error(err4);
            }
            this.unlock();
            this.m_FDS.notifyAndClear(err4);
            if (push_needed) {
                this.m_repobj.clearPushLock();
            }
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        try {
            intarray = new int[]{this.m_FDS.m_notpushed, Integer.MAX_VALUE};
            ResultSet RepQRS = ResultSetFactory.createSingleRow(new short[]{1, 1}, new Object[]{intarray}, this.m_repobj.m_diffchset, RefRS, RefRS.cold);
            short[] tmpftch = new short[]{1};
            rst = new RSTracker();
            new RepAPITest(this.m_repobj).executeEvent(33);
            if (this.m_FDS.m_abort_received || this.m_FDS.m_fatal_error_received) {
                this.unlock();
                this.m_FDS.notifyAndClear(null);
                if (push_needed) {
                    this.m_repobj.clearPushLock();
                }
                this.m_repobj.abortOrRemote(this.m_FDS);
            }
            boolean firsttime = true;
            ResultSet repQRS = null;
            do {
                repQRS = this.m_FDS.m_local.m_repQ_tab.fetch(tmpftch, RepQRS, null, rst);
                if (firsttime) {
                    if (repQRS == null) {
                        this.m_FDS.m_last_transaction = 0;
                        if (push_needed) {
                            grs.flg = (short)(grs.flg | 1);
                            this.m_FDS.m_remote.push_req(grs, ++this.m_FDS.m_sentRequestNumber);
                            break;
                        }
                    } else if (!push_needed) {
                        this.m_repobj.testSetPushLock();
                        this.m_FDS.m_remote.refresh_initiate(this.m_rgid, this.m_refresh_option, (short)1, this.m_refresh_sequence_number);
                        push_needed = true;
                    } else {
                        this.m_FDS.m_remote.push_req(grs, ++this.m_FDS.m_sentRequestNumber);
                    }
                }
                firsttime = false;
            } while (rst.m_RSmore);
            if (repQRS != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(repQRS.buf);
                DataInputStream dis = new DataInputStream(bis);
                dis.skipBytes(repQRS.buf.length - 4);
                this.m_FDS.m_last_transaction = dis.readInt();
            }
        }
        catch (Throwable ioe5) {
            if (this.m_repobj.m_debug_switch) {
                ioe5.printStackTrace();
            }
            ErrorResult err5 = new ErrorResult(new String[]{"C", RepAPIException.msg(503, null, new String[]{ioe5.getMessage()})}, 0, 0, 0, 0, 8);
            if (push_needed) {
                this.m_FDS.m_remote.error(err5);
            }
            this.unlock();
            this.m_FDS.notifyAndClear(err5);
            if (push_needed) {
                this.m_repobj.clearPushLock();
            }
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        if (push_needed) {
            if (this.m_FDS.m_last_transaction > 0) {
                if (!this.m_repobj.pushToMaster(this.m_FDS, (byte)0)) {
                    err = new ErrorResult(new String[]{"C", RepAPIException.msg(316, null, null)}, 0, 0, 0, 0, 8);
                    this.m_FDS.m_remote.error(err);
                    this.unlock();
                    this.m_FDS.notifyAndClear(err);
                    this.m_repobj.clearPushLock();
                    this.m_repobj.abortOrRemote(this.m_FDS);
                }
            } else {
                this.m_FDS.m_last_transaction = this.m_FDS.m_notpushed > 0 ? this.m_FDS.m_notpushed - 1 : 0;
            }
        } else {
            this.m_FDS.m_remote.refresh_initiate(this.m_rgid, this.m_refresh_option, (short)0, this.m_refresh_sequence_number);
        }
        this.m_FDS.waitTilDone();
        this.unlock();
        this.m_FDS.notifyAndClear(null);
        if (push_needed) {
            push_needed = false;
            this.m_repobj.clearPushLock();
        }
        if (!this.m_FDS.m_ack_sent) {
            this.m_repobj.abortOrRemote(this.m_FDS);
        }
        this.m_FDS.m_refgrp = null;
        this.m_FDS.clearCompletionStatus();
        this.m_FDS.m_repapi = null;
        AllA tmpo = this.m_repobj.m_FDSs.push(this.m_FDS);
    }

    protected void setFDSAccess(AllA fds) {
        this.m_FDS = fds;
    }

    protected void setRSN(int rsn) {
        this.m_refresh_sequence_number = rsn;
    }

    public void setRefreshOption(byte option) {
        this.m_refresh_option = option;
    }

    protected void setRepobj(RepAPI repapi) {
        this.m_repobj = repapi;
    }

    protected boolean snaplistIsEmpty() {
        return this.m_snaplist == null || this.m_snaplist.length == 0;
    }

    public boolean synchronize() throws RepAPIException {
        if (!this.m_repobj.isConnected()) {
            throw new RepAPIException(114, null, null);
        }
        if (this.m_repobj.m_debug_switch) {
            System.out.println("synchronize");
        }
        if (!this.lock()) {
            if (this.m_FDS != null) {
                ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(319, null, null)}, 0, 0, 0, 0, 4);
                this.m_FDS.notifyAndClear(err);
                this.m_repobj.abortOrRemote(this.m_FDS);
            }
            throw new RepAPIException(319, null, null);
        }
        if (!this.fdsAccessAvailable()) {
            this.unlock();
            throw new RepAPIException(101, null, null);
        }
        this.m_FDS.m_refgrp = this;
        if (this.m_refresh_option == 1) {
            return this.m_repobj.push(this.m_FDS);
        }
        this.refresh();
        return true;
    }

    protected synchronized void unlock() {
        this.m_locked = false;
    }
}

