/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.client;

import com.visigenic.vbroker.orb.ORB;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.LoginServer;
import oracle.aurora.client.Login;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.repapi.client.AllA;
import oracle.repapi.client.ClientConsts;
import oracle.repapi.client.FDSAccess;
import oracle.repapi.client.FDSObject;
import oracle.repapi.client.LOBTracker;
import oracle.repapi.client.PKException;
import oracle.repapi.client.RSTracker;
import oracle.repapi.client.RefGrp;
import oracle.repapi.client.RepAPITest;
import oracle.repapi.client.SnapAccess;
import oracle.repapi.client.TableMetadata;
import oracle.repapi.joint.ErrorResult;
import oracle.repapi.joint.GroupResultSet;
import oracle.repapi.joint.RefreshGroup;
import oracle.repapi.joint.RepAPIConditionals;
import oracle.repapi.joint.RepAPIContext;
import oracle.repapi.joint.RepAPIException;
import oracle.repapi.joint.RepAPIVersion;
import oracle.repapi.joint.ResultSet;
import oracle.repapi.joint.ResultSetFactory;
import oracle.repapi.joint.string_bufHolder;
import oracle.repapi.serverstub.RS;
import org.omg.CORBA.BOA;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

public final class RepAPI
implements ClientConsts,
RepAPIConditionals {
    private String m_site_name;
    private int m_site_id;
    protected String m_master_name;
    private String m_master_URL;
    private boolean m_master_ssl;
    private String m_master_service;
    private String m_master_obj;
    private String m_master_uid;
    private String m_master_pwd;
    private static String s_local_dbid;
    private static short s_chset;
    protected boolean m_diffchset = false;
    private static String s_local_uid;
    private static String s_local_pwd;
    ORB m_orb;
    BOA m_boa;
    private boolean m_push_lock = false;
    protected Stack m_FDSs = new Stack();
    protected Stack m_FDSi = new Stack();
    private Stack m_refgroups = new Stack();
    private int m_refresh_threshold;
    private int m_lob_threshold;
    private int m_trace_vector;
    private boolean m_is_connected = false;
    protected boolean m_debug_switch = false;
    protected TableMetadata m_lob_metadata = null;
    protected TableMetadata m_repQ_metadata = null;
    private FDSAccess m_fdsa = null;
    private FDSObject m_rsession_tab = null;
    volatile boolean m_close_run = false;
    private int m_server_port = 0;
    private ServerSocket m_serversocket = null;

    static {
        s_chset = 0;
    }

    public RepAPI(FDSAccess[] fdsa, String dbid, String luid, String lupw, String master, String muid) throws RepAPIException {
        this(fdsa, dbid, luid, lupw, muid, null, master, null, 4096, 4096, false, false, 0, false);
    }

    public RepAPI(FDSAccess[] fdsa, String dbid, String luid, String lupw, String muid, String mupw, String master) throws RepAPIException {
        this(fdsa, dbid, luid, lupw, muid, mupw, master, null, 4096, 4096, true, false, 0, false);
    }

    public RepAPI(FDSAccess[] fdsa, String dbid, String luid, String lupw, String muid, String mupw, String master, String url, int rthresh, int lthresh, boolean connect, boolean ssl) throws RepAPIException {
        this(fdsa, dbid, luid, lupw, muid, mupw, master, url, rthresh, lthresh, connect, ssl, 0, false);
    }

    public RepAPI(FDSAccess[] fdsa, String dbid, String luid, String lupw, String muid, String mupw, String master, String url, int rthresh, int lthresh, boolean connect, boolean ssl, int trace, boolean debug_on) throws RepAPIException {
        if (fdsa == null || fdsa.length == 0) {
            throw new RepAPIException(116, null, null);
        }
        if (master == null) {
            throw new RepAPIException(104, null, null);
        }
        if (muid == null) {
            throw new RepAPIException(105, null, null);
        }
        this.m_master_name = this.canonicalize(master);
        this.m_lob_metadata = new TableMetadata("LOB$_" + this.m_master_name, "", 6, ClientConsts.LOB_CD, 0, null);
        this.m_repQ_metadata = new TableMetadata("REPAPI_QUEUE$_" + this.m_master_name, "", 8, ClientConsts.REPQ_CD, 0, null);
        this.m_master_URL = url;
        this.m_master_ssl = ssl;
        s_local_dbid = dbid;
        s_local_uid = luid;
        s_local_pwd = lupw;
        this.m_master_uid = muid;
        this.m_master_pwd = mupw;
        this.m_refresh_threshold = rthresh;
        this.m_lob_threshold = lthresh;
        this.m_debug_switch = debug_on;
        this.m_trace_vector = trace;
        this.m_fdsa = fdsa[0];
        AllA tmp_alla = this.m_FDSs.push(new AllA(fdsa[0]));
        tmp_alla.m_repapi = this;
        try {
            block44: {
                tmp_alla.m_local.m_fdsa.open(luid, lupw, dbid);
                tmp_alla.m_local.m_fdsa.setThresholds(rthresh, lthresh);
                tmp_alla.m_local.m_repapi_tab = tmp_alla.m_local.m_fdsa.locate("REPAPI$", "", ClientConsts.REPAPI_METADATA);
                this.m_rsession_tab = tmp_alla.m_local.m_fdsa.locate("RSESSION$", "", ClientConsts.RSESSION_METADATA);
                tmp_alla.m_local.m_refgrp_tab = tmp_alla.m_local.m_fdsa.locate("REFGROUP$", "", ClientConsts.REFGRP_METADATA);
                tmp_alla.m_local.m_snap_tab = tmp_alla.m_local.m_fdsa.locate("SNAPSHOT$", "", ClientConsts.SNAPSHOT_METADATA);
                tmp_alla.m_local.m_repQ_tab = tmp_alla.m_local.m_fdsa.locate("REPAPI_QUEUE$_" + this.m_master_name, "", this.m_repQ_metadata);
                tmp_alla.m_local.m_lob_tab = tmp_alla.m_local.m_fdsa.locate("LOB$_" + this.m_master_name, "", this.m_lob_metadata);
                this.m_serversocket = new ServerSocket(0);
                this.m_server_port = this.m_serversocket.getLocalPort();
                ResultSet rsession_row = ResultSetFactory.createSingleRow(new short[]{1, 2, 3}, new java.lang.Object[]{this.m_master_name, new GregorianCalendar(), new int[]{this.m_server_port}});
                try {
                    this.m_rsession_tab.insert(rsession_row);
                }
                catch (PKException p) {
                    boolean caught = false;
                    ResultSet rsession_row2 = ResultSetFactory.createSingleRow(new short[]{1}, new java.lang.Object[]{this.m_master_name});
                    ResultSet portrs = this.m_rsession_tab.fetch(new short[]{3}, rsession_row2, null, new RSTracker());
                    Socket clientsocket = null;
                    try {
                        new RepAPITest(this).executeEvent(34);
                        clientsocket = new Socket(InetAddress.getLocalHost(), ResultSetFactory.getIntegerColumn(portrs.buf, 0));
                    }
                    catch (IOException iOException) {
                        this.m_rsession_tab.update(rsession_row);
                        caught = true;
                    }
                    if (caught) break block44;
                    this.m_serversocket.close();
                    clientsocket.close();
                    this.m_rsession_tab = null;
                    throw new RepAPIException(115, null, new String[]{p.toString()});
                }
            }
            tmp_alla.m_local.m_fdsa.commit();
            new SocketThread().start();
            FDSObject site_table = tmp_alla.m_local.m_fdsa.locate("RSITE$", "", ClientConsts.RSITE_METADATA);
            this.getSiteIdandName(site_table, tmp_alla);
            if (this.m_master_URL == null) {
                ResultSet masterRS = ResultSetFactory.createSingleRow(ClientConsts.COLUMN1, new java.lang.Object[]{this.m_master_name});
                ResultSet urlRS = tmp_alla.m_local.m_repapi_tab.fetch(ClientConsts.REPAPI_URL_SSL, masterRS, null, new RSTracker());
                if (urlRS == null || urlRS.numrows == 0) {
                    ResultSet repapiRow = ResultSetFactory.createSingleRow(new short[]{1, 2, 3, 4}, new java.lang.Object[]{this.m_master_name, ClientConsts.NULLINBYTES, ClientConsts.ZEROINBYTES, ClientConsts.ZEROINBYTES});
                    tmp_alla.m_local.m_repapi_tab.insert(repapiRow);
                } else if (urlRS != null && urlRS.numrows == 1 && urlRS.buf != null) {
                    this.m_master_URL = new String(urlRS.buf, 0, urlRS.buf.length - 1);
                    this.m_master_ssl = urlRS.buf[urlRS.buf.length - 1] == 1;
                }
            } else {
                RSTracker rst;
                ResultSet urlRS = ResultSetFactory.createSingleRow(ClientConsts.COLUMN2, new java.lang.Object[]{this.m_master_URL});
                ResultSet masterRS = tmp_alla.m_local.m_repapi_tab.fetch(ClientConsts.COLUMN1, urlRS, null, rst = new RSTracker());
                if (masterRS != null && (masterRS.numrows > 1 || rst.m_RSmore)) {
                    tmp_alla.rollback();
                    throw new RepAPIException(107, new String[]{this.m_master_URL}, null);
                }
                if (masterRS != null && masterRS.numrows == 1) {
                    if (!this.m_master_name.equals(new String(masterRS.buf))) {
                        tmp_alla.rollback();
                        throw new RepAPIException(107, new String[]{this.m_master_URL}, null);
                    }
                } else {
                    masterRS = ResultSetFactory.createSingleRow(ClientConsts.COLUMN1, new java.lang.Object[]{this.m_master_name});
                    ResultSet repapiRS = tmp_alla.m_local.m_repapi_tab.fetch(new short[]{1, 2, 3, 4}, masterRS, null, new RSTracker());
                    if (repapiRS == null || repapiRS.numrows == 0) {
                        repapiRS = ResultSetFactory.createSingleRow(new short[]{1, 2, 3, 4}, new java.lang.Object[]{this.m_master_name, this.m_master_URL, this.m_master_ssl ? ClientConsts.ONEBYTE : ClientConsts.ZEROBYTE, ClientConsts.ZEROINBYTES});
                        tmp_alla.m_local.m_repapi_tab.insert(repapiRS);
                    } else {
                        ResultSetFactory.updateSingleRow(repapiRS, 2, this.m_master_URL);
                        ResultSetFactory.updateSingleRow(repapiRS, 3, new byte[]{this.m_master_ssl ? (byte)1 : 0});
                        tmp_alla.m_local.m_repapi_tab.update(repapiRS);
                    }
                }
            }
            if (connect) {
                if (this.m_master_URL == null) {
                    tmp_alla.rollback();
                    throw new RepAPIException(106, new String[]{"''"}, null);
                }
                int protocolIndex = this.m_master_URL.indexOf("//");
                if (protocolIndex < 0) {
                    tmp_alla.rollback();
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                int serviceIndex = this.m_master_URL.indexOf("/", protocolIndex + 2);
                if (serviceIndex < 0) {
                    tmp_alla.rollback();
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                this.m_master_service = this.m_master_URL.substring(0, serviceIndex);
                this.m_master_obj = this.m_master_URL.substring(serviceIndex + 1, this.m_master_URL.length());
                if (this.m_master_obj == null || this.m_master_service == null) {
                    tmp_alla.rollback();
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                try {
                    tmp_alla.m_remote = this.loginToRemoteSession(this.m_master_service, this.m_master_obj, this.m_master_ssl, muid, mupw, null);
                }
                catch (CommunicationException communicationException) {
                    tmp_alla.rollback();
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                catch (NamingException namingException) {
                    tmp_alla.rollback();
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                Properties props = new Properties();
                ((Hashtable)props).put("ORBservices", "oracle.aurora.client");
                this.m_orb = Orb.init();
                this.m_boa = this.m_orb.BOA_init("TSession", props);
                this.m_boa.obj_is_ready((Object)tmp_alla);
                BooleanHolder CS_diff = new BooleanHolder(false);
                IntHolder svr_site_id = new IntHolder(this.m_site_id);
                Boolean[] pdiff = new Boolean[]{null};
                s_chset = tmp_alla.m_local.m_fdsa.getChset(pdiff);
                int scint = tmp_alla.m_remote.set_context(this.m_site_name, svr_site_id, s_chset, tmp_alla, 134285056, trace, this.m_refresh_threshold, this.m_lob_threshold, CS_diff);
                if (scint == 0) {
                    tmp_alla.rollback();
                    throw new RepAPIException(103, null, new String[]{new Integer(scint).toString()});
                }
                if (this.m_site_id == -1) {
                    this.store_site_id(svr_site_id.value, site_table);
                }
                this.m_diffchset = CS_diff.value;
                if (pdiff[0] == null) {
                    pdiff[0] = new Boolean(this.m_diffchset);
                } else if (pdiff[0] != this.m_diffchset) {
                    tmp_alla.rollback();
                    throw new RepAPIException(103, null, new String[]{pdiff[0].toString(), new Boolean(this.m_diffchset).toString()});
                }
                this.m_is_connected = connect;
            }
            new RepAPITest(this).executeEvent(35);
            if (tmp_alla.m_abort_received || tmp_alla.m_fatal_error_received) {
                this.abortOrRemote(tmp_alla);
            }
            tmp_alla.m_local.m_fdsa.commit();
            int i = 1;
            while (i < fdsa.length) {
                tmp_alla = this.m_FDSs.push(new AllA(fdsa[i]));
                tmp_alla.m_repapi = this;
                tmp_alla.m_local.m_fdsa.open(luid, lupw, dbid);
                tmp_alla.m_local.m_repapi_tab = tmp_alla.m_local.m_fdsa.locate("REPAPI$", "", ClientConsts.REPAPI_METADATA);
                tmp_alla.m_local.m_refgrp_tab = tmp_alla.m_local.m_fdsa.locate("REFGROUP$", "", ClientConsts.REFGRP_METADATA);
                tmp_alla.m_local.m_snap_tab = tmp_alla.m_local.m_fdsa.locate("SNAPSHOT$", "", ClientConsts.SNAPSHOT_METADATA);
                tmp_alla.m_local.m_repQ_tab = tmp_alla.m_local.m_fdsa.locate("REPAPI_QUEUE$_" + this.m_master_name, "", this.m_repQ_metadata);
                tmp_alla.m_local.m_lob_tab = tmp_alla.m_local.m_fdsa.locate("LOB$_" + this.m_master_name, "", this.m_lob_metadata);
                if (connect) {
                    RS rs = null;
                    try {
                        rs = this.loginToRemoteSession(this.m_master_service, this.m_master_obj, this.m_master_ssl, this.m_master_uid, this.m_master_pwd, null);
                    }
                    catch (CommunicationException communicationException) {
                        tmp_alla.rollback();
                        throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                    }
                    catch (NamingException namingException) {
                        tmp_alla.rollback();
                        throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                    }
                    tmp_alla.m_remote = rs;
                    this.m_boa.obj_is_ready((Object)tmp_alla);
                    BooleanHolder CS_diff = new BooleanHolder(false);
                    IntHolder svr_site_id = new IntHolder(this.m_site_id);
                    int scint = tmp_alla.m_remote.set_context(this.m_site_name, svr_site_id, s_chset, tmp_alla, 134285056, trace, this.m_refresh_threshold, this.m_lob_threshold, CS_diff);
                    if (scint == 0) {
                        tmp_alla.rollback();
                        throw new RepAPIException(103, null, new String[]{new Integer(scint).toString()});
                    }
                }
                ++i;
            }
            if (this.m_is_connected) {
                tmp_alla.m_local.m_fdsa.setChsetDiff(this.m_diffchset, this.m_diffchset);
            }
            new RepAPITest(this).executeEvent(36);
            if (tmp_alla.m_abort_received || tmp_alla.m_fatal_error_received) {
                this.abortOrRemote(tmp_alla);
            }
        }
        catch (Throwable ioe) {
            this.close();
            if (ioe instanceof RepAPIException) {
                throw (RepAPIException)ioe;
            }
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            throw new RepAPIException(103, null, new String[]{ioe.getMessage()});
        }
    }

    public RepAPI(FDSAccess[] fdsa, String dbid, String luid, String lupw, String muid, String mupw, String master, String url, boolean ssl) throws RepAPIException {
        this(fdsa, dbid, luid, lupw, muid, mupw, master, url, 4096, 4096, true, ssl, 0, false);
    }

    protected void abortOrRemote(AllA FDS) throws RepAPIException {
        if (this.m_debug_switch) {
            System.out.println("Entered abortOrRemote");
        }
        FDS.m_refgrp = null;
        if (FDS.m_fatal_error_received) {
            RepAPIException repex;
            String[] error_strings = FDS.m_errres.stk;
            FDS.m_fatal_error_received = false;
            if (error_strings[0].equals("C")) {
                FDS.clearCompletionStatus();
                try {
                    new RepAPITest(this).executeEvent(37);
                    if (FDS.m_local.m_repapi_tab != null) {
                        FDS.m_local.m_fdsa.rollback();
                    }
                }
                catch (Throwable ioe) {
                    error_strings[0] = "C";
                    error_strings[1] = RepAPIException.msg(608, null, new String[]{ioe.getMessage()});
                }
                FDS.m_repapi = null;
                AllA tmpo = this.m_FDSs.push(FDS);
                throw new RepAPIException(error_strings[1]);
            }
            if (error_strings[0].equals("F")) {
                FDS.reInit();
                RS rs = null;
                try {
                    rs = this.loginToRemoteSession(this.m_master_service, this.m_master_obj, this.m_master_ssl, this.m_master_uid, this.m_master_pwd, null);
                }
                catch (CommunicationException communicationException) {
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                catch (NamingException namingException) {
                    throw new RepAPIException(106, new String[]{this.m_master_URL}, null);
                }
                FDS.m_remote = rs;
                BooleanHolder CS_diff = new BooleanHolder(false);
                IntHolder svr_site_id = new IntHolder(this.m_site_id);
                int n = FDS.m_remote.set_context(this.m_site_name, svr_site_id, s_chset, FDS, 134285056, this.m_trace_vector, this.m_refresh_threshold, this.m_lob_threshold, CS_diff);
            }
            byte id = FDS.m_errres.opid;
            FDS.clearCompletionStatus();
            try {
                new RepAPITest(this).executeEvent(38);
                if (FDS.m_local.m_repapi_tab != null) {
                    FDS.m_local.m_fdsa.rollback();
                }
            }
            catch (Throwable ioe) {
                throw new RepAPIException(608, null, new String[]{String.valueOf(error_strings[0].substring(1, error_strings[0].length())) + ioe.getMessage()});
            }
            FDS.m_repapi = null;
            AllA tmpo = this.m_FDSs.push(FDS);
            switch (id) {
                case 1: {
                    int i = 2;
                    while (i < error_strings.length) {
                        error_strings[1] = error_strings[1].concat("\n" + error_strings[i]);
                        ++i;
                    }
                    repex = new RepAPIException(208, null, new String[]{error_strings[1]});
                    break;
                }
                case 2: {
                    int i = 2;
                    while (i < error_strings.length) {
                        error_strings[1] = error_strings[1].concat("\n" + error_strings[i]);
                        ++i;
                    }
                    repex = new RepAPIException(207, null, new String[]{error_strings[1]});
                    break;
                }
                case 4: {
                    int i = 2;
                    while (i < error_strings.length) {
                        error_strings[1] = error_strings[1].concat("\n" + error_strings[i]);
                        ++i;
                    }
                    repex = new RepAPIException(317, null, error_strings);
                    break;
                }
                case 8: {
                    int i = 2;
                    while (i < error_strings.length) {
                        error_strings[1] = error_strings[1].concat("\n" + error_strings[i]);
                        ++i;
                    }
                    repex = new RepAPIException(318, null, error_strings);
                    break;
                }
                default: {
                    int i = 2;
                    while (i < error_strings.length) {
                        error_strings[1] = error_strings[1].concat("\n" + error_strings[i]);
                        ++i;
                    }
                    repex = new RepAPIException(609, null, new String[]{error_strings[1]});
                }
            }
            throw repex;
        }
        FDS.clearCompletionStatus();
        try {
            new RepAPITest(this).executeEvent(39);
            if (FDS.m_local.m_repapi_tab != null) {
                FDS.m_local.m_fdsa.rollback();
            }
        }
        catch (Throwable ioe) {
            throw new RepAPIException(608, null, new String[]{"ABORT!\n" + ioe.getMessage()});
        }
        FDS.m_repapi = null;
        AllA tmpo = this.m_FDSs.push(FDS);
        throw new RepAPIException(113, null, null);
    }

    public void abortProcess() {
        AllA alla;
        if (this.m_debug_switch) {
            System.out.println("abortProcess");
        }
        int i = 0;
        while (i < this.m_refgroups.size()) {
            RefGrp rg = (RefGrp)this.m_refgroups.elementAt(i);
            if (rg.isLocked() && (alla = rg.getFDSAccess()) != null) {
                if (this.m_is_connected) {
                    alla.m_remote.abort(alla.m_refgrp.m_rgid, (byte)0);
                }
                alla.m_abort_received = true;
                alla.wakeAll();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_FDSi.size()) {
            alla = (AllA)this.m_FDSi.elementAt(i2);
            if (this.m_is_connected) {
                alla.m_remote.abort(0, (byte)0);
            }
            alla.m_abort_received = true;
            ++i2;
        }
    }

    public void abortProcess(String rgname) {
        AllA alla;
        rgname = this.canonicalize(rgname);
        if (this.m_debug_switch) {
            System.out.println("abortProcess");
            System.out.println("refresh group - " + rgname);
        }
        int i = 0;
        while (i < this.m_refgroups.size()) {
            RefGrp rg = (RefGrp)this.m_refgroups.elementAt(i);
            if (rg.m_refresh_group_name.equals(rgname)) {
                alla = rg.getFDSAccess();
                if (alla == null) break;
                if (this.m_is_connected) {
                    alla.m_remote.abort(0, (byte)0);
                }
                alla.m_abort_received = true;
                alla.wakeAll();
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_FDSi.size()) {
            alla = (AllA)this.m_FDSi.elementAt(i2);
            if (alla.m_refgrp_name.equals(rgname)) {
                if (this.m_is_connected) {
                    alla.m_remote.abort(0, (byte)0);
                }
                alla.m_abort_received = true;
                return;
            }
            ++i2;
        }
    }

    String canonicalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase(Locale.getDefault());
    }

    public static void cleanup(FDSAccess[] fdsa, String dbid, String luid, String lupw) throws RepAPIException {
        String[] masterNames = null;
        boolean openFlag = false;
        if (fdsa == null || fdsa.length == 0) {
            throw new RepAPIException(116, null, null);
        }
        int i = 0;
        while (i < fdsa.length) {
            try {
                masterNames = RepAPI.getMasterNames(fdsa[i], dbid, luid, lupw);
                if (masterNames != null) {
                    int j = 0;
                    while (j < masterNames.length) {
                        RepAPI.dropMasterMetadata(fdsa[i], dbid, luid, lupw, masterNames[j]);
                        ++j;
                    }
                }
                fdsa[i].open(luid, lupw, dbid);
                openFlag = true;
                fdsa[i].drop("REPAPI$");
                fdsa[i].drop("REFGROUP$");
                fdsa[i].drop("SNAPSHOT$");
                fdsa[i].drop("RSESSION$");
                fdsa[i].drop("RSITE$");
                fdsa[i].cleanup();
                fdsa[i].commit();
                fdsa[i].close();
                openFlag = false;
            }
            catch (IOException e) {
                if (openFlag) {
                    try {
                        fdsa[i].close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    openFlag = false;
                }
                throw new RepAPIException(213, null, new String[]{e.toString()});
            }
            catch (RepAPIException e) {
                if (openFlag) {
                    try {
                        fdsa[i].close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    openFlag = false;
                }
                throw e;
            }
            ++i;
        }
    }

    public static void cleanup(FDSAccess[] fdsa, String dbid, String luid, String lupw, String master) throws RepAPIException {
        if (fdsa == null || fdsa.length == 0) {
            throw new RepAPIException(116, null, null);
        }
        if (master == null) {
            throw new RepAPIException(104, null, null);
        }
        int i = 0;
        while (i < fdsa.length) {
            RepAPI.dropMasterMetadata(fdsa[i], dbid, luid, lupw, master);
            ++i;
        }
    }

    protected synchronized void clearPushLock() {
        this.m_push_lock = false;
        this.notifyAll();
    }

    public void close() {
        block14: {
            try {
                AllA alla;
                if (this.m_debug_switch) {
                    System.out.println("close");
                }
                new RepAPITest(this).executeEvent(41);
                if (this.m_close_run) break block14;
                this.m_close_run = true;
                if (this.m_server_port != 0) {
                    try {
                        new RepAPITest(this).executeEvent(42);
                        Socket clientsocket = new Socket(InetAddress.getLocalHost(), this.m_server_port);
                        clientsocket.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (this.m_rsession_tab != null) {
                    ResultSet rsession_row = ResultSetFactory.createSingleRow(new short[]{1}, new java.lang.Object[]{this.m_master_name}, this.m_diffchset);
                    this.m_rsession_tab.delete(rsession_row);
                    if (this.m_fdsa != null) {
                        this.m_fdsa.commit();
                    }
                }
                int i = 0;
                while (i < this.m_FDSs.size()) {
                    ((AllA)this.m_FDSs.elementAt((int)i)).m_local.m_fdsa.close();
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.m_refgroups.size()) {
                    RefGrp rg = (RefGrp)this.m_refgroups.elementAt(i2);
                    if (rg.isLocked() && (alla = rg.getFDSAccess()) != null && alla.m_local != null && alla.m_local.m_fdsa != null) {
                        alla.m_local.m_fdsa.close();
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < this.m_FDSi.size()) {
                    alla = (AllA)this.m_FDSi.elementAt(i3);
                    alla.m_local.m_fdsa.close();
                    ++i3;
                }
                this.m_orb = null;
                if (this.m_is_connected) {
                    alla = this.getAccess();
                    if (alla != null) {
                        alla.m_remote.disconnect();
                    }
                    this.m_is_connected = false;
                }
            }
            catch (Throwable t) {
                if (!this.m_debug_switch) break block14;
                t.printStackTrace();
            }
        }
    }

    public RefGrp createRefreshGroup(String refgroup_name) throws RepAPIException {
        if (this.m_debug_switch) {
            System.out.println("CreateRefreshGroup");
            System.out.println("refresh group - " + refgroup_name);
        }
        if (!this.m_is_connected) {
            throw new RepAPIException(114, null, null);
        }
        refgroup_name = this.canonicalize(refgroup_name);
        AllA tmp_alla = this.getAccess();
        if (tmp_alla == null) {
            throw new RepAPIException(101, null, null);
        }
        tmp_alla = this.m_FDSi.push(tmp_alla);
        RS rs = tmp_alla.m_remote;
        java.lang.Object tmpbytes = null;
        rs.create_refresh_group(refgroup_name);
        tmp_alla.waitTilDone();
        new RepAPITest(this).executeEvent(40);
        if (tmp_alla.m_abort_received || tmp_alla.m_fatal_error_received) {
            this.abortOrRemote(tmp_alla);
        }
        RefGrp rg = tmp_alla.m_refgrp;
        tmp_alla.clearAccessMembers();
        tmp_alla.m_refgrp = null;
        tmp_alla.clearCompletionStatus();
        tmp_alla.m_repapi = null;
        tmp_alla = this.m_FDSs.push(tmp_alla);
        return rg;
    }

    public int dropAll() throws RepAPIException {
        return this.dropAll(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int dropAll(boolean force) throws RepAPIException {
        if (this.m_debug_switch) {
            System.out.println("dropALL");
        }
        if (!this.m_is_connected && !force) {
            throw new RepAPIException(114, null, null);
        }
        int errno = 0;
        AllA alla = this.getAccess();
        if (alla == null) {
            throw new RepAPIException(101, null, null);
        }
        AllA.LocalA loca = alla.m_local;
        try {
            ResultSet RefRS = ResultSetFactory.createSingleRow(new short[]{3}, new java.lang.Object[]{this.m_master_name}, this.m_diffchset);
            RSTracker rst = new RSTracker();
            new RepAPITest(this).executeEvent(43);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                this.abortOrRemote(alla);
            }
            Stack<ResultSet> tmpstack = new Stack<ResultSet>();
            do {
                RefRS = tmpstack.push(loca.m_refgrp_tab.fetch(ClientConsts.RG, RefRS, null, rst));
            } while (rst.m_RSmore);
            alla.m_repapi = null;
            alla = this.m_FDSs.push(alla);
            if (RefRS == null) {
                throw new RepAPIException(212, null, null);
            }
            block3: while (true) {
                if (tmpstack.empty()) {
                    return errno;
                }
                RefRS = (ResultSet)tmpstack.elementAt(0);
                int buff_offset = 0;
                int[] colLengths = ResultSetFactory.decodeLengths(RefRS, RefRS.numrows * RefRS.cold.pos.length);
                int i = 0;
                while (true) {
                    if (i >= colLengths.length) {
                        tmpstack.removeElementAt(0);
                        continue block3;
                    }
                    String str = ResultSetFactory.getStringColumn(RefRS.buf, buff_offset, colLengths[i], this.m_diffchset);
                    errno += this.dropRefreshGroup(str, force);
                    buff_offset += colLengths[i];
                    ++i;
                }
                break;
            }
        }
        catch (Throwable ioe) {
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            RepAPIException e = new RepAPIException(206, null, new String[]{ioe.getMessage()});
            if (!(ioe instanceof RepAPIException)) throw e;
            e.setNextException((RepAPIException)ioe);
            throw e;
        }
    }

    private static void dropMasterMetadata(FDSAccess fdsa, String dbid, String luid, String lupw, String master) throws RepAPIException {
        RepAPI repAPI = null;
        RepAPIException ex = null;
        try {
            repAPI = new RepAPI(new FDSAccess[]{fdsa}, dbid, luid, lupw, master, "");
            AllA tmpAllA = repAPI.getAccess();
            if (tmpAllA == null) {
                throw new RepAPIException(101, null, null);
            }
            tmpAllA.m_repapi = null;
            tmpAllA = repAPI.m_FDSs.push(tmpAllA);
            try {
                repAPI.dropAll(true);
            }
            catch (RepAPIException re) {
                RepAPIException nextEx = re.getNextException();
                if (nextEx == null || nextEx.getErrorNum() != 212) {
                    repAPI.close();
                    throw re;
                }
                tmpAllA.m_repapi = null;
                tmpAllA = repAPI.m_FDSs.push(tmpAllA);
            }
            ResultSet master_row = ResultSetFactory.createSingleRow(new short[]{1}, new java.lang.Object[]{repAPI.m_master_name}, repAPI.m_diffchset);
            tmpAllA.m_local.m_repapi_tab.delete(master_row);
            FDSObject site_table = tmpAllA.m_local.m_fdsa.locate("RSITE$", "", ClientConsts.RSITE_METADATA);
            site_table.delete(master_row);
            tmpAllA.m_local.m_fdsa.drop("REPAPI_QUEUE$_" + repAPI.m_master_name);
            tmpAllA.m_local.m_fdsa.drop("LOB$_" + repAPI.m_master_name);
            tmpAllA.m_local.m_fdsa.commit();
            repAPI.close();
            repAPI = null;
        }
        catch (IOException e) {
            ex = new RepAPIException(213, null, new String[]{e.toString()});
        }
        catch (RepAPIException e) {
            ex = e;
        }
        if (repAPI != null) {
            repAPI.close();
        }
        if (ex != null) {
            throw ex;
        }
    }

    public int dropRefreshGroup(String refgroup_name) throws RepAPIException {
        return this.dropRefreshGroup(refgroup_name, false);
    }

    public int dropRefreshGroup(String refgroup_name, boolean force) throws RepAPIException {
        if (!this.m_is_connected && !force) {
            throw new RepAPIException(114, null, null);
        }
        refgroup_name = this.canonicalize(refgroup_name);
        if (this.m_debug_switch) {
            System.out.println("dropRefreshGroup");
            System.out.println("Refresh Group - " + refgroup_name);
        }
        int error = 0;
        AllA alla = this.getAccess();
        if (alla == null) {
            throw new RepAPIException(101, null, null);
        }
        alla.m_local.m_repQ_tab.lock();
        RSTracker rst = null;
        ResultSet RefRS = null;
        try {
            ErrorResult err;
            ResultSet Rep2RS;
            short[] pos2 = new short[]{1};
            ResultSet RepRS = ResultSetFactory.createSingleRow(pos2, new java.lang.Object[]{this.m_master_name}, this.m_diffchset);
            rst = new RSTracker();
            new RepAPITest(this).executeEvent(44);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                alla.notifyAndClear(null);
                this.abortOrRemote(alla);
            }
            int notpushed = (Rep2RS = alla.m_local.m_repapi_tab.fetch(new short[]{4}, RepRS, null, rst)) == null ? 0 : ResultSetFactory.getIntegerColumn(Rep2RS.buf, 0) + 1;
            int[] tranids = new int[]{notpushed, Integer.MAX_VALUE};
            RepRS = ResultSetFactory.createSingleRow(new short[]{1, 1}, new java.lang.Object[]{tranids}, this.m_diffchset, RepRS, RepRS.cold);
            short[] tmpftch = new short[]{1};
            rst = new RSTracker();
            new RepAPITest(this).executeEvent(45);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                alla.notifyAndClear(null);
                this.abortOrRemote(alla);
            }
            if ((Rep2RS = alla.m_local.m_repQ_tab.fetch(tmpftch, RepRS, null, rst)) != null) {
                err = new ErrorResult(new String[]{"C", RepAPIException.msg(207, null, null)}, 0, 0, 0, 0, 4);
                alla.notifyAndClear(err);
                this.abortOrRemote(alla);
            }
            alla.m_refgrp = this.getRefreshGroup(refgroup_name, alla);
            if (!alla.m_refgrp.lock()) {
                err = new ErrorResult(new String[]{"C", RepAPIException.msg(319, null, null)}, 0, 0, 0, 0, 4);
                alla.notifyAndClear(err);
                this.abortOrRemote(alla);
            }
            int p = alla.m_refgrp.getSnaplistSize();
            tranids = new int[1];
            RefRS = ResultSetFactory.createSingleRow(new short[]{1, 6}, new java.lang.Object[]{tranids, this.m_master_name}, this.m_diffchset, RepRS, RepRS.cold);
            ResultSet Ref2RS = ResultSetFactory.createSingleRow(new short[]{3}, new java.lang.Object[]{tranids}, this.m_diffchset);
            int i = 0;
            while (i < p) {
                SnapAccess tmpsnap = alla.m_refgrp.getSnaplistElementAt(i);
                alla.m_refgrp.dropSnapshot(tmpsnap.m_snapname);
                ResultSetFactory.setIntegerColumn(RefRS.buf, 0, tmpsnap.m_snap_id);
                ResultSetFactory.setIntegerColumn(Ref2RS.buf, 0, tmpsnap.m_snap_id);
                alla.m_local.m_snap_tab.delete(RefRS);
                alla.m_local.m_repQ_tab.delete(Ref2RS);
                ++i;
            }
            tranids[0] = alla.m_refgrp.m_rgid;
            RefRS = ResultSetFactory.createSingleRow(new short[]{1, 3}, new java.lang.Object[]{tranids, this.m_master_name}, this.m_diffchset, RepRS, RepRS.cold);
            new RepAPITest(this).executeEvent(46);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                alla.m_local.m_repQ_tab.unlock();
                alla.notifyAndClear(null);
                this.abortOrRemote(alla);
            }
            alla.m_local.m_refgrp_tab.delete(RefRS);
            if (this.m_is_connected) {
                error = alla.m_remote.drop_refresh_group(alla.m_refgrp.m_rgid);
            }
            if (error != 0 && force) {
                error = 0;
            }
            if (error == 0) {
                alla.m_local.m_fdsa.commit();
                this.m_refgroups.removeElement(alla.m_refgrp);
            } else {
                alla.m_local.m_fdsa.rollback();
                alla.m_refgrp.unlock();
            }
            alla.m_refgrp.setFDSAccess(null);
            alla.notifyAndClear(null);
            alla.clearCompletionStatus();
            alla.m_repapi = null;
            AllA tmpo = this.m_FDSs.push(alla);
        }
        catch (Throwable ioe) {
            if (alla.m_refgrp != null) {
                alla.m_refgrp.unlock();
            }
            alla.m_local.m_repQ_tab.unlock();
            if (ioe instanceof RepAPIException) {
                throw (RepAPIException)ioe;
            }
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(209, null, new String[]{ioe.getMessage()})}, 0, 0, 0, 0, 2);
            alla.notifyAndClear(err);
            this.abortOrRemote(alla);
        }
        return error;
    }

    protected void errorTransaction(AllA alla) throws RepAPIException {
        int size = alla.m_errt.size();
        if (this.m_debug_switch) {
            System.out.println("errorTransaction");
            System.out.println("number of error transactions -" + size);
        }
        int tranid = 0;
        try {
            int i = 0;
            while (i < size) {
                tranid = (Integer)alla.m_errt.elementAt(0);
                new RepAPITest(this).executeEvent(47);
                this.pushTransaction(alla, tranid, 2048);
                alla.m_errt.removeElementAt(0);
                ++i;
            }
        }
        catch (Throwable ioe) {
            if (ioe instanceof RepAPIException) {
                throw (RepAPIException)ioe;
            }
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(314, new String[]{String.valueOf(tranid)}, new String[]{ioe.getMessage()})}, 0, 0, 0, (short)alla.m_refgrp.getRSN(), 8);
            alla.m_remote.error(err);
            alla.m_refgrp.unlock();
            alla.notifyAndClear(err);
            this.clearPushLock();
            this.abortOrRemote(alla);
        }
    }

    private void fillPushLobinfo(AllA alla, ResultSet Push2RS) throws IOException {
        if (this.m_debug_switch) {
            System.out.println("fillPushLobinfo");
            System.out.println("Result Set - " + Push2RS.toString());
        }
        int nlob_columns = 0;
        RSTracker rst = new RSTracker();
        int snapid = ResultSetFactory.getIntegerColumn(Push2RS.buf, 0);
        SnapAccess snapa = alla.m_refgrp.getSnaplistElement(snapid);
        FDSObject snap = alla.m_local.m_fdsa.locate(snapa.m_snapname, snapa.m_schemaname, null);
        long[] length = new long[Push2RS.cold.lobflg.length];
        short[] column_nums = new short[Push2RS.cold.lobflg.length];
        Push2RS.flags |= 1;
        short prevpos = 0;
        boolean posnew = false;
        byte dmltype = Push2RS.buf[Push2RS.buf.length - Push2RS.rowlen[Push2RS.numrows - 1] + 4];
        int[] colLengths = ResultSetFactory.decodeLengths(Push2RS, Push2RS.cold.pos.length);
        int n = 0;
        while (n < colLengths.length) {
            if (Push2RS.cold.pos[n] > 0 && (snap.m_tmd.cols[Push2RS.cold.pos[n] - 1].dty == 113 || snap.m_tmd.cols[Push2RS.cold.pos[n] - 1].dty == 112)) {
                if (dmltype == 73) {
                    int n2 = nlob_columns;
                    Push2RS.cold.lobflg[n2] = (short)(Push2RS.cold.lobflg[n2] | 4);
                } else if (dmltype == 85) {
                    if (Push2RS.cold.pos[n] < prevpos) {
                        posnew = true;
                    }
                    prevpos = Push2RS.cold.pos[n];
                    if (posnew) {
                        int n3 = nlob_columns;
                        Push2RS.cold.lobflg[n3] = (short)(Push2RS.cold.lobflg[n3] | 4);
                    }
                }
                length[nlob_columns] = colLengths[n];
                column_nums[nlob_columns] = Push2RS.cold.pos[n];
                posnew = false;
                ++nlob_columns;
            }
            n = (short)(n + 1);
        }
        AllA allA = alla;
        allA.getClass();
        alla.m_Local_lob_info = allA.new AllA.LobInfo(null, nlob_columns, Push2RS.cold.lobflg, Push2RS.cold.pos, column_nums, Push2RS.cold.lob_offset, length, (Push2RS.flags & 0x2000) != 0);
    }

    protected synchronized AllA getAccess() {
        AllA tmp_alla = null;
        if (!this.m_FDSs.empty()) {
            tmp_alla = (AllA)this.m_FDSs.pop();
            tmp_alla.m_repapi = this;
        }
        return tmp_alla;
    }

    private static String[] getMasterNames(FDSAccess fdsa, String dbid, String luid, String lupw) throws RepAPIException {
        String[] masterNames = null;
        boolean openFlag = false;
        try {
            fdsa.open(luid, lupw, dbid);
            openFlag = true;
            FDSObject fdso = fdsa.locate("REPAPI$", "", ClientConsts.REPAPI_METADATA);
            RSTracker rst = new RSTracker();
            Vector<ResultSet> rstvec = new Vector<ResultSet>();
            ResultSet refRS = null;
            do {
                refRS = fdso.fetch(new short[]{1}, null, null, rst);
                rstvec.addElement(refRS);
            } while (rst.m_RSmore);
            if (refRS == null) {
                masterNames = null;
            } else {
                masterNames = new String[rstvec.size()];
                ResultSet repRS = null;
                int i = 0;
                while (i < rstvec.size()) {
                    repRS = (ResultSet)rstvec.elementAt(i);
                    if (repRS != null) {
                        int[] collen = ResultSetFactory.decodeLengths(repRS, 1);
                        masterNames[i] = ResultSetFactory.getStringColumn(repRS.buf, 0, collen[0], false);
                    } else {
                        masterNames[i] = null;
                    }
                    ++i;
                }
            }
            fdsa.close();
            openFlag = false;
        }
        catch (IOException e) {
            if (openFlag) {
                try {
                    fdsa.close();
                }
                catch (Exception rst) {
                    // empty catch block
                }
                openFlag = false;
            }
            throw new RepAPIException(213, null, new String[]{e.toString()});
        }
        return masterNames;
    }

    public RefGrp getRefreshGroup(String refgroup_name) throws RepAPIException {
        refgroup_name = this.canonicalize(refgroup_name);
        return this.getRefreshGroup(refgroup_name, null);
    }

    protected RefGrp getRefreshGroup(String refgroup_name, AllA tmp_alla) throws RepAPIException {
        AllA new_tmp_alla;
        if (this.m_debug_switch) {
            System.out.println("getRefreshGroup");
            System.out.println("Refresh Group - " + refgroup_name);
        }
        RefGrp rg = null;
        boolean mlength = false;
        AllA allA = new_tmp_alla = tmp_alla == null ? this.getAccess() : tmp_alla;
        if (new_tmp_alla == null) {
            throw new RepAPIException(101, null, null);
        }
        short[] pos1 = new short[]{3, 2};
        ResultSet RefRS = null;
        RSTracker rst = new RSTracker();
        try {
            RefRS = ResultSetFactory.createSingleRow(pos1, new java.lang.Object[]{this.m_master_name, refgroup_name}, this.m_diffchset);
            new RepAPITest(this).executeEvent(48);
            if (new_tmp_alla.m_abort_received || new_tmp_alla.m_fatal_error_received) {
                new_tmp_alla.notifyAndClear(null);
                this.abortOrRemote(new_tmp_alla);
            }
            RefRS = new_tmp_alla.m_local.m_refgrp_tab.fetch(new short[]{1}, RefRS, null, rst);
        }
        catch (Throwable ioe) {
            if (ioe instanceof RepAPIException) {
                throw (RepAPIException)ioe;
            }
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(507, new String[]{ioe.getMessage()}, null)}, 0, 0, 0, 0, 4);
            new_tmp_alla.notifyAndClear(err);
            this.abortOrRemote(new_tmp_alla);
        }
        if (RefRS == null) {
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(508, new String[]{refgroup_name}, null)}, 0, 0, 0, 0, 4);
            new_tmp_alla.notifyAndClear(err);
            this.abortOrRemote(new_tmp_alla);
        }
        int gid = ResultSetFactory.getIntegerColumn(RefRS.buf, 0);
        int rsz1 = this.m_refgroups.size();
        int i = 0;
        while (i < rsz1) {
            rg = (RefGrp)this.m_refgroups.elementAt(i);
            if (rg.m_rgid == gid) break;
            ++i;
        }
        if (i == rsz1) {
            boolean refgroup_exists = false;
            RefGrp rg2 = null;
            rg = this.m_refgroups.push(new RefGrp(this, refgroup_name, gid));
            int rsz2 = this.m_refgroups.size();
            while (i < rsz2) {
                rg2 = (RefGrp)this.m_refgroups.elementAt(i);
                if (rg2.m_rgid == gid) {
                    if (!refgroup_exists) {
                        if (rg2 == rg) break;
                        rg = rg2;
                        refgroup_exists = true;
                    } else {
                        this.m_refgroups.removeElementAt(i);
                    }
                }
                ++i;
            }
        }
        rg.setFDSAccess(new_tmp_alla);
        new_tmp_alla.m_refgrp = rg;
        rg.fillSnaplist();
        return rg;
    }

    void getSiteIdandName(FDSObject site_table, AllA client) throws IOException, RepAPIException {
        RSTracker rst = new RSTracker();
        ResultSet masterRS = ResultSetFactory.createSingleRow(new short[]{1}, new java.lang.Object[]{this.m_master_name});
        ResultSet siteRS = site_table.fetch(new short[]{2, 3}, masterRS, null, rst);
        if (siteRS != null && (siteRS.numrows > 1 || rst.m_RSmore)) {
            throw new RepAPIException(601, null, null);
        }
        if (siteRS != null) {
            int[] collen = ResultSetFactory.decodeLengths(siteRS, 2);
            this.m_site_name = ResultSetFactory.getStringColumn(siteRS.buf, 0, collen[0], false);
            this.m_site_id = ResultSetFactory.getIntegerColumn(siteRS.buf, collen[0]);
        } else {
            this.m_site_name = "REPSITE_" + System.currentTimeMillis();
            this.m_site_id = -1;
            ResultSet rsite_row = ResultSetFactory.createSingleRow(new short[]{1, 2, 3}, new java.lang.Object[]{this.m_master_name, this.m_site_name, new int[]{this.m_site_id}});
            site_table.insert(rsite_row);
        }
    }

    public boolean isConnected() {
        return this.m_is_connected;
    }

    private RS loginToRemoteSession(String serviceURL, String objectName, boolean ssl, String userName, String userPass, String userRole) throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.url.pkgs", "oracle.aurora.jndi");
        if (ssl) {
            environment.put("java.naming.security.principal", userName);
            environment.put("java.naming.security.credentials", userPass);
            environment.put("java.naming.security.authentication", "SecureCredential");
        }
        InitialContext ic = new InitialContext(environment);
        ServiceCtx service = (ServiceCtx)ic.lookup(serviceURL);
        SessionCtx session = (SessionCtx)service.createSubcontext(":repapi" + System.currentTimeMillis());
        if (!ssl) {
            LoginServer login_server = (LoginServer)session.activate("etc/login");
            Login login = new Login(login_server);
            login.authenticate(userName, userPass, userRole);
        }
        return (RS)session.activate(objectName);
    }

    /*
     * Unable to fully structure code
     */
    public void offlineInstantiate(String inst_file) throws RepAPIException {
        block38: {
            if (this.m_debug_switch) {
                System.out.println("offlineInstantiate");
            }
            tmp_alla = null;
            IDLE = false;
            INSTANTIATING = true;
            INSTANTIATION_DONE = 2;
            REFRESHING = 3;
            DONE = 4;
            state = 0;
            if (this.m_is_connected) {
                throw new RepAPIException(403, null, null);
            }
            tmp_alla = this.getAccess();
            if (tmp_alla == null) {
                throw new RepAPIException(101, null, null);
            }
            tmp_alla = this.m_FDSi.push(tmp_alla);
            try {
                fis = new FileInputStream(inst_file);
                ois = new ObjectInputStream(fis);
                object = ois.readObject();
                if (!(object instanceof RepAPIVersion)) {
                    tmp_alla.rollback();
                    throw new RepAPIException(604, new String[]{inst_file}, null);
                }
                vers = (RepAPIVersion)object;
                if (!RepAPIVersion.isCompatible()) {
                    if (RepAPIVersion.getDataVersion() > 134285056) {
                        range = vers.dataRecommendedCodeRange();
                        tmp_alla.rollback();
                        throw new RepAPIException(603, new String[]{Integer.toHexString(range[0]), Integer.toHexString(range[1])}, null);
                    }
                    tmp_alla.rollback();
                    throw new RepAPIException(602, new String[]{Integer.toHexString(RepAPIVersion.getDataVersion())}, null);
                }
                object = ois.readObject();
                if (!(object instanceof RepAPIContext)) {
                    tmp_alla.rollback();
                    throw new RepAPIException(604, new String[]{inst_file}, null);
                }
                ctxt = (RepAPIContext)object;
                if (ctxt.master != null && !ctxt.master.equals(this.m_master_name)) {
                    tmp_alla.rollback();
                    throw new RepAPIException(401, new String[]{this.m_master_name, ctxt.master}, null);
                }
                if (!ctxt.userName.equals(this.canonicalize(this.m_master_uid))) {
                    tmp_alla.rollback();
                    throw new RepAPIException(402, null, null);
                }
                if (ctxt.url != null) {
                    masterRS = ResultSetFactory.createSingleRow(ClientConsts.COLUMN1, new java.lang.Object[]{this.m_master_name}, this.m_diffchset);
                    repapiRS = tmp_alla.m_local.m_repapi_tab.fetch(new short[]{1, 2, 3, 4}, masterRS, null, new RSTracker());
                    if (repapiRS == null || repapiRS.numrows != 1) {
                        tmp_alla.rollback();
                        throw new RepAPIException(601, null, null);
                    }
                    ResultSetFactory.updateSingleRow(repapiRS, 2, ctxt.url, this.m_diffchset);
                    ResultSetFactory.updateSingleRow(repapiRS, 3, new byte[]{ctxt.ssl != false ? 1 : 0});
                    tmp_alla.m_local.m_repapi_tab.update(repapiRS);
                }
                pdiff = new Boolean[]{null};
                RepAPI.s_chset = tmp_alla.m_local.m_fdsa.getChset(pdiff);
                this.m_diffchset = true;
                if (pdiff[0] == null) {
                    pdiff[0] = RepAPI.s_chset == ctxt.serverCharSet ? new Boolean(false) : new Boolean(true);
                } else if (pdiff[0] != (RepAPI.s_chset != ctxt.serverCharSet)) {
                    tmp_alla.rollback();
                    throw new RepAPIException(103, null, new String[]{pdiff[0].toString(), new Boolean(RepAPI.s_chset == ctxt.serverCharSet).toString()});
                }
                tmp_alla.m_local.m_fdsa.setChsetDiff(this.m_diffchset, pdiff[0]);
                this.m_refresh_threshold = ctxt.ResultSetThreshold;
                this.m_lob_threshold = ctxt.LOBThreshold;
                tmp_alla.m_local.m_fdsa.setThresholds(this.m_refresh_threshold, this.m_lob_threshold);
                while (true) {
                    new RepAPITest(this).executeEvent(49);
                    if (tmp_alla.m_abort_received || tmp_alla.m_fatal_error_received) {
                        tmp_alla.notifyAndClear(null);
                        this.abortOrRemote(tmp_alla);
                    }
                    if ((object = ois.readObject()) instanceof RefreshGroup) {
                        rgobj = (RefreshGroup)object;
                        if (state == 0) {
                            state = (rgobj.flg & 1) > 0 ? 2 : 1;
                        } else if (state == 1) {
                            if ((rgobj.flg & 1) > 0) {
                                state = 2;
                            }
                        } else {
                            tmp_alla.rollback();
                            throw new RepAPIException(604, new String[]{inst_file}, null);
                        }
                        tmp_alla.instantiate_req(rgobj, -1);
                        continue;
                    }
                    if (object instanceof GroupResultSet) {
                        grsobj = (GroupResultSet)object;
                        if (state == 2) {
                            state = (grsobj.flg & 1) > 0 ? 4 : 3;
                        } else if (state == 3) {
                            if ((grsobj.flg & 1) > 0) {
                                state = 4;
                            }
                        } else {
                            tmp_alla.rollback();
                            throw new RepAPIException(604, new String[]{inst_file}, null);
                        }
                        tmp_alla.refresh_req(grsobj, -1);
                        continue;
                    }
                    if (!(object instanceof byte[])) break;
                    if (state != 3) {
                        tmp_alla.rollback();
                        throw new RepAPIException(604, new String[]{inst_file}, null);
                    }
                    tmp_alla.send_lob_req((byte[])object, -1);
                }
                tmp_alla.rollback();
                throw new RepAPIException(604, new String[]{inst_file}, null);
            }
            catch (EOFException v0) {
                if (state != 4) {
                    tmp_alla.rollback();
                    throw new RepAPIException(604, new String[]{inst_file}, null);
                }
                tmp_alla.clearAccessMembers();
                if (tmp_alla.m_refgrp != null) {
                    tmp_alla.m_refgrp.setRepobj(null);
                }
                tmp_alla.m_refgrp = null;
                tmp_alla.clearCompletionStatus();
                tmp_alla.m_repapi = null;
                this.m_FDSs.push(tmp_alla);
                i = 0;
                ** while (i < this.m_FDSi.size())
            }
lbl-1000:
            // 1 sources

            {
                alla = (AllA)this.m_FDSi.elementAt(i);
                ++i;
                continue;
            }
lbl121:
            // 1 sources

            i = 0;
            while (i < this.m_FDSs.size()) {
                alla = (AllA)this.m_FDSs.elementAt(i);
                alla.m_repapi = null;
                alla.m_refgrp = null;
                ++i;
            }
            break block38;
            catch (RepAPIException rex) {
                throw rex;
            }
            catch (Throwable exc) {
                if (this.m_debug_switch) {
                    exc.printStackTrace();
                }
                tmp_alla.rollback();
                throw new RepAPIException(606, null, new String[]{exc.toString()});
            }
        }
    }

    protected boolean push(AllA alla) throws RepAPIException {
        ErrorResult err;
        if (this.m_debug_switch) {
            System.out.println("Push");
        }
        this.testSetPushLock();
        boolean result = false;
        alla.m_push_only = true;
        short[] pos2 = new short[]{1};
        ResultSet RepRS = null;
        RSTracker rst = new RSTracker();
        try {
            RepRS = ResultSetFactory.createSingleRow(pos2, new java.lang.Object[]{this.m_master_name}, this.m_diffchset);
            RepRS = alla.m_local.m_repapi_tab.fetch(new short[]{4}, RepRS, null, rst);
            alla.m_notpushed = RepRS == null ? 0 : ResultSetFactory.getIntegerColumn(RepRS.buf, 0) + 1;
            int[] tranids = new int[]{alla.m_notpushed, Integer.MAX_VALUE};
            RepRS = ResultSetFactory.createSingleRow(new short[]{1, 1}, new java.lang.Object[]{tranids}, this.m_diffchset, RepRS, RepRS.cold);
            short[] tmpftch = new short[]{1};
            new RepAPITest(this).executeEvent(50);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                alla.m_refgrp.unlock();
                alla.notifyAndClear(null);
                this.clearPushLock();
                this.abortOrRemote(alla);
            }
            ResultSet repQRS = null;
            do {
                repQRS = alla.m_local.m_repQ_tab.fetch(tmpftch, RepRS, tmpftch, rst);
                new RepAPITest(this).executeEvent(51);
                if (!alla.m_abort_received && !alla.m_fatal_error_received) continue;
                alla.m_refgrp.unlock();
                alla.notifyAndClear(null);
                this.clearPushLock();
                this.abortOrRemote(alla);
            } while (rst.m_RSmore);
            if (repQRS == null) {
                alla.m_refgrp.unlock();
                alla.notifyAndClear(null);
                this.clearPushLock();
                alla.m_refgrp = null;
                alla.clearCompletionStatus();
                alla.m_repapi = null;
                AllA tmpo = this.m_FDSs.push(alla);
                return true;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(repQRS.buf);
            DataInputStream dis = new DataInputStream(bis);
            dis.skipBytes(repQRS.buf.length - 4);
            alla.m_last_transaction = dis.readInt();
        }
        catch (Throwable ioe) {
            if (ioe instanceof RepAPIException) {
                throw (RepAPIException)ioe;
            }
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            err = new ErrorResult(new String[]{"C", RepAPIException.msg(312, null, new String[]{ioe.getMessage()})}, 0, 0, 0, 0, 8);
            alla.m_remote.error(err);
            alla.m_refgrp.unlock();
            alla.notifyAndClear(err);
            this.clearPushLock();
            this.abortOrRemote(alla);
        }
        if (this.pushToMaster(alla, (byte)1)) {
            try {
                new RepAPITest(this).executeEvent(52);
                alla.m_local.m_fdsa.commit();
            }
            catch (Throwable ioe2) {
                if (this.m_debug_switch) {
                    ioe2.printStackTrace();
                }
                err = new ErrorResult(new String[]{"C", RepAPIException.msg(313, null, new String[]{ioe2.getMessage()})}, 0, 0, 0, 0, 8);
                alla.m_remote.error(err);
                alla.m_refgrp.unlock();
                alla.notifyAndClear(err);
                this.clearPushLock();
                this.abortOrRemote(alla);
            }
            alla.m_refgrp.unlock();
            alla.notifyAndClear(null);
            this.clearPushLock();
            alla.m_refgrp = null;
            alla.clearCompletionStatus();
            alla.m_repapi = null;
            AllA tmpo = this.m_FDSs.push(alla);
            result = true;
        } else {
            ErrorResult err2 = new ErrorResult(new String[]{"C", RepAPIException.msg(311, null, null)}, 0, 0, 0, 0, 8);
            alla.m_refgrp.unlock();
            alla.notifyAndClear(err2);
            this.clearPushLock();
            this.abortOrRemote(alla);
        }
        return result;
    }

    private void pushLobs(AllA alla, ResultSet Push2RS, int lseqno) throws IOException, RepAPIException {
        if (this.m_debug_switch) {
            System.out.println("pushLobs");
            System.out.println("Result Set -" + Push2RS.toString());
        }
        int q = 0;
        while (q < Push2RS.cold.lobflg.length) {
            LOBTracker lobt = new LOBTracker();
            while (alla.m_Local_lob_info.m_length[q] > 0L) {
                int n = q;
                short s = (short)(alla.m_Local_lob_info.m_lob_flags[n] & 4);
                alla.m_Local_lob_info.m_lob_flags[n] = s;
                alla.m_remote.send_lob_req(alla.m_local.m_lob_tab.fetchLobChunk(Push2RS.tranid, lseqno, alla.m_Local_lob_info.m_column_nums[q], s == 0 ? (byte)0 : 1, lobt), ++alla.m_sentRequestNumber);
                int n2 = q;
                alla.m_Local_lob_info.m_length[n2] = alla.m_Local_lob_info.m_length[n2] - (long)lobt.m_LOBchunksize;
            }
            ++q;
        }
    }

    protected boolean pushToMaster(AllA alla, byte push_type) throws RepAPIException {
        if (this.m_debug_switch) {
            System.out.println("pushToMaster");
            System.out.println("push_type - " + push_type);
        }
        boolean result = false;
        AllA.LocalA loca = alla.m_local;
        RS rs = alla.m_remote;
        new RepAPITest(this).executeEvent(53);
        if (alla.m_abort_received || alla.m_fatal_error_received) {
            alla.m_refgrp.unlock();
            alla.notifyAndClear(null);
            this.clearPushLock();
            this.abortOrRemote(alla);
        }
        if (push_type == 1) {
            rs.refresh_initiate(alla.m_refgrp.m_rgid, (byte)0, (short)2, 0);
        }
        short[] pos1 = new short[]{1, 1};
        short[] sort1 = new short[]{1};
        int[] tranids = new int[]{alla.m_notpushed, alla.m_last_transaction};
        short[] fetch1 = new short[]{1};
        RSTracker rst = new RSTracker();
        ResultSet PushRS = null;
        ResultSet RepQRS = null;
        try {
            RepQRS = ResultSetFactory.createSingleRow(pos1, new java.lang.Object[]{tranids});
            int tranid = 0;
            int ptranid = 0;
            ByteArrayInputStream bis = null;
            DataInputStream dis = null;
            Stack<ResultSet> pobj = new Stack<ResultSet>();
            do {
                new RepAPITest(this).executeEvent(54);
                if (alla.m_abort_received || alla.m_fatal_error_received) {
                    alla.m_refgrp.unlock();
                    alla.notifyAndClear(null);
                    this.clearPushLock();
                    this.abortOrRemote(alla);
                }
                PushRS = pobj.push(alla.m_local.m_repQ_tab.fetch(fetch1, RepQRS, sort1, rst));
            } while (rst.m_RSmore);
            if (PushRS == null) {
                pobj = new Stack();
            }
            while (pobj.size() > 0) {
                byte[] tb = ((ResultSet)pobj.elementAt((int)0)).buf;
                int tbs = tb.length / 4;
                bis = new ByteArrayInputStream(tb);
                dis = new DataInputStream(bis);
                int l = 0;
                while (l < tbs) {
                    tranid = dis.readInt();
                    if (ptranid == 0 || tranid > ptranid) {
                        this.pushTransaction(alla, tranid, 1024);
                        new RepAPITest(this).executeEvent(55);
                        if (alla.m_abort_received || alla.m_fatal_error_received) {
                            alla.m_refgrp.unlock();
                            alla.notifyAndClear(null);
                            this.clearPushLock();
                            this.abortOrRemote(alla);
                        }
                        if (!alla.m_errt.empty()) {
                            this.errorTransaction(alla);
                        }
                    }
                    ptranid = tranid;
                    ++l;
                }
                pobj.removeElementAt(0);
            }
        }
        catch (Throwable ioe2) {
            if (ioe2 instanceof RepAPIException) {
                throw (RepAPIException)ioe2;
            }
            ErrorResult err = new ErrorResult(new String[]{"C", RepAPIException.msg(311, null, new String[]{ioe2.getMessage()})}, 0, 0, 0, (short)alla.m_refgrp.getRSN(), 8);
            if (this.m_debug_switch) {
                ioe2.printStackTrace();
                System.out.println("DEFER_PUSH");
                System.out.println("err - " + err.toString());
            }
            alla.m_remote.error(err);
            alla.m_refgrp.unlock();
            alla.notifyAndClear(err);
            this.clearPushLock();
            this.abortOrRemote(alla);
        }
        alla.waitTilPushDone();
        if (!alla.m_ack_received) {
            if (alla.m_refgrp != null) {
                alla.m_refgrp.unlock();
            }
            alla.notifyAndClear(null);
            this.clearPushLock();
            this.abortOrRemote(alla);
        } else {
            result = true;
        }
        return result;
    }

    private void pushTransaction(AllA alla, int tranid, int trantype) throws RepAPIException, IOException {
        if (this.m_debug_switch) {
            System.out.println("pushTransaction");
            System.out.println("tranid - " + tranid);
            System.out.println("trantype - " + trantype);
        }
        boolean multimsg = false;
        int numrows = 0;
        GroupResultSet grs = new GroupResultSet(alla.m_refgrp.m_rgid, 1, 0, 0, new ResultSet[1]);
        Stack<byte[]> bobj = new Stack<byte[]>();
        ResultSet Push2RS = null;
        ResultSet temprs = null;
        byte[] tempbuf = null;
        RSTracker rst = new RSTracker();
        new RepAPITest(this).executeEvent(56);
        if (alla.m_abort_received || alla.m_fatal_error_received) {
            alla.m_refgrp.unlock();
            alla.notifyAndClear(null);
            this.clearPushLock();
            this.abortOrRemote(alla);
        }
        short[] fetchseq = new short[]{2};
        short[] fetch2 = new short[]{3, 4, 5, 7};
        ResultSet RepQ2RS = ResultSetFactory.createSingleRow(new short[]{1}, new java.lang.Object[]{new int[]{tranid}});
        int lseqno = 0;
        do {
            temprs = alla.m_local.m_repQ_tab.fetch(fetchseq, RepQ2RS, fetchseq, rst);
            tempbuf = bobj.push(temprs.buf);
        } while (rst.m_RSmore);
        do {
            Push2RS = alla.m_local.m_repQ_tab.fetch(fetch2, RepQ2RS, fetchseq, rst);
            numrows += Push2RS.numrows;
            Push2RS.tranid = tranid;
            Push2RS.flags |= trantype;
            if (rst.m_RSmore) {
                Push2RS.flags |= 0x10;
                multimsg = true;
            } else {
                if (multimsg) {
                    Push2RS.flags |= 0x10;
                }
                Push2RS.flags |= 0x20;
                multimsg = false;
                if (tranid == alla.m_last_transaction) {
                    grs.flg = (short)(grs.flg | 1);
                }
            }
            int tbssum = 0;
            if (rst.m_lob_columns) {
                this.fillPushLobinfo(alla, Push2RS);
            }
            grs.rsltsets[0] = Push2RS;
            new RepAPITest(this).executeEvent(57);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                alla.m_refgrp.unlock();
                alla.notifyAndClear(null);
                this.clearPushLock();
                this.abortOrRemote(alla);
            }
            alla.m_remote.push_req(grs, ++alla.m_sentRequestNumber);
            if (!rst.m_lob_columns) continue;
            int i = 0;
            while (i < bobj.size()) {
                byte[] tb = (byte[])bobj.elementAt(i);
                int tbs = tb.length / 4;
                if ((tbssum += tbs) >= numrows) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(tb);
                    DataInputStream dis = new DataInputStream(bis);
                    int bufpos = tbs - (tbssum - numrows);
                    int skiprows = bufpos - 1;
                    if (skiprows > 0) {
                        dis.skipBytes(4 * skiprows);
                    }
                    lseqno = dis.readInt();
                }
                ++i;
            }
            this.pushLobs(alla, Push2RS, lseqno);
        } while (rst.m_RSmore);
    }

    private void setClientThresholds(int rthresh, int lthresh) throws RepAPIException {
        AllA tmp_alla = this.getAccess();
        if (tmp_alla == null) {
            throw new RepAPIException(101, null, null);
        }
        this.m_refresh_threshold = rthresh;
        this.m_lob_threshold = lthresh;
        tmp_alla.m_local.m_fdsa.setThresholds(this.m_refresh_threshold, this.m_lob_threshold);
        tmp_alla.m_repapi = null;
        tmp_alla = this.m_FDSs.push(tmp_alla);
    }

    public String[] showAvailableGroups() throws RepAPIException {
        if (!this.m_is_connected) {
            throw new RepAPIException(506, new String[]{this.m_master_name}, null);
        }
        string_bufHolder tmpbuf = new string_bufHolder();
        AllA alla = this.getAccess();
        if (alla == null) {
            throw new RepAPIException(101, null, null);
        }
        alla.m_remote.list_groups(tmpbuf);
        alla.m_repapi = null;
        alla = this.m_FDSs.push(alla);
        return tmpbuf.value;
    }

    public String[] showLocalGroups() throws RepAPIException {
        AllA alla = this.getAccess();
        if (alla == null) {
            throw new RepAPIException(101, null, null);
        }
        AllA.LocalA loca = alla.m_local;
        RSTracker rst = new RSTracker();
        ResultSet RefRS = null;
        String[] return_strings = null;
        try {
            new RepAPITest(this).executeEvent(58);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                this.abortOrRemote(alla);
            }
            Stack<ResultSet> tmpstack = new Stack<ResultSet>();
            do {
                RefRS = tmpstack.push(loca.m_refgrp_tab.fetch(ClientConsts.MRG, null, ClientConsts.MRG, rst));
            } while (rst.m_RSmore);
            loca.m_fdsa.commit();
            if (RefRS == null) {
                alla.m_repapi = null;
                this.m_FDSs.push(alla);
                return null;
            }
            Stack<String> tmpstack2 = new Stack<String>();
            String tmpobject = null;
            while (!tmpstack.empty()) {
                RefRS = (ResultSet)tmpstack.elementAt(0);
                int[] colLengths = ResultSetFactory.decodeLengths(RefRS, RefRS.numrows * RefRS.cold.pos.length);
                int offset = 0;
                int i = 0;
                while (i < colLengths.length) {
                    tmpobject = tmpstack2.push(ResultSetFactory.getStringColumn(RefRS.buf, offset, colLengths[i], this.m_diffchset));
                    offset += colLengths[i];
                    ++i;
                }
                tmpstack.removeElementAt(0);
            }
            return_strings = new String[tmpstack2.size()];
            int i = 0;
            while (i < return_strings.length) {
                return_strings[i] = (String)tmpstack2.elementAt(i);
                ++i;
            }
        }
        catch (Throwable ioe) {
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            alla.rollback();
            throw new RepAPIException(505, null, null);
        }
        alla.m_repapi = null;
        this.m_FDSs.push(alla);
        return return_strings;
    }

    public String[] showLocalGroupsForMaster() throws RepAPIException {
        AllA alla = this.getAccess();
        if (alla == null) {
            throw new RepAPIException(101, null, null);
        }
        AllA.LocalA loca = alla.m_local;
        String[] return_strings = null;
        try {
            ResultSet RefRS = ResultSetFactory.createSingleRow(ClientConsts.REFGROUP_MASTER_COLUMN, new java.lang.Object[]{this.m_master_name}, this.m_diffchset);
            ResultSet tempRS = null;
            RSTracker rst = new RSTracker();
            new RepAPITest(this).executeEvent(59);
            if (alla.m_abort_received || alla.m_fatal_error_received) {
                this.abortOrRemote(alla);
            }
            Stack<ResultSet> tmpstack = new Stack<ResultSet>();
            do {
                tempRS = tmpstack.push(loca.m_refgrp_tab.fetch(ClientConsts.RG, RefRS, null, rst));
            } while (rst.m_RSmore);
            loca.m_fdsa.commit();
            if (tempRS == null) {
                alla.m_repapi = null;
                this.m_FDSs.push(alla);
                return null;
            }
            Stack<String> tmpstack2 = new Stack<String>();
            String tmpobject = null;
            while (!tmpstack.empty()) {
                RefRS = (ResultSet)tmpstack.elementAt(0);
                int[] colLengths = ResultSetFactory.decodeLengths(RefRS, RefRS.numrows * RefRS.cold.pos.length);
                int offset = 0;
                int i = 0;
                while (i < colLengths.length) {
                    tmpobject = tmpstack2.push(ResultSetFactory.getStringColumn(RefRS.buf, offset, colLengths[i], this.m_diffchset));
                    offset += colLengths[i];
                    ++i;
                }
                tmpstack.removeElementAt(0);
            }
            return_strings = new String[tmpstack2.size()];
            int i = 0;
            while (i < return_strings.length) {
                return_strings[i] = (String)tmpstack2.elementAt(i);
                ++i;
            }
        }
        catch (Throwable ioe) {
            if (this.m_debug_switch) {
                ioe.printStackTrace();
            }
            alla.rollback();
            throw new RepAPIException(504, new String[]{this.m_master_name}, new String[]{ioe.getMessage()});
        }
        alla.m_repapi = null;
        this.m_FDSs.push(alla);
        return return_strings;
    }

    void store_site_id(int new_site_id, FDSObject site_table) throws IOException {
        this.m_site_id = new_site_id;
        ResultSet site_row = ResultSetFactory.createSingleRow(new short[]{1, 2, 3}, new java.lang.Object[]{this.m_master_name, this.m_site_name, new int[]{this.m_site_id}});
        site_table.update(site_row);
    }

    protected synchronized void testSetPushLock() {
        while (this.m_push_lock) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_push_lock = true;
    }

    class SocketThread
    extends Thread {
        SocketThread() {
        }

        public void run() {
            Socket socket = null;
            try {
                while (!RepAPI.this.m_close_run) {
                    socket = RepAPI.this.m_serversocket.accept();
                    new PrintWriter(socket.getOutputStream()).println(RepAPI.this.m_master_name);
                }
                RepAPI.this.m_serversocket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

