/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsInvalidDestinationException;
import oracle.jms.AQjmsInvalidSelectorException;
import oracle.jms.AQjmsMessageEOFException;
import oracle.jms.AQjmsMessageFormatException;
import oracle.jms.AQjmsMessageNotReadableException;
import oracle.jms.AQjmsMessageNotWriteableException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParseException;

public class AQjmsError {
    private static ResourceBundle bundle;
    public static final int INVALID_DELIVERY_MODE = 101;
    public static final int NOT_SUPPORTED = 102;
    public static final int SUB_IMPL = 103;
    public static final int PAYLOAD_NULL = 104;
    public static final int AGENT_NULL = 105;
    public static final int MULTI_SESSION = 106;
    public static final int INVALID_OPERATION = 107;
    public static final int INVALID_MESSAGE_TYPE = 108;
    public static final int CLASS_NOT_FOUND = 109;
    public static final int FIELD_NOT_WRITEABLE = 110;
    public static final int CONN_NULL = 111;
    public static final int INVALID_CONN = 112;
    public static final int CONN_STOPPED = 113;
    public static final int CONN_CLOSED = 114;
    public static final int CONSUMER_CLOSED = 115;
    public static final int INVALID_CONSUMER = 116;
    public static final int CONVERSION_FAILED = 117;
    public static final int INVALID_VALUE = 118;
    public static final int INVALID_PROP_VALUE = 119;
    public static final int DEQUEUE_FAILED = 120;
    public static final int DEST_PROP_NULL = 121;
    public static final int INTERNAL_ERROR = 122;
    public static final int INVALID_INTERVAL = 123;
    public static final int INVALID_DEQ_MODE = 124;
    public static final int INVALID_QUEUE = 125;
    public static final int INVALID_TOPIC = 126;
    public static final int INVALID_DESTINATION = 127;
    public static final int INVALID_NAVIG_MODE = 128;
    public static final int INVALID_PAYLOAD_TYPE = 129;
    public static final int MULTICONS_QUEUE = 130;
    public static final int SESSION_CLOSED = 131;
    public static final int MAX_PROP_EXCEEDED = 132;
    public static final int MESSAGE_NULL = 133;
    public static final int NAME_NULL = 134;
    public static final int INVALID_DRIVER = 135;
    public static final int PLOAD_FACT_NOTNULL = 136;
    public static final int PLOAD_FACT_NULL = 137;
    public static final int PRODUCER_CLOSED = 138;
    public static final int PROP_NAME_NULL = 139;
    public static final int INVALID_PROP_NAME = 140;
    public static final int INVALID_QTABLE = 141;
    public static final int MULTICONS_NOT_ENABLED = 142;
    public static final int QUEUE_NULL = 143;
    public static final int MULTICONS_ENABLED = 144;
    public static final int INVALID_RECP_LIST = 145;
    public static final int REGISTRATION_FAILED = 146;
    public static final int INVALID_REPLYTO = 147;
    public static final int MAX_PROP_SIZE_EXCEEDED = 148;
    public static final int SUBS_NULL = 149;
    public static final int PROP_NOT_SUPPORTED = 150;
    public static final int INVALID_TOPIC_TYPE = 151;
    public static final int INVALID_ACCESS_MODE = 152;
    public static final int INVALID_PROP_TYPE = 153;
    public static final int INVALID_SEQ_DEV = 154;
    public static final int AQ_EXCEPTION = 155;
    public static final int INVALID_CLASS = 156;
    public static final int IO_EXCEPTION = 157;
    public static final int SQL_EXCEPTION = 158;
    public static final int INVALID_SELECTOR = 159;
    public static final int EOF_EXCEPTION = 160;
    public static final int MESG_FORMAT_EXCEPTION = 161;
    public static final int MESG_NOT_READABLE = 162;
    public static final int MESG_NOT_WRITEABLE = 163;
    public static final int NO_SUCH_ELEMENT = 164;
    public static final int MAX_VALUE_SIZE_EXCEEDED = 165;
    public static final int TOPIC_NULL = 166;
    public static final int INVALID_DEQ_PARAMS = 167;
    public static final int MULTI_DEQ_PARAMS = 168;
    public static final int SQL_DATA_CLASS_NULL = 169;
    public static final int INVALID_REL_MSGID = 170;
    public static final int INVALID_MSG_PAYLOAD = 171;
    public static final int MULTI_QUEUE_TABLES = 172;
    public static final int QTABLE_NOT_FOUND = 173;
    public static final int CLASS_NULL = 174;
    public static final int DEQ_OPTION_NULL = 175;
    public static final int ENQ_OPTION_NULL = 176;
    public static final int INVALID_DEQ_CALL = 177;
    public static final int INVALID_QUEUE_NAME = 178;
    public static final int INVALID_QTABLE_NAME = 179;
    public static final int INVALID_QUEUE_TYPE = 180;
    public static final int INVALID_WAIT_TIME = 181;
    public static final int MULTI_QUEUE = 182;
    public static final int NO_AQ_DRIVER = 183;
    public static final int INVALID_QUEUE_HANDLE = 184;
    public static final int QUEUE_PROP_NULL = 185;
    public static final int QTABLE_PROP_NULL = 186;
    public static final int QTABLE_NULL = 187;
    public static final int INVALID_QTABLE_HANDLE = 188;
    public static final int BYTE_ARRAY_SMALL = 189;
    public static final int QUEUE_NOT_FOUND = 190;
    public static final int INVALID_SQLDATA_CLASS = 191;
    public static final int INVALID_VISIBILITY = 192;
    public static final int RAW_NOT_ALLOWED = 193;
    public static final int INVALID_SESSION = 194;
    public static final int INVALID_OBJ_TYPE = 195;
    public static final int MULTI_BROWSER = 196;
    public static final int AGENT_ADDRESS_NULL = 197;
    public static final int PRIVILEGED_LISTENER_SET = 198;
    public static final int NOTIFICATION_REG_FAILED = 199;
    public static final int DESTINATION_NULL = 200;
    public static final int RECIPIENT_NULL = 201;
    public static final int NOTIFICATION_UNREG_FAILED = 202;
    public static final int PAYLOAD_FACTORY_NULL = 203;
    public static final int JNI_ERROR = 204;

    static String getMessage(String key, Object[] args) {
        String ret_str = null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("oracle.jms.AQjmsMessages");
        }
        try {
            ret_str = MessageFormat.format(bundle.getString(key), args);
            ret_str = "JMS-" + key + ": " + ret_str;
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsError.getMessage", ex);
            ret_str = "Message [" + key + "] not found in 'AQjmsMessages'.";
        }
        return ret_str;
    }

    static void throwEx(int jms_error_code) throws JMSException {
        String msg = null;
        Object[] args = new String[]{"", ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsException(msg, jms_error_code);
    }

    static void throwEx(int jms_error_code, Exception linked_ex) throws JMSException {
        String msg = null;
        Object[] args = new String[]{"", ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsException(msg, jms_error_code, linked_ex);
    }

    static void throwEx(int jms_error_code, String arg1) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsException(msg, jms_error_code);
    }

    static void throwEx(int jms_error_code, String arg1, Exception linked_ex) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsException(msg, jms_error_code, linked_ex);
    }

    static void throwEx(int jms_error_code, String arg1, String arg2) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, arg2 == null ? "" : arg2};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsException(msg, jms_error_code);
    }

    static void throwEx(int jms_error_code, String arg1, String arg2, Exception linked_ex) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, arg2 == null ? "" : arg2};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsException(msg, jms_error_code, linked_ex);
    }

    static void throwMsgNotWriteableEx(int jms_error_code) throws JMSException {
        String msg = null;
        Object[] args = new String[]{"", ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsMessageNotWriteableException(msg, jms_error_code);
    }

    static void throwMsgNotReadableEx(int jms_error_code) throws JMSException {
        String msg = null;
        Object[] args = new String[]{"", ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsMessageNotReadableException(msg, jms_error_code);
    }

    static void throwMsgFormatEx(int jms_error_code, String arg1) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsMessageFormatException(msg, jms_error_code);
    }

    static void throwEOFileEx(int jms_error_code, String arg1) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsMessageEOFException(msg, jms_error_code);
    }

    static void throwInvalidDestEx(int jms_error_code) throws JMSException {
        String msg = null;
        Object[] args = new String[]{"", ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsInvalidDestinationException(msg, jms_error_code);
    }

    static void throwInvalidSelectorEx(int jms_error_code, String arg1) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsInvalidSelectorException(msg, jms_error_code);
    }

    static void throwInvalidSelectorEx(int jms_error_code, String arg1, Exception linked_ex) throws JMSException {
        String msg = null;
        Object[] args = new String[]{arg1 == null ? "" : arg1, ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsInvalidSelectorException(msg, jms_error_code, linked_ex);
    }

    static void throwParseEx(int jms_error_code) throws JMSException {
        String msg = null;
        Object[] args = new String[]{"", ""};
        msg = AQjmsError.getMessage(Integer.toString(jms_error_code), args);
        throw new AQjmsParseException(msg, jms_error_code);
    }

    static void throwSQLEx(String reason, String sqlstate, int vendorcode) throws SQLException {
        throw new SQLException(reason, sqlstate, vendorcode);
    }
}

