/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.sql.BLOB;
import oracle.sql.CustomDatumFactory;

public class AQjmsMapMessage
extends AQjmsMessage
implements MapMessage {
    Hashtable mapItemHash;
    AQjmsMapMessage_C map_msg_cont;

    AQjmsMapMessage() throws JMSException {
        try {
            this.map_msg_cont = new AQjmsMapMessage_C();
            this.map_msg_cont.setHeader(this.header_ext);
            this.mapItemHash = new Hashtable();
            this.access_mode = 2;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsMapMessage(AQjmsMapMessage_C msg_cont) throws JMSException {
        try {
            this.map_msg_cont = msg_cont;
            this.header_ext = msg_cont.getHeader();
            this.mapItemHash = this.readMapMessageContainer();
            this.access_mode = 0;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.map_msg_cont != null) {
                this.map_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsMapMessage(byte[] bdata) throws JMSException {
        this.mapItemHash = AQjmsMapMessage.convertByteArrayToHashtable(bdata);
        this.access_mode = 0;
    }

    public byte[] getHashTable() throws JMSException {
        return AQjmsMapMessage.convertHashtableToByteArray(this.mapItemHash);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Boolean(value));
    }

    public void setByte(String name, byte value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Byte(value));
    }

    public void setShort(String name, short value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Short(value));
    }

    public void setChar(String name, char value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Character(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Double(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Float(value));
    }

    public void setInt(String name, int value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, new Long(value));
    }

    public void setString(String name, String value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (value instanceof Integer || value instanceof Character || value instanceof Long || value instanceof Float || value instanceof Short || value instanceof Byte || value instanceof Double || value instanceof String || value instanceof byte[] || value instanceof Boolean) {
            this.mapItemHash.put(name, value);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        byte[] newValue = new byte[length];
        System.arraycopy(value, offset, newValue, 0, length);
        this.mapItemHash.put(name, newValue);
    }

    public boolean getBoolean(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    return new Boolean((String)obj);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return false;
        }
        AQjmsError.throwEx(164);
        return false;
    }

    public byte getByte(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return (Byte)obj;
                }
                if (obj instanceof String) {
                    return Byte.parseByte((String)obj);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0;
        }
        AQjmsError.throwEx(164);
        return 0;
    }

    public byte[] getBytes(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                return (byte[])obj;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
                AQjmsError.throwMsgFormatEx(117, null);
                return null;
            }
        }
        AQjmsError.throwEx(164);
        return null;
    }

    public char getChar(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Character) {
                    return ((Character)obj).charValue();
                }
                if (obj instanceof String) {
                    return ((String)obj).charAt(0);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return '\u0000';
        }
        AQjmsError.throwEx(164);
        return '\u0000';
    }

    public double getDouble(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Float) {
                    return ((Float)obj).floatValue();
                }
                if (obj instanceof Double) {
                    return (Double)obj;
                }
                if (obj instanceof String) {
                    return new Double((String)obj);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0.0;
        }
        AQjmsError.throwEx(164);
        return 0.0;
    }

    public float getFloat(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Float) {
                    return ((Float)obj).floatValue();
                }
                if (obj instanceof String) {
                    return new Float((String)obj).floatValue();
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0.0f;
        }
        AQjmsError.throwEx(164);
        return 0.0f;
    }

    public int getInt(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return ((Byte)obj).byteValue();
                }
                if (obj instanceof Short) {
                    return ((Short)obj).shortValue();
                }
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
                if (obj instanceof String) {
                    return new Integer((String)obj);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0;
        }
        AQjmsError.throwEx(164);
        return 0;
    }

    public long getLong(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return ((Byte)obj).byteValue();
                }
                if (obj instanceof Short) {
                    return ((Short)obj).shortValue();
                }
                if (obj instanceof Integer) {
                    return ((Integer)obj).intValue();
                }
                if (obj instanceof Long) {
                    return (Long)obj;
                }
                if (obj instanceof String) {
                    return new Long((String)obj);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0L;
        }
        AQjmsError.throwEx(164);
        return 0L;
    }

    public Enumeration getMapNames() throws JMSException {
        return this.mapItemHash.keys();
    }

    public Object getObject(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            return obj;
        }
        AQjmsError.throwEx(164);
        return null;
    }

    public short getShort(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Byte) {
                    return ((Byte)obj).byteValue();
                }
                if (obj instanceof Short) {
                    return (Short)obj;
                }
                if (obj instanceof String) {
                    return new Short((String)obj);
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0;
        }
        AQjmsError.throwEx(164);
        return 0;
    }

    public String getString(String name) throws JMSException {
        Object obj = this.mapItemHash.get(name);
        if (obj != null) {
            try {
                if (obj instanceof Integer || obj instanceof Character || obj instanceof Long || obj instanceof Float || obj instanceof Short || obj instanceof Byte || obj instanceof Double || obj instanceof String || obj instanceof Boolean) {
                    return obj.toString();
                }
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return null;
        }
        AQjmsError.throwEx(164);
        return null;
    }

    public boolean itemExists(String name) throws JMSException {
        return this.mapItemHash.containsKey(name);
    }

    public void clearBody() throws JMSException {
        this.mapItemHash.clear();
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    AQjmsMapMessage_C getMessageCont() {
        return this.map_msg_cont;
    }

    static byte[] convertHashtableToByteArray(Hashtable mapItemHash) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashtableToByteArray", "entry");
        try {
            ByteArrayOutputStream baostream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(baostream);
            oostream.writeObject(mapItemHash);
            AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashtableToByteArray", "exit");
            return baostream.toByteArray();
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertHashtableToByteArray IO", io_exp);
            AQjmsError.throwEx(157, io_exp.getMessage());
            return null;
        }
    }

    static Hashtable convertByteArrayToHashtable(byte[] in_byte_array) throws JMSException {
        Hashtable h_table = new Hashtable();
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashTable", "entry");
        try {
            ByteArrayInputStream baistream = new ByteArrayInputStream(in_byte_array);
            ObjectInputStream oistream = new ObjectInputStream(baistream);
            h_table = (Hashtable)oistream.readObject();
        }
        catch (ClassNotFoundException cnf_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashTable CNF", cnf_exp);
            AQjmsError.throwEx(109, cnf_exp.getMessage());
            return null;
        }
        catch (InvalidClassException ic_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashTable ICE", ic_exp);
            AQjmsError.throwEx(156, ic_exp.getMessage());
            return null;
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashTable IO", io_exp);
            AQjmsError.throwEx(157, io_exp.getMessage());
            return null;
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashTable", "exit");
        return h_table;
    }

    void populateMapMessageContainer() throws JMSException {
        Object bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.populateMapMessageContainer", "entry");
        try {
            this.map_msg_cont.setHeader(this.header_ext);
            b_data = AQjmsMapMessage.convertHashtableToByteArray(this.mapItemHash);
            bytes_len = b_data.length;
            AQjmsOracleDebug.trace(5, "AQjmsMapMessage.populateMapMessageContainer", " bytes_len " + bytes_len);
            this.map_msg_cont.setBytesLen(new Integer(bytes_len));
            if (bytes_len > 2000) {
                this.map_msg_cont.setBytesRaw(null);
            } else {
                this.map_msg_cont.setBytesRaw(b_data);
                this.map_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.populateMapMessageContainer", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.populateMapMessageContainer", "exit");
    }

    void write_blob(Connection db_conn, String q_table, byte[] msg_id) throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        int b_len = 0;
        OracleCallableStatement blob_stmt = null;
        ResultSet rset = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.write_blob", "entry");
        try {
            b_data = AQjmsMapMessage.convertHashtableToByteArray(this.mapItemHash);
            bytes_len = b_data.length;
            if (q_table == null) {
                AQjmsOracleDebug.trace(1, "AQjmsMapMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsMapMessage.write_blob", "bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                CustomDatumFactory payload_fact = AQjmsMapMessage_C.getFactory();
                blob_stmt = (OracleCallableStatement)db_conn.prepareCall("SELECT user_data FROM " + q_table + " where msgid = ?");
                blob_stmt.setBytes(1, msg_id);
                rset = blob_stmt.executeQuery();
                if (rset.next()) {
                    AQjmsMapMessage_C map_msg_c = (AQjmsMapMessage_C)((OracleResultSet)rset).getCustomDatum(1, payload_fact);
                    bytes_lob = map_msg_c.getBytesLob();
                }
                if (bytes_lob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsMapMessage.write_blob", "Internal error - bytes_blob is null");
                    AQjmsError.throwEx(122, "bytes_blob is null");
                }
                b_len = bytes_lob.putBytes(1L, b_data);
                try {
                    blob_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sql_ex) {
            try {
                blob_stmt.close();
            }
            catch (Exception exception) {}
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessaeg.write_blob", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.write_blob", "exit");
    }

    Hashtable readMapMessageContainer() throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.readMapMessageContainer", "entry");
        try {
            bytes_len = this.map_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsMapMessage.readMapMessageContainer", "bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                bytes_lob = this.map_msg_cont.getBytesLob();
                if (bytes_lob != null) {
                    b_data = bytes_lob.getBytes(1L, bytes_len);
                }
            } else {
                b_data = this.map_msg_cont.getBytesRaw();
            }
            AQjmsOracleDebug.trace(4, "AQjmsMapMessage.readMapMessageContainer", "exit");
            return AQjmsMapMessage.convertByteArrayToHashtable(b_data);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.readMapMessageContainer", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }
}

