/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsQueueConnectionFactory
implements QueueConnectionFactory {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver;
    String jdbc_conn_str;
    Properties jdbc_info;

    AQjmsQueueConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        if (driver != null) {
            if (driver.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (driver.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else {
                AQjmsError.throwEx(135, driver);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "hostname: " + hostname + "  oracle_sid: " + oracle_sid + "  port_no: " + portno + "  driver: " + driver);
    }

    AQjmsQueueConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "jdbc connect string: " + jdbc_connect_str);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        AQjmsConnection qconn = null;
        qconn = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "Connection created successfully");
        return qconn;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        AQjmsConnection qconn = null;
        Properties new_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "Username: " + username);
        if (this.jdbc_conn_str != null) {
            if (this.jdbc_info != null) {
                if (username != null || password != null) {
                    new_info = (Properties)((Hashtable)this.jdbc_info).clone();
                    ((Hashtable)new_info).put("user", username);
                    ((Hashtable)new_info).put("password", password);
                } else {
                    new_info = this.jdbc_info;
                }
                qconn = new AQjmsConnection(this.jdbc_conn_str, new_info, 10);
            } else {
                qconn = new AQjmsConnection(this.jdbc_conn_str, username, password, 10);
            }
        } else {
            qconn = new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, username, password, this.jdbc_driver, 10);
        }
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/username/password", "Connection created successfully");
        return qconn;
    }

    public static QueueConnection createQueueConnection(Connection jdbc_connection) throws JMSException {
        AQjmsConnection qconn = null;
        qconn = new AQjmsConnection(jdbc_connection, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/jdbc_conn", "Connection created successfully");
        return qconn;
    }
}

