/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsTextMessage_C;
import oracle.sql.CLOB;
import oracle.sql.CustomDatumFactory;

public class AQjmsTextMessage
extends AQjmsMessage
implements TextMessage {
    String text_data = null;
    AQjmsTextMessage_C text_msg_cont;

    AQjmsTextMessage() throws JMSException {
        try {
            this.text_msg_cont = new AQjmsTextMessage_C();
            this.text_msg_cont.setHeader(this.header_ext);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsTextMessage(AQjmsTextMessage_C msg_cont, OracleConnection db_conn) throws JMSException {
        try {
            this.text_msg_cont = msg_cont;
            this.header_ext = msg_cont.getHeader();
            this.readTextMessageContainer();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.text_msg_cont != null) {
                this.text_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void setText(String string) throws JMSException {
        Object len = null;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            this.text_data = string;
        }
    }

    public String getText() throws JMSException {
        return this.text_data;
    }

    public void clearBody() throws JMSException {
        this.text_data = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    AQjmsTextMessage_C getMessageCont() {
        return this.text_msg_cont;
    }

    void populateTextMessageContainer(OracleConnection db_conn) throws JMSException {
        Object text_lob = null;
        int text_len = 0;
        String str_data = null;
        boolean slen = false;
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.populateTextMessageContainer", "entry");
        try {
            this.text_msg_cont.setHeader(this.header_ext);
            this.text_msg_cont.setHeader(this.header_ext);
            str_data = this.getText();
            if (str_data != null) {
                text_len = str_data.length();
            }
            AQjmsOracleDebug.trace(5, "AQjmsTextMessage.populateTextMessageContainer", "text_len: " + text_len);
            if (text_len > 4000) {
                this.text_msg_cont.setTextLen(new Integer(text_len));
                this.text_msg_cont.setTextVc(null);
            } else {
                this.text_msg_cont.setTextLen(new Integer(text_len));
                this.text_msg_cont.setTextVc(str_data);
                this.text_msg_cont.setTextLob(null);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.populateTextMessageContainer", "exit");
    }

    void write_lob(Connection db_conn, String q_table, byte[] msg_id) throws JMSException {
        CLOB text_lob = null;
        int text_len = 0;
        String str_data = null;
        long slen = 0L;
        OracleCallableStatement lob_stmt = null;
        ResultSet rset = null;
        boolean num_loops = false;
        boolean lc_size = false;
        boolean pos = false;
        Object buf = null;
        try {
            str_data = this.getText();
            if (str_data != null) {
                text_len = str_data.length();
            }
            AQjmsOracleDebug.trace(5, "AQjmsTextMessage.write_blob", "text_len: " + text_len);
            if (q_table == null) {
                AQjmsOracleDebug.trace(1, "AQjmsTextMessage.write_lob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            if (text_len > 4000) {
                CustomDatumFactory payload_fact = AQjmsTextMessage_C.getFactory();
                AQjmsOracleDebug.trace(4, "AQjmsTextMessage.write_lob", "msg_id: " + RepConversion.bArray2String((byte[])msg_id));
                lob_stmt = (OracleCallableStatement)db_conn.prepareCall("SELECT user_data FROM " + q_table + " where msgid = ?");
                lob_stmt.setBytes(1, msg_id);
                rset = lob_stmt.executeQuery();
                if (rset.next()) {
                    AQjmsOracleDebug.trace(4, "AQjmsTextMessage.write_lob", "found the msg");
                    AQjmsTextMessage_C text_msg_c = (AQjmsTextMessage_C)((OracleResultSet)rset).getCustomDatum(1, payload_fact);
                    text_lob = text_msg_c.getTextLob();
                }
                if (text_lob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsTextMessage.write_lob", "Internal error - text_lob is null");
                    AQjmsError.throwEx(122, "text_lob is null");
                }
                slen = text_lob.putString(1L, str_data);
                try {
                    lob_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sql_ex) {
            try {
                lob_stmt.close();
            }
            catch (Exception exception) {}
            AQjmsOracleDebug.traceEx(3, "AQjmsTextMessage.write_lob", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.write_lob", "exit");
    }

    void readTextMessageContainer() throws JMSException {
        CLOB text_lob = null;
        int text_len = 0;
        String str_data = null;
        boolean slen = false;
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.readTextMessageContainer", "entry");
        try {
            text_len = this.text_msg_cont.getTextLen();
            AQjmsOracleDebug.trace(5, "AQjmsTextMessage.readTextMessageContainer", "text_len: " + text_len);
            if (text_len > 4000) {
                text_lob = this.text_msg_cont.getTextLob();
                if (text_lob != null) {
                    str_data = text_lob.getSubString(1L, text_len);
                }
                this.text_data = str_data;
            } else {
                this.text_data = str_data = this.text_msg_cont.getTextVc();
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTextMessage.readTextMessageContainer", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.readTextMessageContainer", "exit");
    }
}

