/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsError;

public class AQjmsTopicConnectionFactory
implements TopicConnectionFactory {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver;
    String jdbc_conn_str;
    Properties jdbc_info;

    AQjmsTopicConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        if (driver != null) {
            if (driver.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (driver.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else {
                AQjmsError.throwEx(135, driver);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
    }

    AQjmsTopicConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        AQjmsConnection tconn = null;
        tconn = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 20);
        return tconn;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        AQjmsConnection tconn = null;
        Properties new_info = null;
        if (this.jdbc_conn_str != null) {
            if (this.jdbc_info != null) {
                if (username != null || password != null) {
                    new_info = (Properties)((Hashtable)this.jdbc_info).clone();
                    ((Hashtable)new_info).put("user", username);
                    ((Hashtable)new_info).put("password", password);
                } else {
                    new_info = this.jdbc_info;
                }
                tconn = new AQjmsConnection(this.jdbc_conn_str, new_info, 20);
            } else {
                tconn = new AQjmsConnection(this.jdbc_conn_str, username, password, 20);
            }
        } else {
            tconn = new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, username, password, this.jdbc_driver, 20);
        }
        return tconn;
    }

    public static TopicConnection createTopicConnection(Connection jdbc_connection) throws JMSException {
        AQjmsConnection tconn = null;
        tconn = new AQjmsConnection(jdbc_connection, 20);
        return tconn;
    }
}

