/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import oracle.de.backend.runinformation.BaseDataSource;
import oracle.de.backend.runinformation.RIObjectRunList;
import oracle.de.backend.runinformation.RIResource;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;

public class RIDataSource
extends BaseDataSource {
    public static RIResource _resObject = null;
    RIObjectRunList _runList;
    String _ConObj;
    public static final int RISUMMARYRUNID = 0;
    public static final int EXPORT_COLUMN_SIZE = 21;

    public RIDataSource() {
        this._runList = null;
        _resObject = null;
    }

    public RIDataSource(String string) {
        _resObject = new RIResource(string);
        this._runList = null;
    }

    public RIDataSource(String string, String string2, String string3, String string4) {
        this._ConObj = null;
        _resObject = new RIResource(string);
        try {
            this.ConnectDB(string2, string3, string4);
            return;
        }
        catch (SQLException sQLException) {
            System.out.println("Failed to connect");
            return;
        }
    }

    public RIDataSource(String string, String string2) {
        this._ConObj = string2;
        _resObject = new RIResource(string);
        try {
            if (this.ConnectDB(this._ConObj)) {
                this._runList = new RIObjectRunList(BaseDataSource.getConnection());
                return;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Failed to connect");
        }
    }

    protected void finalize() {
        try {
            this.CloseDB();
            System.out.println("CloseDB in finalize of RIDataSource.");
            return;
        }
        catch (SQLException sQLException) {
            System.out.println("Failed to CloseDB in finalize of RIDataSource.");
            return;
        }
    }

    public RIResource getResObject() {
        return _resObject;
    }

    public boolean deleteRun(int n) {
        OracleConnection oracleConnection = BaseDataSource.getConnection();
        try {
            oracleConnection.setAutoCommit(false);
            String string = "delete from PLSQL_PROFILER_DATA where RUNID = " + n;
            OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
            oracleStatement.execute(string);
            oracleStatement.close();
            string = "delete from PLSQL_PROFILER_UNITS where RUNID = " + n;
            oracleStatement = (OracleStatement)oracleConnection.createStatement();
            oracleStatement.execute(string);
            oracleStatement.close();
            System.out.println("Successfully deleted the Units");
            string = "delete from PLSQL_PROFILER_RUNS where RUNID = " + n;
            oracleStatement = (OracleStatement)oracleConnection.createStatement();
            oracleStatement.execute(string);
            oracleStatement.close();
            System.out.println("Successfully deleted the Runs");
            oracleConnection.commit();
            System.out.println("Deletion committed");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            try {
                oracleConnection.rollback();
            }
            catch (Exception exception2) {
                System.out.println(exception2.getMessage());
            }
            return false;
        }
        boolean bl = this._runList.deleteRun(n);
        return bl;
    }

    public int poppulate() {
        if (this._runList == null) {
            this._runList = new RIObjectRunList(BaseDataSource.getConnection());
        }
        this._runList.poppulate();
        return 0;
    }

    public RIObjectRunList getRunsList() {
        if (this._runList == null) {
            this._runList = new RIObjectRunList(BaseDataSource.getConnection());
        }
        return this._runList;
    }

    public boolean saveRun(int n, String string, String string2) {
        return this._runList.saveRun(n, string, string2);
    }

    public boolean exportRunId(String string, int n) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            this._runList.getRunByRunId(n).exportObjectRun(fileWriter);
            fileWriter.flush();
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Could not open a file");
            return false;
        }
    }

    public boolean isRunModified(int n) {
        return this._runList.getRunByRunId(n).isModified();
    }

    public static String padSpaces(String string) {
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        while (n < 21) {
            string = String.valueOf(string) + " ";
            ++n;
        }
        return string;
    }
}

