/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.awt.Image;
import java.sql.SQLException;
import java.util.Properties;
import oracle.de.backend.runinformation.BaseDataSource;
import oracle.de.backend.runinformation.RIDataSource;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;

public class RIObjectAbout {
    private int _rc;
    private RIDataSource _ds;
    private ArrayTwoDDataSource _spDataSrc;
    private ArrayOneDDataSource _spHeaders;

    public RIObjectAbout(Object object) {
        this._ds = (RIDataSource)object;
    }

    public Image getAppImage() {
        return this._ds.getResObject().getAppIcon();
    }

    public ArrayOneDDataSource getVersionHeaders() {
        Object[] objectArray = new String[]{"Item", "Value", "Details"};
        this._spHeaders = new ArrayOneDDataSource(objectArray);
        return this._spHeaders;
    }

    public ArrayTwoDDataSource getVersionInfo() {
        this._rc = 0;
        this._spDataSrc = new ArrayTwoDDataSource(3, this._rc);
        Properties properties = System.getProperties();
        this.addGridData("Java Version ", properties.getProperty("java.version"), "Vendor:  " + properties.getProperty("java.vendor"));
        this.addDBVersionInfo();
        this.addGridData("Java Home", properties.getProperty("java.home"), "");
        this.addGridData("Operating System", properties.getProperty("os.name"), properties.getProperty("os.version"));
        return this._spDataSrc;
    }

    private void addDBVersionInfo() {
        OracleConnection oracleConnection = BaseDataSource.getConnection();
        String string = "select PRODUCT, VERSION, STATUS  from SYS.PRODUCT_COMPONENT_VERSION";
        if (oracleConnection != null) {
            try {
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement(string);
                OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                while (oracleResultSet.next()) {
                    this.addGridData(oracleResultSet.getString("PRODUCT"), oracleResultSet.getString("VERSION"), oracleResultSet.getString("STATUS"));
                }
                oracleResultSet.close();
                oraclePreparedStatement.close();
                oraclePreparedStatement = null;
                this.addJDBCDriverVersion(oracleConnection);
                this.addProfilerVersion(oracleConnection);
                return;
            }
            catch (SQLException sQLException) {
                System.out.println("SQLException thrown: " + sQLException.getMessage());
                return;
            }
        }
    }

    private void addJDBCDriverVersion(OracleConnection oracleConnection) throws SQLException {
        OracleDatabaseMetaData oracleDatabaseMetaData = new OracleDatabaseMetaData(oracleConnection);
        this.addGridData(oracleDatabaseMetaData.getDriverName(), OracleDatabaseMetaData.getDriverVersionInfo(), "");
    }

    private void addProfilerVersion(OracleConnection oracleConnection) throws SQLException {
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("{call DBMS_PROFILER.GET_VERSION (?, ?)}");
        oracleCallableStatement.registerOutParameter(1, 4);
        oracleCallableStatement.registerOutParameter(2, 4);
        oracleCallableStatement.execute();
        this.addGridData("DBMS_PROFILER", "Major:  " + oracleCallableStatement.getNUMBER(1).intValue(), "Minor:  " + oracleCallableStatement.getNUMBER(2).intValue());
        oracleCallableStatement.close();
    }

    private void addGridData(String string, String string2, String string3) {
        this._spDataSrc.addRows(this._rc, 1);
        this._spDataSrc.setData(0, this._rc, (Object)string);
        this._spDataSrc.setData(1, this._rc, (Object)string2);
        this._spDataSrc.setData(2, this._rc, (Object)string3);
        ++this._rc;
    }
}

