/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import oracle.de.backend.runinformation.BaseDataSource;
import oracle.de.backend.runinformation.RIDataSource;
import oracle.de.backend.runinformation.RIObjectPUDetailsList;
import oracle.de.backend.runinformation.RIObjectSrcList;

public class RIObjectPU {
    int _RunId;
    String _PUType;
    String _PUName;
    int _PUNumber;
    String _Owner;
    Date _PUTimeStamp;
    long _TotalRunTime;
    RIObjectPUDetailsList _PUDetailsList;
    RIObjectSrcList _PUSrcList;

    RIObjectPU() {
        this._RunId = -1;
        this._PUSrcList = null;
        this._PUDetailsList = null;
    }

    RIObjectPU(int n, int n2, String string, String string2, String string3, Date date, long l) {
        this._RunId = n;
        this._PUType = string;
        this._PUName = string3;
        this._Owner = string2;
        this._TotalRunTime = l;
        this._PUTimeStamp = date;
        this._PUNumber = n2;
        this._PUSrcList = null;
        this._PUDetailsList = null;
    }

    public int getRunId() {
        return this._RunId;
    }

    public String getPUType() {
        return this._PUType;
    }

    public String getPUName() {
        return this._PUName;
    }

    public String getPUOwner() {
        return this._Owner;
    }

    public long getTotalRunTime() {
        return this._TotalRunTime;
    }

    public int getPUNumber() {
        return this._PUNumber;
    }

    public Date getPUTimeStamp() {
        return this._PUTimeStamp;
    }

    public RIObjectPUDetailsList getPUDetailsList() {
        if (this._PUDetailsList != null) {
            return this._PUDetailsList;
        }
        this._PUDetailsList = new RIObjectPUDetailsList(BaseDataSource.getConnection());
        this._PUDetailsList.poppulate(this._RunId, (long)this._PUNumber);
        return this._PUDetailsList;
    }

    public RIObjectSrcList getPUSrcList() {
        if (this._PUSrcList != null) {
            return this._PUSrcList;
        }
        this._PUSrcList = new RIObjectSrcList(BaseDataSource.getConnection());
        this._PUSrcList.poppulate(this._Owner, this._PUType, this._PUName);
        return this._PUSrcList;
    }

    public boolean exportObjectPU(FileWriter fileWriter) {
        try {
            fileWriter.write(RIDataSource.padSpaces((String)this._PUType));
            fileWriter.write(RIDataSource.padSpaces((String)this._Owner));
            fileWriter.write(RIDataSource.padSpaces((String)this._PUName));
            fileWriter.write(RIDataSource.padSpaces((String)String.valueOf(this._PUNumber)));
            fileWriter.write(RIDataSource.padSpaces((String)String.valueOf(this._PUTimeStamp)));
            fileWriter.write(RIDataSource.padSpaces((String)String.valueOf(this._TotalRunTime)));
        }
        catch (IOException iOException) {
            System.out.println("Could not write to the file");
            return false;
        }
        return true;
    }

    public boolean exportPUDetailslist(FileWriter fileWriter) {
        if (this._PUDetailsList == null) {
            this.getPUDetailsList();
        }
        this._PUDetailsList.exportObjectPUDetailsList(fileWriter);
        return true;
    }
}

