/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.io.FileWriter;
import java.io.IOException;
import oracle.de.backend.runinformation.BaseDataSource;
import oracle.de.backend.runinformation.RIObjectPUList;

public class RIObjectRun {
    int _RunId;
    String _RunComment;
    String _RunName;
    long _TotalRunTime;
    boolean _Modified;
    String _RunDate;
    RIObjectPUList _PUList;

    RIObjectRun() {
        this._RunId = -1;
        this._Modified = false;
        this._PUList = null;
    }

    RIObjectRun(int n, String string, String string2, String string3, long l) {
        this._RunId = n;
        this._RunComment = string;
        this._RunName = string2;
        this._RunDate = string3;
        this._TotalRunTime = l;
        this._PUList = null;
        this._Modified = false;
    }

    public int getRunId() {
        return this._RunId;
    }

    public String getRunComment() {
        return this._RunComment;
    }

    public String getRunName() {
        return this._RunName;
    }

    public String getRunDate() {
        return this._RunDate;
    }

    public long getTotalRunTime() {
        return this._TotalRunTime;
    }

    public boolean isModified() {
        return this._Modified;
    }

    public void setRunComment(String string) {
        this._RunComment = string;
    }

    public void setRunName(String string) {
        this._Modified = true;
        this._RunName = string;
    }

    public RIObjectPUList getPUList() {
        if (this._PUList != null) {
            return this._PUList;
        }
        this._PUList = new RIObjectPUList(BaseDataSource.getConnection());
        this._PUList.poppulate(this._RunId);
        return this._PUList;
    }

    public boolean exportObjectRun(FileWriter fileWriter) {
        try {
            String string = System.getProperties().getProperty("line.separator");
            fileWriter.write("Run Id:  " + this._RunId);
            fileWriter.write(String.valueOf(string) + "Run Comment:  " + this._RunComment);
            fileWriter.write(String.valueOf(string) + "Run Name:  " + this._RunName);
            fileWriter.write(String.valueOf(string) + "Total Run Time:  " + this._TotalRunTime);
            fileWriter.write("Run Date:  " + this._RunDate + string + string);
            if (this._PUList == null) {
                this.getPUList();
            }
            this._PUList.exportObjectPUList(fileWriter);
        }
        catch (IOException iOException) {
            System.out.println("Could not write to the given file.");
            return false;
        }
        return true;
    }

    public void setModified(boolean bl) {
        this._Modified = bl;
    }
}

