/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.sql.SQLException;
import java.util.Vector;
import oracle.de.backend.runinformation.RIObjectRun;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;

public class RIObjectRunList {
    Vector _RIRunsList;
    OracleConnection _ConObject;
    boolean _Modified;
    OraclePreparedStatement _stmt;
    private final int RUN_NAME_SIZE = 32;

    RIObjectRunList() {
        this._RIRunsList = new Vector(0, 1);
        this._ConObject = null;
    }

    RIObjectRunList(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
        this._RIRunsList = new Vector(0, 1);
    }

    protected void finalize() throws SQLException {
    }

    public void setConObject(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
    }

    public OracleConnection getConObject() {
        return this._ConObject;
    }

    public void setRunName(int n, String string) {
        this.getRunByRunId(n).setRunName(string);
        this._Modified = true;
    }

    public boolean poppulate() {
        if (this._ConObject == null) {
            return false;
        }
        this.addRun(new RIObjectRun(0, "", "Summarize All Runs", "", -1L));
        if (this._ConObject == null) {
            System.out.println("Cannot continue without Database connection.");
            return false;
        }
        try {
            String string = "Select to_char(RUN_DATE, 'DD-MM-YYYY HH24:MI:SS') as RUN_DATE,  RUN_COMMENT, RUNID, RUN_TOTAL_TIME  from PLSQL_PROFILER_RUNS";
            this._stmt = (OraclePreparedStatement)this._ConObject.prepareStatement(string);
            OracleResultSet oracleResultSet = (OracleResultSet)this._stmt.executeQuery();
            while (oracleResultSet.next()) {
                String string2;
                String string3 = oracleResultSet.getString("RUN_DATE");
                String string4 = oracleResultSet.getString("RUN_COMMENT");
                if (string4 != null) {
                    if ((string4 = string4.trim()).length() < 32) {
                        string2 = string4;
                    } else {
                        string2 = string4.substring(0, 32);
                        string2 = string2.trim();
                        string4 = string4.substring(32);
                        string4 = string4.trim();
                    }
                } else {
                    string4 = "No Comments";
                    string2 = "No Names";
                }
                this.addRun(new RIObjectRun(oracleResultSet.getInt("RUNID"), string4, string2, string3, oracleResultSet.getLong("RUN_TOTAL_TIME")));
            }
            oracleResultSet.close();
            this._stmt.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException thrown:   " + sQLException.getMessage());
            return false;
        }
        return true;
    }

    public boolean addRun(RIObjectRun rIObjectRun) {
        this._RIRunsList.addElement(rIObjectRun);
        return true;
    }

    public RIObjectRun getFirstRun() {
        return (RIObjectRun)this._RIRunsList.firstElement();
    }

    public RIObjectRun getRun(int n) {
        return (RIObjectRun)this._RIRunsList.elementAt(n);
    }

    public RIObjectRun removeRun(int n) {
        RIObjectRun rIObjectRun = this.getRun(n);
        this._RIRunsList.removeElementAt(n);
        return rIObjectRun;
    }

    public boolean removeRun(RIObjectRun rIObjectRun) {
        return this._RIRunsList.removeElement(rIObjectRun);
    }

    public int getRunsCount() {
        return this._RIRunsList.size();
    }

    public boolean removeRunByRunId(int n) {
        int n2 = 0;
        while (n2 < this.getRunsCount()) {
            if (this.getRun(n2).getRunId() == n) {
                this.removeRun(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public RIObjectRun getRunByRunId(int n) {
        int n2 = 0;
        while (n2 < this.getRunsCount()) {
            if (this.getRun(n2).getRunId() == n) {
                return this.getRun(n2);
            }
            ++n2;
        }
        return null;
    }

    public boolean isModified() {
        return this._Modified;
    }

    public boolean deleteRun(int n) {
        return this.removeRunByRunId(n);
    }

    public boolean saveRun(int n, String string, String string2) {
        int n2 = 0;
        if (string == null) {
            return false;
        }
        RIObjectRun rIObjectRun = this.getRunByRunId(n);
        rIObjectRun.setRunComment(string2);
        rIObjectRun.setRunName(string);
        n2 = string.length();
        while (n2 < 32) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        try {
            int n3 = 0;
            String string3 = "update PLSQL_PROFILER_RUNS set RUN_COMMENT = ? where RUNID = ?";
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this._ConObject.prepareStatement(string3);
            oraclePreparedStatement.setString(1, String.valueOf(string) + string2);
            oraclePreparedStatement.setInt(2, n);
            n3 = oraclePreparedStatement.executeUpdate();
            oraclePreparedStatement.close();
            rIObjectRun.setModified(false);
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException thrown:   " + sQLException.getMessage());
            return false;
        }
        return true;
    }
}

