/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.backend.runinformation;

import java.sql.SQLException;
import java.util.Vector;
import oracle.de.backend.runinformation.BaseDataSource;
import oracle.de.backend.runinformation.RIObjectSrc;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;

public class RIObjectSrcList {
    Vector _RISrcList;
    OracleConnection _ConObject;
    OraclePreparedStatement _stmt;
    String _PUOwner;
    String _PUType;
    String _PUName;

    public RIObjectSrcList() {
        this._RISrcList = new Vector(0, 1);
        this._ConObject = null;
        this._PUOwner = null;
        this._PUType = null;
        this._PUName = null;
    }

    public RIObjectSrcList(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
        this._RISrcList = new Vector(0, 1);
        this._PUOwner = null;
        this._PUType = null;
        this._PUName = null;
    }

    public boolean setDefaultConObject() {
        this._ConObject = BaseDataSource.getConnection();
        return this._ConObject != null;
    }

    public void setConObject(OracleConnection oracleConnection) {
        this._ConObject = oracleConnection;
    }

    public OracleConnection getConObject() {
        return this._ConObject;
    }

    public boolean poppulate(String string, String string2, String string3) {
        if (this._ConObject == null) {
            System.out.println("Cannot continue without Database connection.");
            return false;
        }
        try {
            boolean bl = false;
            String string4 = "Select LINE, TEXT from ALL_SOURCE where OWNER = ? AND TYPE = ? and NAME = ? ORDER BY LINE";
            this._stmt = (OraclePreparedStatement)this._ConObject.prepareStatement(string4);
            this._stmt.setString(1, string);
            this._stmt.setString(2, string2);
            this._stmt.setString(3, string3);
            OracleResultSet oracleResultSet = (OracleResultSet)this._stmt.executeQuery();
            while (oracleResultSet.next()) {
                String string5 = oracleResultSet.getString("TEXT");
                this.addSrc(new RIObjectSrc(oracleResultSet.getLong("LINE"), string5.replace('\t', ' ')));
                bl = true;
            }
            if (!bl) {
                this.addSrc(new RIObjectSrc(0L, "Source Not Available"));
            }
            oracleResultSet.close();
            this._stmt.close();
            this._PUOwner = string;
            this._PUType = string2;
            this._PUName = string3;
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException thrown:  " + sQLException.getMessage());
            return false;
        }
        return true;
    }

    public boolean addSrc(RIObjectSrc rIObjectSrc) {
        this._RISrcList.addElement(rIObjectSrc);
        return true;
    }

    public RIObjectSrc getFirstSrc() {
        return (RIObjectSrc)this._RISrcList.firstElement();
    }

    public RIObjectSrc getLineSrc(int n) {
        return (RIObjectSrc)this._RISrcList.elementAt(n);
    }

    public int getLineCount() {
        return this._RISrcList.size();
    }

    public String getPUOwner() {
        return this._PUOwner;
    }

    public String getPUType() {
        return this._PUType;
    }

    public String getPUName() {
        return this._PUName;
    }

    protected void finalize() throws SQLException {
    }
}

