/*
 * Decompiled with CFR 0.152.
 */
package oracle.de.ui.runinformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.Window;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Properties;
import oracle.de.backend.runinformation.BaseDataSource;
import oracle.de.backend.runinformation.RIDataSource;
import oracle.de.backend.runinformation.RIResource;
import oracle.de.ui.runinformation.ExportFilenameFilter;
import oracle.de.ui.runinformation.ProfileEventListener;
import oracle.de.ui.runinformation.ProfileEventObject;
import oracle.de.ui.runinformation.RIListRuns;
import oracle.de.ui.runinformation.RIPrintDlg;
import oracle.de.ui.runinformation.RITab;
import oracle.de.ui.runinformation.RIToolBar;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.splitter.Splitter;
import oracle.ewt.util.WindowUtils;
import oracle.jdbc.driver.OracleConnection;

public class RIWindow
extends LWComponent {
    RIDataSource _rids;
    ScrollBox _RIScrollBoxTree;
    Splitter _RISplitter;
    RIListRuns _RIRuns;
    RITab _rit;
    RIToolBar _ritb;
    RIResource _rirsrc;
    ScrollBox _RITreeScrollBox;
    String _ConObj;
    int _CurRunId;
    ListenerManager _listeners;
    private int RIUNINVALIDNODEID = -1;
    private double RIWINDOW_SPLITTER_RATIO = 0.2;

    public RIWindow() {
        this._rids = new RIDataSource("Images");
        this.initializeUI();
    }

    public RIWindow(String string) {
        this._ConObj = string;
        this._rids = new RIDataSource("Images", string);
        this.initializeUI();
        this.poppulate();
    }

    public RIWindow(String string, String string2, String string3) {
        this._ConObj = null;
        this._rids = new RIDataSource("Images", string, string2, string3);
        this.initializeUI();
        this.poppulate();
    }

    private void initializeUI() {
        this._rirsrc = this._rids.getResObject();
        this.setLayout(new BorderLayout());
        this._listeners = null;
        this._ritb = new RIToolBar(this, this._rirsrc);
        this._ritb.poppulate();
        this.add((Component)this._ritb, "North");
        this._RIRuns = new RIListRuns();
        this._RIRuns.setHost(this);
        this._RITreeScrollBox = new ScrollBox((Component)this._RIRuns, 0, 0);
        this._rit = new RITab(this, this._rids);
        this._RISplitter = new Splitter((Component)this._RITreeScrollBox, (Component)this._rit, false);
        this.add((Component)this._RISplitter, "Center");
        this._RISplitter.setSizeRatio(this.RIWINDOW_SPLITTER_RATIO);
    }

    public void setDBConnection(OracleConnection oracleConnection) {
        BaseDataSource.setDBConnection((OracleConnection)oracleConnection);
    }

    public int poppulate() {
        this._rids.poppulate();
        this._RIRuns.setDataSource(this._rids.getRunsList());
        return this._RIRuns.poppulate(false);
    }

    public void runSelectionChanged(int n, int n2, String string) {
        String string2;
        if (n2 != this.RIUNINVALIDNODEID && this._rids.isRunModified(n2)) {
            string2 = this._rit.getRunComment(n2);
            this._rids.saveRun(n2, string, string2);
        }
        if (n != this.RIUNINVALIDNODEID) {
            this._rit.poppulate(n, true);
        }
        this._CurRunId = n;
        if (this._listeners != null) {
            string2 = new ProfileEventObject((Object)this, n, n2, 0);
            this.processProfileEventObject((ProfileEventObject)string2);
        }
    }

    public void printRIProfile() {
        BufferedFrame bufferedFrame = new BufferedFrame();
        RIPrintDlg rIPrintDlg = new RIPrintDlg(WindowUtils.parentFrame((Component)this), this._rirsrc.getPrintDlgTitle(), true);
        rIPrintDlg.setOptions(this._rit.getDisplayedTab());
        WindowUtils.centerWindow((Window)rIPrintDlg, (Component)WindowUtils.parentFrame((Component)this));
        rIPrintDlg.setVisible(true);
        if (rIPrintDlg.isCancelled) {
            return;
        }
        PrintJob printJob = this.getToolkit().getPrintJob((Frame)bufferedFrame, "PL/SQL Profile  RunId:  " + this._CurRunId, null);
        if (printJob == null) {
            return;
        }
        if (rIPrintDlg.isRunInfoSelected) {
            this._rit.printContents(printJob, bufferedFrame, 1, false, 0, 0);
        }
        if (rIPrintDlg.isPUListSelected) {
            this._rit.printContents(printJob, bufferedFrame, 2, rIPrintDlg.isPUListAllSelected, rIPrintDlg.puListFrom, rIPrintDlg.puListTo);
        }
        if (rIPrintDlg.isPUDetailsSelected) {
            this._rit.printContents(printJob, bufferedFrame, 3, rIPrintDlg.isPUDetailsAllSelected, rIPrintDlg.puDetailsFrom, rIPrintDlg.puDetailsTo);
        }
        printJob.end();
        bufferedFrame.dispose();
        rIPrintDlg.dispose();
    }

    public void exportRIProfile() {
        FileDialog fileDialog = new FileDialog(WindowUtils.parentFrame((Component)this), this._rirsrc.getExportDlgTitle(), 1);
        ExportFilenameFilter exportFilenameFilter = new ExportFilenameFilter();
        fileDialog.setFilenameFilter((FilenameFilter)exportFilenameFilter);
        fileDialog.setFile("*.txt");
        WindowUtils.centerWindow((Window)fileDialog, (Component)WindowUtils.parentFrame((Component)this));
        fileDialog.show();
        String string = fileDialog.getDirectory();
        string = string != null ? String.valueOf(string) + this.getFileSeparator() : "";
        String string2 = String.valueOf(string) + fileDialog.getFile();
        if (string2 != null) {
            this._rids.exportRunId(string2, this._CurRunId);
        }
    }

    public void deleteRIProfile() {
        int n = 3;
        if (this.showRIAlert(String.valueOf(this._rirsrc.getDeleteConfirmMsg()) + this._RIRuns.getSelectedItemRunName(), 0, n, this._rirsrc.getDeleteConfirmTitle()) == 1) {
            this._DeleteARun();
        }
    }

    public int showRIAlert(String string, int n, int n2, String string2) {
        Alert alert = new Alert(string, n, n2);
        alert.setTitle(string2);
        return alert.runAlert();
    }

    public void setAppIcon(Frame frame) {
        frame.setIconImage(this._rirsrc.getAppIcon());
    }

    public Object getDataSrc() {
        return this._rids;
    }

    public int getCurRunId() {
        return this._CurRunId;
    }

    public void addProfileEventListener(ProfileEventListener profileEventListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)profileEventListener);
    }

    public void removeProfileListener(ProfileEventListener profileEventListener) {
        this._listeners.removeListener((EventListener)profileEventListener);
    }

    protected void processProfileEventObject(ProfileEventObject profileEventObject) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ProfileEventListener profileEventListener = (ProfileEventListener)enumeration.nextElement();
                switch (profileEventObject.getEventID()) {
                    case 0: {
                        profileEventListener.runSelectionChanged(profileEventObject);
                        break;
                    }
                    case 1: {
                        profileEventListener.runSelectionChanged(profileEventObject);
                        break;
                    }
                }
            }
        }
    }

    private boolean _DeleteARun() {
        boolean bl = this._rids.deleteRun(this._RIRuns.getSelectedItemRunId());
        if (bl) {
            this._RIRuns.deleteCurSelItem();
        }
        return bl;
    }

    private String getFileSeparator() {
        Properties properties = System.getProperties();
        return properties.getProperty("file.separator");
    }
}

