/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.plsql;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.gss.util.NLSLocale;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.xml.parser.plsql.XMLDocumentCover;
import oracle.xml.parser.plsql.XSLStylesheetCover;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNodeCover {
    static int NODE_MASK = 1048575;
    static int DOC_SHIFT = 20;
    static Vector documents = new Vector(10);

    static {
        documents.addElement(new Vector(100));
    }

    public static int appendChild(int n, int n2, int[] nArray) {
        Node node = XMLNodeCover.getNode(n);
        Node node2 = XMLNodeCover.getNode(n2);
        try {
            return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.appendChild(node2));
        }
        catch (DOMException dOMException) {
            nArray[0] = dOMException.code;
            return -1;
        }
    }

    public static int cloneNode(int n, boolean bl) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.cloneNode(bl));
    }

    public static void freeDocument(int n) {
        documents.setElementAt(null, n >> DOC_SHIFT);
    }

    public static int getAttributes(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getAttributes());
    }

    public static int getChildNodes(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getChildNodes());
    }

    public static Document getDocument(int n) {
        Vector vector = (Vector)documents.elementAt(n >> DOC_SHIFT);
        return (Document)vector.elementAt(0);
    }

    public static int getDocumentId(Node node) {
        Vector<Node> vector = new Vector<Node>(100);
        vector.addElement(node);
        documents.addElement(vector);
        int n = documents.size() - 1;
        return n << DOC_SHIFT;
    }

    public static int getFirstChild(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getFirstChild());
    }

    public static int getLastChild(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getLastChild());
    }

    public static NamedNodeMap getNNM(int n) {
        Vector vector = (Vector)documents.elementAt(n >> DOC_SHIFT);
        return (NamedNodeMap)vector.elementAt(n & NODE_MASK);
    }

    public static int getNextSibling(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getNextSibling());
    }

    public static Node getNode(int n) {
        Vector vector = (Vector)documents.elementAt(n >> DOC_SHIFT);
        return (Node)vector.elementAt(n & NODE_MASK);
    }

    public static int getNodeId(int n, Object object) {
        if (object != null) {
            Vector vector = (Vector)documents.elementAt(n);
            vector.addElement(object);
            int n2 = vector.size() - 1;
            n2 = (n << DOC_SHIFT) + n2;
            return n2;
        }
        return -1;
    }

    public static NodeList getNodeList(int n) {
        Vector vector = (Vector)documents.elementAt(n >> DOC_SHIFT);
        return (NodeList)vector.elementAt(n & NODE_MASK);
    }

    public static String getNodeName(int n) {
        Node node = XMLNodeCover.getNode(n);
        return node.getNodeName();
    }

    public static short getNodeType(int n) {
        Node node = XMLNodeCover.getNode(n);
        return node.getNodeType();
    }

    public static String getNodeValue(int n, int[] nArray) {
        Node node = XMLNodeCover.getNode(n);
        try {
            return node.getNodeValue();
        }
        catch (DOMException dOMException) {
            nArray[0] = dOMException.code;
            return null;
        }
    }

    public static int getOwnerDocument(int n) {
        return n - (n & NODE_MASK);
    }

    public static int getParentNode(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getParentNode());
    }

    public static int getPreviousSibling(int n) {
        Node node = XMLNodeCover.getNode(n);
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.getPreviousSibling());
    }

    public static boolean hasChildNodes(int n) {
        Node node = XMLNodeCover.getNode(n);
        return node.hasChildNodes();
    }

    public static int insertBefore(int n, int n2, int n3, int[] nArray) {
        Node node = XMLNodeCover.getNode(n);
        Node node2 = XMLNodeCover.getNode(n2);
        Node node3 = XMLNodeCover.getNode(n3);
        try {
            return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node.insertBefore(node2, node3));
        }
        catch (DOMException dOMException) {
            nArray[0] = dOMException.code;
            return -1;
        }
    }

    public static int removeChild(int n, int n2, int[] nArray) {
        Node node = XMLNodeCover.getNode(n);
        Node node2 = XMLNodeCover.getNode(n2);
        try {
            return XMLNodeCover.getNodeId(0, node.removeChild(node2));
        }
        catch (DOMException dOMException) {
            nArray[0] = dOMException.code;
            return -1;
        }
    }

    public static int replaceChild(int n, int n2, int n3, int[] nArray) {
        Node node = XMLNodeCover.getNode(n);
        Node node2 = XMLNodeCover.getNode(n2);
        Node node3 = XMLNodeCover.getNode(n3);
        try {
            return XMLNodeCover.getNodeId(0, node.replaceChild(node2, node3));
        }
        catch (DOMException dOMException) {
            nArray[0] = dOMException.code;
            return -1;
        }
    }

    public static int selectNodes(int n, String string, String[] stringArray) {
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        NodeList nodeList = null;
        try {
            nodeList = xMLNode.selectNodes(string);
        }
        catch (XSLException xSLException) {
            stringArray[0] = xSLException.getMessage();
            return -1;
        }
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, nodeList);
    }

    public static int selectSingleNode(int n, String string, String[] stringArray) {
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        Node node = null;
        try {
            node = xMLNode.selectSingleNode(string);
        }
        catch (XSLException xSLException) {
            stringArray[0] = xSLException.getMessage();
            return -1;
        }
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, node);
    }

    public static void setNodeValue(int n, String string, int[] nArray) {
        Node node = XMLNodeCover.getNode(n);
        try {
            node.setNodeValue(string);
        }
        catch (DOMException dOMException) {
            nArray[0] = dOMException.code;
            return;
        }
    }

    public static int transformNode(int n, int n2, String[] stringArray) {
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        XSLStylesheet xSLStylesheet = XSLStylesheetCover.getStylesheet(n2);
        XMLDocumentFragment xMLDocumentFragment = null;
        try {
            xMLDocumentFragment = (XMLDocumentFragment)xMLNode.transformNode(xSLStylesheet);
        }
        catch (XSLException xSLException) {
            stringArray[0] = xSLException.getMessage();
            return -1;
        }
        return XMLNodeCover.getNodeId(n >> DOC_SHIFT, xMLDocumentFragment);
    }

    public static String valueOf(int n, String string, String[] stringArray) {
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        String string2 = null;
        try {
            string2 = xMLNode.valueOf(string);
        }
        catch (XSLException xSLException) {
            stringArray[0] = xSLException.getMessage();
            return null;
        }
        return string2;
    }

    public static void writeToBuffer(int n, CHAR[] cHARArray, String string, String[] stringArray) {
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string2 = null;
        String string3 = NLSLocale.getInstance().getJavaCharset(string);
        if (string3 != null) {
            string2 = (String)XMLDocumentCover.m_JavaCS2MIMECS.get(string3);
        }
        try {
            if (string2 != null) {
                xMLNode.print((OutputStream)new BufferedOutputStream(byteArrayOutputStream), string2);
            } else {
                xMLNode.print((OutputStream)new BufferedOutputStream(byteArrayOutputStream));
            }
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
            return;
        }
        if (cHARArray[0] != null) {
            cHARArray[0].setBytes(byteArrayOutputStream.toByteArray());
        } else {
            cHARArray[0] = new CHAR(byteArrayOutputStream.toByteArray(), null);
        }
    }

    public static void writeToClob(int n, CLOB[] cLOBArray, String string, String[] stringArray) {
        OutputStream outputStream = null;
        if (cLOBArray[0] == null) {
            stringArray[0] = "CLOB to write to can not be null";
            return;
        }
        try {
            outputStream = cLOBArray[0].getAsciiOutputStream();
        }
        catch (SQLException sQLException) {
            stringArray[0] = sQLException.getMessage();
            return;
        }
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        String string2 = null;
        String string3 = NLSLocale.getInstance().getJavaCharset(string);
        if (string3 != null) {
            string2 = (String)XMLDocumentCover.m_JavaCS2MIMECS.get(string3);
        }
        try {
            if (string2 != null) {
                xMLNode.print((OutputStream)new BufferedOutputStream(outputStream), string2);
            } else {
                xMLNode.print((OutputStream)new BufferedOutputStream(outputStream));
            }
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
            return;
        }
    }

    public static void writeToFile(int n, String string, String string2, String[] stringArray) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
            return;
        }
        XMLNode xMLNode = (XMLNode)XMLNodeCover.getNode(n);
        String string3 = null;
        String string4 = NLSLocale.getInstance().getJavaCharset(string2);
        if (string4 != null) {
            string3 = (String)XMLDocumentCover.m_JavaCS2MIMECS.get(string4);
        }
        try {
            if (string3 != null) {
                xMLNode.print((OutputStream)new BufferedOutputStream(fileOutputStream), string3);
            } else {
                xMLNode.print((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
            return;
        }
    }
}

