/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.plsql;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.xml.parser.plsql.XMLNodeCover;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLParserCover {
    static PrintStream dummy = System.out;
    static Vector parsers = new Vector(10);
    static Vector errorlogs = new Vector(10);

    static URL fileToURL(String string) throws MalformedURLException {
        URL uRL = null;
        if (string == null) {
            return uRL;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            String string2 = file.getAbsolutePath();
            String string3 = System.getProperty("file.separator");
            if (string3.length() == 1) {
                char c = string3.charAt(0);
                if (c != '/') {
                    string2 = string2.replace(c, '/');
                }
                if (string2.charAt(0) != '/') {
                    string2 = String.valueOf('/') + string2;
                }
            }
            if (file.isDirectory() && !string2.endsWith("/")) {
                string2 = String.valueOf(string2) + "/";
            }
            string2 = "file://" + string2;
            uRL = new URL(string2);
        }
        return uRL;
    }

    public static void freeParser(int n) {
        parsers.setElementAt(null, n);
        errorlogs.setElementAt(null, n);
    }

    public static int getDoctype(int n) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        return XMLNodeCover.getNodeId(0, dOMParser.getDoctype());
    }

    public static int getDocument(int n) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        return XMLNodeCover.getDocumentId((Node)dOMParser.getDocument());
    }

    public static int getValidationMode(int n) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        return dOMParser.getValidationMode() ? 1 : 0;
    }

    public static int newParser() {
        DOMParser dOMParser = new DOMParser();
        parsers.addElement(dOMParser);
        errorlogs.addElement(null);
        return parsers.size() - 1;
    }

    public static void parse(int n, String string, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = XMLParserCover.fileToURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            stringArray[0] = malformedURLException.getMessage();
            return;
        }
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        String string2 = (String)errorlogs.elementAt(n);
        if (string2 != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                dOMParser.setErrorStream((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                stringArray[0] = iOException.getMessage();
                return;
            }
        }
        try {
            dOMParser.parse(uRL);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
        }
        catch (SAXException sAXException) {
            stringArray[0] = sAXException.getMessage();
        }
    }

    public static void parseBuffer(int n, CHAR cHAR, String[] stringArray) {
        byte[] byArray = cHAR.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        String string = (String)errorlogs.elementAt(n);
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                dOMParser.setErrorStream((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                stringArray[0] = iOException.getMessage();
                return;
            }
        }
        try {
            dOMParser.parse((InputStream)byteArrayInputStream);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
        }
        catch (SAXException sAXException) {
            stringArray[0] = sAXException.getMessage();
        }
    }

    public static void parseClob(int n, CLOB cLOB, String[] stringArray) {
        InputStream inputStream = null;
        try {
            inputStream = cLOB.getAsciiStream();
        }
        catch (SQLException sQLException) {
            stringArray[0] = sQLException.getMessage();
            return;
        }
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        String string = (String)errorlogs.elementAt(n);
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                dOMParser.setErrorStream((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                stringArray[0] = iOException.getMessage();
                return;
            }
        }
        try {
            dOMParser.parse(inputStream);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
        }
        catch (SAXException sAXException) {
            stringArray[0] = sAXException.getMessage();
        }
    }

    public static void parseDTD(int n, String string, String string2, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = XMLParserCover.fileToURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            stringArray[0] = malformedURLException.getMessage();
            return;
        }
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        String string3 = (String)errorlogs.elementAt(n);
        if (string3 != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string3, true);
                dOMParser.setErrorStream((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                stringArray[0] = iOException.getMessage();
                return;
            }
        }
        try {
            dOMParser.parseDTD(uRL, string2);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
        }
        catch (SAXException sAXException) {
            stringArray[0] = sAXException.getMessage();
        }
    }

    public static void parseDTDBuffer(int n, CHAR cHAR, String string, String[] stringArray) {
        byte[] byArray = cHAR.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        String string2 = (String)errorlogs.elementAt(n);
        if (string2 != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                dOMParser.setErrorStream((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                stringArray[0] = iOException.getMessage();
                return;
            }
        }
        try {
            dOMParser.parseDTD((InputStream)byteArrayInputStream, string);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
        }
        catch (SAXException sAXException) {
            stringArray[0] = sAXException.getMessage();
        }
    }

    public static void parseDTDClob(int n, CLOB cLOB, String string, String[] stringArray) {
        InputStream inputStream = null;
        try {
            inputStream = cLOB.getAsciiStream();
        }
        catch (SQLException sQLException) {
            stringArray[0] = sQLException.getMessage();
            return;
        }
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        String string2 = (String)errorlogs.elementAt(n);
        if (string2 != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                dOMParser.setErrorStream((OutputStream)new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                stringArray[0] = iOException.getMessage();
                return;
            }
        }
        try {
            dOMParser.parseDTD(inputStream, string);
        }
        catch (IOException iOException) {
            stringArray[0] = iOException.getMessage();
        }
        catch (SAXException sAXException) {
            stringArray[0] = sAXException.getMessage();
        }
    }

    public static void setBaseURL(int n, String string, String[] stringArray) {
        URL uRL = null;
        try {
            uRL = XMLParserCover.fileToURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            stringArray[0] = malformedURLException.getMessage();
            return;
        }
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        dOMParser.setBaseURL(uRL);
    }

    public static void setDoctype(int n, int n2) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        DTD dTD = (DTD)XMLNodeCover.getNode(n2);
        dOMParser.setDoctype(dTD);
    }

    public static void setErrorLog(int n, String string) {
        errorlogs.setElementAt(string, n);
    }

    public static void setPreserveWhitespace(int n, boolean bl) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        dOMParser.setPreserveWhitespace(bl);
    }

    public static void setValidationMode(int n, boolean bl) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        dOMParser.setValidationMode(bl);
    }

    public static void showWarnings(int n, boolean bl) {
        DOMParser dOMParser = (DOMParser)parsers.elementAt(n);
        dOMParser.showWarnings(bl);
    }
}

