/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.joint;

import oracle.repapi.joint.ColumnDescriptor;
import oracle.repapi.joint.ColumnDescriptorHelper;
import oracle.repapi.joint.ColumnGroup;
import oracle.repapi.joint.ColumnGroupHelper;
import oracle.repapi.joint.HiddenColumnIndexes;
import oracle.repapi.joint.HiddenColumnIndexesHelper;
import oracle.repapi.joint.Snapshot;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class SnapshotHelper {
    private static TypeCode _type;

    private static ORB _orb() {
        return ORB.init();
    }

    public static Snapshot extract(Any any) {
        if (!any.type().equal(SnapshotHelper.type())) {
            throw new BAD_TYPECODE();
        }
        return SnapshotHelper.read(any.create_input_stream());
    }

    public static String id() {
        return "IDL:Snapshot:1.0";
    }

    public static void insert(Any any, Snapshot value) {
        OutputStream output = any.create_output_stream();
        SnapshotHelper.write(output, value);
        any.read_value(output.create_input_stream(), SnapshotHelper.type());
    }

    public static Snapshot read(InputStream _input) {
        Snapshot result = new Snapshot();
        result.snapname = _input.read_wstring();
        result.schemaname = _input.read_wstring();
        result.flag = _input.read_short();
        result.snapid = _input.read_long();
        result.numcols = _input.read_short();
        int _length3 = _input.read_long();
        result.snapcols = new ColumnDescriptor[_length3];
        int _i3 = 0;
        while (_i3 < _length3) {
            result.snapcols[_i3] = ColumnDescriptorHelper.read(_input);
            ++_i3;
        }
        result.numcgrp = _input.read_short();
        int _length32 = _input.read_long();
        result.snapcgrp = new ColumnGroup[_length32];
        int _i32 = 0;
        while (_i32 < _length32) {
            result.snapcgrp[_i32] = ColumnGroupHelper.read(_input);
            ++_i32;
        }
        result.numidx = _input.read_short();
        int _length33 = _input.read_long();
        result.hididx = new HiddenColumnIndexes[_length33];
        int _i33 = 0;
        while (_i33 < _length33) {
            result.hididx[_i33] = HiddenColumnIndexesHelper.read(_input);
            ++_i33;
        }
        int _length34 = _input.read_long();
        result.pkcols = new short[_length34];
        int _i34 = 0;
        while (_i34 < _length34) {
            result.pkcols[_i34] = _input.read_short();
            ++_i34;
        }
        return result;
    }

    public static TypeCode type() {
        if (_type == null) {
            StructMember[] members = new StructMember[]{new StructMember("snapname", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_wstring), null), new StructMember("schemaname", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_wstring), null), new StructMember("flag", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_short), null), new StructMember("snapid", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_long), null), new StructMember("numcols", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_short), null), new StructMember("snapcols", SnapshotHelper._orb().create_sequence_tc(0, ColumnDescriptorHelper.type()), null), new StructMember("numcgrp", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_short), null), new StructMember("snapcgrp", SnapshotHelper._orb().create_sequence_tc(0, ColumnGroupHelper.type()), null), new StructMember("numidx", SnapshotHelper._orb().get_primitive_tc(TCKind.tk_short), null), new StructMember("hididx", SnapshotHelper._orb().create_sequence_tc(0, HiddenColumnIndexesHelper.type()), null), new StructMember("pkcols", SnapshotHelper._orb().create_sequence_tc(0, SnapshotHelper._orb().get_primitive_tc(TCKind.tk_short)), null)};
            _type = SnapshotHelper._orb().create_struct_tc(SnapshotHelper.id(), "Snapshot", members);
        }
        return _type;
    }

    public static void write(OutputStream _output, Snapshot value) {
        _output.write_wstring(value.snapname);
        _output.write_wstring(value.schemaname);
        _output.write_short(value.flag);
        _output.write_long(value.snapid);
        _output.write_short(value.numcols);
        _output.write_long(value.snapcols.length);
        int _i2 = 0;
        while (_i2 < value.snapcols.length) {
            ColumnDescriptorHelper.write(_output, value.snapcols[_i2]);
            ++_i2;
        }
        _output.write_short(value.numcgrp);
        _output.write_long(value.snapcgrp.length);
        int _i22 = 0;
        while (_i22 < value.snapcgrp.length) {
            ColumnGroupHelper.write(_output, value.snapcgrp[_i22]);
            ++_i22;
        }
        _output.write_short(value.numidx);
        _output.write_long(value.hididx.length);
        int _i23 = 0;
        while (_i23 < value.hididx.length) {
            HiddenColumnIndexesHelper.write(_output, value.hididx[_i23]);
            ++_i23;
        }
        _output.write_long(value.pkcols.length);
        int _i24 = 0;
        while (_i24 < value.pkcols.length) {
            _output.write_short(value.pkcols[_i24]);
            ++_i24;
        }
    }
}

