/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Frame;
import oracle.repapi.RepApiGui.CompleteDialog;
import oracle.repapi.RepApiGui.Confirmation;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.Offline;
import oracle.repapi.RepApiGui.Purpose;
import oracle.repapi.client.FDSAccess;
import oracle.repapi.client.RepAPI;
import oracle.repapi.poljac.PolAccess;

class OfflineExecutioner
implements Runnable {
    public Offline m_offline;
    private Confirmation m_confirmation;
    private Purpose m_purpose;
    private CompleteDialog dialog;

    public OfflineExecutioner(Offline offline, Confirmation confirmation) {
        this.m_offline = offline;
        this.m_confirmation = confirmation;
        this.m_purpose = this.m_offline.m_clientLogin.m_purpose;
    }

    private void offlineCleanup() {
        if (this.m_confirmation.p_dialog.isShowing()) {
            this.m_confirmation.p_dialog.dispose();
        }
        if (this.m_confirmation.p_dialog.yn_dialog != null && this.m_confirmation.p_dialog.yn_dialog.isShowing()) {
            this.m_confirmation.p_dialog.yn_dialog.dispose();
        }
    }

    public void run() {
        try {
            try {
                this.m_confirmation.p_dialog.p_bar.setText("Instantiating " + this.m_offline.m_filename + "...");
                Thread.sleep(330L);
                if (this.m_offline.m_clientLogin.m_repapi == null || this.m_offline.m_clientLogin.m_repapi.isConnected()) {
                    FDSAccess[] fds = new FDSAccess[Purpose.m_numConns];
                    int i = 0;
                    while (i < Purpose.m_numConns) {
                        fds[i] = new PolAccess();
                        ++i;
                    }
                    if (this.m_offline.m_clientLogin.m_repapi != null) {
                        this.m_offline.m_clientLogin.m_repapi.close();
                    }
                    this.m_offline.m_clientLogin.m_repapi = new RepAPI(fds, this.m_offline.m_clientLogin.m_clientDatabase, this.m_offline.m_clientLogin.m_clientUsername, this.m_offline.m_clientLogin.m_clientPassword, this.m_offline.m_serverInfo.m_serverInfoDatabase, this.m_offline.m_serverInfo.m_serverInfoUsername);
                }
                this.m_offline.m_clientLogin.m_repapi.offlineInstantiate(this.m_offline.m_offlineTemplate);
                Frame frame = this.m_confirmation.m_frame;
                this.dialog = new CompleteDialog(frame, this.m_confirmation.m_gui, this.m_purpose, this.m_confirmation);
                this.m_confirmation.p_dialog.p_bar.stopAnimation();
                this.offlineCleanup();
                this.dialog.show();
            }
            catch (Exception ex) {
                this.m_confirmation.p_dialog.p_bar.stopAnimation();
                new ErrorDialog(this.m_confirmation.m_frame, ex.getMessage());
                this.offlineCleanup();
                this.m_confirmation.buttonsReset(true);
                return;
            }
        }
        catch (ThreadDeath threadDeath) {
            this.m_confirmation.p_dialog.p_bar.stopAnimation();
            this.offlineCleanup();
            this.m_confirmation.buttonsReset(true);
        }
    }
}

