/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import oracle.repapi.RepApiGui.AppletGui;
import oracle.repapi.RepApiGui.ButtonPanel;
import oracle.repapi.RepApiGui.ClientLogin;
import oracle.repapi.RepApiGui.Creation;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.GuiPanel;
import oracle.repapi.RepApiGui.IIException;
import oracle.repapi.RepApiGui.Offline;
import oracle.repapi.RepApiGui.Separator;
import oracle.repapi.RepApiGui.ServerInfo_Back_actionAdapter;
import oracle.repapi.RepApiGui.ServerInfo_Cancel_actionAdapter;
import oracle.repapi.RepApiGui.ServerInfo_Next_actionAdapter;

public class ServerInfo
extends GuiPanel {
    public AppletGui m_gui;
    public ClientLogin m_clientLogin;
    public String m_serverInfoUsername = null;
    public String m_serverInfoDatabase = null;
    private Offline m_offline = null;
    private Creation m_creation;
    private TextField m_usernametf;
    private TextField m_passwordtf;
    private TextField m_databasetf;
    private Frame m_frame;

    public ServerInfo(AppletGui gui, ClientLogin client, Creation previous) {
        this.m_gui = gui;
        this.m_clientLogin = client;
        this.m_creation = previous;
        this.m_frame = this.m_gui.getTopLevelFrame(this);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            new ErrorDialog(this.m_frame, e.getMessage());
        }
    }

    void Back_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_creation.setVisible(true);
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.m_clientLogin.m_purpose.setVisible(true);
    }

    void Next_actionPerformed(ActionEvent e) {
        this.m_serverInfoUsername = this.canonicalize(this.m_usernametf.getText());
        this.m_serverInfoDatabase = this.canonicalize(this.m_databasetf.getText());
        try {
            this.ValidateInput(this.m_serverInfoUsername, this.m_serverInfoDatabase);
        }
        catch (IIException ie) {
            new ErrorDialog(this.m_frame, ie.getMessage());
            return;
        }
        if (this.m_offline == null) {
            this.m_offline = new Offline(this.m_gui, this.m_clientLogin, this);
            this.m_gui.add(this.m_offline);
        }
        this.m_gui.validate();
        this.setVisible(false);
        this.m_offline.setVisible(true);
    }

    void ValidateInput(String name, String db) throws IIException {
        if (name.length() == 0) {
            throw new IIException("Server username needs to be entered.");
        }
        if (db.length() == 0) {
            throw new IIException("Server database needs to be entered.");
        }
    }

    String canonicalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    public void layoutComponents() {
        this.gbc.anchor = 18;
        Label m_title = new Label("Oracle Client Replication Tool, step 5 of 7: Server Information");
        m_title.setFont(this.titleFont);
        this.add(this, m_title, this.gbl, this.gbc, 0, 0, 8, 1);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        Separator m_sep1 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep1, this.gbl, this.gbc, 0, 1, 8, 1);
        this.setFont(this.textFont);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 10;
        Label m_command = new Label("Please provide the following information about the server site:");
        this.add(this, m_command, this.gbl, this.gbc, 0, 2, 8, 2);
        this.gbc.anchor = 13;
        Label m_username = new Label("Username:");
        this.add(this, m_username, this.gbl, this.gbc, 0, 4, 2, 1);
        this.gbc.anchor = 17;
        this.m_usernametf = new TextField(30);
        this.add(this, this.m_usernametf, this.gbl, this.gbc, 2, 4, 6, 1);
        this.gbc.anchor = 12;
        Label m_database = new Label("Server URL Label:");
        this.add(this, m_database, this.gbl, this.gbc, 0, 5, 2, 1);
        this.gbc.anchor = 18;
        this.m_databasetf = new TextField(30);
        this.add(this, this.m_databasetf, this.gbl, this.gbc, 2, 5, 6, 1);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 15;
        Separator m_sep2 = new Separator(480, 10, Color.gray);
        this.add(this, m_sep2, this.gbl, this.gbc, 0, 6, 8, 1);
        this.gbc.fill = 2;
        this.gbc.anchor = 15;
        Button m_cancel = new Button("Cancel");
        Button m_back = new Button("< Back");
        Button m_next = new Button("Next >");
        m_cancel.addActionListener(new ServerInfo_Cancel_actionAdapter(this));
        m_back.addActionListener(new ServerInfo_Back_actionAdapter(this));
        m_next.addActionListener(new ServerInfo_Next_actionAdapter(this));
        ButtonPanel m_buttonPanel = new ButtonPanel(this.m_gui, m_cancel, m_back, m_next, null);
        this.add(this, m_buttonPanel, this.gbl, this.gbc, 0, 7, 8, 1);
    }
}

