/*
 * Decompiled with CFR 0.152.
 */
package oracle.repapi.RepApiGui;

import java.awt.Frame;
import oracle.repapi.RepApiGui.CompleteDialog;
import oracle.repapi.RepApiGui.Confirmation;
import oracle.repapi.RepApiGui.ErrorDialog;
import oracle.repapi.RepApiGui.Purpose;
import oracle.repapi.RepApiGui.Template;
import oracle.repapi.client.RefGrp;

class TemplateExecutioner
implements Runnable {
    private Template m_template;
    private Confirmation m_confirmation;
    private CompleteDialog dialog;
    private Purpose m_purpose;

    public TemplateExecutioner(Template template, Confirmation confirmation) {
        this.m_template = template;
        this.m_confirmation = confirmation;
        this.m_purpose = this.m_template.m_serverLogin.m_clientLogin.m_purpose;
    }

    public void run() {
        try {
            try {
                Thread.sleep(150L);
                if (this.m_confirmation.m_confirmTask == 1) {
                    this.m_confirmation.p_dialog.p_bar.setText("Preparing to refresh ...");
                } else if (this.m_confirmation.m_confirmTask == 2) {
                    this.m_confirmation.p_dialog.p_bar.setText("Preparing to instantiate ...");
                } else if (this.m_confirmation.m_confirmTask == 4) {
                    this.m_confirmation.p_dialog.p_bar.setText("Preparing to drop ...");
                }
                int i = 0;
                String[] files = this.m_template.m_list.getSelectedItems();
                i = 0;
                while (i < files.length) {
                    if (this.m_confirmation.m_confirmTask == 1) {
                        this.m_confirmation.p_dialog.p_bar.setText("Refreshing " + files[i] + " ...");
                        RefGrp refgrp = this.m_template.m_serverLogin.m_clientLogin.m_repapi.getRefreshGroup("\"" + files[i] + "\"");
                        refgrp.synchronize();
                    } else if (this.m_confirmation.m_confirmTask == 2) {
                        this.m_confirmation.p_dialog.p_bar.setText("Instantiating " + files[i] + " ...");
                        this.m_template.m_serverLogin.m_clientLogin.m_repapi.createRefreshGroup("\"" + files[i] + "\"");
                    } else if (this.m_confirmation.m_confirmTask == 4) {
                        this.m_confirmation.p_dialog.p_bar.setText("Dropping " + files[i] + " ...");
                        this.m_template.m_serverLogin.m_clientLogin.m_repapi.dropRefreshGroup("\"" + files[i] + "\"");
                    }
                    ++i;
                }
                Frame frame = this.m_confirmation.m_frame;
                this.dialog = new CompleteDialog(frame, this.m_confirmation.m_gui, this.m_purpose, this.m_confirmation);
                this.m_confirmation.p_dialog.p_bar.stopAnimation();
                this.m_template.m_serverLogin.m_databasetf.setText("");
                this.templateCleanup();
                this.dialog.show();
            }
            catch (Exception ie) {
                this.m_confirmation.p_dialog.p_bar.stopAnimation();
                new ErrorDialog(this.m_confirmation.m_frame, ie.getMessage());
                this.templateCleanup();
                this.m_confirmation.buttonsReset(true);
                return;
            }
        }
        catch (ThreadDeath threadDeath) {
            this.m_confirmation.p_dialog.p_bar.stopAnimation();
            this.templateCleanup();
            this.m_confirmation.buttonsReset(true);
        }
    }

    private void templateCleanup() {
        if (this.m_confirmation.p_dialog.isShowing()) {
            this.m_confirmation.p_dialog.dispose();
        }
        if (this.m_confirmation.p_dialog.yn_dialog != null && this.m_confirmation.p_dialog.yn_dialog.isShowing()) {
            this.m_confirmation.p_dialog.yn_dialog.dispose();
        }
    }
}

