/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSNameImpl;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DocumentBuilder
extends DefaultXMLDocumentHandler
implements XMLConstants {
    XMLError err = new XMLError();
    String version;
    String standalone;
    String encoding;
    boolean xmldecl = false;
    Locator locator;
    int stackSize = 16;
    public int currentParent = -1;
    public XMLNode[] parents;
    DTD dtd;
    XMLDocument doc;
    NodeFactory factory = new NodeFactory();
    boolean factorySet = false;
    boolean parsingDTD;
    boolean debugFlag = false;
    boolean retainCDATA = false;
    boolean chopIt = false;
    int elems = 0;
    int chopstart = 0;

    public DocumentBuilder() {
        this.parents = new XMLNode[16];
        this.debugFlag = this.getDebugMode();
    }

    public void cDATASection(char[] cArray, int n, int n2) throws SAXException {
        XMLNode xMLNode;
        if (this.chopIt) {
            return;
        }
        XMLNode xMLNode2 = this.parents[this.currentParent];
        if (this.retainCDATA) {
            xMLNode = this.factory.createCDATASection(new String(cArray, n, n2));
            if (xMLNode != null) {
                xMLNode2.appendChild(xMLNode, true);
            }
        } else if (!this.factorySet) {
            xMLNode2.addText(cArray, n, n2);
        } else {
            xMLNode = this.factory.createCDATASection(new String(cArray, n, n2));
            if (xMLNode != null) {
                xMLNode2.addText(((XMLText)xMLNode).getText());
            }
        }
        if (this.debugFlag) {
            xMLNode = (XMLNode)xMLNode2.getLastChild();
            xMLNode.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.chopIt) {
            return;
        }
        XMLNode xMLNode = this.parents[this.currentParent];
        if (!this.factorySet) {
            xMLNode.addText(cArray, n, n2);
            if (this.debugFlag) {
                XMLNode xMLNode2 = (XMLNode)xMLNode.getLastChild();
                xMLNode2.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
            }
        } else {
            XMLText xMLText = this.factory.createTextNode(new String(cArray, n, n2));
            if (xMLText != null) {
                xMLNode.addText(xMLText.getText());
                if (this.debugFlag) {
                    XMLNode xMLNode3 = (XMLNode)xMLNode.getLastChild();
                    xMLNode3.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
                }
            }
        }
    }

    private boolean chopping() {
        ++this.elems;
        return this.chopIt;
    }

    public void comment(String string) throws SAXException {
        if (this.parsingDTD) {
            return;
        }
        XMLComment xMLComment = this.factory.createComment(string);
        if (xMLComment != null) {
            XMLNode xMLNode = this.parents[this.currentParent];
            xMLNode.appendChild(xMLComment, true);
            if (this.debugFlag) {
                xMLComment.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
            }
        }
    }

    public void endDoctype() throws SAXException {
        this.parsingDTD = false;
    }

    public void endDocument() throws SAXException {
        --this.currentParent;
    }

    public void endElement(NSName nSName) throws SAXException {
        if (this.stopChopping()) {
            --this.currentParent;
        }
    }

    boolean getDebugMode() {
        String string = System.getProperty("oracle.xml.parser.debugmode", "false");
        return string.equals("true");
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.parsingDTD) {
            return;
        }
        XMLPI xMLPI = this.factory.createProcessingInstruction(string, string2);
        if (xMLPI != null) {
            XMLNode xMLNode = this.parents[this.currentParent];
            xMLNode.appendChild(xMLPI, true);
            if (this.debugFlag) {
                xMLPI.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
            }
        }
    }

    void reset() {
        this.locator = null;
        int n = 0;
        while (n < this.stackSize) {
            this.parents[n] = null;
            ++n;
        }
        this.currentParent = -1;
        this.dtd = null;
        this.doc = null;
    }

    public void retainCDATASection(boolean bl) {
        this.retainCDATA = bl;
    }

    public void setDebugMode(boolean bl) {
        this.debugFlag = bl;
    }

    public void setDoctype(DTD dTD) throws SAXException {
        this.parsingDTD = true;
        this.dtd = dTD;
        if (this.doc != null) {
            this.doc.appendChild(dTD, true);
        } else {
            this.parents[++this.currentParent] = dTD;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.factorySet = true;
        this.factory = nodeFactory;
    }

    public void setTextDecl(String string, String string2) throws SAXException {
    }

    public void setXMLDecl(String string, String string2, String string3) throws SAXException {
        this.xmldecl = true;
        this.version = string;
        this.standalone = string2;
        this.encoding = string3;
    }

    private void startChopping() {
        this.chopstart = this.elems;
        this.chopIt = true;
    }

    public void startDocument() throws SAXException {
        this.doc = this.factory.createDocument();
        if (this.doc == null) {
            throw new SAXException(this.err.getMessage0(180));
        }
        this.doc.err = this.err;
        if (this.debugFlag) {
            this.doc.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
        }
        if (this.xmldecl) {
            this.xmldecl = false;
            this.doc.setVersion(this.version);
            this.doc.setStandalone(this.standalone);
            this.doc.setEncoding(this.encoding);
        }
        this.parents[++this.currentParent] = this.doc;
    }

    public void startElement(NSName nSName, SAXAttrList sAXAttrList) throws SAXException {
        Object object;
        XMLElement xMLElement;
        if (this.chopping()) {
            return;
        }
        NSNameImpl nSNameImpl = (NSNameImpl)nSName;
        if (!this.factorySet) {
            xMLElement = new XMLElement(nSNameImpl.name, nSNameImpl.prefix, nSNameImpl.qname, nSNameImpl.namespace);
        } else {
            xMLElement = this.factory.createElement(nSNameImpl.qname);
            if (xMLElement != null) {
                xMLElement.namespace = nSNameImpl.namespace;
                xMLElement.name = nSNameImpl.name;
                xMLElement.prefix = nSNameImpl.prefix;
            }
        }
        if (xMLElement == null) {
            this.startChopping();
            return;
        }
        if (this.debugFlag) {
            xMLElement.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
        }
        XMLNode xMLNode = this.parents[this.currentParent];
        if (this.dtd != null) {
            xMLElement.ed = this.dtd.findElementDecl(xMLElement.getNodeName());
        }
        int n = sAXAttrList.count;
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr;
            if (!this.factorySet) {
                xMLAttr = new XMLAttr(sAXAttrList.name[n2], sAXAttrList.prefix[n2], sAXAttrList.qname[n2], sAXAttrList.namespace[n2], sAXAttrList.values[n2]);
            } else {
                xMLAttr = this.factory.createAttribute(sAXAttrList.qname[n2], sAXAttrList.values[n2]);
                if (xMLAttr != null) {
                    xMLAttr.namespace = sAXAttrList.namespace[n2];
                    xMLAttr.name = sAXAttrList.name[n2];
                    xMLAttr.prefix = sAXAttrList.prefix[n2];
                }
            }
            if (xMLAttr != null) {
                object = xMLAttr.getValue();
                if (xMLAttr.prefix == "xmlns") {
                    if (xMLElement.nameSpaces == null) {
                        xMLElement.nameSpaces = new Hashtable(20);
                    }
                    xMLElement.nameSpaces.put(xMLAttr.name, object);
                }
                if (xMLAttr.name == "xmlns") {
                    xMLElement.defNamespace = object;
                }
                if (sAXAttrList.attrType[n2] == 1) {
                    this.doc.addID((String)object, xMLElement);
                }
                xMLElement.setAttributeNode(xMLAttr);
                xMLAttr.specified = sAXAttrList.specified[n2];
                if (this.debugFlag) {
                    xMLAttr.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
                }
            }
            ++n2;
        }
        if (xMLNode instanceof XMLElement && xMLElement.defNamespace == null) {
            xMLElement.defNamespace = ((XMLElement)xMLNode).defNamespace;
        }
        xMLNode.appendChild(xMLElement, true);
        if (this.currentParent < this.stackSize - 1) {
            this.parents[++this.currentParent] = xMLElement;
        } else {
            object = this.parents;
            this.parents = new XMLNode[this.stackSize * 2];
            System.arraycopy(object, 0, this.parents, 0, this.stackSize);
            this.stackSize *= 2;
            this.parents[++this.currentParent] = xMLElement;
        }
    }

    private boolean stopChopping() {
        --this.elems;
        if (this.elems < this.chopstart) {
            this.chopIt = false;
            this.chopstart = 0;
            return false;
        }
        return this.chopIt ^ true;
    }
}

