/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.Serializable;
import oracle.xml.parser.v2.XMLCharReader;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Entity;

public class XMLEntity
extends XMLNode
implements Entity,
Serializable {
    public String url;
    public String pubid;
    char cdata;
    public String ndata;
    int line;
    int column;
    boolean par;
    public boolean parsed;
    public boolean inStack = false;
    XMLNode eref;
    transient XMLCharReader reader;

    public XMLEntity(String string, boolean bl) {
        super(string, (short)6);
        this.par = bl;
        this.parsed = false;
    }

    public XMLEntity(String string, boolean bl, int n) {
        this(string, bl);
        this.cdata = (char)n;
        this.text = String.valueOf(this.cdata);
        this.setPosition(0, 0);
    }

    public XMLEntity(String string, boolean bl, int n, boolean bl2) {
        this(string, bl);
        this.cdata = (char)n;
        this.text = String.valueOf(this.cdata);
        this.setPosition(0, 0);
        this.parsed = bl2;
    }

    public XMLEntity(String string, boolean bl, String string2) {
        this(string, bl);
        this.text = string2;
        this.setPosition(0, 0);
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    public char getChar(int n) {
        if (this.getText() == null) {
            return this.cdata;
        }
        return this.getText().charAt(n);
    }

    public int getLength() {
        if (this.cdata > '\u0000') {
            return -1;
        }
        if (this.getText() == null) {
            return 0;
        }
        return this.getText().length();
    }

    public String getNotationName() {
        if (this.ndata != null) {
            return this.ndata;
        }
        return null;
    }

    public String getPublicId() {
        return this.pubid;
    }

    public XMLCharReader getReader(XMLReader xMLReader) throws IOException {
        String string = this.getText();
        if (string.length() == 0) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new XMLCharReader(string, xMLReader.getSystemId(), xMLReader.getPublicId());
        } else {
            this.reader.reset();
        }
        this.reader.setPrevReader(xMLReader.input);
        return this.reader;
    }

    public String getSystemId() {
        return this.url;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.external) {
            xMLOutputStream.writeChars("<!ENTITY ");
            if (this.par) {
                xMLOutputStream.writeChars("% ");
            }
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            if (this.pubid != null) {
                xMLOutputStream.writeChars(" PUBLIC ");
                xMLOutputStream.writeQuotedString(this.pubid);
                xMLOutputStream.writeChars(" ");
                xMLOutputStream.writeQuotedString(this.url);
                if (this.ndata != null) {
                    xMLOutputStream.writeChars(" NDATA " + this.ndata);
                }
            } else if (this.url != null) {
                xMLOutputStream.writeChars(" SYSTEM ");
                xMLOutputStream.writeQuotedString(this.url);
                if (this.ndata != null) {
                    xMLOutputStream.writeChars(" NDATA " + this.ndata);
                }
            } else {
                xMLOutputStream.writeQuotedString(this.text);
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public void setNDATA(String string) {
        this.ndata = string;
    }

    public void setNodeValue(String string) {
        this.text = string;
    }

    void setPosition(int n, int n2) {
        this.line = n;
        this.column = n2;
    }

    public void setURL(String string) {
        this.url = string;
    }
}

