/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;

public class XMLOutputStream {
    static final int OUTPUTSW = 1;
    static final int UCS2 = 2;
    static final int UCS2_BOM = 3;
    static final int UCS4 = 4;
    static final int ASCII = 5;
    static final int BUFSIZE = 16384;
    private PrintWriter out;
    private OutputStreamWriter outsw;
    private OutputStream outs;
    char[] chBuffer;
    char[] savBuffer = null;
    int chIndex = 0;
    int savIndex = 0;
    int bufSize = 16384;
    boolean localErr = false;
    public XMLError err;
    String nl;
    boolean lendian;
    String encoding;
    private int wrtstate;
    public int outstyle;
    public boolean mixed;
    public boolean holdBuffer = false;
    private int indent;
    public DTD dtd;
    public static int DEFAULT = 0;
    public static int PRETTY = 1;
    public static int COMPACT = 2;

    public XMLOutputStream(OutputStream outputStream) {
        this.outs = outputStream;
        this.out = new PrintWriter(outputStream);
        this.outstyle = PRETTY;
        this.lendian = false;
        this.mixed = false;
        this.nl = System.getProperty("line.separator");
        this.indent = 0;
        this.outsw = null;
        this.wrtstate = 5;
        this.encoding = "ASCII";
        this.chBuffer = new char[this.bufSize];
    }

    public XMLOutputStream(PrintWriter printWriter) {
        this.outs = null;
        this.out = printWriter;
        this.outstyle = PRETTY;
        this.lendian = false;
        this.mixed = false;
        this.nl = System.getProperty("line.separator");
        this.indent = 0;
        this.outsw = null;
        this.wrtstate = 5;
        this.encoding = "ASCII";
        this.chBuffer = new char[this.bufSize];
    }

    public void addIndent(int n) {
        this.indent += n;
    }

    public void altBuffer() {
        this.savBuffer = this.chBuffer;
        this.savIndex = this.chIndex;
        this.chIndex = 0;
        this.chBuffer = new char[16384];
    }

    public int bufLength() {
        return this.chIndex;
    }

    public void close() throws IOException {
        if (this.outsw != null) {
            this.outsw.close();
        } else {
            this.out.close();
        }
        if (this.outs != null) {
            this.outs.close();
        }
        try {
            if (this.localErr) {
                this.err.flushErrors();
            }
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }

    public void flush() throws IOException {
        switch (this.wrtstate) {
            case 1: {
                this.outsw.write(this.chBuffer, 0, this.chIndex);
                break;
            }
            default: {
                this.out.write(this.chBuffer, 0, this.chIndex);
                this.out.checkError();
            }
        }
        this.chIndex = 0;
        if (this.outsw != null) {
            this.outsw.flush();
        } else {
            this.out.flush();
            if (this.outs != null) {
                this.outs.flush();
            }
        }
    }

    public int getOutputStyle() {
        return this.outstyle;
    }

    public void pop(int n) throws IOException {
        if (this.chIndex < n) {
            throw new IOException("Internal error while writing file");
        }
        this.chIndex -= n;
    }

    public void priBuffer() {
        if (this.savBuffer != null) {
            this.chBuffer = this.savBuffer;
            this.chIndex = this.savIndex;
        }
    }

    public void setEncoding(String string, boolean bl, boolean bl2) throws IOException {
        if (string.equalsIgnoreCase("ISO-10646-UCS-2") || string.equalsIgnoreCase("UCS-2") || string.equalsIgnoreCase("UTF-16")) {
            this.wrtstate = bl2 ? 3 : 2;
            this.encoding = "UCS-2";
            this.lendian = bl;
            return;
        }
        if (string.equalsIgnoreCase("ISO-10646-UCS-4") || string.equalsIgnoreCase("UCS-4")) {
            this.wrtstate = 4;
            this.encoding = "UCS-4";
            this.lendian = bl;
            return;
        }
        if (string.toUpperCase().equals("ASCII")) {
            this.wrtstate = 5;
            this.encoding = "ASCII";
            return;
        }
        if (this.outs == null && this.out != null) {
            if (this.err == null) {
                this.localErr = true;
                this.err = new XMLError();
            }
            throw new IOException(this.err.getMessage0(195));
        }
        boolean bl3 = false;
        String string2 = (String)XMLReader.encodingMap.get(string.toUpperCase());
        if (string2 != null) {
            try {
                this.outsw = new OutputStreamWriter(this.outs, string2);
            }
            catch (Exception exception) {
                bl3 = true;
            }
        }
        if (bl3 || string2 == null) {
            bl3 = false;
            string2 = (String)XMLReader.encodingMap116.get(string.toUpperCase());
            if (string2 != null) {
                try {
                    this.outsw = new OutputStreamWriter(this.outs, string2);
                }
                catch (Exception exception) {
                    bl3 = true;
                }
            }
        }
        if (bl3 || string2 == null) {
            string2 = string.toUpperCase();
            try {
                this.outsw = new OutputStreamWriter(this.outs, string2);
            }
            catch (Exception exception) {
                if (this.err == null) {
                    this.localErr = true;
                    this.err = new XMLError();
                }
                throw new IOException(this.err.getMessage1(231, string));
            }
        }
        this.wrtstate = 1;
        this.encoding = string;
    }

    public void setOutputStyle(int n) {
        this.outstyle = n;
    }

    public void write(int n) throws IOException {
        try {
            switch (this.wrtstate) {
                case 1: {
                    this.chBuffer[this.chIndex] = (char)n;
                    ++this.chIndex;
                    break;
                }
                case 2: {
                    int n2 = n >> 8;
                    int n3 = n & 0xFF;
                    if (this.lendian) {
                        this.chBuffer[this.chIndex] = (char)n2;
                        this.chBuffer[this.chIndex + 1] = (char)n3;
                        this.chIndex += 2;
                        break;
                    }
                    this.chBuffer[this.chIndex] = (char)n3;
                    this.chBuffer[this.chIndex + 1] = (char)n2;
                    this.chIndex += 2;
                    break;
                }
                case 3: {
                    this.wrtstate = 2;
                    if (this.lendian) {
                        this.chBuffer[this.chIndex] = 254;
                        this.chBuffer[this.chIndex + 1] = 255;
                        this.chIndex += 2;
                    } else {
                        this.chBuffer[this.chIndex] = 255;
                        this.chBuffer[this.chIndex + 1] = 254;
                        this.chIndex += 2;
                    }
                    int n4 = n >> 8;
                    int n5 = n & 0xFF;
                    if (this.lendian) {
                        this.chBuffer[this.chIndex] = (char)n4;
                        this.chBuffer[this.chIndex + 1] = (char)n5;
                        this.chIndex += 2;
                        break;
                    }
                    this.chBuffer[this.chIndex] = (char)n5;
                    this.chBuffer[this.chIndex + 1] = (char)n4;
                    this.chIndex += 2;
                    break;
                }
                case 4: {
                    int n6 = n >> 24;
                    int n7 = n >> 16 & 0xFF;
                    int n8 = n >> 8 & 0xFF;
                    int n9 = n & 0xFF;
                    if (this.lendian) {
                        this.chBuffer[this.chIndex] = (char)n9;
                        this.chBuffer[this.chIndex + 1] = (char)n8;
                        this.chBuffer[this.chIndex + 2] = (char)n7;
                        this.chBuffer[this.chIndex + 3] = (char)n6;
                        this.chIndex += 4;
                        break;
                    }
                    this.chBuffer[this.chIndex] = (char)n6;
                    this.chBuffer[this.chIndex + 1] = (char)n7;
                    this.chBuffer[this.chIndex + 2] = (char)n8;
                    this.chBuffer[this.chIndex + 3] = (char)n9;
                    this.chIndex += 4;
                    break;
                }
                default: {
                    this.chBuffer[this.chIndex] = (char)n;
                    ++this.chIndex;
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.holdBuffer) {
                this.bufSize *= 2;
                char[] cArray = new char[this.bufSize];
                System.arraycopy(this.chBuffer, 0, cArray, 0, this.chIndex);
                this.chBuffer = cArray;
            } else {
                switch (this.wrtstate) {
                    case 1: {
                        this.outsw.write(this.chBuffer, 0, this.chIndex);
                        break;
                    }
                    default: {
                        this.out.write(this.chBuffer, 0, this.chIndex);
                        this.out.checkError();
                    }
                }
                this.chIndex = 0;
            }
            this.write(n);
        }
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                int n3 = this.nl.length();
                int n4 = 0;
                while (n4 < n3) {
                    this.write(this.nl.charAt(n4));
                    ++n4;
                }
            } else {
                this.write(c);
            }
            ++n2;
        }
    }

    public void writeIndent() throws IOException {
        if (this.outstyle == PRETTY && !this.mixed) {
            int n = 0;
            while (n < this.indent) {
                this.writeChars("   ");
                ++n;
            }
        }
    }

    public void writeNewLine() throws IOException {
        if (this.outstyle == PRETTY && !this.mixed) {
            int n = this.nl.length();
            int n2 = 0;
            while (n2 < n) {
                this.write(this.nl.charAt(n2));
                ++n2;
            }
        }
    }

    public void writeQuotedString(String string) throws IOException {
        char c = '\"';
        if (string.indexOf(34) >= 0 && string.indexOf(39) < 0) {
            c = '\'';
        }
        this.write(c);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == c) {
                if (c == '\"') {
                    this.writeChars("&quot;");
                } else {
                    this.writeChars("&apos;");
                }
            } else {
                this.write(c2);
            }
            ++n2;
        }
        this.write(c);
    }
}

