/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.XMLByteReader;
import oracle.xml.parser.v2.XMLError;

class XMLUCS2Reader
extends XMLByteReader {
    boolean utf16Mode = false;
    boolean surrogate = false;

    public XMLUCS2Reader(InputStream inputStream, String string, String string2) throws IOException {
        super(inputStream, string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkSurrogate(int n) {
        if (n >= 55296 && n < 57344) {
            if (!this.utf16Mode) return true;
            if (n < 56320) {
                if (this.surrogate) {
                    return true;
                }
                this.surrogate = true;
                return false;
            } else {
                if (!this.surrogate) {
                    return true;
                }
                this.surrogate = false;
            }
            return false;
        } else {
            if (!this.surrogate) return false;
            return true;
        }
    }

    int fillBuffer(int n) throws IOException {
        boolean bl = false;
        this.endPos = this.currentPos = this.copyPushBack(n);
        while (true) {
            try {
                while (true) {
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return this.currentPos;
                    }
                    int n2 = (this.buffer[this.byteIndex + this.first] & 0xFF) << 8 | this.buffer[this.byteIndex + this.second] & 0xFF;
                    bl = this.checkSurrogate(n2);
                    if (bl || n2 == 65535 || n2 == 65534) {
                        XMLError xMLError = this.parent != null ? this.parent.err : new XMLError();
                        throw new IOException(xMLError.getMessage1(171, Integer.toHexString(n2)));
                    }
                    this.currentBuffer[this.endPos] = (char)n2;
                    this.byteIndex += 2;
                    ++this.endPos;
                    if (this.currentBuffer[this.endPos - 1] != '\r' && this.currentBuffer[this.endPos - 1] != '\n') continue;
                    char c = this.currentBuffer[this.endPos - 1];
                    this.setLineNumber(this.endPos - 1);
                    this.currentBuffer[this.endPos - 1] = 10;
                    n2 = (this.buffer[this.byteIndex + this.first] & 0xFF) << 8 | this.buffer[this.byteIndex + this.second] & 0xFF;
                    bl = this.checkSurrogate(n2);
                    if (bl || n2 == 65535 || n2 == 65534) {
                        XMLError xMLError = this.parent != null ? this.parent.err : new XMLError();
                        throw new IOException(xMLError.getMessage1(171, Integer.toHexString(n2)));
                    }
                    this.currentBuffer[this.endPos] = (char)n2;
                    this.byteIndex += 2;
                    if (c != '\r' || this.currentBuffer[this.endPos] == '\n') continue;
                    ++this.endPos;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return this.currentPos;
            }
            break;
        }
    }

    void setByteOrder(int n) {
        if (n == 1) {
            this.first = 1;
            this.second = 0;
        }
    }

    void setUTF16Mode(boolean bl) {
        this.utf16Mode = bl;
    }
}

