/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLNodeSetInt;
import oracle.xml.parser.v2.XSLPatternInt;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.NodeList;

public class XSLKey
implements XSLConstants,
Cloneable {
    private NSName name;
    private XSLPatternInt pattern;
    private XSLNodeSetInt useExpr;
    private boolean evaluated = false;

    XSLKey(NSName nSName, String string, String string2) throws XSLException {
        this.name = nSName;
        this.pattern = XSLExprBase.createPattern(string, null);
        this.useExpr = XSLExprBase.createNodeSetExpr(string2, null);
    }

    private void addToTable(Hashtable hashtable, String string, XMLNode xMLNode) throws XSLException {
        XSLNodeList xSLNodeList = (XSLNodeList)hashtable.get(string);
        if (xSLNodeList == null) {
            XSLNodeList xSLNodeList2 = new XSLNodeList();
            xSLNodeList2.addNode(xMLNode);
            hashtable.put(string, xSLNodeList2);
        } else {
            XSLExprValue.mergeNode(xSLNodeList, xMLNode);
        }
    }

    public XSLNodeList getMatchingNodes(XSLTContext xSLTContext, String string, XMLNode xMLNode) throws XSLException {
        XSLNodeList xSLNodeList;
        XMLElement xMLElement = xMLNode.getSrcRoot();
        Hashtable hashtable = xSLTContext.getSrcContext(xMLNode).getKeyTable();
        if (hashtable == null) {
            hashtable = new Hashtable(20);
            xSLTContext.getSrcContext(xMLNode).setKeyTable(hashtable);
            this.evaluated = false;
        }
        if (!this.evaluated) {
            this.updateHashtable(hashtable, xMLElement, xSLTContext);
            this.evaluated = true;
        }
        if ((xSLNodeList = (XSLNodeList)hashtable.get(string)) != null) {
            return (XSLNodeList)xSLNodeList.clone();
        }
        return null;
    }

    public NSName getName() {
        return this.name;
    }

    private void updateHashtable(Hashtable hashtable, XMLNode xMLNode, XSLTContext xSLTContext) throws XSLException {
        int n;
        NodeList nodeList;
        if (this.pattern.matchPattern(xMLNode, -1000.0f, xSLTContext) != null) {
            nodeList = new XSLNodeList();
            xSLTContext.pushCurrentNodeList((XSLNodeList)nodeList);
            xSLTContext.setCurrentNode(xMLNode);
            NodeList nodeList2 = this.useExpr.getSelectedNodes(xSLTContext);
            xSLTContext.popCurrentNodeList();
            n = 0;
            while (n < nodeList2.getLength()) {
                this.addToTable(hashtable, ((XMLNode)nodeList2.item(n)).getText(), xMLNode);
                ++n;
            }
        }
        if (xMLNode instanceof XMLElement && (nodeList = xMLNode.getChildNodes()) != null) {
            n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.updateHashtable(hashtable, (XMLNode)nodeList.item(n2), xSLTContext);
                ++n2;
            }
        }
    }
}

