/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Attr;

class XSLOutput
extends XSLNode
implements XSLConstants {
    String method;
    String version;
    String encoding;
    String standalone;
    String mediaType;
    int indent;
    int omitXMLDecl;
    String doctypePublic;
    String doctypeSystem;
    Hashtable cdataSectionElements;
    String oraHref;
    static String HTML = "html";
    static String XML = "xml";
    static String TEXT = "text";
    static String YES = "yes";
    static String NO = "no";
    static String METHOD = "method";
    static String VERSION = "version";
    static String ENCODING = "encoding";
    static String STANDALONE = "standalone";
    static String MEDIATYPE = "media-type";
    static String INDENT = "indent";
    static String OMITXMLDECL = "omit-xml-declaration";
    static String DOCTYPEPUBLIC = "doctype-public";
    static String DOCTYPESYSTEM = "doctype-system";
    static String CDATAELEMENTS = "cdata-section-elements";
    static String ORAHREF = "href";

    XSLOutput(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        super(xMLElement, xSLStylesheet, true);
    }

    XSLOutput(XSLStylesheet xSLStylesheet) throws XSLException {
        super("output", xSLStylesheet, true);
        this.initialize();
    }

    boolean checkCDATASectionElement(String string) {
        return this.cdataSectionElements.get(string) != null;
    }

    String getDoctypePublic() {
        return this.doctypePublic;
    }

    String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    String getEncoding() {
        if (this.encoding == "") {
            return "UTF-8";
        }
        return this.encoding;
    }

    boolean getIndent() {
        if (this.indent == -1) {
            if (this.method == XML || this.method == "") {
                this.indent = 0;
            } else if (this.method == HTML) {
                this.indent = 1;
            }
        }
        return this.indent == 1;
    }

    String getMediaType() {
        if (this.mediaType == "") {
            if (this.method == HTML) {
                this.mediaType = "text/html";
            } else if (this.method == TEXT) {
                this.mediaType = "text/plain";
            } else if (this.method != "") {
                this.mediaType = "text/xml";
            } else {
                return "text/xml";
            }
        }
        return this.mediaType;
    }

    String getMethod() {
        return this.method;
    }

    boolean getOmitXMLDecl() {
        if (this.omitXMLDecl == -1) {
            this.omitXMLDecl = this.method == XML || this.method == "" ? 0 : 1;
        }
        return this.omitXMLDecl == 1;
    }

    String getOraHref() {
        return this.oraHref;
    }

    String getStandalone() {
        return this.standalone;
    }

    String getVersion() {
        if (this.version == "") {
            if (this.method == HTML) {
                this.version = "4.0";
            } else if (this.method != "") {
                this.version = "1.0";
            } else {
                return "1.0";
            }
        }
        return this.version;
    }

    void initialize() {
        this.method = "";
        this.version = "";
        this.encoding = "";
        this.standalone = "";
        this.mediaType = "";
        this.doctypePublic = "";
        this.doctypeSystem = "";
        this.cdataSectionElements = new Hashtable(20);
        this.omitXMLDecl = -1;
        this.indent = -1;
    }

    boolean isEncodingSpecified() {
        return this.encoding != "";
    }

    void merge(XSLOutput xSLOutput) {
        Attr attr = xSLOutput.getAttributeNode(METHOD);
        if (attr != null) {
            this.method = attr.getValue().intern();
        }
        if ((attr = xSLOutput.getAttributeNode(VERSION)) != null) {
            this.version = attr.getValue();
        }
        if ((attr = xSLOutput.getAttributeNode(ENCODING)) != null) {
            this.encoding = attr.getValue();
        }
        if ((attr = xSLOutput.getAttributeNode(STANDALONE)) != null) {
            this.standalone = attr.getValue();
        }
        if ((attr = xSLOutput.getAttributeNode(MEDIATYPE)) != null) {
            this.mediaType = attr.getValue();
        }
        if ((attr = xSLOutput.getAttributeNode(DOCTYPEPUBLIC)) != null) {
            this.doctypePublic = attr.getValue();
        }
        if ((attr = xSLOutput.getAttributeNode(DOCTYPESYSTEM)) != null) {
            this.doctypeSystem = attr.getValue();
        }
        if (xSLOutput.getNamespace().intern() == "http://www.oracle.com/XSL/Transform/java/" && (attr = xSLOutput.getAttributeNode(ORAHREF)) != null) {
            this.oraHref = attr.getValue();
        }
        if (xSLOutput.getAttribute(INDENT).equals("yes")) {
            this.indent = 1;
        } else if (xSLOutput.getAttribute(INDENT).equals("no")) {
            this.indent = 0;
        }
        if (xSLOutput.getAttribute(OMITXMLDECL).equals("yes")) {
            this.omitXMLDecl = 1;
        } else if (xSLOutput.getAttribute(OMITXMLDECL).equals("no")) {
            this.omitXMLDecl = 0;
        }
        String string = xSLOutput.getAttribute(CDATAELEMENTS);
        int n = 0;
        int n2 = 0;
        do {
            String string2 = (n2 = string.indexOf(32, n)) == -1 ? string.substring(n, string.length()) : string.substring(n, n2);
            n = n2 + 1;
            String string3 = XSLExprValue.resolveQname(string2, xSLOutput).getExpandedName();
            this.cdataSectionElements.put(string3, string3);
        } while (n2 != -1);
    }

    void setMethod(String string) {
        this.method = string;
    }

    void setOraHref(String string) {
        this.oraHref = string;
    }
}

