/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XSLProcessor {
    private XSLTContext context = new XSLTContext();

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, InputStream inputStream, URL uRL) throws XSLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.retainCDATASection(false);
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setBaseURL(uRL);
        try {
            dOMParser.setDebugMode(xSLStylesheet.debugFlag);
            dOMParser.parse(inputStream);
        }
        catch (XMLParseException xMLParseException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1004, xMLParseException.formatErrorMessage(0)), 1004);
        }
        catch (IOException iOException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1005, iOException.getMessage()), 1005);
        }
        catch (SAXException sAXException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1004, sAXException.getMessage()), 1004);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, Reader reader, URL uRL) throws XSLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.retainCDATASection(false);
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setBaseURL(uRL);
        try {
            dOMParser.setDebugMode(xSLStylesheet.debugFlag);
            dOMParser.parse(reader);
        }
        catch (XMLParseException xMLParseException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1004, xMLParseException.formatErrorMessage(0)), 1004);
        }
        catch (IOException iOException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1007, iOException.getMessage()), 1007);
        }
        catch (SAXException sAXException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1004, sAXException.getMessage()), 1004);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, URL uRL, URL uRL2) throws XSLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.retainCDATASection(false);
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setBaseURL(uRL2);
        try {
            dOMParser.setDebugMode(xSLStylesheet.debugFlag);
            dOMParser.parse(uRL);
        }
        catch (XMLParseException xMLParseException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1004, xMLParseException.formatErrorMessage(0)), 1004);
        }
        catch (IOException iOException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1006, iOException.getMessage()), 1006);
        }
        catch (SAXException sAXException) {
            xSLStylesheet.error(this.context.getError().getMessage1(1004, sAXException.getMessage()), 1004);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument) throws XSLException {
        XSLDocumentBuilder xSLDocumentBuilder = new XSLDocumentBuilder();
        XMLDocumentFragment xMLDocumentFragment = null;
        this.processXSL(xSLStylesheet, xMLDocument, (XMLDocumentHandler)xSLDocumentBuilder);
        xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
        return xMLDocumentFragment;
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, OutputStream outputStream) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver(outputStream, xSLStylesheet.output);
        this.processXSL(xSLStylesheet, xMLDocument, (XMLDocumentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, PrintWriter printWriter) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver(printWriter, xSLStylesheet.output);
        this.processXSL(xSLStylesheet, xMLDocument, (XMLDocumentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        Element element = xMLDocument.getDocumentElement();
        XSLEventHandler xSLEventHandler = new XSLEventHandler(xMLDocumentHandler, this.context);
        try {
            block4: {
                try {
                    XSLNodeList xSLNodeList = new XSLNodeList();
                    xSLNodeList.addNode(xMLDocument);
                    this.context.init();
                    this.context.addSourceContext(xMLDocument, xMLDocument);
                    this.context.setEventHandler(xSLEventHandler);
                    this.context.pushCurrentNodeList(xSLNodeList);
                    this.context.pushCurrentNodeList2(xSLNodeList);
                    this.context.setCurrentNode(xMLDocument);
                    this.context.setCurrentNode2(xMLDocument);
                    this.context.setStyleSheet(xSLStylesheet);
                    xSLStylesheet.execute(this.context);
                    this.context.reset();
                }
                catch (XSLException xSLException) {
                    if (xSLException.getMessage().equals("TERMINATE PROCESSING")) break block4;
                    throw xSLException;
                }
            }
            Object var7_8 = null;
            this.context.popCurrentNodeList();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.context.popCurrentNodeList();
            xSLEventHandler.flushEvents();
            throw throwable;
        }
        xSLEventHandler.flushEvents();
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment) throws XSLException {
        XSLDocumentBuilder xSLDocumentBuilder = new XSLDocumentBuilder();
        XMLDocumentFragment xMLDocumentFragment2 = null;
        this.processXSL(xSLStylesheet, xMLDocumentFragment, (XMLDocumentHandler)xSLDocumentBuilder);
        xMLDocumentFragment2 = xSLDocumentBuilder.getResultFragment();
        return xMLDocumentFragment2;
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, OutputStream outputStream) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver(outputStream, xSLStylesheet.output);
        this.processXSL(xSLStylesheet, xMLDocumentFragment, (XMLDocumentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, PrintWriter printWriter) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver(printWriter, xSLStylesheet.output);
        this.processXSL(xSLStylesheet, xMLDocumentFragment, (XMLDocumentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        XSLEventHandler xSLEventHandler = new XSLEventHandler(xMLDocumentHandler, this.context);
        try {
            block4: {
                try {
                    XSLNodeList xSLNodeList = new XSLNodeList();
                    xSLNodeList.addNode(xMLDocumentFragment);
                    this.context.init();
                    this.context.addSourceContext(xMLDocumentFragment, (XMLDocument)xMLDocumentFragment.getOwnerDocument());
                    this.context.setEventHandler(xSLEventHandler);
                    this.context.pushCurrentNodeList(xSLNodeList);
                    this.context.setCurrentNode(xMLDocumentFragment);
                    this.context.pushCurrentNodeList2(xSLNodeList);
                    this.context.setCurrentNode2(xMLDocumentFragment);
                    this.context.setStyleSheet(xSLStylesheet);
                    xSLStylesheet.execute(this.context);
                    this.context.reset();
                }
                catch (XSLException xSLException) {
                    if (xSLException.getMessage().equals("TERMINATE PROCESSING")) break block4;
                    throw xSLException;
                }
            }
            Object var6_7 = null;
            this.context.popCurrentNodeList();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.context.popCurrentNodeList();
            xSLEventHandler.flushEvents();
            throw throwable;
        }
        xSLEventHandler.flushEvents();
    }

    public final void setErrorStream(OutputStream outputStream) throws IOException {
        this.context.setErrorStream(new OutputStreamWriter(outputStream));
    }

    public void setLocale(Locale locale) {
        this.context.setLocale(locale);
    }

    public final void showWarnings(boolean bl) {
        this.context.showWarnings(bl);
    }
}

