/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLOutput;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;

class XSLResultElement
extends XSLNode
implements XSLConstants {
    int nattr = 0;
    String oraOutputName;

    XSLResultElement(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        super(xMLElement, xSLStylesheet);
        this.elementType = 5;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        Object object;
        XMLNode xMLNode = null;
        if (xSLTContext.getDebugFlag()) {
            xMLNode = xSLTContext.getDebugNode();
            xSLTContext.setDebugNode(this);
        }
        String string = this.getNamespace();
        String string2 = this.getPrefix();
        String string3 = this.getLocalName();
        if (string == "http://www.oracle.com/XSL/Transform/java/" && string3 == "output") {
            this.processOraOutput(xSLTContext);
            if (xSLTContext.getDebugFlag()) {
                xSLTContext.setDebugNode(xMLNode);
            }
            return;
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        String string4 = this.stylesheet.getNamespaceAlias(string);
        if (string4 == null) {
            string4 = string;
        }
        xSLEventHandler.startElement(string2, string3, string4);
        this.processAttrSets(xSLTContext);
        int n = 0;
        while (n < this.nattr) {
            XMLAttr xMLAttr = (XMLAttr)this.attrlist.item(n);
            if (xMLAttr.getNamespace() != "http://www.w3.org/1999/XSL/Transform" && xMLAttr.getPrefix() != "xmlns" && xMLAttr.getLocalName() != "xmlns") {
                String string5 = XSLExprBase.getAttributeTemplateValue(xSLTContext, xMLAttr.getNodeValue(), this);
                xSLEventHandler.attribute(xMLAttr.getPrefix(), xMLAttr.getLocalName(), xMLAttr.getNamespace(), string5);
            }
            ++n;
        }
        if (this.defNamespace != null && this.defNamespace != "http://www.w3.org/1999/XSL/Transform") {
            object = this.stylesheet.getNamespaceAlias(this.defNamespace);
            if (object == null) {
                object = this.defNamespace;
            }
            if (!this.excludeResultNamespace((String)object)) {
                xSLEventHandler.namespaceAttr("", (String)object);
            }
        }
        if ((object = this.getAllNamespaceAttrs("http://www.w3.org/1999/XSL/Transform")) != null) {
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                String string7 = (String)((Hashtable)object).get(string6);
                String string8 = this.stylesheet.getNamespaceAlias(string7);
                if (string8 == null) {
                    string8 = string7;
                }
                if (this.excludeResultNamespace(string8)) continue;
                xSLEventHandler.namespaceAttr(string6, string8);
            }
        }
        this.processChildren(xSLTContext);
        xSLEventHandler.endElement(string2, string3, string4);
        if (xSLTContext.getDebugFlag()) {
            xSLTContext.setDebugNode(xMLNode);
        }
    }

    void processAttributes(XSLTContext xSLTContext) throws XSLException {
        super.processAttributes(xSLTContext);
        if (this.attrlist == null) {
            return;
        }
        if (this.getNamespace() == "http://www.oracle.com/XSL/Transform/java/" && this.getLocalName() == "output") {
            this.oraOutputName = this.getAttribute("use");
            return;
        }
        this.nattr = this.attrlist.getLength();
        XMLNode xMLNode = null;
        int n = 0;
        while (n < this.nattr) {
            XMLAttr xMLAttr = (XMLAttr)this.attrlist.item(n);
            if (xSLTContext.getDebugFlag()) {
                xMLNode = xSLTContext.getDebugNode();
                xSLTContext.setDebugNode(xMLAttr);
            }
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getNodeValue().intern();
            if (xMLAttr.getNamespace() == "http://www.w3.org/1999/XSL/Transform") {
                if (string == "exclude-result-prefixes") {
                    this.addResultPrefixes(string2);
                } else if (string == "use-attribute-sets") {
                    this.processUseAttrSets(string2);
                }
            } else if (string == "space" && xMLAttr.getNamespace() == "http://www.w3/org/XML/1998/namespace") {
                this.processSpaceAttr(string2);
            }
            if (xSLTContext.getDebugFlag()) {
                xSLTContext.setDebugNode(xMLNode);
            }
            ++n;
        }
    }

    void processOraOutput(XSLTContext xSLTContext) throws XSLException {
        XSLOutput xSLOutput;
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler(this.oraOutputName);
        if (xSLEventHandler2 == null) {
            xSLOutput = this.stylesheet.getOutput(this.oraOutputName);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(xSLOutput.getOraHref());
                XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver(fileOutputStream, xSLOutput);
                xSLEventHandler2 = new XSLEventHandler(xSLSAXPrintDriver, xSLTContext);
            }
            catch (IOException iOException) {
                xSLTContext.error(xSLTContext.getError().getMessage1(1003, xSLOutput.getOraHref()), 1003);
            }
            xSLTContext.setEventHandler(xSLEventHandler2, this.oraOutputName);
        }
        xSLTContext.setEventHandler(xSLEventHandler2);
        this.processChildren(xSLTContext);
        try {
            ((XSLSAXPrintDriver)xSLEventHandler2.getXMLHandler()).flush();
        }
        catch (IOException iOException) {
            xSLOutput = this.stylesheet.getOutput(this.oraOutputName);
            xSLTContext.error(xSLTContext.getError().getMessage1(1003, xSLOutput.getOraHref()), 1003);
        }
        xSLTContext.setEventHandler(xSLEventHandler);
    }
}

