/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.Node;

class XSLSort
extends XSLNode
implements XSLConstants {
    private static final String SELECT_ATTR = "select";
    private static final String ORDER_ATTR = "order";
    private static final String LANG_ATTR = "lang";
    private static final String DATA_TYPE_ATTR = "data-type";
    private static final String CASE_ORDER_ATTR = "case-order";
    private static final String ASCENDING_ORDER = "ascending";
    private static final String DESCENDING_ORDER = "descending";
    private static final String TEXT_TYPE = "text";
    private static final String NUMBER_TYPE = "number";
    private XSLSort seckey;
    private XSLExprInt selectexpr;
    private boolean texttype = true;
    private boolean ascending = true;
    private String lang = "";

    XSLSort(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        super(xMLElement, xSLStylesheet, true);
        this.elementType = 1;
    }

    private int CompareAsNumber(String string, String string2) throws XSLException {
        double d;
        double d2;
        try {
            d2 = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 0.0;
        }
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 == d) {
            return 0;
        }
        return 1;
    }

    private String[] SortAsNumber(String[] stringArray, int n) throws XSLException {
        Vector<String> vector = new Vector<String>(n);
        vector.addElement(stringArray[0]);
        int n2 = -1;
        int n3 = 1;
        while (n3 < n) {
            String string = stringArray[n3];
            int n4 = 0;
            while (n4 < vector.size()) {
                n2 = this.CompareAsNumber(string, (String)vector.elementAt(n4));
                if (this.ascending) {
                    if (n2 < 0) {
                        vector.insertElementAt(string, n4);
                        break;
                    }
                    if (n4 == vector.size() - 1) {
                        vector.addElement(string);
                        break;
                    }
                } else {
                    if (n2 > 0) {
                        vector.insertElementAt(string, n4);
                        break;
                    }
                    if (n4 == vector.size() - 1) {
                        vector.addElement(string);
                        break;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String[] SortAsText(String[] stringArray, int n) throws XSLException {
        Collator collator = Collator.getInstance(this.getLocale());
        int n2 = -1;
        Vector<String> vector = new Vector<String>(n);
        vector.addElement(stringArray[0]);
        int n3 = 1;
        while (n3 < n) {
            String string = stringArray[n3];
            int n4 = 0;
            while (n4 < vector.size()) {
                n2 = collator.compare(string, (String)vector.elementAt(n4));
                if (this.ascending) {
                    if (n2 < 0) {
                        vector.insertElementAt(string, n4);
                        break;
                    }
                    if (n4 == vector.size() - 1) {
                        vector.addElement(string);
                        break;
                    }
                } else {
                    if (n2 > 0) {
                        vector.insertElementAt(string, n4);
                        break;
                    }
                    if (n4 == vector.size() - 1) {
                        vector.addElement(string);
                        break;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void addSecondaryKey(XSLSort xSLSort) throws XSLException {
        if (this.seckey == null) {
            this.seckey = xSLSort;
        } else {
            this.seckey.addSecondaryKey(xSLSort);
        }
    }

    private Locale getLocale() throws XSLException {
        Locale locale = Locale.getDefault();
        if (this.lang == "") {
            return locale;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.lang, "-");
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return new Locale(string, string2);
    }

    void processAttributes(XSLTContext xSLTContext) throws XSLException {
        super.processAttributes(xSLTContext);
        if (this.attrlist == null) {
            return;
        }
        int n = this.attrlist.getLength();
        XMLNode xMLNode = null;
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)this.attrlist.item(n2);
            if (xSLTContext.getDebugFlag()) {
                xMLNode = xSLTContext.getDebugNode();
                xSLTContext.setDebugNode(xMLAttr);
            }
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getNodeValue().intern();
            if (string == SELECT_ATTR) {
                this.selectexpr = XSLExprBase.createStringExpr(string2, this);
            } else if (string == DATA_TYPE_ATTR) {
                this.texttype = string2 != NUMBER_TYPE;
            } else if (string == ORDER_ATTR) {
                if (string2 == DESCENDING_ORDER) {
                    this.ascending = false;
                } else if (string2 == ASCENDING_ORDER) {
                    this.ascending = true;
                } else if (string2 != "") {
                    xSLTContext.warning(xSLTContext.getError().getMessage2(1030, string2, ORDER_ATTR), 1030);
                }
            } else if (string == LANG_ATTR) {
                this.lang = string2;
            }
            if (xSLTContext.getDebugFlag()) {
                xSLTContext.setDebugNode(xMLNode);
            }
            ++n2;
        }
        if (this.selectexpr == null) {
            this.selectexpr = XSLExprBase.createStringExpr(".", this);
        }
    }

    XSLNodeList sortNodes(XSLTContext xSLTContext) throws XSLException {
        XSLNodeList xSLNodeList = xSLTContext.getCurrentNodeList();
        int n = xSLNodeList.getLength();
        if (n == 0) {
            return xSLNodeList;
        }
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = xSLNodeList.item(n2);
            ++n2;
        }
        Node[] nodeArray2 = this.sorting(xSLTContext, nodeArray, n);
        XSLNodeList xSLNodeList2 = new XSLNodeList(n);
        n2 = 0;
        while (n2 < n) {
            xSLNodeList2.addNode(nodeArray2[n2]);
            ++n2;
        }
        return xSLNodeList2;
    }

    private Node[] sorting(XSLTContext xSLTContext, Node[] nodeArray, int n) throws XSLException {
        Vector vector;
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>(20);
        Vector<Node> vector2 = new Vector<Node>();
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Node node = nodeArray[n3];
            xSLTContext.setCurrentNode(node);
            String string = this.selectexpr.getStringValue(xSLTContext);
            if (string.length() == 0) {
                vector2.addElement(node);
            } else {
                vector = (Vector)hashtable.get(string);
                if (vector == null) {
                    vector = new Vector();
                    vector.addElement(node);
                    hashtable.put(string, vector);
                    stringArray[n2++] = string;
                } else {
                    vector.addElement(node);
                }
            }
            ++n3;
        }
        String[] stringArray2 = this.texttype ? this.SortAsText(stringArray, n2) : this.SortAsNumber(stringArray, n2);
        Node[] nodeArray2 = new Node[n];
        int n4 = 0;
        n3 = 0;
        while (n3 < vector2.size()) {
            nodeArray2[n4++] = (Node)vector2.elementAt(n3);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n5;
            vector = (Vector)hashtable.get(stringArray2[n3]);
            int n6 = vector.size();
            if (this.seckey != null) {
                if (n6 > 1) {
                    Object[] objectArray = new Node[n6];
                    vector.copyInto(objectArray);
                    objectArray = this.seckey.sorting(xSLTContext, (Node[])objectArray, n6);
                    n5 = 0;
                    while (n5 < n6) {
                        nodeArray2[n4++] = objectArray[n5];
                        ++n5;
                    }
                } else {
                    nodeArray2[n4++] = (Node)vector.elementAt(0);
                }
            } else {
                n5 = 0;
                while (n5 < n6) {
                    nodeArray2[n4++] = (Node)vector.elementAt(n5);
                    ++n5;
                }
            }
            ++n3;
        }
        return nodeArray2;
    }
}

