/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.FastVector;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSNameImpl;
import oracle.xml.parser.v2.WildCard;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XSLAttributeSet;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLKey;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLOutput;
import oracle.xml.parser.v2.XSLPatternInt;
import oracle.xml.parser.v2.XSLSpaceElem;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.parser.v2.XSLTemplate;
import oracle.xml.parser.v2.XSLVariable;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class XSLStylesheet
implements XSLConstants {
    XSLTemplate[] templates = new XSLTemplate[5];
    int numTempl = 0;
    int templSize = 5;
    int importLevel = 0;
    int currentTmpl = -1;
    XSLTemplate builtinElementTemplate;
    XSLTemplate builtinTextTemplate;
    Stack nodeListStack;
    Hashtable namedTemplates;
    Hashtable attributeSets;
    FastVector imports;
    public DOMParser parser;
    int namespacePrefixCount = 0;
    public URL baseURL;
    XSLNode stylesheetRoot = null;
    XSLNode topLevelStylesheetRoot = null;
    XSLNodeList varList;
    XSLNodeList pvarList;
    Hashtable params;
    Hashtable decimalFormats;
    Hashtable namespaceAliasHashtable;
    Hashtable keyHashtable;
    private XMLError err;
    FastVector spaceElems;
    int numSpaceElems;
    boolean fwdCompFlag = false;
    public boolean debugFlag = false;
    XMLNode dbgNode;
    public boolean warning = false;
    OutputStreamWriter out;
    XSLOutput output;
    Hashtable outputSet = new Hashtable(20);
    boolean varTransformed;
    boolean pvarTransformed;

    public XSLStylesheet() throws XSLException {
        this.init();
    }

    public XSLStylesheet(InputStream inputStream, URL uRL) throws XSLException {
        this.debugFlag = this.getDebugMode();
        this.parser = new DOMParser();
        this.parser.retainCDATASection(false);
        this.parser.setPreserveWhitespace(true);
        this.parser.setBaseURL(uRL);
        try {
            this.parser.setDebugMode(this.debugFlag);
            this.parser.parse(inputStream);
        }
        catch (XMLParseException xMLParseException) {
            this.error(this.err.getMessage1(1000, xMLParseException.formatErrorMessage(0)), 1000);
        }
        catch (Exception exception) {
            this.error(this.err.getMessage1(1000, exception.getMessage()), 1000);
        }
        XMLDocument xMLDocument = this.parser.getDocument();
        this.initStylesheet(xMLDocument, uRL);
    }

    public XSLStylesheet(Reader reader, URL uRL) throws XSLException {
        this.debugFlag = this.getDebugMode();
        this.parser = new DOMParser();
        this.parser.retainCDATASection(false);
        this.parser.setPreserveWhitespace(true);
        this.parser.setBaseURL(uRL);
        try {
            this.parser.setDebugMode(this.debugFlag);
            this.parser.parse(reader);
        }
        catch (XMLParseException xMLParseException) {
            this.error(this.err.getMessage1(1000, xMLParseException.formatErrorMessage(0)), 1000);
        }
        catch (Exception exception) {
            this.error(this.err.getMessage1(1000, exception.getMessage()), 1000);
        }
        XMLDocument xMLDocument = this.parser.getDocument();
        this.initStylesheet(xMLDocument, uRL);
    }

    public XSLStylesheet(URL uRL, URL uRL2) throws XSLException {
        this.debugFlag = this.getDebugMode();
        this.parser = new DOMParser();
        this.parser.retainCDATASection(false);
        this.parser.setPreserveWhitespace(true);
        this.parser.setBaseURL(uRL2);
        try {
            this.parser.setDebugMode(this.debugFlag);
            this.parser.parse(uRL);
        }
        catch (XMLParseException xMLParseException) {
            this.error(this.err.getMessage1(1000, xMLParseException.formatErrorMessage(0)), 1000);
        }
        catch (Exception exception) {
            this.error(this.err.getMessage1(1000, exception.getMessage()), 1000);
        }
        XMLDocument xMLDocument = this.parser.getDocument();
        this.initStylesheet(xMLDocument, uRL2);
    }

    public XSLStylesheet(XMLDocument xMLDocument, URL uRL) throws XSLException {
        this.debugFlag = xMLDocument.getDebugMode() || this.getDebugMode();
        this.initStylesheet(xMLDocument, uRL);
    }

    void addAttributeSet(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        String string = xMLElement.getAttribute("name");
        NSNameImpl nSNameImpl = XSLExprValue.resolveQname(string, xMLElement);
        XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)this.attributeSets.get(nSNameImpl);
        if (xSLAttributeSet != null) {
            xSLAttributeSet.mergeAttributeSet(xMLElement);
        } else {
            xSLAttributeSet = new XSLAttributeSet(xMLElement, xSLStylesheet);
            this.stylesheetRoot.appendChild(xSLAttributeSet);
            this.attributeSets.put(nSNameImpl, xSLAttributeSet);
        }
    }

    void addBuiltInTemplate() throws XSLException {
        XMLElement xMLElement = new XMLElement("template", "xsl", "http://www.w3.org/1999/XSL/Transform");
        xMLElement.setAttribute("match", "*|/");
        xMLElement.setAttribute("priority", "-500");
        XMLElement xMLElement2 = new XMLElement("apply-templates", "xsl", "http://www.w3.org/1999/XSL/Transform");
        xMLElement.appendChild(xMLElement2);
        this.builtinElementTemplate = new XSLTemplate(xMLElement, this, 0, 0);
        this.builtinElementTemplate.isBuiltInElementTemplate = true;
        xMLElement = new XMLElement("template", "xsl", "http://www.w3.org/1999/XSL/Transform");
        xMLElement.setAttribute("match", "text()|@*");
        xMLElement.setAttribute("priority", "-500");
        XMLElement xMLElement3 = new XMLElement("value-of", "xsl", "http://www.w3.org/1999/XSL/Transform");
        xMLElement3.setAttribute("select", ".");
        xMLElement.appendChild(xMLElement3);
        this.builtinTextTemplate = new XSLTemplate(xMLElement, this, 0, 0);
    }

    void addDecimalFormat(XMLElement xMLElement) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        String string = xMLElement.getAttribute("name");
        NSNameImpl nSNameImpl = XSLExprValue.resolveQname(string, xMLElement);
        this.decimalFormats.put(nSNameImpl, decimalFormatSymbols);
        String string2 = xMLElement.getAttribute("decimal-separator");
        if (string2 == "") {
            string2 = ".";
        }
        decimalFormatSymbols.setDecimalSeparator(string2.charAt(0));
        string2 = xMLElement.getAttribute("grouping-separator");
        if (string2 == "") {
            string2 = ",";
        }
        decimalFormatSymbols.setGroupingSeparator(string2.charAt(0));
        string2 = xMLElement.getAttribute("infinity");
        if (string2 == "") {
            string2 = "Infinity";
        }
        decimalFormatSymbols.setInfinity(string2);
        string2 = xMLElement.getAttribute("minus-sign");
        if (string2 == "") {
            string2 = "-";
        }
        decimalFormatSymbols.setMinusSign(string2.charAt(0));
        string2 = xMLElement.getAttribute("NaN");
        if (string2 == "") {
            string2 = "NaN";
        }
        decimalFormatSymbols.setNaN(string2);
        string2 = xMLElement.getAttribute("percent");
        if (string2 == "") {
            string2 = "%";
        }
        decimalFormatSymbols.setPercent(string2.charAt(0));
        string2 = xMLElement.getAttribute("per-mille");
        if (string2 == "") {
            string2 = "&#x2030";
        }
        decimalFormatSymbols.setPerMill(string2.charAt(0));
        string2 = xMLElement.getAttribute("zero-digit");
        if (string2 == "") {
            string2 = "0";
        }
        decimalFormatSymbols.setZeroDigit(string2.charAt(0));
        string2 = xMLElement.getAttribute("digit");
        if (string2 == "") {
            string2 = "#";
        }
        decimalFormatSymbols.setDigit(string2.charAt(0));
        string2 = xMLElement.getAttribute("pattern-separator");
        if (string2 == "") {
            string2 = ";";
        }
        decimalFormatSymbols.setPatternSeparator(string2.charAt(0));
    }

    void addNamedTemplate(NSName nSName, XSLTemplate xSLTemplate) throws XSLException {
        this.stylesheetRoot.appendChild(xSLTemplate);
        Object v = this.namedTemplates.get(nSName);
        if (v == null) {
            this.namedTemplates.put(nSName, xSLTemplate);
        } else if (v instanceof XSLTemplate) {
            Vector<Object> vector = new Vector<Object>(5);
            vector.insertElementAt(v, 0);
            vector.insertElementAt(xSLTemplate, 0);
            this.namedTemplates.put(nSName, vector);
        } else {
            ((Vector)v).insertElementAt(xSLTemplate, 0);
        }
    }

    void addOutput(XSLOutput xSLOutput, boolean bl) throws XSLException {
        this.stylesheetRoot.appendChild(xSLOutput);
        if (!bl) {
            this.output.merge(xSLOutput);
        } else {
            Attr attr = xSLOutput.getAttributeNode("name");
            if (attr == null) {
                this.error(xSLOutput, this.err.getMessage2(1009, "version", xSLOutput.getQualifiedName()), 1009);
                return;
            }
            String string = attr.getValue();
            XSLOutput xSLOutput2 = (XSLOutput)this.outputSet.get(string);
            if (xSLOutput2 == null) {
                xSLOutput2 = new XSLOutput(this);
                this.outputSet.put(string, xSLOutput2);
            }
            xSLOutput2.merge(xSLOutput);
        }
    }

    void addParam(XSLVariable xSLVariable) throws XSLException {
        this.stylesheetRoot.appendChild(xSLVariable);
        this.pvarList.addNode(xSLVariable);
    }

    void addSpaceElem(XSLSpaceElem xSLSpaceElem) {
        this.stylesheetRoot.appendChild(xSLSpaceElem);
        this.spaceElems.addElement(xSLSpaceElem);
    }

    void addTemplate(XSLTemplate xSLTemplate) throws XSLException {
        this.stylesheetRoot.appendChild(xSLTemplate);
        if (this.templSize <= this.numTempl) {
            XSLTemplate[] xSLTemplateArray = new XSLTemplate[this.templSize * 2];
            int n = 0;
            while (n < this.templSize) {
                xSLTemplateArray[n] = this.templates[n];
                ++n;
            }
            this.templSize *= 2;
            this.templates = xSLTemplateArray;
        }
        this.templates[this.numTempl++] = xSLTemplate;
    }

    void addVar(XSLVariable xSLVariable) throws XSLException {
        this.stylesheetRoot.appendChild(xSLVariable);
        this.varList.addNode(xSLVariable);
    }

    public void error(String string, int n) throws XSLException {
        this.error(this.dbgNode, string, n);
    }

    public void error(XMLNode xMLNode, String string, int n) throws XSLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debugFlag && xMLNode != null) {
            String string2 = xMLNode.getSystemId();
            int n2 = xMLNode.getLineNumber();
            int n3 = xMLNode.getColumnNumber();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (n2 != 0 && n3 != 0) {
                stringBuffer.append("<Line " + n2 + ", Column " + n3 + ">");
                stringBuffer.append(": ");
            } else if (string2 != null) {
                stringBuffer.append(": ");
            }
        }
        stringBuffer.append(String.valueOf(this.err.idToString(n)) + ": " + string);
        throw new XSLException(stringBuffer.toString());
    }

    public void execute(XSLTContext xSLTContext) throws XSLException {
        xSLTContext.setDebugFlag(xSLTContext.getDebugFlag() || this.debugFlag);
        XMLElement xMLElement = (XMLElement)xSLTContext.getCurrentNode();
        try {
            this.processSpaceInfo(xMLElement, xSLTContext);
            this.processVariables(xSLTContext);
            NSNameImpl nSNameImpl = new NSNameImpl();
            XSLTemplate xSLTemplate = this.getMatchingTemplate(xMLElement, nSNameImpl, xSLTContext);
            xSLTemplate.processAction(xSLTContext);
        }
        catch (XPathException xPathException) {
            this.error(xSLTContext.getDebugNode(), xPathException.getMessage(this.err), xPathException.getErrorID());
        }
    }

    XSLAttributeSet getAttributeSet(NSName nSName) throws XSLException {
        return (XSLAttributeSet)this.attributeSets.get(nSName);
    }

    boolean getDebugMode() {
        String string = System.getProperty("oracle.xml.parser.debugmode", "false");
        return string.equals("true");
    }

    public DecimalFormatSymbols getDecimalFormat(NSNameImpl nSNameImpl) {
        return (DecimalFormatSymbols)this.decimalFormats.get(nSNameImpl);
    }

    XSLTemplate getImportedNamedTemplate(XMLElement xMLElement) throws XSLException {
        String string = null;
        String string2 = null;
        while (xMLElement != null) {
            if (xMLElement.checkNamespace("template", "http://www.w3.org/1999/XSL/Transform")) {
                string2 = xMLElement.getAttribute("name");
                if (string2 != null) {
                    if (!string2.equals("")) {
                        string = string2;
                        break;
                    }
                    return null;
                }
                return null;
            }
            xMLElement = (XMLElement)xMLElement.getParentNode();
        }
        Object v = this.namedTemplates.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof XSLTemplate) {
            return null;
        }
        Vector vector = (Vector)v;
        int n = 0;
        while (n < vector.size()) {
            if (xMLElement == vector.elementAt(n)) break;
            ++n;
        }
        if (n >= vector.size() - 1) {
            return null;
        }
        return (XSLTemplate)vector.elementAt(n + 1);
    }

    public XSLKey getKey(NSName nSName) {
        return (XSLKey)this.keyHashtable.get(nSName);
    }

    XSLTemplate getMatchingImportTemplate(XMLNode xMLNode, XSLTContext xSLTContext) throws XSLException {
        XSLTemplate xSLTemplate = null;
        float f = -1000.0f;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (this.currentTmpl <= -1) {
            return null;
        }
        n2 = this.templates[this.currentTmpl].importPriority;
        n3 = this.templates[this.currentTmpl].importLevel;
        NSName nSName = this.templates[this.currentTmpl].mode;
        int n5 = this.currentTmpl;
        while (n5 >= 0) {
            if (this.templates[n5].importLevel > n3) {
                n4 = n5;
                break;
            }
            --n5;
        }
        if (n4 == -1) {
            return null;
        }
        int n6 = n4;
        while (n6 >= 0) {
            XSLPatternInt xSLPatternInt;
            XSLTemplate xSLTemplate2 = this.templates[n6];
            if (xSLTemplate2.importPriority <= n2 || n != -1 && xSLTemplate2.importLevel < n) break;
            if (xSLTemplate2.getPriority() > f && (xSLPatternInt = xSLTemplate2.matchTemplate(xMLNode, nSName, f, xSLTContext)) != null) {
                this.currentTmpl = n6;
                xSLTemplate = xSLTemplate2;
                f = xSLPatternInt.getPriority();
                n = xSLTemplate2.importLevel;
            }
            --n6;
        }
        return xSLTemplate;
    }

    XSLSpaceElem getMatchingSpaceElem(XMLElement xMLElement) throws XSLException {
        XSLSpaceElem xSLSpaceElem = null;
        float f = -1000.0f;
        int n = -1;
        int n2 = this.numSpaceElems - 1;
        while (n2 >= 0) {
            XSLSpaceElem xSLSpaceElem2 = (XSLSpaceElem)this.spaceElems.elementAt(n2);
            if (n != -1 && xSLSpaceElem2.getImportPriority() != n) break;
            WildCard wildCard = xSLSpaceElem2.matchWildCard(xMLElement, f);
            if (wildCard != null) {
                xSLSpaceElem = xSLSpaceElem2;
                f = wildCard.getPriority();
                n = xSLSpaceElem2.getImportPriority();
            }
            --n2;
        }
        return xSLSpaceElem;
    }

    XSLTemplate getMatchingTemplate(XMLNode xMLNode, NSName nSName, XSLTContext xSLTContext) throws XSLException {
        XSLTemplate xSLTemplate = null;
        if (xMLNode instanceof XMLDeclPI || xMLNode instanceof DTD) {
            return xSLTemplate;
        }
        float f = -1000.0f;
        int n = -1;
        int n2 = this.numTempl - 1;
        while (n2 >= 0) {
            XSLPatternInt xSLPatternInt;
            XSLTemplate xSLTemplate2 = this.templates[n2];
            if (n != -1 && xSLTemplate2.importLevel > n) break;
            if (xSLTemplate2.getPriority() > f && (xSLPatternInt = xSLTemplate2.matchTemplate(xMLNode, nSName, f, xSLTContext)) != null) {
                this.currentTmpl = n2;
                xSLTemplate = xSLTemplate2;
                f = xSLPatternInt.getPriority();
                n = xSLTemplate2.importLevel;
            }
            --n2;
        }
        if (xSLTemplate == null) {
            if (xMLNode instanceof XMLElement) {
                this.currentTmpl = -1;
                if (!this.builtinElementTemplate.transformed) {
                    this.builtinElementTemplate.transformChildren(xSLTContext);
                    this.builtinElementTemplate.transformed = true;
                }
                return this.builtinElementTemplate;
            }
            if (xMLNode.getNodeType() == 3 || xMLNode.getNodeType() == 2) {
                this.currentTmpl = -1;
                if (!this.builtinTextTemplate.transformed) {
                    this.builtinTextTemplate.transformChildren(xSLTContext);
                    this.builtinTextTemplate.transformed = true;
                }
                return this.builtinTextTemplate;
            }
            return null;
        }
        return xSLTemplate;
    }

    XSLTemplate getNamedTemplate(NSName nSName) throws XSLException {
        Object v = this.namedTemplates.get(nSName);
        if (v == null) {
            return null;
        }
        if (v instanceof XSLTemplate) {
            return (XSLTemplate)v;
        }
        return (XSLTemplate)((Vector)v).elementAt(0);
    }

    String getNamespaceAlias(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.namespaceAliasHashtable.get(string);
    }

    String getNewNamespacePrefix() throws XSLException {
        return "ns" + this.namespacePrefixCount++;
    }

    XSLOutput getOutput(String string) {
        return (XSLOutput)this.outputSet.get(string);
    }

    public String getOutputEncoding() {
        return this.output.getEncoding();
    }

    public String getOutputMediaType() {
        return this.output.getMediaType();
    }

    void init() throws XSLException {
        this.namedTemplates = new Hashtable(20);
        this.attributeSets = new Hashtable(20);
        this.keyHashtable = new Hashtable(20);
        this.decimalFormats = new Hashtable(20);
        this.namespaceAliasHashtable = new Hashtable(20);
        this.varList = new XSLNodeList(5);
        this.pvarList = new XSLNodeList(5);
        this.params = new Hashtable(20);
        this.spaceElems = new FastVector(5);
        this.imports = new FastVector(5);
        this.err = new XMLError();
        this.output = new XSLOutput(this);
    }

    private void initStylesheet(XMLDocument xMLDocument, URL uRL) throws XSLException {
        this.init();
        this.varTransformed = false;
        this.pvarTransformed = false;
        this.baseURL = uRL;
        this.addBuiltInTemplate();
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        String string = xMLElement.getNamespace();
        try {
            if (!string.equals("http://www.w3.org/1999/XSL/Transform")) {
                XSLNode xSLNode = this.stylesheetRoot;
                this.topLevelStylesheetRoot = this.stylesheetRoot = new XSLNode(xMLElement, this);
                this.processResult(xMLElement);
                return;
            }
            this.updateStylesheet(xMLDocument, 0);
        }
        catch (XPathException xPathException) {
            this.error(xPathException.getMessage(this.err), xPathException.getErrorID());
        }
    }

    boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }

    void processImport(String string, int n) throws XSLException {
        ++this.importLevel;
        this.processIncludes(string, n);
        --this.importLevel;
    }

    void processIncludes(String string, int n) throws XSLException {
        if (this.parser == null) {
            this.parser = new DOMParser();
            this.parser.retainCDATASection(false);
            this.parser.setPreserveWhitespace(true);
        }
        URL uRL = null;
        try {
            uRL = new URL(this.baseURL, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.error(this.err.getMessage1(1002, malformedURLException.getMessage()), 1002);
        }
        URL uRL2 = this.baseURL;
        try {
            this.parser.setDebugMode(this.debugFlag);
            this.parser.setBaseURL(uRL);
            this.parser.parse(uRL);
        }
        catch (XMLParseException xMLParseException) {
            this.error(this.err.getMessage1(1002, xMLParseException.formatErrorMessage(0)), 1002);
        }
        catch (Exception exception) {
            this.error(this.err.getMessage1(1002, exception.getMessage()), 1002);
        }
        this.baseURL = uRL;
        this.updateStylesheet(this.parser.getDocument(), n);
        this.baseURL = uRL2;
    }

    void processKey(XSLKey xSLKey) throws XSLException {
        this.keyHashtable.put(xSLKey.getName(), xSLKey);
    }

    void processNamespaceAlias(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("stylesheet-prefix");
        String string2 = xMLElement.getAttribute("result-prefix");
        String string3 = !string2.equals("#default") ? xMLElement.resolveNamespacePrefix(string2) : xMLElement.defNamespace;
        String string4 = !string.equals("#default") ? xMLElement.resolveNamespacePrefix(string) : xMLElement.defNamespace;
        if (string4 != null) {
            this.namespaceAliasHashtable.put(string4, string3);
        }
    }

    void processResult(XMLElement xMLElement) throws XSLException {
        XMLAttr xMLAttr = (XMLAttr)xMLElement.getAttributeNode("version", "http://www.w3.org/1999/XSL/Transform");
        if (xMLAttr == null) {
            this.error(xMLElement, this.err.getMessage2(1009, "xsl:version", xMLElement.getQualifiedName()), 1009);
        } else {
            this.setForwardCompatibilityMode(xMLAttr.getNodeValue());
        }
        String string = xMLElement.getLocalName().toLowerCase().intern();
        if (string == "html" && xMLElement.getNamespace().equals("")) {
            this.output.setMethod(XSLOutput.HTML);
        }
        XMLElement xMLElement2 = new XMLElement("template", "xsl" + Math.random(), "http://www.w3.org/1999/XSL/Transform");
        xMLElement2.setAttribute("match", "/");
        xMLElement2.setAttribute("priority", "100");
        XSLTemplate xSLTemplate = new XSLTemplate(xMLElement2, this, 0, 0);
        this.addTemplate(xSLTemplate);
        XMLNode xMLNode = (XMLNode)xMLElement.getParentNode();
        xSLTemplate.xmlchildren = xMLNode.getChildNodes();
    }

    void processSpaceInfo(XMLElement xMLElement, XSLTContext xSLTContext) throws XSLException {
        XMLElement xMLElement2;
        NodeList nodeList = xMLElement.getElementsByTagName("*");
        int n = nodeList.getLength();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(600);
        int n2 = 0;
        while (n2 < n) {
            xMLElement2 = (XMLElement)nodeList.item(n2);
            hashtable.put(xMLElement2.getNodeName(), "");
            ++n2;
        }
        this.numSpaceElems = this.spaceElems.size();
        if (this.numSpaceElems != 0) {
            n2 = 0;
            while (n2 < n) {
                xMLElement2 = (XMLElement)nodeList.item(n2);
                XSLSpaceElem xSLSpaceElem = this.getMatchingSpaceElem(xMLElement2);
                if (xSLSpaceElem != null) {
                    if (xSLSpaceElem.strip()) {
                        hashtable.remove(xMLElement2.getNodeName());
                    } else {
                        hashtable.put(xMLElement2.getNodeName(), "");
                    }
                }
                ++n2;
            }
        }
        xSLTContext.setSrcSpaceElems(hashtable);
    }

    void processVariables(XSLTContext xSLTContext) throws XSLException {
        int n = this.pvarList.getLength();
        int n2 = this.varList.getLength();
        XSLExprInt xSLExprInt = null;
        xSLTContext.setGlobalContext(true);
        int n3 = 0;
        while (n3 < n) {
            XSLVariable xSLVariable = (XSLVariable)this.pvarList.item(n3);
            if (!this.pvarTransformed) {
                xSLVariable.transformChildren(xSLTContext);
            }
            NSName nSName = xSLVariable.getName();
            if (this.params != null) {
                xSLExprInt = (XSLExprInt)this.params.get(nSName);
            }
            if (xSLExprInt != null) {
                XSLExprValue xSLExprValue = xSLExprInt.getValue(xSLTContext);
                xSLExprValue.setConstant(true);
                xSLTContext.pushVariable(nSName, xSLExprValue);
            } else {
                xSLVariable.processAction(xSLTContext);
            }
            ++n3;
        }
        this.pvarTransformed = true;
        int n4 = 0;
        while (n4 < n2) {
            XSLVariable xSLVariable = (XSLVariable)this.varList.item(n4);
            if (!this.varTransformed) {
                xSLVariable.transformChildren(xSLTContext);
            }
            xSLVariable.processAction(xSLTContext);
            ++n4;
        }
        this.varTransformed = true;
        xSLTContext.setGlobalContext(false);
    }

    public void removeParam(String string) throws XSLException {
        String[] stringArray = new String[2];
        String string2 = "";
        String string3 = "";
        XSLExprValue.splitQname(string, stringArray);
        String string4 = stringArray[0].intern();
        if (stringArray[1] != "" && (string3 = this.topLevelStylesheetRoot.resolveNamespacePrefix(string2 = stringArray[1].intern())) == null) {
            string3 = "";
        }
        NSNameImpl nSNameImpl = new NSNameImpl(string2, string4, string3);
        this.params.remove(nSNameImpl);
    }

    public void resetParams() throws XSLException {
        this.params.clear();
    }

    void setForwardCompatibilityMode(String string) throws XSLException {
        try {
            double d = new Double(string);
            if (d > 1.0) {
                this.fwdCompFlag = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.error(this.err.getMessage2(1030, string, "version"), 1030);
        }
    }

    public void setParam(String string, String string2) throws XSLException {
        String[] stringArray = new String[2];
        String string3 = "";
        String string4 = "";
        XSLExprValue.splitQname(string, stringArray);
        String string5 = stringArray[0].intern();
        if (stringArray[1] != "" && (string4 = this.topLevelStylesheetRoot.resolveNamespacePrefix(string3 = stringArray[1].intern())) == null) {
            string4 = "";
        }
        NSNameImpl nSNameImpl = new NSNameImpl(string3, string5, string4);
        XSLExprInt xSLExprInt = XSLExprBase.createStringExpr(string2, this.topLevelStylesheetRoot);
        this.params.put(nSNameImpl, xSLExprInt);
    }

    void updateStylesheet(XMLDocument xMLDocument, int n) throws XSLException {
        String string;
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        XSLNode xSLNode = this.stylesheetRoot;
        this.stylesheetRoot = new XSLNode(xMLElement, this);
        if (xSLNode == null) {
            this.topLevelStylesheetRoot = this.stylesheetRoot;
        }
        if ((string = this.stylesheetRoot.getAttribute("exclude-result-prefixes")) != "") {
            this.stylesheetRoot.addResultPrefixes(string);
        }
        String string2 = this.stylesheetRoot.getAttribute("xml:space").intern();
        this.stylesheetRoot.processSpaceAttr(string2);
        string2 = this.stylesheetRoot.getAttribute("version").intern();
        if (string2 == "") {
            this.error(this.stylesheetRoot, this.err.getMessage2(1009, "version", this.stylesheetRoot.getQualifiedName()), 1009);
        } else {
            this.setForwardCompatibilityMode(string2);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = n;
        boolean bl = true;
        int n4 = 0;
        while (n4 < n2) {
            if (nodeList.item(n4).getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)nodeList.item(n4);
                String string3 = xMLElement2.getNamespace().intern();
                String string4 = xMLElement2.getLocalName();
                if (string3 == "http://www.w3.org/1999/XSL/Transform") {
                    this.dbgNode = xMLElement2;
                    if (string4 == "template") {
                        bl = false;
                        this.addTemplate(new XSLTemplate(xMLElement2, this, n, this.importLevel));
                    } else if (string4 == "variable") {
                        bl = false;
                        this.addVar(new XSLVariable(xMLElement2, this));
                    } else if (string4 == "param") {
                        bl = false;
                        this.addParam(new XSLVariable(xMLElement2, this));
                    } else if (string4 == "attribute-set") {
                        bl = false;
                        this.addAttributeSet(xMLElement2, this);
                    } else if (string4 == "import") {
                        if (bl) {
                            this.processImport(xMLElement2.getAttribute("href"), ++n3);
                        } else {
                            this.error(xMLElement2, this.err.getMessage2(1048, "xsl:import", "xsl:stylesheet"), 1048);
                        }
                    } else if (string4 == "include") {
                        bl = false;
                        this.processIncludes(xMLElement2.getAttribute("href"), n);
                    } else if (string4 == "key") {
                        bl = false;
                        this.processKey(new XSLKey(XSLExprValue.resolveQname(xMLElement2.getAttribute("name"), this.stylesheetRoot), xMLElement2.getAttribute("match"), xMLElement2.getAttribute("use")));
                    } else if (string4 == "strip-space") {
                        bl = false;
                        this.addSpaceElem(new XSLSpaceElem(xMLElement2, this, n));
                    } else if (string4 == "preserve-space") {
                        bl = false;
                        this.addSpaceElem(new XSLSpaceElem(xMLElement2, this, n));
                    } else if (string4 == "output") {
                        bl = false;
                        this.addOutput(new XSLOutput(xMLElement2, this), false);
                    } else if (string4 == "namespace-alias") {
                        bl = false;
                        this.processNamespaceAlias(xMLElement2);
                    } else if (string4 == "decimal-format") {
                        bl = false;
                        this.addDecimalFormat(xMLElement2);
                    }
                } else if (string3 == "http://www.oracle.com/XSL/Transform/java/" && string4 == "output") {
                    bl = false;
                    this.addOutput(new XSLOutput(xMLElement2, this), true);
                }
            }
            ++n4;
        }
        this.stylesheetRoot = xSLNode;
    }
}

