/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;

class XSLVariable
extends XSLNode
implements XSLConstants {
    private NSName xslVarName;
    private boolean selectFound = false;
    private XSLExprInt exp;

    XSLVariable(XMLElement xMLElement, XSLStylesheet xSLStylesheet) throws XSLException {
        super(xMLElement, xSLStylesheet);
        this.elementType = 5;
    }

    NSName getName() {
        return this.xslVarName;
    }

    XSLExprValue getValue(XSLTContext xSLTContext) throws XSLException {
        XSLExprValue xSLExprValue;
        if (this.selectFound) {
            xSLExprValue = this.exp.getValue(xSLTContext);
        } else {
            XSLDocumentBuilder xSLDocumentBuilder = new XSLDocumentBuilder();
            XSLEventHandler xSLEventHandler = new XSLEventHandler(xSLDocumentBuilder, xSLTContext);
            XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler();
            xSLTContext.setEventHandler(xSLEventHandler);
            this.processChildren(xSLTContext);
            xSLEventHandler.flushEvents();
            xSLExprValue = new XSLExprValue(xSLDocumentBuilder.getResultFragment());
            xSLTContext.setEventHandler(xSLEventHandler2);
        }
        xSLExprValue.setConstant(true);
        return xSLExprValue;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        XSLExprValue xSLExprValue = this.getValue(xSLTContext);
        xSLTContext.pushVariable(this.xslVarName, xSLExprValue);
    }

    void processAttributes(XSLTContext xSLTContext) throws XSLException {
        super.processAttributes(xSLTContext);
        if (this.attrlist == null) {
            return;
        }
        int n = this.attrlist.getLength();
        XMLNode xMLNode = null;
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)this.attrlist.item(n2);
            if (xSLTContext.getDebugFlag()) {
                xMLNode = xSLTContext.getDebugNode();
                xSLTContext.setDebugNode(xMLAttr);
            }
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getNodeValue().intern();
            if (string == "name") {
                this.xslVarName = XSLExprValue.resolveQname(string2, this);
            } else if (string == "select") {
                this.exp = XSLExprBase.createStringExpr(string2, this);
                this.selectFound = true;
            } else if (string == "space" && xMLAttr.getNamespace() == "http://www.w3/org/XML/1998/namespace") {
                this.processSpaceAttr(string2);
            }
            if (xSLTContext.getDebugFlag()) {
                xSLTContext.setDebugNode(xMLNode);
            }
            ++n2;
        }
        if (this.xslVarName == null) {
            xSLTContext.error(this, xSLTContext.getError().getMessage2(1009, "name", this.getNodeName()), 1009);
        }
    }
}

