/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import oracle.net.common.NetGetEnv;

public final class CAWizardUtils {
    private static NetGetEnv env = new NetGetEnv();

    public static Frame getParentFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame)) {
            if (component2 == null) {
                return null;
            }
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    public static String getHostName() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown Host: " + unknownHostException.getMessage());
        }
        return string;
    }

    public static String getComputerName() {
        String string = "";
        string = NetGetEnv.getComputerName();
        if (string == null) {
            string = CAWizardUtils.getHostName();
        }
        return string;
    }

    public static void copyOraFile(File file, File file2) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return;
        }
    }

    public static boolean isValidServiceName(String string) {
        if (string.length() < 1 || string.length() > 137) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        String string2 = stringTokenizer.nextToken();
        int n = string2.length();
        if (n > 8) {
            return false;
        }
        if (!Character.isLetter(string2.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#' && c != '$') {
                return false;
            }
            ++n2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n3 = string3.length();
            if (n3 >= 128) {
                return false;
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = string3.charAt(n4);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '#' && c != '.') {
                    return false;
                }
                ++n4;
            }
        }
        return true;
    }

    public static boolean isValidSID(String string) {
        if (string.length() < 1 || string.length() > 9) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String appendNoDuplicates(String string, String string2) {
        String string3 = string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string2.indexOf(string4) != -1) continue;
            string3 = String.valueOf(string3) + "," + string4;
        }
        return string3;
    }
}

