/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.NetStrings;
import oracle.net.ca.OPSUtil;
import oracle.net.common.NetGetEnv;
import oracle.net.common.TNSEndpoint;
import oracle.net.common.WindowsService;
import oracle.net.config.Config;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.Listener;
import oracle.net.config.ListenerException;
import oracle.net.config.SOExceptionConfig;
import oracle.ops.config.cluster.ClusterRegister;

public class ConfigureListener {
    private String listenerName;
    private String[] userSelectedProtocols;
    private Config config;
    private Listener listener;
    private int ADDR_NUM = 10;
    private int currAddr;
    private String hostname;
    private String compname;
    private String sidDesc;
    private String[] addressDescriptions;
    private String oraHome;
    private String oraHid;
    private String oraHname;
    private String os;
    private String TCPort;
    private String TCPSPort;
    private String TCPortIIOP;
    private String SPXname;
    private String NMPipe;
    private String IPCKey;
    private NetGetEnv env = new NetGetEnv();
    final NetStrings netstr = new NetStrings();
    private CmdlineArgs cmdarg;
    private File fileAdminDir;

    public ConfigureListener(Config config, CmdlineArgs cmdlineArgs, File file) {
        this.config = config;
        this.cmdarg = cmdlineArgs;
        this.fileAdminDir = file;
        this.oraHome = this.cmdarg.getStringArgs("orahome");
        this.oraHid = this.cmdarg.getStringArgs("orahid");
        this.oraHname = this.cmdarg.getStringArgs("orahnam");
        if (this.oraHid.equals("NO_VALUE")) {
            this.oraHid = "";
        }
        this.oraHname = this.cmdarg.getStringArgs("orahnam");
        this.os = System.getProperty("os.name");
    }

    public void typicalConfigure() {
        this.setListenerName("LISTENER");
        this.initListener();
        this.buildAddressIPC();
        this.setTCPort("1521");
        this.setTCPSPort("2484");
        this.setSPXname(String.valueOf(this.compname) + "_lsnr");
        this.setNMPipe("ORAPIPE");
        String string = this.cmdarg.getPreferredProtocol();
        if (this.cmdarg.isComponentInstalled("javavm") && this.cmdarg.isComponentInstalled("server") && string.equals("TCP")) {
            this.setTCPortIIOP("2481");
        }
        this.buildAddress(string);
        this.addAddressToListener();
        this.addSIDescription();
        this.saveListener();
        if (!this.os.equals("Windows 95")) {
            this.startListener("LISTENER");
        }
        System.out.println(this.netstr.getString("SOListenerComplete"));
    }

    public void initHostname(String string) {
        this.hostname = string;
        this.compname = string;
    }

    public void typicalConfigureOPS(String[] stringArray) {
        this.typicalConfigure();
        this.saveListenerOPS(stringArray);
        this.startListenerOPS("LISTENER", stringArray);
    }

    /*
     * Unable to fully structure code
     */
    private String OPSHelper(int var1_1, String[] var2_2, String var3_3, String var4_4) {
        var7_5 = this.config.getFilename(4);
        var10_6 = new String();
        var5_7 = 0;
        while (var5_7 < var2_2.length) {
            var10_6 = String.valueOf(var10_6) + var2_2[var5_7] + "|";
            ++var5_7;
        }
        var11_8 = File.separator;
        var13_9 = this.fileAdminDir.getAbsolutePath();
        var12_10 = new String(String.valueOf(var13_9) + var11_8 + "opstmp");
        var14_11 = new File(var12_10);
        if (!var14_11.exists()) {
            var14_11.mkdir();
        }
        var9_12 = new ClusterRegister(var12_10);
        var9_12.debug(OPSUtil.debug());
        var5_7 = 0;
        while (var5_7 < var2_2.length) {
            var6_13 = new String("CopyFileNodeFrom|" + var7_5 + "|" + var7_5 + "." + var2_2[var5_7] + "|" + var2_2[var5_7]);
            var9_12.writeClusterLog(var6_13);
            ++var5_7;
        }
        if (var9_12.finalCluster(var10_6)) ** GOTO lbl35
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v0) {
                var15_14 = 0;
                ** while (var15_14 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var15_14;
                continue;
            }
lbl35:
            // 3 sources

            ** while (!var9_12.doneProcessing())
        }
lbl36:
        // 1 sources

        OPSUtil.println();
        var9_12 = new ClusterRegister(var12_10);
        var9_12.debug(OPSUtil.debug());
        var5_7 = 0;
        while (var5_7 < var2_2.length) {
            var8_17 = new String(String.valueOf(var7_5) + "." + var2_2[var5_7]);
            this.config.setFilename(4, var8_17);
            var15_16 = new ConfigureListener(this.config, this.cmdarg, this.fileAdminDir);
            var15_16.setListenerName(this.listenerName);
            var15_16.initListener();
            var15_16.initHostname(var2_2[var5_7]);
            var15_16.addSIDescription();
            var15_16.setTCPort(this.TCPort);
            var15_16.setSPXname(this.SPXname);
            var15_16.setNMPipe(this.NMPipe);
            var15_16.setIPCKey(this.IPCKey);
            var15_16.buildAddressIPC();
            if (this.userSelectedProtocols != null) {
                var16_18 = 0;
                while (var16_18 < this.userSelectedProtocols.length) {
                    if (this.userSelectedProtocols[var16_18] == null) break;
                    var15_16.buildAddress(this.userSelectedProtocols[var16_18]);
                    ++var16_18;
                }
            }
            var15_16.addAddressToListener();
            switch (var1_1) {
                case 0: {
                    OPSUtil.print("saveListener...");
                    var15_16.saveListener();
                    OPSUtil.println("saveListener done");
                    break;
                }
                case 30: {
                    OPSUtil.print("renameListener...");
                    var15_16.renameListener(var3_3, var4_4);
                    OPSUtil.println("renameListener done");
                    break;
                }
                case 20: {
                    OPSUtil.print("deleteListener...");
                    var15_16.deleteListener(var4_4);
                    OPSUtil.println("deleteListener done");
                }
            }
            this.config.setFilename(4, var7_5);
            var6_13 = new String("CopyFileNode|" + var8_17 + "|" + var7_5 + "|" + var2_2[var5_7]);
            var9_12.writeClusterLog(var6_13);
            ++var5_7;
        }
        if (var9_12.finalCluster(var10_6)) ** GOTO lbl95
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v1) {
                var16_18 = 0;
                ** while (var16_18 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var16_18;
                continue;
            }
lbl95:
            // 3 sources

            ** while (!var9_12.doneProcessing())
        }
lbl96:
        // 1 sources

        OPSUtil.println();
        OPSUtil.deleteTmpFiles(var7_5, var2_2);
        if (var14_11.exists()) {
            var14_11.delete();
        }
        return OPSUtil.ClusterErrorMsg(var9_12, var2_2);
    }

    public void setListenerName(String string) {
        this.listenerName = string;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public boolean initListener() {
        this.userSelectedProtocols = new String[this.ADDR_NUM * 2];
        this.currAddr = 0;
        this.IPCKey = null;
        this.NMPipe = null;
        this.SPXname = null;
        this.TCPortIIOP = null;
        this.TCPSPort = null;
        this.TCPort = null;
        this.sidDesc = null;
        this.addressDescriptions = new String[this.ADDR_NUM];
        this.hostname = CAWizardUtils.getHostName();
        this.compname = CAWizardUtils.getComputerName();
        return this.initListener(this.listenerName);
    }

    public boolean initListener(String string) {
        try {
            this.listener = new Listener(this.config, string);
            return true;
        }
        catch (ListenerException listenerException) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExCreate")) + listenerException.getMessage());
            return false;
        }
    }

    public void buildAddressIPC() {
        String[][] stringArray = new String[][]{{"KEY", null, null}, {"EXTPROC" + this.oraHid, null, null}};
        this.addressDescriptions[this.currAddr++] = this.buildAddressString("IPC", stringArray);
    }

    public String buildAddress(String string) {
        String[][] stringArray;
        this.userSelectedProtocols[this.currAddr] = new String(string);
        if (string.equals("TCP")) {
            stringArray = new String[][]{{"HOST", "PORT", null}, {this.hostname, this.TCPort, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(string, stringArray);
        }
        if (string.equals("TCPS")) {
            stringArray = new String[][]{{"HOST", "PORT", null}, {this.hostname, this.TCPSPort, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(string, stringArray);
        }
        if (string.equals("SPX")) {
            stringArray = new String[][]{{"SERVICE", null, null}, {this.SPXname, null, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(string, stringArray);
        }
        if (string.equals("NMP")) {
            stringArray = new String[][]{{"SERVER", "PIPE", null}, {this.compname, this.NMPipe, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(string, stringArray);
        }
        if (string.equals("IPC")) {
            stringArray = new String[][]{{"KEY", null, null}, {this.IPCKey, null, null}};
            this.addressDescriptions[this.currAddr++] = this.buildAddressString(string, stringArray);
        }
        return this.addressDescriptions[this.currAddr - 1];
    }

    private String buildAddressString(String string, String[][] stringArray) {
        String string2 = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=" + string + ")";
        int n = 0;
        while (stringArray[0][n] != null) {
            string2 = String.valueOf(string2) + "(" + stringArray[0][n] + "=" + stringArray[1][n] + ")";
            ++n;
        }
        string2 = String.valueOf(string2) + "))";
        return string2;
    }

    public void addAddressToListener() {
        Vector<DescriptionListConfig> vector = new Vector<DescriptionListConfig>();
        String string = "(DESCRIPTION_LIST=(DESCRIPTION=";
        int n = 0;
        while (n < this.ADDR_NUM && this.addressDescriptions[n] != null) {
            string = String.valueOf(string) + this.addressDescriptions[n];
            ++n;
        }
        string = this.TCPortIIOP != null ? String.valueOf(string) + ")(DESCRIPTION=(PROTOCOL_STACK=(PRESENTATION=GIOP)(SESSION=RAW))(ADDRESS=(PROTOCOL=TCP)(HOST=" + this.hostname + ")(PORT=" + this.TCPortIIOP + "))))" : String.valueOf(string) + "))";
        try {
            DescriptionListConfig descriptionListConfig = new DescriptionListConfig(string, null);
            vector.addElement(descriptionListConfig);
            this.listener.setEndpoints(vector);
            return;
        }
        catch (SOExceptionConfig sOExceptionConfig) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExSO")) + string + sOExceptionConfig.getMessage());
            return;
        }
        catch (ListenerException listenerException) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExAddAddr")) + string + listenerException.getMessage());
            return;
        }
    }

    public void addSIDescription() {
        String[][] stringArrayArray = new String[][]{{"SID_NAME", "ORACLE_HOME", "PROGRAM", null}, {"PLSExtProc", this.oraHome, "extproc", null}};
        String string = "(SID_DESC=";
        int n = 0;
        while (stringArrayArray[0][n] != null) {
            string = String.valueOf(string) + "(" + stringArrayArray[0][n] + "=" + stringArrayArray[1][n] + ")";
            ++n;
        }
        string = String.valueOf(string) + ")";
        this.listener.addSidDesc(string, true);
    }

    public int isAddressBusy(String string) {
        if (TNSEndpoint.IsListener(string)) {
            return 1;
        }
        if (TNSEndpoint.IsInUse(string)) {
            return 2;
        }
        return 0;
    }

    public String[] getListeners() {
        String[] stringArray = null;
        stringArray = Listener.enumListeners((Config)this.config);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public void deleteListener(String string) {
        try {
            Listener.delete((Config)this.config, (String)string);
        }
        catch (ListenerException listenerException) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExDelete")) + string + listenerException.getMessage());
        }
        System.out.println(String.valueOf(this.netstr.getString("SOListenerDelete")) + string);
    }

    public void deleteListenerOPS(String[] stringArray, String string) {
        boolean bl = true;
        while (bl) {
            bl = false;
            String string2 = this.OPSHelper(20, stringArray, null, string);
            if (string2.length() <= 0) continue;
            bl = OPSUtil.Alert(string2);
        }
    }

    public void renameListener(String string, String string2) {
        try {
            this.listener.saveAs(this.config, true, string2);
            Listener.delete((Config)this.config, (String)string);
        }
        catch (ListenerException listenerException) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExRename")) + string + listenerException.getMessage());
        }
        System.out.println(String.valueOf(this.netstr.getString("SOListenerRename")) + string + this.netstr.getString("to") + string2);
    }

    public void renameListenerOPS(String[] stringArray, String string, String string2) {
        boolean bl = true;
        while (bl) {
            bl = false;
            String string3 = this.OPSHelper(30, stringArray, string, string2);
            if (string3.length() <= 0) continue;
            bl = OPSUtil.Alert(string3);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean startListener(String var1_1) {
        var3_2 = "";
        var6_3 = 1;
        System.out.println(this.netstr.getString("SOListenerStart"));
        var2_4 = String.valueOf(this.oraHome) + File.separator + "bin" + File.separator + "lsnrctl start " + var1_1;
        System.out.println(String.valueOf(this.netstr.getString("SORunListenerStartCtl")) + var2_4);
        var7_5 = null;
        var8_6 = null;
        try {
            try {
                var4_7 = Runtime.getRuntime();
                var5_8 = var4_7.exec(var2_4);
                var7_5 = new BufferedInputStream(var5_8.getInputStream());
                var8_6 = new BufferedInputStream(var5_8.getErrorStream());
                var11_9 = false;
                ** GOTO lbl34
                {
                    var7_5.read();
                    do {
                        if (var7_5.available() > 0) continue block9;
                        while (var8_6.available() > 0) {
                            var8_6.read();
                        }
                        try {
                            var6_3 = var5_8.exitValue();
                            var11_9 = true;
                            System.out.println(this.netstr.getString("SOListenerStartCtlComp"));
                            if (var6_3 == 0) {
                                System.out.println(this.netstr.getString("SOListenerStartSuccess"));
                                continue;
                            }
                            System.out.println(this.netstr.getString("SOListenerStartFail"));
                        }
                        catch (IllegalThreadStateException v0) {}
lbl34:
                        // 4 sources

                    } while (!var11_9);
                }
            }
            catch (IOException v1) {
                System.out.println(this.netstr.getString("SOListenerExControl"));
            }
            var10_10 = null;
        }
        catch (Throwable var9_13) {
            var10_11 = null;
            try {
                var7_5.close();
                var8_6.close();
            }
            catch (Throwable v2) {}
            throw var9_13;
        }
        try {
            var7_5.close();
            var8_6.close();
        }
        catch (Throwable v3) {}
        if (var6_3 == 0 && this.os.equals("Windows NT")) {
            if (var1_1.startsWith("LISTENER")) {
                var3_2 = var1_1.equals("LISTENER") != false ? "" : var1_1;
            }
            if ((var10_12 = WindowsService.setStartType(var9_14 = "Oracle" + this.oraHname + "TNSListener" + var3_2, 0)) == 0) {
                System.out.println(this.netstr.getString("SOListenerStartAuto"));
            } else {
                System.out.println(String.valueOf(this.netstr.getString("SOListenerExAuto")) + var10_12);
            }
        }
        return var6_3 == 0;
    }

    public void saveListener() {
        try {
            this.listener.save(this.config, true);
            return;
        }
        catch (ListenerException listenerException) {
            System.out.println(String.valueOf(this.netstr.getString("SOListenerExSave")) + listenerException.getMessage());
            return;
        }
    }

    public void saveListenerOPS(String[] stringArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            String string = this.OPSHelper(0, stringArray, null, null);
            if (string.length() <= 0) continue;
            bl = OPSUtil.Alert(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startListenerOPS(String var1_1, String[] var2_2) {
        var3_3 = new String();
        var4_4 = 0;
        while (var4_4 < var2_2.length) {
            var3_3 = String.valueOf(var3_3) + var2_2[var4_4] + "|";
            ++var4_4;
        }
        var5_5 = File.separator;
        var7_6 = this.fileAdminDir.getAbsolutePath();
        var6_7 = new String(String.valueOf(var7_6) + var5_5 + "opstmp");
        var8_8 = new File(var6_7);
        if (!var8_8.exists()) {
            var8_8.mkdir();
        }
        var9_9 = System.getProperty("os.name");
        var10_10 = null;
        var10_10 = var9_9.equals("Windows NT") != false ? "TNSLSNR" : "lsnrctl";
        var11_11 = String.valueOf(this.oraHome) + File.separator + "bin" + File.separator + var10_10;
        var12_12 = true;
        while (var12_12) {
            block9: {
                var12_12 = false;
                var13_13 = new ClusterRegister(var6_7);
                var13_13.debug(OPSUtil.debug());
                var14_14 = 0;
                while (var14_14 < var2_2.length) {
                    var15_15 = new String("startListener|" + var1_1 + "|" + this.oraHname + "|" + var11_11 + "|" + var2_2[var14_14]);
                    var13_13.writeClusterLog(var15_15);
                    ++var14_14;
                }
                if (var13_13.finalCluster(var3_3)) ** GOTO lbl42
                System.out.println("Problem in final cluster API");
                break block9;
lbl-1000:
                // 1 sources

                {
                    OPSUtil.print(".");
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException v0) {
                        var15_16 = 0;
                        ** while (var15_16 < 1000)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++var15_16;
                        continue;
                    }
lbl42:
                    // 3 sources

                    ** while (!var13_13.doneProcessing())
                }
            }
            var15_15 = OPSUtil.ClusterErrorMsg(var13_13, var2_2);
            if (var15_15.length() <= 0) continue;
            var12_12 = OPSUtil.Alert(var15_15);
        }
        if (var8_8.exists()) {
            var8_8.delete();
        }
    }

    public void setAddress(String[] stringArray) {
    }

    public void setTCPort(String string) {
        this.TCPort = string;
    }

    public void setTCPSPort(String string) {
        this.TCPSPort = string;
    }

    public void setTCPortIIOP(String string) {
        this.TCPortIIOP = string;
    }

    public void setSPXname(String string) {
        this.SPXname = string;
    }

    public void setNMPipe(String string) {
        this.NMPipe = string;
    }

    public void setIPCKey(String string) {
        this.IPCKey = string;
    }
}

