/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.File;
import java.util.StringTokenizer;
import oracle.net.ca.CAWizardUtils;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.NetStrings;
import oracle.net.ca.OPSUtil;
import oracle.net.common.NetGetEnv;
import oracle.net.config.Config;
import oracle.net.config.Profile;
import oracle.net.config.ProfileException;
import oracle.ops.config.cluster.ClusterRegister;

public class ConfigureProfile {
    private Config config;
    private Profile profile;
    private String os = System.getProperty("os.name");
    final NetStrings netstr = new NetStrings();
    private File fileAdminDir;

    public ConfigureProfile(Config config, File file) {
        this.config = config;
        this.fileAdminDir = file;
    }

    public void typicalConfigure(CmdlineArgs cmdlineArgs) {
        this.initProfile();
        this.setDefaultProfileParameters(cmdlineArgs);
        this.saveProfile();
    }

    public void typicalConfigureOPS(CmdlineArgs cmdlineArgs, String[] stringArray) {
        this.typicalConfigure(cmdlineArgs);
        this.saveProfileOPS(cmdlineArgs, stringArray);
    }

    public void initProfile() {
        try {
            this.profile = new Profile(this.config, false, "");
            return;
        }
        catch (ProfileException profileException) {
            System.out.println(String.valueOf(this.netstr.getString("SOProfileExCreate")) + profileException.getMessage());
            return;
        }
    }

    public void setDefaultProfileParameters(CmdlineArgs cmdlineArgs) {
        if (!Profile.exists((Config)this.config, (boolean)false, null)) {
            String string = NetGetEnv.getDNSDomain();
            if (string != null) {
                this.setProfileParam("NAMES.DEFAULT_DOMAIN", string);
            }
            if (!cmdlineArgs.isStandAlone()) {
                if (cmdlineArgs.isConfigLocal()) {
                    this.setProfileParam("NAMES.DIRECTORY_PATH", "(TNSNAMES, ONAMES, HOSTNAME)");
                } else {
                    this.setProfileParam("NAMES.DIRECTORY_PATH", "(LDAP, TNSNAMES, ONAMES, HOSTNAME)");
                }
            }
            if (this.os.equals("Windows NT") || this.os.equals("Windows 95") || this.os.equals("Windows 98")) {
                this.setProfileParam("SQLNET.AUTHENTICATION_SERVICES", "(NTS)");
            }
        }
    }

    public String[] getNamingMethods() {
        String[] stringArray = new String[10];
        String string = this.getProfileParam("NAMES.DIRECTORY_PATH");
        if (string != null) {
            string = string.substring(1, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken().trim();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public String getProfileParam(String string) {
        return this.profile.getParameter(string);
    }

    public void setProfileParam(String string, String string2) {
        this.profile.setParameter(string, string2);
    }

    public void setNamesDirPath(String string) {
        String string2 = string.substring(0, string.length() - 1);
        this.profile.setParameter("NAMES.DIRECTORY_PATH", "(" + string2 + ")");
    }

    public void appendProfileParam(String string, String string2) {
        String string3 = null;
        String string4 = null;
        string3 = this.profile.getParameter(string);
        if (string3 == null) {
            string4 = string2.substring(0, string2.length() - 1);
        } else {
            string3 = string3.substring(1, string3.length() - 1);
            string4 = CAWizardUtils.appendNoDuplicates(string2, string3);
        }
        this.profile.setParameter(string, "(" + string4 + ")");
    }

    public void saveProfile() {
        try {
            this.profile.save(this.config, true);
        }
        catch (ProfileException profileException) {
            System.out.println(String.valueOf(this.netstr.getString("SOProfileExSave")) + profileException.getMessage());
        }
        System.out.println(this.netstr.getString("SOProfileComplete"));
    }

    public void saveProfileOPS(CmdlineArgs cmdlineArgs, String[] stringArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            try {
                String string = this.OPSHelper(0, cmdlineArgs, stringArray);
                if (string.length() <= 0) continue;
                bl = OPSUtil.Alert(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String OPSHelper(int var1_1, CmdlineArgs var2_2, String[] var3_3) {
        var6_4 = this.config.getFilename(3);
        var8_5 = "";
        var10_6 = new String();
        var4_7 = 0;
        while (var4_7 < var3_3.length) {
            var10_6 = String.valueOf(var10_6) + var3_3[var4_7] + "|";
            ++var4_7;
        }
        var11_8 = File.separator;
        var13_9 = this.fileAdminDir.getAbsolutePath();
        var12_10 = new String(String.valueOf(var13_9) + var11_8 + "opstmp");
        var14_11 = new File(var12_10);
        if (!var14_11.exists()) {
            var14_11.mkdir();
        }
        var9_12 = new ClusterRegister(var12_10);
        var9_12.debug(OPSUtil.debug());
        var4_7 = 0;
        while (var4_7 < var3_3.length) {
            var5_13 = new String("CopyFileNodeFrom|" + var6_4 + "|" + var6_4 + "." + var3_3[var4_7] + "|" + var3_3[var4_7]);
            var9_12.writeClusterLog(var5_13);
            ++var4_7;
        }
        if (var9_12.finalCluster(var10_6)) ** GOTO lbl36
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v0) {
                var15_14 = 0;
                ** while (var15_14 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var15_14;
                continue;
            }
lbl36:
            // 3 sources

            ** while (!var9_12.doneProcessing())
        }
lbl37:
        // 1 sources

        OPSUtil.println();
        var4_7 = 0;
        var9_12 = new ClusterRegister(var12_10);
        var9_12.debug(OPSUtil.debug());
        while (var4_7 < var3_3.length) {
            var7_17 = new String(String.valueOf(var6_4) + "." + var3_3[var4_7]);
            this.config.setFilename(3, var7_17);
            var15_16 = new ConfigureProfile(this.config, this.fileAdminDir);
            var15_16.initProfile();
            var15_16.setDefaultProfileParameters(var2_2);
            var16_18 = "";
            var17_21 = this.profile.enum();
            while (var17_21.hasMoreElements()) {
                var16_18 = (String)var17_21.nextElement();
                if (var16_18 == null || var16_18.length() <= 0) continue;
                var15_16.setProfileParam(var16_18, this.getProfileParam(var16_18));
            }
            switch (var1_1) {
                case 0: {
                    OPSUtil.print("saveProfile...");
                    var15_16.saveProfile();
                    OPSUtil.println("saveProfile done");
                    break;
                }
                case 20: {
                    OPSUtil.println("Deletion not possible in ConfigureProfile");
                    break;
                }
                case 30: {
                    OPSUtil.println("Rename not possible in ConfigureProfile");
                }
            }
            this.config.setFilename(3, var6_4);
            var5_13 = new String("CopyFileNode|" + var7_17 + "|" + var6_4 + "|" + var3_3[var4_7]);
            var9_12.writeClusterLog(var5_13);
            ++var4_7;
        }
        if (var9_12.finalCluster(var10_6)) ** GOTO lbl82
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v1) {
                var16_20 = 0;
                ** while (var16_20 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var16_20;
                continue;
            }
lbl82:
            // 3 sources

            ** while (!var9_12.doneProcessing())
        }
lbl83:
        // 1 sources

        OPSUtil.println();
        OPSUtil.deleteTmpFiles(var6_4, var3_3);
        if (var14_11.exists()) {
            var14_11.delete();
        }
        var8_5 = OPSUtil.ClusterErrorMsg(var9_12, var3_3);
        return var8_5;
    }
}

