/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.ca.CmdlineArgs;
import oracle.net.ca.ConfigureProfile;
import oracle.net.ca.NetStrings;
import oracle.net.ca.OPSUtil;
import oracle.net.common.NetGetEnv;
import oracle.net.config.Config;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.nl.NLException;
import oracle.ops.config.cluster.ClusterRegister;

public class ConfigureServiceAlias {
    private DescriptionConfig descCfg;
    private Vector endpoints;
    private ServiceAlias alias;
    private Config config;
    private String aliasName;
    private String shortName;
    private String fullName;
    private String serviceName;
    private String sid;
    private String dfltDomain;
    private String addrDescription;
    private String address_list;
    final NetStrings netstr = new NetStrings();
    private CmdlineArgs cmdarg;
    private File fileAdminDir;

    public ConfigureServiceAlias(Config config, CmdlineArgs cmdlineArgs, ConfigureProfile configureProfile, File file) {
        this.config = config;
        this.cmdarg = cmdlineArgs;
        this.fileAdminDir = file;
        this.dfltDomain = configureProfile.getProfileParam("NAMES.DEFAULT_DOMAIN");
        if (this.dfltDomain == null || this.dfltDomain == "") {
            this.dfltDomain = NetGetEnv.getDNSDomain();
        }
        this.addrDescription = null;
    }

    public void typicalConfigure() {
        if (this.dfltDomain != null) {
            this.initAlias("extproc_connection_data." + this.dfltDomain);
        } else {
            this.initAlias("extproc_connection_data");
        }
        String string = this.cmdarg.getStringArgs("orahid");
        if (string.equals("NO_VALUE")) {
            string = "";
        }
        String string2 = "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=IPC)(KEY=EXTPROC" + string + ")))(CONNECT_DATA=(SID=PLSExtProc)(PRESENTATION=RO)))";
        this.setDescription(string2);
        this.setEndpoints();
        this.saveAlias();
    }

    public void typicalConfigureOPS(String[] stringArray, ConfigureProfile configureProfile) {
        this.typicalConfigure();
        OPSUtil.println("saveAliasOPS");
        this.saveAliasOPS(stringArray, configureProfile);
    }

    /*
     * Unable to fully structure code
     */
    private String OPSHelper(int var1_1, String[] var2_2, ConfigureProfile var3_3, String var4_4, String var5_5) {
        var8_6 = this.config.getFilename(1);
        var10_7 = "";
        var12_8 = new String();
        var6_9 = 0;
        while (var6_9 < var2_2.length) {
            var12_8 = String.valueOf(var12_8) + var2_2[var6_9] + "|";
            ++var6_9;
        }
        var13_10 = File.separator;
        var15_11 = this.fileAdminDir.getAbsolutePath();
        var14_12 = new String(String.valueOf(var15_11) + var13_10 + "opstmp");
        System.out.println("\n ConfigureServiceAlias: Log file path created" + var14_12);
        var16_13 = new File(var14_12);
        if (!var16_13.exists()) {
            var16_13.mkdir();
        }
        var11_14 = new ClusterRegister(var14_12);
        var11_14.debug(OPSUtil.debug());
        var6_9 = 0;
        while (var6_9 < var2_2.length) {
            var7_15 = new String("CopyFileNodeFrom|" + var8_6 + "|" + var8_6 + "." + var2_2[var6_9] + "|" + var2_2[var6_9]);
            var11_14.writeClusterLog(var7_15);
            ++var6_9;
        }
        if (var11_14.finalCluster(var12_8)) ** GOTO lbl37
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v0) {
                var17_16 = 0;
                ** while (var17_16 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var17_16;
                continue;
            }
lbl37:
            // 3 sources

            ** while (!var11_14.doneProcessing())
        }
lbl38:
        // 1 sources

        OPSUtil.println();
        var6_9 = 0;
        var11_14 = new ClusterRegister(var14_12);
        var11_14.debug(OPSUtil.debug());
        while (var6_9 < var2_2.length) {
            var9_19 = new String(String.valueOf(var8_6) + "." + var2_2[var6_9]);
            this.config.setFilename(1, var9_19);
            var17_18 = new ConfigureServiceAlias(this.config, this.cmdarg, var3_3, this.fileAdminDir);
            var17_18.initAlias(this.aliasName);
            var18_20 = this.alias.enumEndpointsArray();
            var19_22 = 0;
            while (var19_22 < var18_20.length) {
                var17_18.setDescription(var18_20[var19_22]);
                var17_18.setEndpoints();
                ++var19_22;
            }
            switch (var1_1) {
                case 0: {
                    OPSUtil.print("saveAlias...");
                    var17_18.saveAlias();
                    OPSUtil.println("saveAlias done");
                    break;
                }
                case 20: {
                    OPSUtil.print("deleteNetServiceName...");
                    var17_18.deleteNetServiceName(var4_4);
                    OPSUtil.println("deleteNetServiceName done");
                    break;
                }
                case 30: {
                    OPSUtil.print("renameNetServiceName...");
                    var17_18.renameNetServiceName(var4_4, var5_5);
                    OPSUtil.println("renameNetServiceName done");
                }
            }
            this.config.setFilename(1, var8_6);
            var7_15 = new String("CopyFileNode|" + var9_19 + "|" + var8_6 + "|" + var2_2[var6_9]);
            var11_14.writeClusterLog(var7_15);
            ++var6_9;
        }
        if (var11_14.finalCluster(var12_8)) ** GOTO lbl87
        OPSUtil.println("Problem OPSAPI");
        return this.netstr.getString("OPSAPI");
lbl-1000:
        // 1 sources

        {
            OPSUtil.print(".");
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v1) {
                var18_21 = 0;
                ** while (var18_21 < 1000)
            }
lbl-1000:
            // 1 sources

            {
                ++var18_21;
                continue;
            }
lbl87:
            // 3 sources

            ** while (!var11_14.doneProcessing())
        }
lbl88:
        // 1 sources

        OPSUtil.println();
        OPSUtil.deleteTmpFiles(var8_6, var2_2);
        if (var16_13.exists()) {
            var16_13.delete();
        }
        var10_7 = OPSUtil.ClusterErrorMsg(var11_14, var2_2);
        return var10_7;
    }

    public void initAlias(String string) {
        this.aliasName = new String(string);
        SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
        this.endpoints = new Vector();
        try {
            this.alias = new ServiceAlias(this.config, string);
            this.descCfg = (DescriptionConfig)schemaObjectConfigFactory.create(2);
            return;
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + serviceAliasException.getMessage());
            return;
        }
    }

    public void buildNSNDescription(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        this.initAlias(string2);
        if (string3.equals("tcp")) {
            this.address_list = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + string4 + ")(PORT=" + string5 + ")))";
        }
        if (string3.equals("tcps")) {
            this.address_list = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCPS)(HOST=" + string4 + ")(PORT=" + string5 + ")))";
        }
        if (string3.equals("ipc")) {
            this.address_list = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=IPC)(KEY=" + string4 + ")))";
        }
        if (string3.equals("spx")) {
            this.address_list = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=SPX)(SERVICE=" + string4 + ")))";
        }
        if (string3.equals("nmp")) {
            this.address_list = "(ADDRESS_LIST=(ADDRESS=(PROTOCOL=NMP)(SERVER=" + string4 + ")(PIPE=" + string5 + ")))";
        }
        if (string.equals("81")) {
            string6 = "(CONNECT_DATA=(SERVICE_NAME=" + string2 + "))";
            this.serviceName = string2;
        }
        if (string.equals("80")) {
            string6 = "(CONNECT_DATA=(SID=" + string2 + "))";
            this.sid = string2;
        }
        this.setDescription("(DESCRIPTION=" + this.address_list + string6 + ")");
    }

    public void createHTTPalias(String string) {
        String[] stringArray = new String[]{this.address_list};
        try {
            ServiceAlias.createHttpSimpleAlias((Config)this.config, (boolean)true, (String)string, (String[])stringArray, null, (String)this.serviceName, (String)this.sid);
            return;
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + serviceAliasException.getMessage());
            return;
        }
    }

    public String getDescription() {
        return this.addrDescription;
    }

    public void setDescription(String string) {
        this.addrDescription = string;
    }

    public String getEndpoint() {
        String[] stringArray = this.alias.enumEndpointsArray();
        if (stringArray.length == 0) {
            System.out.println(this.netstr.getString("SOLocalAlaisExEnum"));
            System.out.println(String.valueOf(this.netstr.getString("SONetConfigFail")) + 1);
            System.exit(1);
        }
        return stringArray[0];
    }

    public void setEndpoints() {
        try {
            this.descCfg.initFromString(this.addrDescription);
            this.endpoints.addElement(this.descCfg);
            this.alias.setEndpoints(this.endpoints);
            return;
        }
        catch (NLException nLException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + nLException.getMessage());
            return;
        }
        catch (SOException sOException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExInit")) + sOException.getMessage());
            return;
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExEndp")) + serviceAliasException.getMessage());
            return;
        }
    }

    public void saveAlias() {
        try {
            this.alias.save(this.config, true);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExSave")) + serviceAliasException.getMessage());
        }
        System.out.println(this.netstr.getString("SOLocalAliasComplete"));
    }

    public void saveAliasOPS(String[] stringArray, ConfigureProfile configureProfile) {
        boolean bl = true;
        while (bl) {
            bl = false;
            String string = this.OPSHelper(0, stringArray, configureProfile, null, null);
            if (string.length() <= 0) continue;
            bl = OPSUtil.Alert(string);
        }
    }

    public String[] getNetServiceNames() {
        String[] stringArray = null;
        try {
            stringArray = ServiceAlias.enum((Config)this.config, null, (boolean)false);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExEnum")) + serviceAliasException.getMessage());
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public void deleteNetServiceName(String string) {
        try {
            ServiceAlias.delete((Config)this.config, (String)string);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExDelete")) + string + serviceAliasException.getMessage());
        }
        Object[] objectArray = new Object[]{string};
        System.out.println("  " + this.netstr.getString("StandAloneNSNdeleted", objectArray));
    }

    public void deleteNetServiceNameOPS(String[] stringArray, ConfigureProfile configureProfile, String string) {
        boolean bl = true;
        while (bl) {
            bl = false;
            String string2 = this.OPSHelper(20, stringArray, configureProfile, string, null);
            if (string2.length() <= 0) continue;
            bl = OPSUtil.Alert(string2);
        }
    }

    public void renameNetServiceName(String string, String string2) {
        try {
            this.alias.saveAs(this.config, true, string2);
            ServiceAlias.delete((Config)this.config, (String)string);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasExRename")) + string + serviceAliasException.getMessage());
        }
        System.out.println(String.valueOf(this.netstr.getString("SOLocalAliasRename")) + string + this.netstr.getString("to") + string2);
    }

    public void renameNetServiceNameOPS(String[] stringArray, ConfigureProfile configureProfile, String string, String string2) {
        boolean bl = true;
        while (bl) {
            bl = false;
            String string3 = this.OPSHelper(30, stringArray, configureProfile, string, string2);
            if (string3.length() <= 0) continue;
            bl = OPSUtil.Alert(string3);
        }
    }

    public String getNSNshortName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        return stringTokenizer.nextToken();
    }

    public String getNSNfullName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            if (this.dfltDomain != null) {
                return String.valueOf(string2) + "." + this.dfltDomain;
            }
            return string2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            return string;
        }
        return string2;
    }
}

