/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ca;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class IniFile {
    String NEW_LINE = System.getProperty("line.separator");
    private String m_sFileName;
    private String m_sHeader;
    private Vector m_sections;

    public IniFile(String string) {
        this.m_sFileName = string;
    }

    public void setHeader(String string) {
        this.m_sHeader = string;
    }

    public String getHeader() {
        return this.m_sHeader;
    }

    public Vector getVarsInSection(String string) throws IOException {
        if (this.m_sections == null) {
            this.readIniFile();
        }
        string = string.trim();
        int n = this.m_sections.size();
        int n2 = 0;
        while (n2 < n) {
            IniSection iniSection = (IniSection)this.m_sections.elementAt(n2);
            if (string.equalsIgnoreCase(iniSection.getName())) {
                return iniSection.getVarNames();
            }
            ++n2;
        }
        return null;
    }

    public String getProfileString(String string, String string2, String string3) throws IOException {
        if (this.m_sections == null) {
            this.readIniFile();
        }
        string = string.trim();
        string2 = string2.trim();
        int n = this.m_sections.size();
        int n2 = 0;
        while (n2 < n) {
            IniSection iniSection = (IniSection)this.m_sections.elementAt(n2);
            if (string.equalsIgnoreCase(iniSection.getName())) {
                String string4 = iniSection.getValue(string2, string3);
                if (string4 != null) {
                    if (string4.startsWith("\"")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.endsWith("\"")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                }
                return string4;
            }
            ++n2;
        }
        return string3;
    }

    public Object getValue(String string, String string2, String string3) throws IOException {
        String string4 = null;
        try {
            string4 = this.getProfileString(string, string2, string3);
        }
        catch (IOException iOException) {
            System.err.println("Could not read response file");
        }
        if (string4 == null) {
            return null;
        }
        if ((string4 = string4.trim()).equals("")) {
            return string4;
        }
        String string5 = string4.trim();
        if (string5 == null) {
            return null;
        }
        Object object = null;
        try {
            Integer n = Integer.valueOf(string5);
            object = n;
        }
        catch (NumberFormatException numberFormatException) {
            if (string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("false")) {
                object = Boolean.valueOf(string5);
            }
            if (string5.charAt(0) == '{') {
                if (string5.endsWith("}")) {
                    object = this.makeStringArray(string5.substring(1, string5.length() - 1));
                }
            }
            object = string5.charAt(0) == '\"' ? string5.substring(1, string5.length() - 1) : null;
        }
        if (object == null) {
            return null;
        }
        return object;
    }

    private String[] makeStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < n) {
            String string2 = stringTokenizer.nextToken();
            if (!(string2 = string2.trim()).startsWith("\"") || !string2.endsWith("\"")) {
                return null;
            }
            stringArray[n2] = string2.substring(1, string2.length() - 1);
            ++n2;
        }
        return stringArray;
    }

    public void setProfileString(String string, String string2, String string3) {
        try {
            if (this.m_sections == null) {
                this.readIniFile();
            }
        }
        catch (IOException iOException) {}
        if (this.m_sections == null) {
            this.m_sections = new Vector();
        }
        string = string.trim();
        string2 = string2.trim();
        IniSection iniSection = null;
        int n = this.m_sections.size();
        int n2 = 0;
        while (n2 < n) {
            iniSection = (IniSection)this.m_sections.elementAt(n2);
            if (string.equalsIgnoreCase(iniSection.getName())) break;
            iniSection = null;
            ++n2;
        }
        if (iniSection == null) {
            iniSection = new IniSection(string);
            this.m_sections.addElement(iniSection);
        }
        iniSection.addPair(String.valueOf(string2) + "=" + string3);
    }

    public void setProfileString(String string, String string2, String string3, String string4) {
        this.setProfileString(string, string2, string3);
        IniSection iniSection = null;
        int n = this.m_sections.size();
        int n2 = 0;
        while (n2 < n) {
            iniSection = (IniSection)this.m_sections.elementAt(n2);
            if (string.equalsIgnoreCase(iniSection.getName())) {
                iniSection.addPair(String.valueOf(string2) + "=" + string3, string4);
            }
            ++n2;
        }
    }

    public void writeIniFile() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.m_sFileName));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        if (this.m_sHeader != null) {
            bufferedWriter.write(this.m_sHeader, 0, this.m_sHeader.length());
        }
        int n = this.m_sections.size();
        int n2 = 0;
        while (n2 < n) {
            IniSection iniSection = (IniSection)this.m_sections.elementAt(n2);
            String string = new String();
            string = String.valueOf(string) + "[" + iniSection.getName() + "]" + this.NEW_LINE;
            Vector vector = iniSection.elements();
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                IniPair iniPair = (IniPair)vector.elementAt(n4);
                string = String.valueOf(string) + iniPair.toString() + this.NEW_LINE;
                ++n4;
            }
            string = String.valueOf(string) + this.NEW_LINE;
            bufferedWriter.write(string, 0, string.length());
            ++n2;
        }
        bufferedWriter.close();
        outputStreamWriter.close();
        fileOutputStream.close();
    }

    private void readIniFile() throws IOException {
        String string;
        this.m_sections = new Vector();
        IniSection iniSection = null;
        FileInputStream fileInputStream = new FileInputStream(new File(this.m_sFileName));
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() < 2) continue;
            if (string.startsWith("#")) {
                string2 = String.valueOf(string2) + this.NEW_LINE + string;
                continue;
            }
            if (string.startsWith("[") && string.endsWith("]")) {
                string = string.replace('[', ' ');
                string = string.replace(']', ' ');
                if ((string = string.trim()).length() < 1) continue;
                IniSection iniSection2 = new IniSection(string);
                this.m_sections.addElement(iniSection2);
                iniSection = iniSection2;
                string2 = "";
                continue;
            }
            if (iniSection != null) {
                iniSection.addPair(string, string2);
            }
            string2 = "";
        }
        bufferedReader.close();
        inputStreamReader.close();
        fileInputStream.close();
    }

    public static final void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: IniFile filename");
            return;
        }
        IniFile iniFile = new IniFile(stringArray[0]);
        try {
            System.out.println("GDBNAME is : " + iniFile.getProfileString("General", "GDBNAME", null));
            System.in.read();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    class IniPair {
        String m_sValue = "";
        String m_sVariable = "";
        String m_sDescription;

        public IniPair(String string) {
            IniFile.this = IniFile.this;
            int n = string.indexOf("=");
            if (n == -1) {
                this.m_sVariable = string;
                this.m_sValue = "";
            } else {
                this.m_sVariable = string.substring(0, n);
                this.m_sValue = string.substring(n + 1, string.length());
            }
            this.m_sVariable = this.m_sVariable.trim();
            this.m_sValue = this.m_sValue.trim();
        }

        public String getValue() {
            return this.m_sValue;
        }

        public String getVariable() {
            return this.m_sVariable;
        }

        public void setValue(String string) {
            this.m_sValue = string;
        }

        public void setDescription(String string) {
            this.m_sDescription = string;
        }

        public String toString() {
            if (this.m_sDescription == null) {
                return String.valueOf(this.m_sVariable) + "=" + this.m_sValue;
            }
            return String.valueOf(this.m_sDescription) + IniFile.this.NEW_LINE + this.m_sVariable + "=" + this.m_sValue;
        }
    }

    class IniSection {
        String m_sName;
        Vector m_pairs = new Vector();

        public IniSection(String string) {
            IniFile.this = IniFile.this;
            this.m_sName = string.trim();
        }

        public void addPair(String string) {
            IniPair iniPair = new IniPair(string);
            IniPair iniPair2 = this.getValuePair(iniPair.getVariable());
            if (iniPair2 == null) {
                this.m_pairs.addElement(iniPair);
                return;
            }
            iniPair2.setValue(iniPair.getValue());
        }

        public void addPair(String string, String string2) {
            if (string2 != null) {
                IniPair iniPair = new IniPair(string);
                iniPair.setDescription(string2);
                IniPair iniPair2 = this.getValuePair(iniPair.getVariable());
                if (iniPair2 == null) {
                    this.m_pairs.addElement(iniPair);
                    return;
                }
                iniPair2.setValue(iniPair.getValue());
                iniPair2.setDescription(string2);
                return;
            }
            this.addPair(string);
        }

        public String getName() {
            return this.m_sName;
        }

        public String getValue(String string, String string2) {
            IniPair iniPair = this.getValuePair(string);
            if (iniPair == null) {
                return string2;
            }
            return iniPair.getValue();
        }

        public IniPair getValuePair(String string) {
            int n = this.m_pairs.size();
            int n2 = 0;
            while (n2 < n) {
                IniPair iniPair = (IniPair)this.m_pairs.elementAt(n2);
                if (string.equalsIgnoreCase(iniPair.getVariable())) {
                    return iniPair;
                }
                ++n2;
            }
            return null;
        }

        public Vector elements() {
            return this.m_pairs;
        }

        public Vector getVarNames() {
            if (this.m_pairs != null) {
                Vector<String> vector = new Vector<String>();
                int n = this.m_pairs.size();
                int n2 = 0;
                while (n2 < n) {
                    IniPair iniPair = (IniPair)this.m_pairs.elementAt(n2);
                    vector.addElement(iniPair.getVariable());
                    ++n2;
                }
                return vector;
            }
            return null;
        }
    }
}

