/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.common;

import oracle.net.common.jlsnrctl;

public class TNSEndpoint {
    private static final int LISTENER = 0;
    private static final int OTHER_NET = 1153;
    private static final int NOT_LISTENER = 12541;

    public static boolean IsInUse(String string) {
        boolean bl;
        int n = jlsnrctl.discover(string);
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1153: {
                bl = true;
                break;
            }
            case 12541: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean IsListener(String string) {
        int n = jlsnrctl.discover(string);
        return n == 0;
    }

    public static void main(String[] stringArray) {
        System.out.println("testing listener at (ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1521))");
        System.out.println("====> IS IN USE   = " + TNSEndpoint.IsInUse("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1521))"));
        System.out.println("====> IS LISTENER = " + TNSEndpoint.IsListener("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1521))"));
        System.out.println("testing cman at (ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1630))");
        System.out.println("====> IS IN USE   = " + TNSEndpoint.IsInUse("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1630))"));
        System.out.println("====> IS LISTENER = " + TNSEndpoint.IsListener("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1630))"));
        System.out.println("testing onames at (ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1575))");
        System.out.println("====> IS IN USE   = " + TNSEndpoint.IsInUse("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1575))"));
        System.out.println("====> IS LISTENER = " + TNSEndpoint.IsListener("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=1575))"));
        System.out.println("testing dispatcher at (ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=2000))");
        System.out.println("====> IS IN USE   = " + TNSEndpoint.IsInUse("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=2000))"));
        System.out.println("====> IS LISTENER = " + TNSEndpoint.IsListener("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=2000))"));
        System.out.println("testing ftp at (ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=21))");
        System.out.println("====> IS IN USE   = " + TNSEndpoint.IsInUse("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=21))"));
        System.out.println("====> IS LISTENER = " + TNSEndpoint.IsListener("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=21))"));
        System.out.println("testing none at (ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=5555))");
        System.out.println("====> IS IN USE   = " + TNSEndpoint.IsInUse("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=5555))"));
        System.out.println("====> IS LISTENER = " + TNSEndpoint.IsListener("(ADDRESS=(PROTOCOL=tcp)(HOST=)(PORT=5555))"));
    }
}

