/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ber;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.IntRef;
import oracle.sumatra.net.ber.BERElement;
import oracle.sumatra.net.ber.BERException;

public abstract class BERIntbase
extends BERElement {
    private long m_value;

    public BERIntbase(byte by, long l) {
        super(by);
        this.m_value = l;
    }

    public BERIntbase(InputStream inputStream, byte by, IntRef intRef) throws BERException {
        super(by);
        this.m_value = 0L;
        int n = BERElement.readDefLength(inputStream, intRef);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            try {
                n3 = inputStream.read();
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 == -1) {
                throw new BERException("Found end of input while parsing BER data");
            }
            byte by2 = (byte)n3;
            if (n2 == 0) {
                this.m_value = by2;
            } else {
                this.m_value <<= 8;
                this.m_value |= (long)((short)by2 & 0xFF);
            }
            ++n2;
        }
        intRef.set(intRef.get() + n);
    }

    public int getEncodedLength() {
        if (this.m_value < 128L && this.m_value > -128L) {
            return 3;
        }
        if (this.m_value < 32768L && this.m_value > -32768L) {
            return 4;
        }
        if (this.m_value < 0x800000L && this.m_value > -8388608L) {
            return 5;
        }
        if (this.m_value < Integer.MIN_VALUE && this.m_value > Integer.MIN_VALUE) {
            return 6;
        }
        if (this.m_value < 128L && this.m_value > -128L) {
            return 7;
        }
        if (this.m_value < 32768L && this.m_value > -32768L) {
            return 8;
        }
        if (this.m_value < 0x800000L && this.m_value > -8388608L) {
            return 9;
        }
        return 10;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getTag());
        int n = this.m_value < 128L && this.m_value > -128L ? 1 : (this.m_value < 32768L && this.m_value > -32768L ? 2 : (this.m_value < 0x800000L && this.m_value > -8388608L ? 3 : (this.m_value < Integer.MIN_VALUE && this.m_value > Integer.MIN_VALUE ? 4 : (this.m_value < 128L && this.m_value > -128L ? 5 : (this.m_value < 32768L && this.m_value > -32768L ? 6 : (this.m_value < 0x800000L && this.m_value > -8388608L ? 7 : 8))))));
        BERElement.writeDefLength(outputStream, n);
        if (n >= 8) {
            outputStream.write((byte)((this.m_value & 0xFF00000000000000L) >> 56));
        }
        if (n >= 7) {
            outputStream.write((byte)((this.m_value & 0xFF000000000000L) >> 48));
        }
        if (n >= 6) {
            outputStream.write((byte)((this.m_value & 0xFF0000000000L) >> 40));
        }
        if (n >= 5) {
            outputStream.write((byte)((this.m_value & 0xFF00000000L) >> 32));
        }
        if (n >= 4) {
            outputStream.write((byte)((this.m_value & 0xFF000000L) >> 24));
        }
        if (n >= 3) {
            outputStream.write((byte)((this.m_value & 0xFF0000L) >> 16));
        }
        if (n >= 2) {
            outputStream.write((byte)((this.m_value & 0xFF00L) >> 8));
        }
        outputStream.write((byte)(this.m_value & 0xFFL));
    }

    public long getValue() {
        return this.m_value;
    }
}

