/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ber;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.IntRef;
import oracle.sumatra.net.ber.BERElement;
import oracle.sumatra.net.ber.BERException;

public class BEROctetString
extends BERElement {
    String m_value;
    String m_noUTF8Value;
    ByteArrayOutputStream m_byteArray;

    public BEROctetString(String string) {
        super((byte)4);
        this.m_value = string;
    }

    public BEROctetString(ByteArrayOutputStream byteArrayOutputStream) {
        super((byte)4);
        this.m_byteArray = byteArrayOutputStream;
    }

    public BEROctetString(byte by, String string) {
        super(by);
        this.m_value = string;
    }

    public BEROctetString(InputStream inputStream, byte by, IntRef intRef) throws BERException {
        super(by);
        byte[] byArray = null;
        int n = BERElement.readDefLength(inputStream, intRef);
        if (n == 0) {
            this.m_value = "";
            this.m_noUTF8Value = "";
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            try {
                n3 = inputStream.read();
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 == -1) {
                throw new BERException("Found end of input while parsing BER data");
            }
            stringBuffer.append((char)n3);
            byArray[n2] = (byte)n3;
            ++n2;
        }
        if (n > 0 && stringBuffer.charAt(n - 1) == '\u0000') {
            stringBuffer.setLength(n - 1);
            byte[] byArray2 = new byte[n - 1];
            int n4 = 0;
            while (n4 < n - 1) {
                byArray2[n4] = byArray[n4];
                ++n4;
            }
            byArray = byArray2;
        }
        try {
            this.m_noUTF8Value = stringBuffer.toString();
            this.m_byteArray = new ByteArrayOutputStream();
            this.m_byteArray.write(byArray, 0, byArray.length);
            this.m_value = new String(byArray, "UTF8");
        }
        catch (Exception exception) {}
        intRef.set(intRef.get() + n);
    }

    public int getEncodedLength() {
        int n = 0;
        try {
            if (this.m_value != null) {
                n = 1 + BERElement.getDefLength(this.m_value.getBytes("UTF8").length) + this.m_value.getBytes("UTF8").length;
            } else if (this.m_byteArray != null) {
                byte[] byArray = this.m_byteArray.toByteArray();
                n = 1 + BERElement.getDefLength(byArray.length) + byArray.length;
            }
        }
        catch (Exception exception) {}
        return n;
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        if (this.m_value != null) {
            byArray = this.m_value.getBytes("UTF8");
        } else if (this.m_byteArray != null) {
            byArray = this.m_byteArray.toByteArray();
        }
        if (byArray != null) {
            outputStream.write(this.getTag());
            BERElement.writeDefLength(outputStream, byArray.length);
            outputStream.write(byArray);
        }
    }

    public String getValue() {
        return this.m_value;
    }

    public ByteArrayOutputStream getNoUTF8Value() {
        return this.m_byteArray;
    }

    public String toString() {
        return this.m_value;
    }
}

