/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import java.util.Vector;

public class Attribute {
    public static final int CONTAINS = 1;
    public static final int BEGINSWITH = 2;
    public static final int ENDSWITH = 3;
    public static final int EQUALS = 4;
    private String m_attributeType;
    private String[] m_attributeValues;

    public Attribute(String string, String string2) {
        this.m_attributeType = string;
        this.m_attributeValues = new String[1];
        this.m_attributeValues[0] = string2;
    }

    public Attribute(String string, String[] stringArray) {
        this.m_attributeType = string;
        this.m_attributeValues = stringArray;
    }

    public String getType() {
        return this.m_attributeType;
    }

    public String[] getValues() {
        return this.m_attributeValues;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Attribute) {
            bl = this.equals((Attribute)object, 4, true);
        }
        return bl;
    }

    public boolean equalsIgnoreCase(Attribute attribute) {
        return this.equals(attribute, 4, false);
    }

    public boolean equals(Attribute attribute, int n, boolean bl) {
        boolean bl2 = false;
        if (this.m_attributeType.equalsIgnoreCase(attribute.m_attributeType)) {
            if (this.m_attributeValues == null && attribute.m_attributeValues == null) {
                bl2 = true;
            } else if (this.m_attributeValues != null && attribute.m_attributeValues != null && this.m_attributeValues.length >= attribute.m_attributeValues.length) {
                boolean bl3 = true;
                int n2 = 0;
                while (bl3 && n2 < attribute.m_attributeValues.length) {
                    bl3 = false;
                    String string = attribute.m_attributeValues[n2];
                    if (!bl) {
                        string = string.toUpperCase();
                    }
                    int n3 = 0;
                    while (!bl3 && n3 < this.m_attributeValues.length) {
                        String string2 = this.m_attributeValues[n3];
                        if (!bl) {
                            string2 = string2.toUpperCase();
                        }
                        switch (n) {
                            case 4: {
                                bl3 = string2.equals(string);
                                break;
                            }
                            case 2: {
                                bl3 = string2.indexOf(string) == 0;
                                break;
                            }
                            case 3: {
                                int n4 = string2.lastIndexOf(string);
                                if (n4 == -1) break;
                                bl3 = n4 + string.length() == string2.length();
                                break;
                            }
                            default: {
                                bl3 = string2.indexOf(string) != -1;
                                break;
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
                bl2 = bl3;
            }
        }
        return bl2;
    }

    public static String encodeValue(String string) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl && c == ' ') {
                stringBuffer.append("\\ ");
            } else {
                bl = false;
                switch (c) {
                    case '\n': {
                        stringBuffer.append("\\n");
                        break;
                    }
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        break;
                    }
                    case ' ': {
                        if (n == string.length() - 1) {
                            stringBuffer.append("\\ ");
                            break;
                        }
                        stringBuffer.append(c);
                        bl = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.m_attributeType);
        stringBuffer.append('=');
        int n = 0;
        while (n < this.m_attributeValues.length) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_attributeValues[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toLDIFString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < this.m_attributeValues.length) {
            stringBuffer.append(this.m_attributeType);
            stringBuffer.append(": ");
            stringBuffer.append(this.m_attributeValues[n]);
            stringBuffer.append("\r\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Attribute union(Attribute attribute) {
        Attribute attribute2 = null;
        String string = attribute.getType();
        if (string.equalsIgnoreCase(this.m_attributeType)) {
            Object object;
            int n;
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < this.m_attributeValues.length) {
                boolean bl = false;
                n = 0;
                while (n < vector.size()) {
                    object = (String)vector.elementAt(n);
                    if (object.equalsIgnoreCase(this.m_attributeValues[n2])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    vector.addElement(this.m_attributeValues[n2]);
                }
                ++n2;
            }
            String[] stringArray = attribute.getValues();
            n = 0;
            while (n < stringArray.length) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < vector.size()) {
                    String string2 = (String)vector.elementAt(n3);
                    if (string2.equalsIgnoreCase(stringArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
            attribute2 = new Attribute(string, (String[])object);
        }
        return attribute2;
    }

    public Attribute difference(Attribute attribute) {
        Attribute attribute2 = null;
        String string = attribute.getType();
        String[] stringArray = attribute.getValues();
        if (string.equalsIgnoreCase(this.m_attributeType)) {
            Vector<String> vector = new Vector<String>();
            String[] stringArray2 = new String[stringArray.length + this.m_attributeValues.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2[n++] = stringArray[n2];
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.m_attributeValues.length) {
                stringArray2[n++] = this.m_attributeValues[n3];
                ++n3;
            }
            int n4 = 0;
            while (n4 < stringArray2.length) {
                boolean bl = false;
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    if (stringArray2[n5].equalsIgnoreCase(stringArray2[n4])) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    vector.addElement(stringArray2[n4]);
                }
                ++n4;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            attribute2 = new Attribute(string, (String[])objectArray);
        }
        return attribute2;
    }
}

