/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import oracle.sumatra.net.ldap.RDN;

public class DN {
    private RDN[] m_RDNs;

    public DN(String string) throws IllegalArgumentException {
        this.m_RDNs = RDN.parseRDNs(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < this.m_RDNs.length) {
            if (n == 0) {
                stringBuffer.append(this.m_RDNs[n].toString());
            } else {
                stringBuffer.append(", ");
                stringBuffer.append(this.m_RDNs[n].toString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toLDIFString() {
        return "DN: " + this.toString();
    }

    public boolean isChild(DN dN) {
        boolean bl = false;
        if (this.m_RDNs.length == dN.m_RDNs.length - 1) {
            bl = true;
            int n = this.m_RDNs.length - 1;
            while (bl && n >= 0) {
                bl = this.m_RDNs[n].equals(dN.m_RDNs[n]);
                --n;
            }
        }
        return bl;
    }

    public static boolean isChild(String string, String string2) throws IllegalArgumentException {
        return new DN(string).isChild(new DN(string2));
    }

    public boolean isDescendent(DN dN) {
        boolean bl = false;
        if (dN.m_RDNs.length < this.m_RDNs.length) {
            bl = true;
            int n = this.m_RDNs.length - 1;
            while (bl && n >= 0) {
                bl = this.m_RDNs[n].equals(dN.m_RDNs[n]);
                --n;
            }
        }
        return bl;
    }

    public static boolean isDescendent(String string, String string2) throws IllegalArgumentException {
        return new DN(string).isDescendent(new DN(string2));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DN) {
            DN dN = (DN)object;
            if (this.m_RDNs.length == dN.m_RDNs.length) {
                bl = true;
                int n = 0;
                while (bl && n < this.m_RDNs.length) {
                    if (!this.m_RDNs[n].equals(dN.m_RDNs[n])) {
                        bl = false;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }
}

