/*
 * Decompiled with CFR 0.152.
 */
package oracle.sumatra.net.ldap;

import java.io.InputStream;
import oracle.net.util.ICommand;
import oracle.sumatra.net.ber.BERException;
import oracle.sumatra.net.ber.BERModule;
import oracle.sumatra.net.ldap.IParseResponseAdvise;

class ParseResponseCommand
implements ICommand {
    private boolean m_done = false;
    private InputStream m_strm;
    private IParseResponseAdvise m_advise;

    public ParseResponseCommand(InputStream inputStream, IParseResponseAdvise iParseResponseAdvise) {
        this.m_strm = inputStream;
        this.m_advise = iParseResponseAdvise;
    }

    public synchronized void done() {
        this.m_done = true;
    }

    public void execute() {
        while (!this.m_done) {
            try {
                BERModule bERModule = new BERModule(this.m_strm);
                this.m_advise.onResponse(bERModule);
            }
            catch (BERException bERException) {
                if (this.m_done) continue;
                this.m_advise.onException(bERException);
                this.done();
            }
            catch (Exception exception) {
                if (this.m_done) continue;
                this.m_advise.onException(exception);
                this.done();
            }
        }
        this.m_strm = null;
        this.m_advise = null;
    }
}

