/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSet;

public class OracleXMLDataSetExtJdbc
extends OracleXMLDataSet {
    private OracleConnection conn;
    private OracleResultSet rset;
    private boolean rsetIsExt = false;
    private ResultSetMetaData rmdata;
    private String connUser;
    private OraclePreparedStatement stmt;
    private Statement tempS;
    boolean rsetFirstTime = true;
    OracleXMLDataSetExtJdbc[] dsetList;
    static boolean useNewJdbcCalls = true;
    private static Hashtable typeHash = null;
    private boolean rsetVal = true;
    private Hashtable bindPosHash;
    private boolean isConsistent = false;

    public OracleXMLDataSetExtJdbc(Connection connection, OracleResultSet oracleResultSet) throws SQLException {
        this.conn = (OracleConnection)connection;
        this.rset = oracleResultSet;
        this.rsetIsExt = true;
        this.tempS = this.rset.getStatement();
        this.rmdata = this.rset.getMetaData();
        this.rsetVal = this.rset.next();
        this.connUser = this.conn.getMetaData().getUserName();
        this.isConsistent = true;
    }

    public OracleXMLDataSetExtJdbc(Connection connection, String string) throws SQLException {
        this.conn = (OracleConnection)connection;
        this.stmt = (OraclePreparedStatement)this.conn.prepareStatement(string);
        this.refreshDataSet();
    }

    public OracleXMLDataSetExtJdbc(Connection connection, Reader reader) throws Exception {
        this.conn = (OracleConnection)connection;
        String string = this.processSQLQuery(reader);
        this.stmt = (OraclePreparedStatement)this.conn.prepareStatement(string);
        if (this.bindPosHash != null) {
            this.isConsistent = false;
            return;
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetExtJdbc(Connection connection, Reader reader, Vector vector, Vector vector2) throws IOException, SQLException {
        this.conn = (OracleConnection)connection;
        if (vector != null) {
            String string = null;
            if (vector2 == null || vector.size() != vector2.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0010"));
            }
            string = this.processSQLQuery(reader);
            if (vector.size() != this.bindPosHash.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0011"));
            }
            this.stmt = (OraclePreparedStatement)this.conn.prepareStatement(string);
            int n = vector.size() - 1;
            while (n >= 0) {
                this.bindValue((String)vector.elementAt(n), (String)vector2.elementAt(n));
                --n;
            }
        } else {
            StringBuffer stringBuffer = OracleXMLConvert.ReaderToStrBuf(reader, null);
            this.stmt = (OraclePreparedStatement)this.conn.prepareStatement(stringBuffer.toString());
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetExtJdbc(Connection connection) {
        this.conn = (OracleConnection)connection;
    }

    public void refreshDataSet() throws SQLException {
        if (this.isConsistent) {
            return;
        }
        this.dsetList = null;
        this.rset = (OracleResultSet)this.stmt.executeQuery();
        this.rsetFirstTime = true;
        this.rsetVal = this.rset.next();
        if (this.rmdata == null) {
            this.rmdata = this.rset.getMetaData();
            this.connUser = this.conn.getMetaData().getUserName();
        }
        this.isConsistent = true;
    }

    public void bindValue(String string, String string2) throws SQLException {
        Integer n = null;
        if (this.bindPosHash != null) {
            n = (Integer)this.bindPosHash.get(string);
        }
        if (n == null) {
            throw new OracleXMLSQLException(this.msg.getMessage1("XSUE-0012", string));
        }
        if (string2 == null) {
            this.stmt.setNull(n.intValue(), 12);
        } else {
            this.stmt.setString(n.intValue(), string2);
        }
        this.isConsistent = false;
    }

    private String processSQLQuery(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = null;
        int n = 0;
        int n2 = 0;
        if (this.bindPosHash == null) {
            this.bindPosHash = new Hashtable(10);
        }
        int n3 = reader.read();
        while (n3 != -1) {
            if (n3 == 39 || n3 == 34) {
                n2 = n3 == n2 ? (char)'\u0000' : (char)n3;
            }
            if (n3 != 58 || n2 != 0) {
                stringBuffer.append((char)n3);
            } else {
                ++n;
                stringBuffer2 = new StringBuffer(32);
                stringBuffer.append("? ");
                while ((n3 = reader.read()) != -1 && n3 != 32) {
                    stringBuffer2.append((char)n3);
                }
                if (stringBuffer2.length() == 0) {
                    throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0013"));
                }
                this.bindPosHash.put(stringBuffer2.toString(), new Integer(n));
            }
            n3 = reader.read();
        }
        if (n == 0) {
            this.bindPosHash = null;
        }
        return stringBuffer.toString();
    }

    public boolean isEmpty() {
        return !this.rsetVal;
    }

    public void close() throws SQLException {
        if (this.rset != null && !this.rsetIsExt) {
            this.rset.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.tempS != null) {
            this.tempS.close();
        }
    }

    public int getColumnCount() throws SQLException {
        return this.rset.getMetaData().getColumnCount();
    }

    public String getColumnName(int n) throws SQLException {
        return this.rmdata.getColumnName(n);
    }

    public int getColumnType(int n) throws SQLException {
        return this.rmdata.getColumnType(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.rmdata.getColumnLabel(n);
    }

    public int isNullable(int n) throws SQLException {
        if (this.rmdata.getColumnType(n) == -10) {
            return 0;
        }
        return this.rmdata.isNullable(n);
    }

    public Object getColumnTypeObject(int n) throws SQLException {
        OracleXMLDataSetExtJdbc oracleXMLDataSetExtJdbc;
        if (this.rmdata.getColumnType(n) != -10) {
            return this.rmdata.getColumnTypeName(n);
        }
        if (this.dsetList == null) {
            this.dsetList = new OracleXMLDataSetExtJdbc[this.rmdata.getColumnCount()];
            int n2 = this.rmdata.getColumnCount() - 1;
            while (n2 >= 0) {
                this.dsetList[n2] = null;
                --n2;
            }
        }
        this.dsetList[n - 1] = oracleXMLDataSetExtJdbc = new OracleXMLDataSetExtJdbc((Connection)this.conn, (OracleResultSet)this.rset.getObject(n));
        return oracleXMLDataSetExtJdbc;
    }

    public void getStructMetaData(Object object, Vector vector, Vector vector2, Vector vector3) throws SQLException {
        if (useNewJdbcCalls) {
            try {
                String string = (String)object;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)string, (Connection)this.conn);
                int n = structDescriptor.getLength();
                ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
                int n2 = 1;
                while (n2 <= n) {
                    vector.addElement(resultSetMetaData.getColumnLabel(n2));
                    int n3 = resultSetMetaData.getColumnType(n2);
                    vector3.addElement(new Integer(n3));
                    if (n3 == 2006) {
                        String string2 = resultSetMetaData.getColumnTypeName(n2);
                        vector2.addElement(string2.substring("REF ".length()));
                    } else {
                        vector2.addElement(resultSetMetaData.getColumnTypeName(n2));
                    }
                    ++n2;
                }
                return;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                useNewJdbcCalls = false;
                OracleXMLDataSetExtJdbc.createTypeHashTable();
            }
        }
        String string = (String)object;
        String string3 = null;
        String string4 = null;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        stringArray[0] = null;
        stringArray2[0] = null;
        OracleXMLConvert.parse(string, stringArray, stringArray2);
        string4 = stringArray2[0];
        string3 = stringArray[0];
        this.getAttrValue(string3, string4, vector, vector2, vector3);
    }

    public String getConnUser() {
        return this.connUser;
    }

    public String getTypesSchema(Object object) {
        try {
            String string = (String)object;
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[]{null};
            stringArray[0] = null;
            OracleXMLConvert.parse(string, stringArray, stringArray2);
            if (stringArray[0] == null) {
                return this.connUser;
            }
            return stringArray[0];
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException, "ERROR");
        }
    }

    public String getTypesName(Object object) {
        try {
            String string = (String)object;
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[]{null};
            stringArray[0] = null;
            OracleXMLConvert.parse(string, stringArray, stringArray2);
            return stringArray2[0];
        }
        catch (SQLException sQLException) {
            throw new OracleXMLSQLException(sQLException, "ERROR");
        }
    }

    public void getCollectionMetaData(Object object, Object[] objectArray, int[] nArray) throws SQLException {
        String string = (String)object;
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)this.conn);
        objectArray[0] = arrayDescriptor.getBaseName();
        nArray[0] = arrayDescriptor.getBaseType();
    }

    public boolean fetchNextRow() throws SQLException {
        if (this.rsetFirstTime) {
            this.rsetFirstTime = false;
            return this.rsetVal;
        }
        this.dsetList = null;
        return this.rset.next();
    }

    public Object getObject(int n) throws SQLException {
        if (this.dsetList == null || this.dsetList[n - 1] == null) {
            if (this.rmdata.getColumnType(n) == -10) {
                return new OracleXMLDataSetExtJdbc((Connection)this.conn, (OracleResultSet)this.rset.getObject(n));
            }
            return this.rset.getOracleObject(n);
        }
        return this.dsetList[n - 1];
    }

    public Object[] getStructAttributes(Object object) throws SQLException {
        return ((STRUCT)object).getOracleAttributes();
    }

    public Object[] getCollectionValues(Object object) throws SQLException {
        return ((ARRAY)object).getOracleArray();
    }

    private Vector getAttrNames(String string, String string2) throws SQLException {
        OracleConnection oracleConnection = this.conn;
        PreparedStatement preparedStatement = oracleConnection.prepareStatement("SELECT ATTR_NAME FROM ALL_TYPE_ATTRS WHERE TYPE_NAME = ? AND OWNER = ?");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        Vector<String> vector = new Vector<String>(5, 3);
        int n2 = 5;
        vector.setSize(n2);
        while (resultSet.next()) {
            if (n >= n2) {
                vector.setSize(n2 += 3);
            }
            vector.setElementAt(resultSet.getString(1), n);
            ++n;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return vector;
    }

    private void getAttrValue(String string, String string2, Vector vector, Vector vector2, Vector vector3) throws SQLException {
        OracleConnection oracleConnection = this.conn;
        String string3 = "SELECT ATTR_NAME, ATTR_TYPE_MOD, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE TYPE_NAME = ? AND OWNER = ?  ORDER BY ATTR_NO ";
        String string4 = "SELECT TYPECODE FROM ALL_TYPES WHERE OWNER=? AND TYPE_NAME=?";
        PreparedStatement preparedStatement = oracleConnection.prepareStatement(string3);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.addElement(resultSet.getString(1));
            String string5 = resultSet.getString(3);
            String string6 = resultSet.getString(4);
            boolean bl = resultSet.wasNull();
            String string7 = !bl ? String.valueOf(string6) + "." + string5 : string5;
            vector2.addElement(string7);
            String string8 = resultSet.getString(2);
            if (string8 != null && string8.compareTo("REF") == 0) {
                vector3.addElement(new Integer(2006));
                continue;
            }
            if (bl) {
                vector3.addElement(this.convertStringToObjTypecode(string5));
                continue;
            }
            PreparedStatement preparedStatement2 = oracleConnection.prepareStatement(string4);
            preparedStatement2.setString(1, string6);
            preparedStatement2.setString(2, string5);
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            String string9 = resultSet2.getString(1);
            vector3.addElement(this.convertStringToObjTypecode(string9));
            preparedStatement2.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
    }

    public Integer convertStringToObjTypecode(String string) {
        Integer n = (Integer)typeHash.get(string);
        if (n == null) {
            return new Integer(0);
        }
        return n;
    }

    private static synchronized void createTypeHashTable() {
        if (typeHash != null) {
            return;
        }
        typeHash = new Hashtable(30);
        typeHash.put("OBJECT", new Integer(2002));
        typeHash.put("NAMED OBJECT", new Integer(2002));
        typeHash.put("REF", new Integer(2006));
        typeHash.put("COLLECTION", new Integer(2003));
        typeHash.put("NAMED COLLECTION", new Integer(2003));
        typeHash.put("VARYING ARRAY", new Integer(2003));
        typeHash.put("CHAR", new Integer(1));
        typeHash.put("VARCHAR", new Integer(1));
        typeHash.put("VARCHAR2", new Integer(1));
        typeHash.put("LONG", new Integer(1));
        typeHash.put("BFILE", new Integer(-13));
        typeHash.put("BLOB", new Integer(2004));
        typeHash.put("CLOB", new Integer(2005));
        typeHash.put("RAW", new Integer(-2));
        typeHash.put("LONG RAW", new Integer(-2));
        typeHash.put("ROWID", new Integer(-8));
        typeHash.put("DATE", new Integer(93));
        typeHash.put("TIMESTAMP", new Integer(93));
        typeHash.put("TIMESTAMP WITH TZ", new Integer(93));
        typeHash.put("TIME", new Integer(93));
        typeHash.put("TIME WITH TZ", new Integer(93));
        typeHash.put("NUMBER", new Integer(2));
        typeHash.put("DECIMAL", new Integer(3));
        typeHash.put("DOUBLE PRECISION", new Integer(8));
        typeHash.put("SMALLINT", new Integer(5));
        typeHash.put("FLOAT", new Integer(6));
        typeHash.put("REAL", new Integer(7));
        typeHash.put("INTEGER", new Integer(4));
    }

    public boolean cursorFetchNextRow(Object object, int n) throws SQLException {
        return ((OracleXMLDataSetExtJdbc)object).fetchNextRow();
    }

    public Object cursorGetColumnObject(Object object, int n) throws SQLException {
        return ((OracleXMLDataSetExtJdbc)object).getObject(n);
    }

    public void cursorGetMetaData(Object object, Vector vector, Vector vector2, Vector vector3) throws SQLException {
        OracleXMLDataSetExtJdbc oracleXMLDataSetExtJdbc = (OracleXMLDataSetExtJdbc)object;
        int n = oracleXMLDataSetExtJdbc.getColumnCount();
        vector.setSize(n);
        vector2.setSize(n);
        vector3.setSize(n);
        int n2 = 0;
        while (n2 < n) {
            vector.setElementAt(oracleXMLDataSetExtJdbc.getColumnLabel(n2 + 1), n2);
            vector2.setElementAt(oracleXMLDataSetExtJdbc.getColumnTypeObject(n2 + 1), n2);
            vector3.setElementAt(new Integer(oracleXMLDataSetExtJdbc.getColumnType(n2 + 1)), n2);
            ++n2;
        }
    }

    public void cursorClose(Object object) throws SQLException {
        ((OracleXMLDataSetExtJdbc)object).close();
    }

    /*
     * Unable to fully structure code
     */
    public static CLOB createTempCLOBFromString(Connection var0, String var1_1, String var2_2) throws SQLException, IOException {
        block4: {
            if (var2_2 == null) {
                var2_2 = "DBMS_LOB.SESSION";
            }
            var3_3 = (OracleCallableStatement)var0.prepareCall(" declare x CLOB := null;  begin dbms_lob.createtemporary(x,FALSE," + var2_2 + ");" + " ? := x; end;");
            var3_3.registerOutParameter(1, 2005);
            var3_3.execute();
            var4_4 = var3_3.getCLOB(1);
            try {
                var4_4.putString(1L, var1_1);
                break block4;
            }
            catch (SQLException v0) {
                var5_5 = var4_4.getChunkSize();
                var5_5 = var5_5 < 4000 ? 4000 / var5_5 * var5_5 : 4000;
                var6_6 = new char[var5_5];
                var7_7 = 0L;
                var9_8 = 0;
                var10_9 = new StringReader(var1_1);
                var11_10 = var1_1.length();
                ** while ((var9_8 = var10_9.read((char[])var6_6, (int)0, (int)var5_5)) > -1)
            }
lbl-1000:
            // 1 sources

            {
                var4_4.putChars(var7_7 + 1L, var6_6);
                if ((long)var11_10 >= (var7_7 += (long)var9_8) + (long)var5_5) continue;
                var5_5 = var11_10 % var5_5;
                var6_6 = new char[var5_5];
                continue;
            }
lbl27:
            // 1 sources

            var10_9.close();
        }
        var3_3.close();
        return var4_4;
    }

    public static BLOB createTempBLOBFromString(Connection connection, String string, String string2) throws SQLException, IOException {
        if (string2 == null) {
            string2 = "DBMS_LOB.SESSION";
        }
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(" declare x BLOB := null;  begin dbms_lob.createtemporary(x,FALSE," + string2 + ");" + " ? := x; end;");
        oracleCallableStatement.registerOutParameter(1, 2004);
        oracleCallableStatement.execute();
        BLOB bLOB = oracleCallableStatement.getBLOB(1);
        OutputStream outputStream = bLOB.getBinaryOutputStream();
        byte[] byArray = OracleXMLConvert.convertHexStringToByte(string);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.flush();
        outputStream.close();
        oracleCallableStatement.close();
        return bLOB;
    }

    public String getScalarStrValue(Object object) throws SQLException {
        return ((Datum)object).stringValue();
    }

    public String getDateString(Object object) throws SQLException {
        if (this.sdf == null) {
            return this.getScalarStrValue(object);
        }
        return this.sdf.format(((Datum)object).timestampValue());
    }
}

