/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dataset;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dataset.OracleXMLDataSet;

public class OracleXMLDataSetGenJdbc
extends OracleXMLDataSet {
    private Connection conn;
    private ResultSet rset;
    private boolean rsetIsExt = false;
    private PreparedStatement stmt;
    private ResultSetMetaData rmdata;
    private String connUser;
    boolean rsetFirstTime = true;
    static boolean useNewJdbcCalls = true;
    private static Hashtable typeHash = null;
    public boolean rsetVal = true;
    private Hashtable bindPosHash;
    private boolean isConsistent = false;

    public OracleXMLDataSetGenJdbc(Connection connection, ResultSet resultSet) throws SQLException {
        this.conn = connection;
        this.rset = resultSet;
        this.rsetIsExt = true;
        this.rmdata = this.rset.getMetaData();
        this.rsetVal = this.rset.next();
        this.connUser = this.conn.getMetaData().getUserName();
        this.isConsistent = true;
    }

    public OracleXMLDataSetGenJdbc(Connection connection, String string) throws SQLException {
        this.conn = connection;
        this.stmt = this.conn.prepareStatement(string);
        this.refreshDataSet();
    }

    public OracleXMLDataSetGenJdbc(Connection connection, Reader reader) throws Exception {
        this.conn = connection;
        String string = this.processSQLQuery(reader);
        this.stmt = this.conn.prepareStatement(string);
        if (this.bindPosHash != null) {
            this.isConsistent = false;
            return;
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetGenJdbc(Connection connection, Reader reader, Vector vector, Vector vector2) throws IOException, SQLException {
        this.conn = connection;
        if (vector != null) {
            String string = null;
            if (vector2 == null || vector.size() != vector2.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0010"));
            }
            string = this.processSQLQuery(reader);
            if (vector.size() != this.bindPosHash.size()) {
                throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0011"));
            }
            this.stmt = this.conn.prepareStatement(string);
            int n = vector.size() - 1;
            while (n >= 0) {
                this.bindValue((String)vector.elementAt(n), (String)vector2.elementAt(n));
                --n;
            }
        } else {
            StringBuffer stringBuffer = OracleXMLConvert.ReaderToStrBuf(reader, null);
            this.stmt = this.conn.prepareStatement(stringBuffer.toString());
        }
        this.refreshDataSet();
    }

    public OracleXMLDataSetGenJdbc(Connection connection) {
        this.conn = connection;
    }

    public void refreshDataSet() throws SQLException {
        if (this.isConsistent) {
            return;
        }
        this.rset = this.stmt.executeQuery();
        this.rsetFirstTime = true;
        this.rsetVal = this.rset.next();
        if (this.rmdata == null) {
            this.rmdata = this.rset.getMetaData();
            this.connUser = this.conn.getMetaData().getUserName();
        }
        this.isConsistent = true;
    }

    public void bindValue(String string, String string2) throws SQLException {
        Integer n = null;
        if (this.bindPosHash != null) {
            n = (Integer)this.bindPosHash.get(string);
        }
        if (n == null) {
            throw new OracleXMLSQLException(this.msg.getMessage1("XSUE-0012", string));
        }
        if (string2 == null) {
            this.stmt.setNull(n, 12);
        } else {
            this.stmt.setString(n, string2);
        }
        this.isConsistent = false;
    }

    private String processSQLQuery(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = null;
        int n = 0;
        int n2 = 0;
        if (this.bindPosHash == null) {
            this.bindPosHash = new Hashtable(10);
        }
        int n3 = reader.read();
        while (n3 != -1) {
            if (n3 == 39 || n3 == 34) {
                n2 = n3 == n2 ? (char)'\u0000' : (char)n3;
            }
            if (n3 != 58 || n2 != 0) {
                stringBuffer.append((char)n3);
            } else {
                ++n;
                stringBuffer2 = new StringBuffer(32);
                stringBuffer.append("? ");
                while ((n3 = reader.read()) != -1 && n3 != 32) {
                    stringBuffer2.append((char)n3);
                }
                if (stringBuffer2.length() == 0) {
                    throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0013"));
                }
                this.bindPosHash.put(stringBuffer2.toString(), new Integer(n));
            }
            n3 = reader.read();
        }
        if (n == 0) {
            this.bindPosHash = null;
        }
        return stringBuffer.toString();
    }

    public boolean isEmpty() {
        return !this.rsetVal;
    }

    public void close() throws SQLException {
        if (this.rset != null && !this.rsetIsExt) {
            this.rset.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public int getColumnCount() throws SQLException {
        return this.rmdata.getColumnCount();
    }

    public String getColumnName(int n) throws SQLException {
        return this.rmdata.getColumnName(n);
    }

    public int getColumnType(int n) throws SQLException {
        return this.rmdata.getColumnType(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.rmdata.getColumnLabel(n);
    }

    public int isNullable(int n) throws SQLException {
        return this.rmdata.isNullable(n);
    }

    public Object getColumnTypeObject(int n) throws SQLException {
        return this.rmdata.getColumnTypeName(n);
    }

    public void getStructMetaData(Object object, Vector vector, Vector vector2, Vector vector3) throws SQLException {
        throw new OracleXMLSQLException("getStructMetaData:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public String getConnUser() {
        return this.connUser;
    }

    public String getTypesSchema(Object object) {
        throw new OracleXMLSQLException("getTypesSchema:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public String getTypesName(Object object) {
        throw new OracleXMLSQLException("getTypesName:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public void getCollectionMetaData(Object object, Object[] objectArray, int[] nArray) throws SQLException {
        throw new OracleXMLSQLException("getCollectionMetaData:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public boolean fetchNextRow() throws SQLException {
        if (this.rsetFirstTime) {
            this.rsetFirstTime = false;
            return this.rsetVal;
        }
        return this.rset.next();
    }

    public Object getObject(int n) throws SQLException {
        return this.rset.getObject(n);
    }

    public Object[] getStructAttributes(Object object) throws SQLException {
        throw new OracleXMLSQLException("getStructAttributes:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public Object[] getCollectionValues(Object object) throws SQLException {
        throw new OracleXMLSQLException("getCollectionValues:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public boolean cursorFetchNextRow(Object object, int n) throws SQLException {
        throw new OracleXMLSQLException("cursorFetchNextRow:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public Object cursorGetColumnObject(Object object, int n) throws SQLException {
        throw new OracleXMLSQLException("cursorGetColumnObject:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public void cursorGetMetaData(Object object, Vector vector, Vector vector2, Vector vector3) throws SQLException {
        throw new OracleXMLSQLException("cursorGetMetaData:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public void cursorClose(Object object) throws SQLException {
        throw new OracleXMLSQLException("cursorClose:  " + this.msg.getMessage2("XSUE-0009", "OracleXMLDataSetGenJdbc", "OracleXMLDataSetExtJdbc"));
    }

    public String getScalarStrValue(Object object) throws SQLException {
        return object.toString();
    }

    public String getDateString(Object object) throws SQLException {
        if (this.sdf == null) {
            return object.toString();
        }
        return this.sdf.format((Date)object);
    }
}

